/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.bacnet;

import com.tridium.bacnet.stack.link.ip.BBdtEntry;
import com.tridium.bacnet.stack.link.ip.BBroadcastDistributionTable;
import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

public class BBdtEntryView
extends BHxView {
    public static final BBdtEntryView INSTANCE = new BBdtEntryView();
    public static final Type TYPE = Sys.loadType(BBdtEntryView.class);
    protected SmartCommand save = new Save(this);
    protected SmartCommand cancel;

    public Type getType() {
        return TYPE;
    }

    protected BBdtEntryView() {
        this.registerEvent((Event)this.save);
        this.cancel = new Cancel(this);
        this.registerEvent((Event)this.cancel);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.save, this.cancel};
    }

    public String getPageTitle(HxOp op) {
        return op.getLexicon("entsecHx").getText("bdtManager.entryView.title");
    }

    public Entry getEntry(HxOp op) {
        String entryName = op.getViewParameter("entryName", null);
        if (entryName == null) {
            return null;
        }
        if (op.get() instanceof BBroadcastDistributionTable) {
            BBroadcastDistributionTable bdt = (BBroadcastDistributionTable)op.get();
            BBdtEntry bdtEntry = (BBdtEntry)bdt.get(entryName);
            if (bdtEntry == null) {
                return null;
            }
            return new Entry(entryName, bdtEntry.getBacnetIPAddress(), bdtEntry.getBroadcastDistributionMask());
        }
        return null;
    }

    public void write(HxOp op) throws Exception {
        op.addStyleSheet("module://smartTableHx/rc/smartTable.css");
        op.addStyleSheet("module://entsecHx/rc/roleManager.css");
        op.addJavaScript("module://smartTableHx/rc/smartTable.js");
        Lexicon lex = op.getLexicon("entsecHx");
        HtmlWriter out = op.getHtmlWriter();
        Entry entry = this.getEntry(op);
        String ipAddress = "";
        String distributionMask = "";
        String title = null;
        title = this.isNewEntry(entry) ? lex.getText("bdtManager.newEntry.title") : lex.getText("bdtManager.editEntry.title");
        HxTabUtil.writeHeader((String)title, (SmartCommand[])this.getButtonCommands(op), (HxOp)op);
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        if (!this.isNewEntry(entry)) {
            ipAddress = entry.ipAddress;
            distributionMask = entry.distributionMask;
            HxTabUtil.startRow((String)lex.getText("bdtManager.entryName"), (HtmlWriter)out, (HxOp)op);
            out.w((Object)"<input type='text' size='50' readonly='readonly' name='").w((Object)op.scope("entryName")).w((Object)"'");
            out.w((Object)" value='").safe((Object)entry.name).w((Object)"'/>");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        }
        HxTabUtil.startRow((String)lex.getText("bdtManager.ipAddress"), (HtmlWriter)out, (HxOp)op);
        out.w((Object)"<input type='text' size='50' name='").w((Object)op.scope("ipAddress")).w((Object)"'");
        out.w((Object)" value='").safe((Object)ipAddress).w((Object)"'/>");
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("bdtManager.distributionMask"), (HtmlWriter)out, (HxOp)op);
        out.w((Object)"<input type='text' size='50' name='").w((Object)op.scope("distributionMask")).w((Object)"'");
        out.w((Object)" value='").safe((Object)distributionMask).w((Object)"'/>");
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
    }

    public BObject save(HxOp op) throws Exception {
        String ipAddress = op.getFormValue("ipAddress");
        if (ipAddress == null) {
            throw new LocalizableRuntimeException("entsecHx", "bdtManager.invalidIpAddress");
        }
        ipAddress = ipAddress.trim();
        String distributionMask = op.getFormValue("distributionMask");
        if (distributionMask == null) {
            throw new LocalizableRuntimeException("entsecHx", "bdtManager.invalidDistributionMask");
        }
        distributionMask = distributionMask.trim();
        if (op.get() instanceof BBroadcastDistributionTable) {
            BBroadcastDistributionTable bdt = (BBroadcastDistributionTable)op.get();
            Entry entry = this.getEntry(op);
            if (this.isNewEntry(entry)) {
                BBdtEntry bdtEntry = new BBdtEntry(ipAddress, distributionMask);
                bdt.add("BdtEntry?", (BValue)bdtEntry);
            } else {
                BBdtEntry bdtEntry = (BBdtEntry)bdt.get(entry.name);
                if (bdtEntry != null) {
                    bdtEntry.setBacnetIPAddress(ipAddress);
                    bdtEntry.setBroadcastDistributionMask(distributionMask);
                }
            }
        }
        return op.get();
    }

    public String getSaveConfirmMessage(HxOp op) throws Exception {
        return null;
    }

    private boolean isNewEntry(Entry entry) {
        return entry == null;
    }

    private class Entry {
        public String name;
        public String ipAddress;
        public String distributionMask;

        public Entry(String name, String ipAddress, String distributionMask) {
            this.name = name;
            this.ipAddress = ipAddress;
            this.distributionMask = distributionMask;
        }
    }

    public class Cancel
    extends SmartCommand {
        public Cancel(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "cancel";
        }

        public String getSuperDisplayName(HxOp op) {
            return super.getDisplayName(op);
        }

        public String getDisplayName(HxOp op) {
            return op.getLexicon("entsecHx").getText("bdtManager.title");
        }

        public BImage getIcon(HxOp op) {
            return BImage.make((String)this.lex.getText("moduleUpLevel.icon"));
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            this.redirect(op, BOrd.make((String)("station:|" + ((BComponent)op.get()).getSlotPathOrd() + "|view:entsecHx:BdtManager")));
        }
    }

    public class Save
    extends SaveCommand {
        public Save(BHxView view) {
            super(view);
        }

        public boolean registerOnInputs() {
            return true;
        }

        public String getConfirmMessage(HxOp op) throws Exception {
            return BBdtEntryView.this.getSaveConfirmMessage(op);
        }

        public void onHandle(HxOp op) throws Exception {
            try {
                BBdtEntryView.this.save(op);
                this.redirect(op, BOrd.make((String)("station:|" + ((BComponent)op.get()).getSlotPathOrd() + "|view:entsecHx:BdtManager")));
            }
            catch (CannotSaveException e) {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"save.pending();");
                e.printStackTrace();
            }
            catch (Exception e) {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"save.pending();");
                new ErrorDialog("Cannot Save", (Command)this, (Throwable)e).open(op);
                e.printStackTrace();
            }
        }
    }
}

