/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm.console;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.hx.BHxAlarmConsole;
import com.tridium.hx.ErrorDialog;
import com.tridium.hx.fieldeditors.BHxStringFE;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.fieldeditors.BHxSmartDefaultFE;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.securityUtil.alarm.BSecurityAlarmConsoleOptions;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsecHx.securityUtilHx.alarm.BLiveSecAlarmConsoleView;
import com.tridiumx.entsecHx.securityUtilHx.alarm.console.BAlarmConsoleProvider;
import com.tridiumx.entsecHx.securityUtilHx.alarm.console.BOpenAlarmsExtent;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BAlarmDataFE;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExtent;
import javax.baja.query.BPredicate;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

public class BHxSecAlarmConsoleView
extends BHxQueryTableView {
    public static final Lexicon entsecHxLexicon = Lexicon.make(BHxSecAlarmConsoleView.class);
    public static final Lexicon lexicon = Lexicon.make(BHxAlarmConsole.class);
    public static final BHxSecAlarmConsoleView INSTANCE = new BHxSecAlarmConsoleView();
    public static final Type TYPE = Sys.loadType(BHxSecAlarmConsoleView.class);
    protected SmartCommand addNotes;
    protected SmartCommand detailsCommand;
    protected SmartCommand acknowledgeCommand = new AcknowledgeCommandWithNotes((BHxView)this);
    protected SmartCommand forceClearCommand;
    protected SmartCommand showRecurring;
    protected SmartCommand showAll;
    protected SmartCommand showLive;
    protected SmartCommand reviewVideo;
    protected SmartCommand consoleList;
    private static BImage yellowAlarmImg = BImage.make((String)"module://icons/x16/alarm.png");
    private static BImage redAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
    private static BImage greenAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
    private static BImage orangeAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmOrange.png");
    private static BImage whiteAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmWhite.png");

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxSecAlarmConsoleView() {
        this.registerEvent((Event)this.acknowledgeCommand);
        this.detailsCommand = new DetailsCommand((BHxView)this);
        this.registerEvent((Event)this.detailsCommand);
        this.forceClearCommand = new ForceClearCommand((BHxView)this);
        this.registerEvent((Event)this.forceClearCommand);
        this.showRecurring = new ShowRecurring((BHxView)this);
        this.registerEvent((Event)this.showRecurring);
        this.showAll = new ShowAll((BHxView)this);
        this.registerEvent((Event)this.showAll);
        this.reviewVideo = new ReviewVideo((BHxView)this);
        this.registerEvent((Event)this.reviewVideo);
        this.showLive = new ShowLive((BHxView)this);
        this.registerEvent((Event)this.showLive);
        this.consoleList = new ConsoleList((BHxView)this);
        this.registerEvent((Event)this.consoleList);
        this.addNotes = new AddNotes((BHxView)this);
        this.registerEvent((Event)this.addNotes);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array(SmartCommand.class);
        a.add((Object)this.acknowledgeCommand);
        if (this.getSourceOrdList(op) == null) {
            a.add((Object)this.showRecurring);
        } else {
            a.add((Object)this.showAll);
        }
        a.add((Object)this.detailsCommand);
        a.add((Object)this.addNotes);
        if (op.getPermissionsForTarget().hasAdminInvoke()) {
            a.add((Object)this.forceClearCommand);
        }
        if (BEnterpriseSecurityService.isVideoDriverAvailable()) {
            a.add((Object)this.reviewVideo);
        }
        a.add((Object)this.filterCommand);
        a.add((Object)this.refreshCommand);
        a.add((Object)this.exportCommand);
        a.add((Object)this.showLive);
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        if (service.getAlarmConsoles().getPermissions((Context)op).hasOperatorRead()) {
            a.add((Object)this.consoleList);
        }
        return (SmartCommand[])a.trim();
    }

    public String getPageTitle(HxOp op) throws Exception {
        StringBuffer b = new StringBuffer();
        b.append(super.getPageTitle(op));
        b.append(" - ");
        b.append(Lexicon.make((String)TYPE.getModule().getModuleName(), (Context)op).getText("snapshot"));
        BOrdList source = this.getSourceOrdList(op);
        if (source != null) {
            b.append(" - ");
            b.append(Lexicon.make((String)BHxAlarmConsole.TYPE.getModule().getModuleName(), (Context)op).getText("hx.showRecurring"));
        }
        return b.toString();
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BQuery query = new BQuery();
        query.from((BExtent)new BOpenAlarmsExtent(BAlarmRecord.TYPE.getTypeSpec()));
        query.add("base", (BValue)BOrd.make((String)"alarm:"));
        query.add(null, (BValue)new BAlarmConsoleProvider());
        BOrdList source = this.getSourceOrdList(op);
        if (source != null) {
            BPredicate predicate = new BPredicate(Predicates.eq((String)"source", (BSimple)source));
            query.where(predicate);
        }
        BAlarmConsoleProvider.addInitialAlarmQuery(query, op);
        return QueryUtil.getWorkingCopy((BQuery)query, (BObject)this.getBase(op), (Context)op);
    }

    @Override
    public String getRowKey(Type rowType, TableCursor cursor, HxOp op) {
        BITable table = cursor.getTable();
        String key = "";
        Column keyColumn = table.getColumns().get("uuid");
        key = key + cursor.cell(keyColumn).toString();
        keyColumn = table.getColumns().get("source.encodeToString");
        String source = cursor.cell(keyColumn).toString();
        source = SlotPath.escape((String)source);
        key = key + "." + source;
        return key;
    }

    @Override
    public BImage[] getRowIcons(TableCursor cursor, HxOp op) {
        BImage[] images = new BImage[]{this.getNotesIcon(cursor, op), this.getVideoIcon(cursor, op), this.getRowIcon(cursor, op)};
        return images;
    }

    public BImage getNotesIcon(TableCursor cursor, HxOp op) {
        int notesLength;
        ColumnList list = cursor.getTable().getColumns();
        Column keyColumn = cursor.getTable().getColumns().get("alarmData.notes");
        BObject result = (BObject)cursor.cell(keyColumn);
        if (result instanceof BString && (notesLength = ((BString)result).toString().length()) > 0) {
            return BImage.make((BIcon)BIcon.std((String)"note.png"));
        }
        return BImage.make((BIcon)BIcon.std((String)"blank.png"));
    }

    public BImage getVideoIcon(TableCursor cursor, HxOp op) {
        int notesLength;
        ColumnList list = cursor.getTable().getColumns();
        Column keyColumn = cursor.getTable().getColumns().get("alarmData.cameraOrd");
        BObject result = (BObject)cursor.cell(keyColumn);
        if (result instanceof BString && (notesLength = ((BString)result).toString().length()) > 0) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("commands.showVideo.icon")));
        }
        return BImage.make((BIcon)BIcon.std((String)"blank.png"));
    }

    @Override
    public BImage getRowIcon(TableCursor cursor, HxOp op) {
        try {
            Column keyColumn = cursor.getTable().getColumns().get("ackState");
            BAckState ackState = BAckState.acked;
            BEnumRange range = ackState.getRange();
            int[] ordinals = range.getOrdinals();
            String displayTag = cursor.cell(keyColumn).toString();
            for (int i = 0; i < ordinals.length; ++i) {
                if (!range.getDisplayTag(ordinals[i], (Context)op).equals(displayTag)) continue;
                ackState = BAckState.make((int)ordinals[i]);
            }
            keyColumn = cursor.getTable().getColumns().get("sourceState");
            BSourceState sourceState = BSourceState.alert;
            range = sourceState.getRange();
            ordinals = range.getOrdinals();
            displayTag = cursor.cell(keyColumn).toString();
            for (int i = 0; i < ordinals.length; ++i) {
                if (!range.getDisplayTag(ordinals[i], (Context)op).equals(displayTag)) continue;
                sourceState = BSourceState.make((int)ordinals[i]);
            }
            if (sourceState == BSourceState.alert) {
                return orangeAlarmImg;
            }
            if (ackState == BAckState.acked && sourceState != BSourceState.normal) {
                return yellowAlarmImg;
            }
            if (ackState != BAckState.acked && sourceState != BSourceState.normal) {
                return redAlarmImg;
            }
            if (ackState != BAckState.acked && sourceState == BSourceState.normal) {
                return greenAlarmImg;
            }
            return whiteAlarmImg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean notesRequired(HxOp op) {
        try {
            String userName = op.getUser().getUsername();
            BUserService userSvc = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)((BConsoleRecipient)op.get()));
            userSvc.lease();
            BUser user = (BUser)userSvc.get(userName);
            user.lease();
            BSecurityAlarmConsoleOptions ac = (BSecurityAlarmConsoleOptions)user.get("entsec_SecurityAlarmConsoleOptions");
            ac.lease();
            return ac.getNotesRequiredOnAck();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public TableContents writeRows(BITable table, BQuery query, HxOp op) {
        int i;
        TableContents contents = super.writeRows(table, query, op);
        if (this.getSourceOrdList(op) != null) {
            return contents;
        }
        LinkedHashMap<String, TableContents.Tr> map = new LinkedHashMap<String, TableContents.Tr>();
        BPredicate predicate = query.getPredicate();
        int ackStateColIndex = -1;
        for (i = 0; i < contents.columns.td.size(); ++i) {
            TableContents.Td td = (TableContents.Td)contents.columns.td.get(i);
            if (!td.text.equals(BAlarmRecord.ackState.getDefaultDisplayName((Context)op)) && !td.text.equals(BAlarmRecord.ackState.getDefaultDisplayName(null))) continue;
            ackStateColIndex = i;
        }
        for (i = 0; i < contents.tr.size(); ++i) {
            TableContents.Td td;
            TableContents.Tr tr = (TableContents.Tr)contents.tr.get(i);
            String key = TextUtil.split((String)tr.id, (char)'.')[1];
            TableContents.Tr found = (TableContents.Tr)map.get(key);
            if (found == null) {
                td = (TableContents.Td)tr.td.get(ackStateColIndex);
                td = td.text.equals(BAckState.unacked.getDisplayTag((Context)op)) || td.text.equals(BAckState.unacked.getDisplayTag(null)) ? new AlarmTd(0, 1, 0, op) : (td.text.equals(BAckState.acked.getDisplayTag((Context)op)) || td.text.equals(BAckState.acked.getDisplayTag(null)) ? new AlarmTd(1, 0, 0, op) : new AlarmTd(0, 0, 1, op));
                tr.td.set(ackStateColIndex, td);
                map.put(key, tr);
                continue;
            }
            td = (TableContents.Td)tr.td.get(ackStateColIndex);
            AlarmTd alarmTd = (AlarmTd)((Object)found.td.get(ackStateColIndex));
            if (td.text.equals(BAckState.unacked.getDisplayTag((Context)op)) || td.text.equals(BAckState.unacked.getDisplayTag(null))) {
                ++alarmTd.unacked;
            } else if (td.text.equals(BAckState.acked.getDisplayTag((Context)op)) || td.text.equals(BAckState.acked.getDisplayTag(null))) {
                ++alarmTd.acked;
            } else {
                ++alarmTd.ackPending;
            }
            alarmTd.setText(op);
        }
        Object[] a = map.values().toArray();
        contents.tr.clear();
        for (int j = 0; j < a.length; ++j) {
            contents.tr.add((TableContents.Tr)a[j]);
        }
        return contents;
    }

    public BOrdList getSourceOrdList(HxOp op) {
        String source = (String)op.getRequest().getSession().getAttribute("source");
        if (source == null) {
            return null;
        }
        try {
            source = SlotPath.unescape((String)source);
            return BOrdList.make((String)source);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BAlarmRecord[] getRecords(HxOp op) throws Exception {
        return this.getRecords(false, op);
    }

    public BAlarmRecord[] getRecords(boolean forceUuidLookup, HxOp op) throws Exception {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        Array records = new Array(BAlarmRecord.class);
        for (int i = 0; i < selectionList.length; ++i) {
            String rowId = BHxSecAlarmConsoleView.unscopeId((String)selectionList[i]);
            String[] split = TextUtil.split((String)rowId, (char)'.');
            BOrdList source = this.getSourceOrdList(op);
            if (source != null || forceUuidLookup) {
                BUuid uuid = BUuid.make((String)split[0]);
                BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + uuid + "'"));
                BITable result = (BITable)ord.resolve(op.get()).get();
                TableCursor c = result.cursor();
                while (c.next()) {
                    BAlarmRecord record = (BAlarmRecord)c.get();
                    record = (BAlarmRecord)record.newCopy();
                    records.add((Object)record);
                }
                continue;
            }
            source = BOrdList.make((String)SlotPath.unescape((String)split[1]));
            BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + SlotPath.escape((String)source.encodeToString()) + "'"));
            BITable result = (BITable)ord.resolve(op.get()).get();
            TableCursor c = result.cursor();
            while (c.next()) {
                BAlarmRecord record = (BAlarmRecord)c.get();
                record = (BAlarmRecord)record.newCopy();
                records.add((Object)record);
            }
        }
        return (BAlarmRecord[])records.trim();
    }

    public void addAlarmNotes(BAlarmRecord[] records, String notes, HxOp op) throws AlarmException, IOException {
        for (int j = 0; j < records.length; ++j) {
            BAlarmRecord alarm = records[j];
            this.addNotes(alarm, notes, op);
            this.getAlarmConnection().update(alarm);
        }
    }

    protected void addNotes(BAlarmRecord rec, String newNotes, HxOp op) {
        if (newNotes == null) {
            return;
        }
        BFacets alarmData = rec.getAlarmData();
        String oldNotes = "";
        if (alarmData.get("notes") != null) {
            oldNotes = alarmData.get("notes").toString();
        }
        StringBuffer notes = new StringBuffer();
        notes.append("## " + BAbsTime.now() + " - " + op.getUser().getUsername() + " ##\n");
        notes.append(newNotes);
        notes.append("\n\n");
        notes.append(oldNotes);
        BFacets f = BFacets.make((BFacets)alarmData, (BFacets)BFacets.make((String)"notes", (BIDataValue)BString.make((String)notes.toString())));
        rec.setAlarmData(f);
    }

    public BAlarmService getAlarmService() {
        return (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    }

    public AlarmDbConnection getAlarmConnection() {
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        return alarmService.getAlarmDb().getDbConnection(null);
    }

    public class AlarmNotesDialog
    extends Dialog {
        public AlarmNotesDialog(String title, Command handler) {
            super(title, handler);
        }

        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit((Dialog)this), new Dialog.Cancel((Dialog)this)};
        }

        public void writeContent(HxOp op) throws Exception {
            String alarmNotes = this.getAlarmNotes(op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<div style='display:block;' >");
            out.w((Object)"<textarea rows='4' cols='40' readonly='yes' wrap='hard'>");
            out.safe((Object)alarmNotes);
            out.w((Object)"</textarea><br />");
            out.w((Object)"</div>");
            out.w((Object)("<textarea rows='4' cols='40' name='" + op.scope("notes") + "' >"));
            out.w((Object)"</textarea>");
        }

        private String getAlarmNotes(HxOp op) throws Exception {
            BAlarmRecord[] records = BHxSecAlarmConsoleView.this.getRecords(op);
            return this.getAlarmNotes(records, op);
        }

        private String getAlarmNotes(BAlarmRecord[] records, HxOp op) {
            StringBuffer buffer = new StringBuffer();
            if (records.length > 1) {
                return lexicon.getText("hx.notes.multiple") + "\n";
            }
            for (int j = 0; j < records.length; ++j) {
                BAlarmRecord alarm = records[j];
                BObject value = alarm.getAlarmData().get("notes");
                if (null == value) continue;
                buffer.append(value.toString());
            }
            return buffer.toString();
        }
    }

    public class AddNotes
    extends SmartCommand {
        Dialog dlg;

        public AddNotes(BHxView view) {
            super(view);
            this.dlg = new AlarmNotesDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "alarmNotes";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String notes = op.getFormValue("notes");
            BAlarmRecord[] records = BHxSecAlarmConsoleView.this.getRecords(op);
            BHxSecAlarmConsoleView.this.addAlarmNotes(records, notes, op);
            BHxSecAlarmConsoleView.this.reloadTable(op);
        }
    }

    public class ReviewVideo
    extends SmartCommand {
        private static final String HEIGHT = "600";
        private static final String WIDTH = "600";

        public ReviewVideo(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "reviewVideo";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            Lexicon lex = Lexicon.make(((Object)((Object)this)).getClass());
            BAlarmRecord[] records = BHxSecAlarmConsoleView.this.getRecords(true, op);
            if (records == null || records.length == 0) {
                new ErrorDialog(lex.getText("alarmHistory.noAlarmFoundErrorDialog.title"), (Throwable)new Exception(lex.getText("alarmHistory.noAlarmFoundErrorDialog.message"))).open(op);
                return;
            }
            BAlarmRecord alarmRecord = records[0];
            try {
                if (alarmRecord.getAlarmFacet("cameraOrd") == null && alarmRecord.getAlarmFacet("cameraHandleOrd") == null) {
                    new ErrorDialog(lex.getText("alarmHistory.nonVideoAlarmDialog.title"), (Throwable)new Exception(lex.getText("alarmHistory.nonVideoAlarmDialog.message"))).open(op);
                    return;
                }
                HtmlWriter out = op.getHtmlWriter();
                BConsoleRecipient recip = (BConsoleRecipient)op.get();
                out.w((Object)("window.open('ord?local:|station:|" + recip.getSlotPath() + "|view:entsecHx:HxVideoReviewView?uuid=" + alarmRecord.getUuid() + ";width=" + "600" + ";height=" + "600" + "','reviewVideo','width=" + "600" + ",height=" + "600" + "');"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class ConsoleList
    extends SmartCommand {
        public ConsoleList(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "consoleList";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isTableCommand(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            BOrd ord = BOrd.make((String)("station:|" + service.getAlarmConsoles().getSlotPathOrd()));
            this.redirect(op, op.toUri(ord));
        }
    }

    public class ShowLive
    extends SmartCommand {
        public ShowLive(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showLive";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isTableCommand(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BOrd ord = op.getOrdWithoutViewQuery();
            this.redirect(op, BOrd.make((String)(ord + "|view:" + BLiveSecAlarmConsoleView.TYPE.toString())));
        }
    }

    public class AcknowledgeCommandWithNotes
    extends SmartCommand {
        NotesDialog dialog;

        public AcknowledgeCommandWithNotes(BHxView view) {
            super(view, Lexicon.make(BHxSecAlarmConsoleView.class));
            this.dialog = new NotesDialog("Notes", (Command)this);
        }

        public String getName(HxOp op) {
            return "ackAlarm";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            boolean notesRequired = BHxSecAlarmConsoleView.this.notesRequired(op);
            if (!this.dialog.isSubmit(op) && notesRequired) {
                this.dialog.open(op);
                return;
            }
            BString notes = BString.DEFAULT;
            if (notesRequired) {
                notes = (BString)this.getNotesTab(op).save();
            }
            BAlarmRecord[] records = BHxSecAlarmConsoleView.this.getRecords(op);
            for (int i = 0; i < records.length; ++i) {
                BHxAlarmConsole.INSTANCE.ackAlarm(records[i], notes.toString(), op);
            }
            BHxSecAlarmConsoleView.this.reloadTable(op);
        }

        public Tab getNotesTab(HxOp op) {
            HxOp fieldOp = op.make("notes", (BObject)BString.DEFAULT, BFacets.make((String)"multiLine", (boolean)true));
            return new Tab((BHxView)BHxStringFE.INSTANCE, fieldOp, op);
        }

        public class NotesDialog
        extends Dialog {
            public NotesDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                AcknowledgeCommandWithNotes.this.getNotesTab(op).write();
            }
        }
    }

    public class ShowAll
    extends SmartCommand {
        public ShowAll(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showAll";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            op.getRequest().getSession().setAttribute("source", null);
            this.refresh(op);
        }
    }

    public class ShowRecurring
    extends SmartCommand {
        public ShowRecurring(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showRecurring";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            Array records = new Array(BAlarmRecord.class);
            for (int i = 0; i < selectionList.length; ++i) {
                String rowId = BHxSmartTableView.unscopeId((String)selectionList[i]);
                String[] split = TextUtil.split((String)rowId, (char)'.');
                rowId = TextUtil.replace((String)split[1], (String)" ", (String)"|");
                op.getRequest().getSession().setAttribute("source", (Object)rowId);
                this.refresh(op);
            }
        }
    }

    public class ForceClearCommand
    extends SmartCommand {
        public ForceClearCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "forceClear";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmRecord[] records = BHxSecAlarmConsoleView.this.getRecords(op);
            for (int i = 0; i < records.length; ++i) {
                BAlarmRecord alarm = records[i];
                BAlarmClass ac = alarmService.lookupAlarmClass(alarm.getAlarmClass());
                op.getUser().check((BIProtected)ac, BPermissions.adminWrite);
                alarm.setUser(op.getUser().getUsername());
                alarm.setAckTime(BAbsTime.now());
                alarm.setAckState(BAckState.acked);
                alarm.setSourceState(BSourceState.normal);
                alarm.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)op.getUser().getUsername()));
                try {
                    AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);
                    conn.update(alarm);
                    alarmService.invoke(BAlarmService.auditForceClear, (BValue)alarm, (Context)op);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            BHxSecAlarmConsoleView.this.reloadTable(op);
        }
    }

    public class DetailsCommand
    extends SmartCommand {
        DetailsDialog dialog;

        public DetailsCommand(BHxView view) {
            super(view);
            this.dialog = new DetailsDialog("Alarm Details", (Command)this);
        }

        public String getName(HxOp op) {
            return "showAlarmDetails";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            return this.getTab(op).process();
        }

        public Tab getTab(HxOp op) throws Exception {
            BAlarmRecord rec = BHxSecAlarmConsoleView.this.getRecords(true, op)[0];
            String dFE = BHxSmartDefaultFE.TYPE.toString();
            String[] fieldNames = new String[]{"timestamp", "uuid", "sourceState", "ackState", "ackRequired", "source", "alarmClass", "priority", "normalTime", "ackTime", "user", "alarmData", "alarmTransition", "lastUpdate"};
            String[] fieldEditors = new String[]{dFE, dFE, dFE, dFE, dFE, dFE, dFE, dFE, dFE, dFE, dFE, BAlarmDataFE.TYPE.toString(), dFE, dFE};
            BFacets facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets((String[])fieldNames), (BFacets)BHxFieldSheet.getFieldEditorsProvidedFacets((String[])fieldEditors));
            HxOp subOp = op.make("showAlarmDetails", (BObject)rec, facets);
            return new Tab((BHxView)BHxFieldSheet.INSTANCE, subOp);
        }

        public class DetailsDialog
        extends Dialog {
            public DetailsDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                DetailsCommand.this.getTab(op).write();
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand()};
            }
        }
    }

    public class AcknowledgeCommand
    extends SmartCommand {
        NotesDialog dialog;

        public AcknowledgeCommand(BHxView view) {
            super(view);
            this.dialog = new NotesDialog("Notes", (Command)this);
        }

        public String getName(HxOp op) {
            return "ackAlarm";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            boolean notesRequired = BHxSecAlarmConsoleView.this.notesRequired(op);
            if (!this.dialog.isSubmit(op) && notesRequired) {
                this.dialog.open(op);
                return;
            }
            BString notes = BString.DEFAULT;
            if (notesRequired) {
                notes = (BString)this.getNotesTab(op).save();
            }
            BAlarmRecord[] records = BHxSecAlarmConsoleView.this.getRecords(op);
            for (int i = 0; i < records.length; ++i) {
                BHxAlarmConsole.INSTANCE.ackAlarm(records[i], notes.toString(), op);
            }
            BHxSecAlarmConsoleView.this.reloadTable(op);
        }

        public Tab getNotesTab(HxOp op) {
            HxOp fieldOp = op.make("notes", (BObject)BString.DEFAULT, BFacets.make((String)"multiLine", (boolean)true));
            return new Tab((BHxView)BHxStringFE.INSTANCE, fieldOp, op);
        }

        public class NotesDialog
        extends Dialog {
            public NotesDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                AcknowledgeCommand.this.getNotesTab(op).write();
            }
        }
    }

    public static class AlarmTd
    extends TableContents.Td {
        public int acked = 0;
        public int unacked = 0;
        public int ackPending = 0;

        public AlarmTd() {
        }

        public AlarmTd(String text) {
            super(text);
        }

        public AlarmTd(int acked, int unacked, int ackPending, HxOp op) {
            super("");
            this.acked = acked;
            this.unacked = unacked;
            this.ackPending = ackPending;
            this.setText(op);
        }

        public void setText(HxOp op) {
            this.text = this.ackPending == 0 ? this.acked + " " + BAckState.acked.getDisplayTag((Context)op) + " / " + this.unacked + " " + BAckState.unacked.getDisplayTag((Context)op) + "" : this.acked + " " + BAckState.acked.getDisplayTag((Context)op) + " / " + this.unacked + " " + BAckState.unacked.getDisplayTag((Context)op) + " / " + this.ackPending + " " + BAckState.ackPending.getDisplayTag((Context)op) + "";
        }
    }
}

