/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm.console;

import com.tridium.alarm.BConsoleRecipient;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.securityUtil.query.BAlarmDbColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.BColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.hx.HxOp;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BAlarmConsoleProvider
extends BColumnsProvider {
    public static final Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(BAlarmConsoleProvider.class).getModuleName());
    public static final Type TYPE = Sys.loadType(BAlarmConsoleProvider.class);

    public Type getType() {
        return TYPE;
    }

    public TypeSpecPath[] getDefaultColumns(BQuery query) {
        Array a = new Array(TypeSpecPath.class);
        a.add((Object)new TypeSpecPath(BAlarmRecord.timestamp));
        a.add((Object)new TypeSpecPath(BString.TYPE.getTypeSpec(), "alarmData.sourceName", lex.getText("sourceName")));
        a.add((Object)new TypeSpecPath(BAlarmRecord.sourceState));
        a.add((Object)new TypeSpecPath(BAlarmRecord.ackState));
        a.add((Object)new TypeSpecPath(BAlarmRecord.priority));
        BFunctionExpression alarmClassExp = Funcs.make((String)(BAlarmDbColumnsProvider.TYPE + ".getAlarmClassDisplayName"), (Type)BString.TYPE, (BExpression)Exprs.simple((BSimple)BString.DEFAULT));
        TypeSpecPath alarmClassDisplayName = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), "alarmClassDisplayName", null, (BExpression)alarmClassExp);
        a.add((Object)alarmClassDisplayName);
        BFunctionExpression exp = Funcs.make((String)(TYPE + ".format"), (Type)BString.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)"alarmData.msgText")));
        TypeSpecPath formatCol = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), "alarmData.msgText", null, (BExpression)exp);
        a.add((Object)formatCol);
        a.add((Object)new TypeSpecPath(BString.TYPE.getTypeSpec(), "alarmData.badge", BBadge.TYPE.getDisplayName(null)));
        a.add((Object)new TypeSpecPath(BAlarmRecord.user));
        return (TypeSpecPath[])a.trim();
    }

    public TypeSpecPath[] getHiddenColumns(BQuery query) {
        Array a = new Array(TypeSpecPath.class);
        a.add((Object)new TypeSpecPath(BAlarmRecord.uuid));
        a.add((Object)new TypeSpecPath(BString.TYPE.getTypeSpec(), "source.encodeToString", "source.encodeToString"));
        a.add((Object)new TypeSpecPath(BAlarmRecord.sourceState));
        a.add((Object)new TypeSpecPath(BAlarmRecord.ackState));
        a.add((Object)new TypeSpecPath(BString.TYPE.getTypeSpec(), "alarmData.notes", "notes"));
        a.add((Object)new TypeSpecPath(BString.TYPE.getTypeSpec(), "alarmData.cameraOrd", "cameraOrd"));
        return (TypeSpecPath[])a.trim();
    }

    public int getDefaultSortColumnIndex(BQuery query) {
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].get("typeSpec").equals((Object)BAbsTime.TYPE.getTypeSpec())) continue;
            return i;
        }
        return -1;
    }

    public static void addInitialAlarmQuery(BQuery query, HxOp op) {
        ExpressionBuilder d;
        ExpressionBuilder c;
        String ac2;
        int i;
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BConsoleRecipient consoleRecipient = (BConsoleRecipient)op.get();
        BUser user = op.getUser();
        boolean hasAlarmClasses = false;
        ExpressionBuilder b = new ExpressionBuilder();
        String[] subscribedAlarmClasses = consoleRecipient.getSubscribedAlarmClasses();
        for (i = 0; i < subscribedAlarmClasses.length; ++i) {
            try {
                ac2 = subscribedAlarmClasses[i];
                user.check((BIProtected)service.lookupAlarmClass(ac2), BPermissions.adminRead);
                b.or(Predicates.eq((Property)BAlarmRecord.alarmClass, (BSimple)BString.make((String)SlotPath.escape((String)ac2))));
                hasAlarmClasses = true;
                continue;
            }
            catch (PermissionException ac2) {
                // empty catch block
            }
        }
        subscribedAlarmClasses = consoleRecipient.getSubscribedEscalatedAlarmClasses(1);
        for (i = 0; i < subscribedAlarmClasses.length; ++i) {
            try {
                ac2 = subscribedAlarmClasses[i];
                user.check((BIProtected)service.lookupAlarmClass(ac2), BPermissions.adminRead);
                c = new ExpressionBuilder();
                c.and(Predicates.eq((Property)BAlarmRecord.alarmClass, (BSimple)BString.make((String)SlotPath.escape((String)ac2))));
                d = new ExpressionBuilder();
                d.and(Predicates.ne((String)"alarmData.escalated", (String)"null"));
                d.and(Predicates.eq((String)"alarmData.escalated", (String)"level3"));
                d.or(Predicates.eq((String)"alarmData.escalated", (String)"level2"));
                d.or(Predicates.eq((String)"alarmData.escalated", (String)"level1"));
                c.and(d.getExpression());
                b.or(c.getExpression());
                hasAlarmClasses = true;
                continue;
            }
            catch (PermissionException ac3) {
                // empty catch block
            }
        }
        subscribedAlarmClasses = consoleRecipient.getSubscribedEscalatedAlarmClasses(2);
        for (i = 0; i < subscribedAlarmClasses.length; ++i) {
            try {
                ac2 = subscribedAlarmClasses[i];
                user.check((BIProtected)service.lookupAlarmClass(ac2), BPermissions.adminRead);
                c = new ExpressionBuilder();
                c.and(Predicates.eq((Property)BAlarmRecord.alarmClass, (BSimple)BString.make((String)SlotPath.escape((String)ac2))));
                d = new ExpressionBuilder();
                d.and(Predicates.ne((String)"alarmData.escalated", (String)"null"));
                d.and(Predicates.eq((String)"alarmData.escalated", (String)"level3"));
                d.or(Predicates.eq((String)"alarmData.escalated", (String)"level2"));
                c.and(d.getExpression());
                b.or(c.getExpression());
                hasAlarmClasses = true;
                continue;
            }
            catch (PermissionException ac4) {
                // empty catch block
            }
        }
        subscribedAlarmClasses = consoleRecipient.getSubscribedEscalatedAlarmClasses(3);
        for (i = 0; i < subscribedAlarmClasses.length; ++i) {
            try {
                ac2 = subscribedAlarmClasses[i];
                user.check((BIProtected)service.lookupAlarmClass(ac2), BPermissions.adminRead);
                c = new ExpressionBuilder();
                c.and(Predicates.eq((Property)BAlarmRecord.alarmClass, (BSimple)BString.make((String)SlotPath.escape((String)ac2))));
                d = new ExpressionBuilder();
                d.and(Predicates.ne((String)"alarmData.escalated", (String)"null"));
                d.and(Predicates.eq((String)"alarmData.escalated", (String)"level3"));
                c.and(d.getExpression());
                b.or(c.getExpression());
                hasAlarmClasses = true;
                continue;
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        if (!hasAlarmClasses) {
            b.and(Predicates.eq((Property)BAlarmRecord.alarmClass, (BSimple)BString.make((String)"null")));
        }
        ExpressionBuilder p = new ExpressionBuilder();
        p.and(b.getExpression());
        if (query.getPredicate() != null && query.getPredicate().getPredicateExpr() != null) {
            p.and(query.getPredicate().getPredicateExpr().newExprCopy());
        }
        query.where(p.getExpression());
    }

    public static BString format(BObject target, BString propertyNameInTarget) {
        if (propertyNameInTarget.toString().indexOf(".") == -1) {
            return BString.make((String)BFormat.format((String)target.asComplex().get(propertyNameInTarget.toString()).toString(), (Object)target));
        }
        String[] split = TextUtil.split((String)propertyNameInTarget.toString(), (char)'.');
        BObject parent = target;
        BValue value = null;
        for (int i = 0; i < split.length; ++i) {
            value = parent instanceof BComplex ? parent.asComplex().get(split[i]) : (BValue)((BFacets)parent).get(split[i]);
            if (!(value instanceof BComplex) && !(value instanceof BFacets)) continue;
            parent = value;
        }
        return BString.make((String)BFormat.format((String)value.toString(), (Object)target));
    }
}

