/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmRecipient;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.access.fieldeditors.BHxFacetsFE;
import com.tridiumx.entsecHx.securityUtilHx.alarm.TableVideoCommand;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class VideoCommand
extends SmartCommand {
    protected VideoDialog dlg;
    protected Logger log = Logger.getLogger("entsecHx.videoSetup");

    public VideoCommand(BHxView view) {
        super(view);
        this.dlg = new VideoDialog((Command)this, this.getDisplayName(null));
    }

    public String getName(HxOp op) {
        return "videoSetup";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    private String facetsAttribute(HxOp op) {
        String attribute = SmartCommand.universalScope((String)"facets", (HxOp)op);
        return TextUtil.replace((String)attribute, (String)"properties.alarmClass", (String)"properties.metaData");
    }

    public String getDisplayName(HxOp op) {
        if (op == null) {
            return super.getDisplayName(op);
        }
        BComponent[] exts = this.getAlarmSourceExts(op);
        if (exts == null || exts.length <= 0) {
            return this.lex.getText(this.getName(op) + ".label");
        }
        BComponent ext = exts[0];
        BFacets videoFacets = (BFacets)op.getRequest().getSession().getAttribute(this.facetsAttribute(op));
        if (videoFacets == null) {
            videoFacets = (BFacets)ext.get("metaData");
        }
        if (videoFacets == null) {
            videoFacets = BFacets.DEFAULT;
        }
        BString cameraHandleOrd = (BString)videoFacets.get("cameraHandleOrd");
        BString cameraOrd = (BString)videoFacets.get("cameraOrd");
        if ((cameraHandleOrd == null || cameraHandleOrd.isNull() || cameraHandleOrd.toString().length() == 0) && (cameraOrd == null || cameraOrd.isNull() || cameraOrd.toString().length() == 0)) {
            return this.lex.getText(this.getName(op) + ".label");
        }
        BComponent camera = null;
        try {
            String cameraHandleOrdString = cameraHandleOrd.getString();
            camera = (BComponent)BOrd.make((String)cameraHandleOrdString).get((BObject)ext);
            return this.lex.getText(this.getName(op) + ".label") + " - " + camera.getDisplayName((Context)op);
        }
        catch (Exception e1) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "Error resolving camera handle ord", e1);
            }
            try {
                String cameraOrdString = cameraOrd.getString();
                camera = (BComponent)BOrd.make((String)cameraOrdString).get((BObject)ext);
                return this.lex.getText(this.getName(op) + ".label") + " - " + camera.getDisplayName((Context)op);
            }
            catch (Exception e2) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Error resolving camera slot path ord", e2);
                }
                return this.lex.getText(this.getName(op) + ".label");
            }
        }
    }

    public String getEnablePolicyInvokeCode(HxOp op) {
        if (!op.canWrite() && !this.readonlyEnablePolicy(op)) {
            return "false";
        }
        String quote = HxUtil.getOuterQuote((HxOp)op);
        return "entsecHx.sameStation(" + quote + op.getPath() + quote + ");";
    }

    public void handle(HxOp op) throws Exception {
        if (!this.dlg.isSubmit(op)) {
            this.dlg.open(op);
            return;
        }
        this.save(op, false);
        BHxFacetsFE.updateFacetsSummary(op);
        SaveCommand.setModified((HxOp)op);
    }

    public BObject save(HxOp op, boolean persistFacets) throws Exception {
        BComponent temp = (BComponent)this.getTab(op).save();
        String videoEnabledS = SlotPath.escape((String)this.lex.getText("videoEnabled"));
        String cameraS = SlotPath.escape((String)this.lex.getText("camera"));
        String goToPresetS = SlotPath.escape((String)this.lex.getText("goToPreset"));
        String cameraPresetS = SlotPath.escape((String)this.lex.getText("cameraPreset"));
        String sendAlarmToDisplayS = SlotPath.escape((String)this.lex.getText("sendAlarmToDisplay"));
        boolean videoEnabled = ((BBoolean)temp.get(videoEnabledS)).getBoolean();
        BString cameraOrd = (BString)temp.get(cameraS);
        boolean goToPreset = ((BBoolean)temp.get(goToPresetS)).getBoolean();
        BEnum cameraPreset = (BEnum)temp.get(cameraPresetS);
        boolean sendAlarmToDisplay = ((BBoolean)temp.get(sendAlarmToDisplayS)).getBoolean();
        BComponent[] exts = this.getAlarmSourceExts(op);
        BFacets videoFacets = BFacets.NULL;
        BString nullCameraOrd = BString.make((String)BOrd.NULL.toString());
        if (cameraOrd != null && !cameraOrd.isNull()) {
            try {
                BComponent camera = BOrd.make((String)cameraOrd.getString()).get((BObject)exts[0]).asComponent();
                BString cameraHandleOrd = BString.make((String)camera.getHandleOrd().toString());
                BString cameraSlotPathOrd = BString.make((String)camera.getSlotPathOrd().toString());
                if (videoEnabled) {
                    int preset = cameraPreset.getOrdinal();
                    if (preset == 0) {
                        preset = 1;
                    }
                    videoFacets = BFacets.make((String[])new String[]{"cameraOrd", "cameraHandleOrd", "startRecording", "goToPreset", "cameraPreset", "sendAlarmToDisplay"}, (BIDataValue[])new BIDataValue[]{cameraSlotPathOrd, cameraHandleOrd, BBoolean.make((boolean)videoEnabled), BBoolean.make((boolean)goToPreset), BDynamicEnum.make((BEnum)cameraPreset), BBoolean.make((boolean)sendAlarmToDisplay)});
                }
            }
            catch (Exception ex) {
                videoFacets = BFacets.make((String[])new String[]{"cameraOrd", "cameraHandleOrd", "startRecording", "goToPreset", "cameraPreset", "sendAlarmToDisplay"}, (BIDataValue[])new BIDataValue[]{nullCameraOrd, nullCameraOrd, BBoolean.make((boolean)false), BBoolean.make((boolean)false), BDynamicEnum.make((int)1), BBoolean.make((boolean)false)});
            }
        } else {
            videoFacets = BFacets.make((String[])new String[]{"cameraOrd", "cameraHandleOrd", "startRecording", "goToPreset", "cameraPreset", "sendAlarmToDisplay"}, (BIDataValue[])new BIDataValue[]{nullCameraOrd, nullCameraOrd, BBoolean.make((boolean)false), BBoolean.make((boolean)false), BDynamicEnum.make((int)1), BBoolean.make((boolean)false)});
        }
        if (exts != null) {
            for (int i = 0; i < exts.length; ++i) {
                BComponent alarmExt = exts[i];
                alarmExt.lease();
                BFacets metaData = (BFacets)op.getRequest().getSession().getAttribute(this.facetsAttribute(op));
                if (metaData == null) {
                    metaData = (BFacets)alarmExt.get("metaData");
                }
                if (videoEnabled) {
                    metaData = BFacets.make((BFacets)metaData, (BFacets)videoFacets);
                } else {
                    metaData = BFacets.makeRemove((BFacets)metaData, (String)"cameraOrd");
                    metaData = BFacets.makeRemove((BFacets)metaData, (String)"cameraHandleOrd");
                    metaData = BFacets.makeRemove((BFacets)metaData, (String)"goToPreset");
                    metaData = BFacets.makeRemove((BFacets)metaData, (String)"cameraPreset");
                    metaData = BFacets.makeRemove((BFacets)metaData, (String)"startRecording");
                    metaData = BFacets.makeRemove((BFacets)metaData, (String)"sendAlarmToDisplay");
                }
                op.getRequest().getSession().setAttribute(this.facetsAttribute(op), (Object)metaData);
                this.updateText(op);
                if (!persistFacets) continue;
                alarmExt.set("metaData", (BValue)metaData);
            }
        }
        return temp;
    }

    public static void configureVideoRecipient(BComponent alarmExt, String alarmClassName, HxOp op) {
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmRecipient videoRecipient = (BAlarmRecipient)alarmService.get("videoRecipient");
        if (videoRecipient == null) {
            videoRecipient = new BVideoAlarmRecipient();
            alarmService.add("videoRecipient", (BValue)videoRecipient);
        }
        if (alarmClassName == null) {
            alarmClassName = alarmExt.get("alarmClass").toString();
        }
        alarmService.lease();
        BAlarmClass ac = alarmService.lookupAlarmClass(alarmClassName);
        BLink[] links = videoRecipient.getLinks((Slot)BAlarmRecipient.routeAlarm);
        for (int l = 0; l < links.length; ++l) {
            if (!links[l].getSourceComponent().equals((Object)ac)) continue;
        }
        LinkCheck checkLink = videoRecipient.checkLink((BComponent)ac, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, (Context)op);
        if (checkLink.isValid()) {
            BLink link = videoRecipient.makeLink((BComponent)ac, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, (Context)op);
            videoRecipient.add(null, (BValue)link);
        }
    }

    public boolean process(HxOp op) throws Exception {
        BComponent[] exts = this.getAlarmSourceExts(op);
        if (exts == null || exts.length == 0) {
            return super.process(op);
        }
        HxOp fieldOp = op.make("ext", (BObject)exts[0], null);
        if (super.process(op)) {
            return true;
        }
        Tab tab = this.getTab(op);
        if (tab == null) {
            return false;
        }
        if (!this.matchesScope(fieldOp)) {
            return false;
        }
        return tab.process();
    }

    public BComponent[] getAlarmSourceExts(HxOp op) {
        if (op != null) {
            return new BComponent[]{(BComponent)op.get()};
        }
        return null;
    }

    private BComponent resolveRemoteCamera(BIRemoteVideoCamera cameraPoint) throws Exception {
        BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)cameraPoint.getNiagaraStation());
        return RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)cameraPoint.getRemoteVideoOrd().toString());
    }

    public Tab getTab(HxOp op) throws Exception {
        BEnumRange range;
        boolean sendAlarmToDisplay;
        int cameraPreset;
        boolean goToPreset;
        boolean cameraOrdDefined;
        BString cameraOrd;
        BComponent ext;
        block11: {
            BComponent[] exts = this.getAlarmSourceExts(op);
            if (exts == null || exts.length <= 0) {
                return null;
            }
            ext = exts[0];
            ext.lease();
            BFacets extensionFacets = this.getExtensionFacets(op, ext);
            cameraOrd = (BString)extensionFacets.get("cameraHandleOrd");
            if (cameraOrd == null) {
                cameraOrd = (BString)extensionFacets.get("cameraOrd");
            }
            cameraOrdDefined = cameraOrd != null;
            goToPreset = extensionFacets.getb("goToPreset", false);
            cameraPreset = extensionFacets.geti("cameraPreset", 0);
            sendAlarmToDisplay = extensionFacets.getb("sendAlarmToDisplay", false);
            range = BEnumRange.DEFAULT;
            if (cameraOrdDefined) {
                BComponent camera = null;
                try {
                    String cameraOrdString = cameraOrd.getString();
                    camera = (BComponent)BOrd.make((String)cameraOrdString).resolve((BObject)ext).get();
                    if (camera instanceof BIRemoteVideoCamera) {
                        BComponent remoteCamera = this.resolveRemoteCamera((BIRemoteVideoCamera)camera);
                        remoteCamera.lease();
                        range = (BEnumRange)remoteCamera.get("presetText");
                    } else {
                        range = (BEnumRange)camera.get("presetText");
                    }
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.FINE)) break block11;
                    this.log.log(Level.FINE, "Error resolving camera", e);
                }
            }
        }
        if (range == null) {
            range = BEnumRange.DEFAULT;
        }
        BComponent temp = new BComponent();
        String videoEnabledS = SlotPath.escape((String)this.lex.getText("videoEnabled"));
        String cameraS = SlotPath.escape((String)this.lex.getText("camera"));
        String goToPresetS = SlotPath.escape((String)this.lex.getText("goToPreset"));
        String cameraPresetS = SlotPath.escape((String)this.lex.getText("cameraPreset"));
        String sendAlarmToDisplayS = SlotPath.escape((String)this.lex.getText("sendAlarmToDisplay"));
        temp.add(videoEnabledS, (BValue)BBoolean.make((boolean)cameraOrdDefined));
        String stationName = this.getStationName(op);
        if (cameraOrdDefined) {
            if (!cameraOrd.getString().startsWith("station:")) {
                cameraOrd = BString.make((String)("station:" + stationName + "|" + cameraOrd.toString()));
            }
        } else {
            cameraOrd = BString.make((String)("station:" + stationName));
        }
        temp.add(cameraS, (BValue)cameraOrd);
        temp.add(goToPresetS, (BValue)BBoolean.make((boolean)goToPreset));
        temp.add(cameraPresetS, (BValue)BDynamicEnum.make((int)cameraPreset, (BEnumRange)range));
        temp.add(sendAlarmToDisplayS, (BValue)BBoolean.make((boolean)sendAlarmToDisplay));
        String[] fieldNames = new String[]{videoEnabledS, cameraS, goToPresetS, cameraPresetS, sendAlarmToDisplayS};
        String[] fieldEditors = new String[]{"hx:HxBooleanFE", "videoHx:HxVideoCameraPickerFE", "hx:HxBooleanFE", "hx:HxEnumFE", "hx:HxBooleanFE"};
        BFacets facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets((String[])fieldNames), (BFacets)BHxFieldSheet.getFieldEditorsProvidedFacets((String[])fieldEditors));
        HxOp fieldOp = op.make("ext", (BObject)ext, null);
        fieldOp = fieldOp.make("videoSetup", (BObject)temp, facets);
        SmartCommand.matchReadonly((HxOp)fieldOp, (HxOp)op);
        Tab tab = new Tab((BHxView)BHxFieldSheet.INSTANCE, "", fieldOp);
        return tab;
    }

    protected BFacets getExtensionFacets(HxOp op, BComponent ext) {
        BFacets extensionFacets = BFacets.DEFAULT;
        extensionFacets = this instanceof TableVideoCommand ? (BFacets)ext.get("metaData") : (BFacets)op.getRequest().getSession().getAttribute(this.facetsAttribute(op));
        if (extensionFacets == null) {
            extensionFacets = (BFacets)ext.get("metaData");
        }
        if (extensionFacets == null) {
            extensionFacets = BFacets.DEFAULT;
        }
        return extensionFacets;
    }

    protected String getStationName(HxOp op) {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        if (selectionList.length > 0) {
            String rowId = selectionList[0];
            int idx = rowId.indexOf(59);
            String stationName = SlotPath.unescape((String)rowId.substring(0, idx));
            return stationName;
        }
        return Sys.getStation().getStationName();
    }

    protected class VideoDialog
    extends DynamicDialog {
        VideoDialog(Command handler, String title) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            VideoCommand.this.getTab(op).write();
        }
    }
}

