/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.hx.ErrorDialog;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxSecAlarmClassFE;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmService;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class EditAlarmClass
extends SmartCommand {
    protected EditDialog dlg = new EditDialog((Command)this, this.getDisplayName(null));

    public EditAlarmClass(BHxView view) {
        super(view);
    }

    public String getName(HxOp op) {
        return "editAlarmClass";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.anySelection;
    }

    public void handle(HxOp op) throws Exception {
        if (!this.dlg.isSubmit(op)) {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList == null || selectionList.length < 1) {
                return;
            }
            this.dlg.open(op);
            return;
        }
        this.save(op);
        BHxSmartTableView sView = (BHxSmartTableView)this.getView();
        if (sView.isEnabled(op)) {
            sView.reloadTable(op);
        }
    }

    public BObject save(HxOp op) throws Exception {
        BString alarmClass = (BString)this.getTab(op).save();
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        if (selectionList == null || selectionList.length < 1) {
            return null;
        }
        String lastStationName = null;
        for (int i = 0; i < selectionList.length; ++i) {
            BAlarmService alarmService;
            BAlarmRecipient videoRecip;
            BComponent alarmExt;
            String rowId = selectionList[i];
            int idx = rowId.indexOf(59);
            String stationName = SlotPath.unescape((String)rowId.substring(0, idx));
            String slotPath = rowId.substring(idx + 1, rowId.length());
            BOrd ord = BOrd.make((String)("station:|" + slotPath));
            if (stationName.equals(Sys.getStation().getStationName())) {
                alarmExt = (BComponent)ord.get();
            } else {
                BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
                BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)station);
                alarmExt = RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)ord.toString());
                if (lastStationName != null && !lastStationName.equals(stationName)) {
                    BAlarmService service = (BAlarmService)foxSession.getService(BAlarmService.TYPE);
                    service.lease();
                    BAlarmClass bAlarmClass = service.lookupAlarmClass(alarmClass.toString());
                    if (bAlarmClass.equals((Object)service.getDefaultAlarmClass()) && !alarmClass.toString().equals("defaultAlarmClass")) {
                        new ErrorDialog("Error", (Command)this, (Throwable)new Exception(this.lex.getText("error.alarmClassDoesNotExistOnStation", new Object[]{"" + SlotPath.unescape((String)alarmClass.toString()), foxSession.getStationName()}))).open(op);
                        return alarmClass;
                    }
                }
            }
            lastStationName = stationName;
            alarmExt.lease();
            alarmExt.set(alarmExt.getProperty("alarmClass"), (BValue)BString.make((String)alarmClass.toString()), (Context)op);
            if (((BFacets)alarmExt.get("metaData")).get("cameraOrd") == null || (videoRecip = (BAlarmRecipient)(alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).get("videoRecipient")) == null) continue;
            BAlarmClass ac = alarmService.lookupAlarmClass(alarmClass.toString());
            BLink[] links = videoRecip.getLinks((Slot)BAlarmRecipient.routeAlarm);
            for (int l = 0; l < links.length; ++l) {
                if (!links[l].getSourceComponent().equals((Object)ac)) continue;
            }
            if (!videoRecip.checkLink((BComponent)ac, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, (Context)op).isValid()) continue;
            BLink link = videoRecip.makeLink((BComponent)ac, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, (Context)op);
            videoRecip.add(null, (BValue)link);
        }
        return alarmClass;
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        Tab tab = this.getTab(op);
        if (tab == null) {
            return false;
        }
        if (!this.matchesScope(tab.op)) {
            return false;
        }
        return tab.process();
    }

    public BObject getBase(HxOp op) {
        BObject o = op.get();
        HxOp t = op;
        while (!(t.get() instanceof BISpaceNode) || ((BISpaceNode)t.get()).getSession() == null) {
            o = t.get();
            t = t.getBaseOrdTarget();
        }
        return t.get();
    }

    public Tab getTab(HxOp op) {
        BComponent ext;
        BHxSecAlarmClassFE alarmClassFE = BHxSecAlarmClassFE.INSTANCE;
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        if (selectionList == null || selectionList.length < 1) {
            return null;
        }
        boolean mixedStations = false;
        boolean hasCurrentStation = false;
        String lastStationName = null;
        int bestId = 0;
        for (int i = 0; i < selectionList.length; ++i) {
            String rowId = selectionList[i];
            int idx = rowId.indexOf(59);
            String stationName = SlotPath.unescape((String)rowId.substring(0, idx));
            if (stationName.equals(Sys.getStation().getStationName()) && !hasCurrentStation) {
                hasCurrentStation = true;
                bestId = i;
            }
            if (lastStationName != null && !lastStationName.equals(stationName)) {
                mixedStations = true;
            }
            lastStationName = stationName;
        }
        String rowId = selectionList[bestId];
        int idx = rowId.indexOf(59);
        String stationName = SlotPath.unescape((String)rowId.substring(0, idx));
        String slotPath = rowId.substring(idx + 1, rowId.length());
        BOrd ord = BOrd.make((String)("station:|" + slotPath));
        if (stationName.equals(Sys.getStation().getStationName())) {
            ext = (BComponent)ord.get();
        } else {
            BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
            BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)station);
            ext = RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)ord.toString());
        }
        ext.lease();
        Property p = ext.getProperty("alarmClass");
        HxOp fieldOp = op.make("ext", (BObject)ext, null);
        fieldOp = fieldOp.make(this.getName(op), (BObject)ext.get(p), ext.getSlotFacets((Slot)p));
        fieldOp = fieldOp.mergeFacets(BHxSecAlarmClassFE.noVideo);
        Tab tab = new Tab((BHxView)alarmClassFE, "", fieldOp);
        return tab;
    }

    protected class EditDialog
    extends DynamicDialog {
        EditDialog(Command handler, String title) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            EditAlarmClass.this.getTab(op).write();
        }
    }
}

