/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.alarm.db.file.BFileAlarmDbConfig;
import com.tridium.alarm.hx.BHxAlarmConsole;
import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.fieldeditors.BHxSmartDefaultFE;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.securityUtil.query.BAlarmHistory;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BAlarmDataFE;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmDbConfig;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

public class BHxAlarmDbSmartTableView
extends BHxQueryTableView {
    public static final BHxAlarmDbSmartTableView INSTANCE = new BHxAlarmDbSmartTableView();
    public static final Type TYPE = Sys.loadType(BHxAlarmDbSmartTableView.class);
    public static final Lexicon lexicon = Lexicon.make(BHxAlarmDbSmartTableView.class);
    private static BImage yellowAlarmImg = BImage.make((String)"module://icons/x16/alarm.png");
    private static BImage redAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
    private static BImage greenAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
    private static BImage orangeAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmOrange.png");
    private static BImage whiteAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmWhite.png");
    private static BImage arrow = BImage.make((String)"module://icons/x16/doubleArrowRight.png");
    private static BImage linkImg = BImage.make((BIcon)BIcon.std((String)"link.png"));
    SmartCommand detailsCommand = new DetailsCommand((BHxView)this);
    SmartCommand configureCommand;
    SmartCommand reviewVideo;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxAlarmDbSmartTableView() {
        this.registerEvent((Event)this.detailsCommand);
        this.configureCommand = new ConfigureCommand((BHxView)this);
        this.registerEvent((Event)this.configureCommand);
        this.reviewVideo = new ReviewVideo((BHxView)this);
        this.registerEvent((Event)this.reviewVideo);
    }

    public static BTypeSpec getRowType(HxOp op) {
        return BAlarmRecord.TYPE.getTypeSpec();
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array arr = new Array((Object[])super.getButtonCommands(op));
        arr.remove((Object)this.addCommand);
        arr.remove((Object)this.deleteCommand);
        arr.remove((Object)this.hyperlinkCommand);
        arr.remove((Object)this.renameCommand);
        arr.add((Object)this.detailsCommand);
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        if (service.getPermissions((Context)op).hasAdminWrite() && op.get().asComponent().getPermissions((Context)op).hasAdminWrite()) {
            arr.add((Object)this.configureCommand);
        }
        if (BEnterpriseSecurityService.isVideoDriverAvailable()) {
            arr.add((Object)this.reviewVideo);
        }
        return (SmartCommand[])arr.trim();
    }

    @Override
    public String getRowKey(Type rowType, TableCursor cursor, HxOp op) {
        Column keyColumn = cursor.getTable().getColumns().get("uuid");
        return cursor.cell(keyColumn).toString();
    }

    @Override
    public BImage[] getRowIcons(TableCursor cursor, HxOp op) {
        BImage[] images = new BImage[]{this.getVideoIcon(cursor, op), this.getRowIcon(cursor, op)};
        return images;
    }

    public BImage getVideoIcon(TableCursor cursor, HxOp op) {
        BObject cameraOrd;
        BAlarmRecord alarmRecord = (BAlarmRecord)cursor.get();
        if (alarmRecord != null && (cameraOrd = alarmRecord.getAlarmData().get("cameraOrd")) != null) {
            return BImage.make((BIcon)BIcon.make((String)Lexicon.make(BHxAlarmConsole.class).getText("commands.showVideo.icon")));
        }
        return BImage.make((BIcon)BIcon.std((String)"blank.png"));
    }

    @Override
    public BImage getRowIcon(TableCursor cursor, HxOp op) {
        try {
            Column keyColumn = cursor.getTable().getColumns().get("ackState");
            BAckState ackState = BAckState.acked;
            BEnumRange range = ackState.getRange();
            int[] ordinals = range.getOrdinals();
            String displayTag = cursor.cell(keyColumn).toString();
            for (int i = 0; i < ordinals.length; ++i) {
                if (!range.getDisplayTag(ordinals[i], (Context)op).equals(displayTag)) continue;
                ackState = BAckState.make((int)ordinals[i]);
            }
            keyColumn = cursor.getTable().getColumns().get("sourceState");
            BSourceState sourceState = BSourceState.alert;
            range = sourceState.getRange();
            ordinals = range.getOrdinals();
            displayTag = cursor.cell(keyColumn).toString();
            for (int i = 0; i < ordinals.length; ++i) {
                if (!range.getDisplayTag(ordinals[i], (Context)op).equals(displayTag)) continue;
                sourceState = BSourceState.make((int)ordinals[i]);
            }
            if (sourceState == BSourceState.alert) {
                return orangeAlarmImg;
            }
            if (ackState == BAckState.acked && sourceState != BSourceState.normal) {
                return yellowAlarmImg;
            }
            if (ackState != BAckState.acked && sourceState != BSourceState.normal) {
                return redAlarmImg;
            }
            if (ackState != BAckState.acked && sourceState == BSourceState.normal) {
                return greenAlarmImg;
            }
            return whiteAlarmImg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return true;
    }

    public boolean defaultAutoRefresh(HxOp op) {
        return false;
    }

    public BOrdList getSourceOrdList(HxOp op) {
        String source = (String)op.getRequest().getSession().getAttribute("source");
        if (source == null) {
            return null;
        }
        try {
            source = SlotPath.unescape((String)source);
            return BOrdList.make((String)source);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BAlarmRecord[] getHistoricalRecords(HxOp op) throws Exception {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        Array records = new Array(BAlarmRecord.class);
        for (int i = 0; i < selectionList.length; ++i) {
            String rowId = BHxAlarmDbSmartTableView.unscopeId((String)selectionList[i]);
            String[] split = TextUtil.split((String)rowId, (char)'.');
            BUuid uuid = BUuid.make((String)split[0]);
            BOrd ord = BOrd.make((String)("alarm:|bql:select * where uuid = Uuid '" + uuid + "'"));
            BITable result = (BITable)ord.resolve(op.get()).get();
            TableCursor c = result.cursor();
            while (c.next()) {
                BAlarmRecord record = (BAlarmRecord)c.get();
                record = (BAlarmRecord)record.newCopy();
                records.add((Object)record);
            }
        }
        return (BAlarmRecord[])records.trim();
    }

    public static Tab getTab(HxOp op) {
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmDbConfig alarmDbConfig = service.getAlarmDbConfig();
        BFacets facets = alarmDbConfig.getSlotFacets((Slot)BFileAlarmDbConfig.capacity);
        HxOp fieldOp = op.make("alarmDbConfig", (BObject)alarmDbConfig, facets);
        String[] fieldNames = new String[]{BFileAlarmDbConfig.capacity.getName()};
        fieldOp = fieldOp.mergeFacets(BHxFieldSheet.getFieldsProvidedFacets((String[])fieldNames));
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, fieldOp);
    }

    public class ReviewVideo
    extends SmartCommand {
        public ReviewVideo(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "reviewVideo";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            Lexicon lex = Lexicon.make(((Object)((Object)this)).getClass());
            BAlarmRecord[] records = BHxAlarmDbSmartTableView.this.getHistoricalRecords(op);
            if (records == null || records.length == 0) {
                new ErrorDialog(lex.getText("alarmHistory.noAlarmFoundErrorDialog.title"), (Command)this, (Throwable)new Exception(lex.getText("alarmHistory.noAlarmFoundErrorDialog.message"))).open(op);
                return;
            }
            BAlarmRecord alarmRecord = records[0];
            try {
                if (alarmRecord.getAlarmFacet("cameraOrd") == null && alarmRecord.getAlarmFacet("cameraHandleOrd") == null) {
                    new ErrorDialog(lex.getText("alarmHistory.nonVideoAlarmDialog.title"), (Command)this, (Throwable)new Exception(lex.getText("alarmHistory.nonVideoAlarmDialog.message"))).open(op);
                    return;
                }
                HtmlWriter out = op.getHtmlWriter();
                BAlarmHistory recip = (BAlarmHistory)op.get();
                out.w((Object)("window.open('ord?local:|station:|" + recip.getSlotPath() + "|view:entsecHx:HxVideoReviewView?uuid=" + alarmRecord.getUuid() + "','reviewVideo','width=600,height=600');"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class ConfigureDialog
    extends Dialog {
        public ConfigureDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            BHxAlarmDbSmartTableView.getTab(op).write();
        }
    }

    public class ConfigureCommand
    extends SmartCommand {
        ConfigureDialog dialog;

        public ConfigureCommand(BHxView view) {
            super(view);
            this.lex = Lexicon.make(BHxAlarmDbSmartTableView.class);
            this.dialog = new ConfigureDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "configureHistory";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            BHxAlarmDbSmartTableView.getTab(op).save();
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }
    }

    public class DetailsCommand
    extends SmartCommand {
        DetailsDialog dialog;

        public DetailsCommand(BHxView view) {
            super(view);
            this.dialog = new DetailsDialog("Alarm Details", (Command)this);
        }

        public String getName(HxOp op) {
            return "showAlarmDetails";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public boolean process(HxOp op) throws Exception {
            if (this.matchesScope(op)) {
                return this.getTab(op).process();
            }
            return false;
        }

        public BAlarmRecord getRecord(HxOp op) throws Exception {
            return this.getRecord(false, op);
        }

        public BAlarmRecord getRecord(boolean encodeBackup, HxOp op) throws Exception {
            String encoding = null;
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList != null && selectionList.length > 0) {
                encoding = selectionList[0];
                if (BHxAlarmDbSmartTableView.this.scopeRowIds(op)) {
                    encoding = TextUtil.split((String)encoding, (char)'~')[1];
                }
                if (encodeBackup) {
                    BHxSmartTableView.writeFormValue((String)"recBackup", (String)encoding, (HxOp)op);
                }
            } else {
                encoding = op.getFormValue("recBackup");
            }
            BUuid uuid = BUuid.make((String)encoding);
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
                BAlarmRecord rec;
                BAlarmRecord bAlarmRecord = rec = conn.getRecord(uuid);
                return bAlarmRecord;
            }
        }

        public Tab getTab(HxOp op) throws Exception {
            BAlarmRecord rec = this.getRecord(op);
            String dFE = BHxSmartDefaultFE.TYPE.toString();
            String[] fieldNames = new String[]{"timestamp", "uuid", "sourceState", "ackState", "ackRequired", "source", "alarmClass", "priority", "normalTime", "ackTime", "user", "alarmData", "alarmTransition", "lastUpdate"};
            String[] fieldEditors = new String[]{dFE, dFE, dFE, dFE, dFE, BHxSmartDefaultFE.TYPE.toString(), dFE, dFE, dFE, dFE, dFE, BAlarmDataFE.TYPE.toString(), dFE, dFE};
            BFacets facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets((String[])fieldNames), (BFacets)BHxFieldSheet.getFieldEditorsProvidedFacets((String[])fieldEditors));
            HxOp subOp = op.make("showAlarmDetails", (BObject)rec, facets);
            return new Tab((BHxView)BHxFieldSheet.INSTANCE, subOp);
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
        }

        public class DetailsDialog
        extends Dialog {
            public DetailsDialog(String title, Command handler) {
                super(title, handler);
            }

            public void open(HxOp op) throws Exception {
                super.open(op);
            }

            protected void writeContent(HxOp op) throws Exception {
                BAlarmRecord rec = DetailsCommand.this.getRecord(op);
                DetailsCommand.this.getTab(op).write();
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand()};
            }
        }
    }
}

