/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmPriorities;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxAlarmClassesView
extends BHxQueryTableView {
    public static final BHxAlarmClassesView INSTANCE = new BHxAlarmClassesView();
    public static final Type TYPE = Sys.loadType(BHxAlarmClassesView.class);
    EditPriorityCommand editCommand = new EditPriorityCommand((BHxView)this);
    DeleteAlarmClassCommand deleteAlarmClassCommand;
    protected SmartCommand alarmRenameCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxAlarmClassesView() {
        this.registerEvent((Event)this.editCommand);
        this.deleteAlarmClassCommand = new DeleteAlarmClassCommand((BHxView)this);
        this.registerEvent((Event)this.deleteAlarmClassCommand);
        this.alarmRenameCommand = new AlarmRenameCommand((BHxView)this);
        this.registerEvent((Event)this.alarmRenameCommand);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.addCommand, this.hyperlinkCommand, this.editCommand, this.deleteAlarmClassCommand, this.alarmRenameCommand, this.columnsCommand, this.filterCommand, this.reportCommand, this.exportCommand};
    }

    public class AlarmRenameCommand
    extends BHxQueryTableView.RenameSubjectCommand {
        public AlarmRenameCommand(BHxView view) {
            super(view);
        }

        public void renamed(String oldName, String newName, BComponent renamed, HxOp op) {
            IntrusionUtil.renameAlarmClass((String)oldName, (String)newName);
        }
    }

    public static class DeleteAlarmClassCommand
    extends SmartCommand {
        ConfirmDialog dlg;

        public DeleteAlarmClassCommand(BHxView view) {
            super(view);
            this.dlg = new ConfirmDialog(this.lex.getText("confirmAlarmClassDelete.title"), (Command)this);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            Object[] subjects = BHxQueryTableView.getSubjects(op);
            if (!this.dlg.isSubmit(op)) {
                int count = 0;
                for (int i = 0; i < subjects.length; ++i) {
                    String name = ((BComponent)subjects[i]).getName();
                    if (name.equals("defaultAlarmClass")) {
                        new ErrorDialog(this.lex.getText("cannotDelete.title"), (Command)this, (Throwable)new Exception(this.lex.getText("cannotDeleteDefaultAlarmClass.msg"))).open(op);
                        return;
                    }
                    count += IntrusionUtil.getAlarmSourceExtUsage((String)name).length;
                    count += IntrusionUtil.getAlarmSourceInfoUsage((String)name).length;
                }
                String message = this.lex.getText("confirmAlarmClassDelete.msgOk");
                if (count > 0) {
                    message = this.lex.getText("confirmAlarmClassDelete.msg", new Object[]{"" + count});
                }
                this.dlg.open(message, op);
                return;
            }
            for (int i = 0; i < subjects.length; ++i) {
                BComponent subject = (BComponent)subjects[i];
                String name = subject.getName();
                Property p = subject.getPropertyInParent();
                if (p.isFrozen()) {
                    throw new IllegalStateException("Cannot Delete Frozen Property");
                }
                subject.getParent().asComponent().remove(p, (Context)op);
                IntrusionUtil.renameAlarmClass((String)name, (String)"defaultAlarmClass");
            }
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }
    }

    public static class EditPriorityCommand
    extends SmartCommand {
        protected EditDialog dlg = new EditDialog((Command)this, this.getDisplayName(null));

        public EditPriorityCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "editPriority";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            this.save(op);
            BHxSmartTableView sView = (BHxSmartTableView)this.getView();
            if (sView.isEnabled(op)) {
                sView.reloadTable(op);
            }
        }

        public BObject save(HxOp op) throws Exception {
            BInteger priority = (BInteger)this.getTab(op).save();
            int intPriority = priority.getInt();
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            for (int i = 0; i < selectionList.length; ++i) {
                BOrd ord = BOrd.make((String)("station:|" + ((BHxSmartTableView)this.getView()).unscopeId(selectionList[i], op)));
                BAlarmClass alarmClass = (BAlarmClass)ord.get(this.getBase(op));
                alarmClass.lease();
                alarmClass.setPriority(BAlarmPriorities.make((int)intPriority, (int)intPriority, (int)intPriority, (int)intPriority));
            }
            return priority;
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            return this.getTab(op).process();
        }

        public BObject getBase(HxOp op) {
            BObject o = op.get();
            HxOp t = op;
            while (!(t.get() instanceof BISpaceNode) || ((BISpaceNode)t.get()).getSession() == null) {
                o = t.get();
                t = t.getBaseOrdTarget();
            }
            return t.get();
        }

        public Tab getTab(HxOp op) {
            String[] selections = SmartCommand.getSelectionList((HxOp)op);
            BHxFieldEditor priorityFE = BHxFieldEditor.makeFor((BObject)BInteger.make((int)255), (Context)op);
            BOrd ord = BOrd.make((String)("station:|" + ((BHxSmartTableView)this.getView()).unscopeId(selections[0], op)));
            BAlarmClass alarmClass = (BAlarmClass)ord.get(this.getBase(op));
            alarmClass.lease();
            Property p = alarmClass.getProperty("priority");
            BAlarmPriorities priorities = alarmClass.getPriority();
            HxOp fieldOp = op.make(this.getName(op), (BObject)BInteger.make((int)priorities.getToOffnormal()), alarmClass.getSlotFacets((Slot)p));
            Tab tab = new Tab((BHxView)priorityFE, "", fieldOp);
            return tab;
        }

        protected class EditDialog
        extends DynamicDialog {
            EditDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                EditPriorityCommand.this.getTab(op).write();
            }
        }
    }
}

