/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.ToggleCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.web.servlets.WbServlet;
import com.tridiumx.entsec.securityUtil.alarm.BLayoutOptions;
import com.tridiumx.entsec.securityUtil.alarm.BPopupOptions;
import com.tridiumx.entsec.securityUtil.alarm.BSecurityAlarmConsoleOptions;
import com.tridiumx.entsec.securityUtil.alarm.BVideoViewingOptions;
import com.tridiumx.entsecHx.BHxAccessProfile;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebService;
import javax.baja.web.UserAgent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BConsolePopupView
extends BHxView
implements BHxAccessProfile.IFullScreen {
    public static final BConsolePopupView INSTANCE = new BConsolePopupView();
    public static final Type TYPE = Sys.loadType(BConsolePopupView.class);
    public static final Lexicon lex = Lexicon.make(BConsolePopupView.class);
    private SmartCommand toggleAlarmLoadingCmd = new ToggleAlarmLoadingCmd(this);
    private SmartCommand alarmPopupSettingCmd;
    private SmartCommand changeLayoutCmd;
    private SmartCommand showAppletCmd;

    public Type getType() {
        return TYPE;
    }

    public BConsolePopupView() {
        this.registerEvent((Event)this.toggleAlarmLoadingCmd);
        this.alarmPopupSettingCmd = new AlarmPopupSettingCmd(this);
        this.registerEvent((Event)this.alarmPopupSettingCmd);
        this.changeLayoutCmd = new ChangeLayoutCmd(this);
        this.registerEvent((Event)this.changeLayoutCmd);
        this.showAppletCmd = new ShowAppletCmd(this);
        this.registerEvent((Event)this.showAppletCmd);
    }

    public String getPageTitle(HxOp op) {
        return ((BConsoleRecipient)op.get()).getDisplayName((Context)op) + " - " + lex.getText("live");
    }

    private BSecurityAlarmConsoleOptions getSecurityAlarmConsoleOptions(HxOp op) {
        BUser user = op.getUser();
        BSecurityAlarmConsoleOptions ac = (BSecurityAlarmConsoleOptions)user.get("entsec_SecurityAlarmConsoleOptions");
        return ac;
    }

    private boolean hasVideoViews(HxOp op) {
        BSecurityAlarmConsoleOptions options = this.getSecurityAlarmConsoleOptions(op);
        options.lease();
        String tag = options.getLayout().getTag().toLowerCase();
        return tag.indexOf("live") > -1 || tag.indexOf("playback") > -1;
    }

    public void write(HxOp op) throws Exception {
        BConsoleRecipient recip = (BConsoleRecipient)op.get();
        BWebService webSvc = (BWebService)Sys.getService((Type)BWebService.TYPE);
        HtmlWriter out = op.getHtmlWriter();
        op.addStyleSheet("module://smartTableHx/rc/smartTable.css");
        op.addJavaScript("module://smartTableHx/rc/smartTable.js");
        int columnSpan = 0;
        out.w((Object)"<table width='100%'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td>");
        out.w((Object)"<span class='smartTable-header'>");
        out.safe((Object)this.getPageTitle(op));
        out.w((Object)"</span>");
        out.w((Object)"</td>");
        ++columnSpan;
        BSecurityAlarmConsoleOptions options = this.getSecurityAlarmConsoleOptions(op);
        if (options.getPermissions((Context)op).hasAdminWrite()) {
            out.w((Object)"<td align='right'>");
            out.w((Object)"<table><tr>");
            if (options.getEnableVideoSettings() && this.hasVideoViews(op)) {
                out.w((Object)"<td>");
                out.w((Object)"<span style='white-space:nowrap; padding-right:5px;' id='videoLoadingStatus'>");
                out.w((Object)"</span>");
                out.w((Object)"</td>");
                out.w((Object)"<td>");
                HxTabUtil.writeCommand((SmartCommand)this.toggleAlarmLoadingCmd, (boolean)true, (HxOp)op);
                out.w((Object)"</td>");
            }
            out.w((Object)"<td>");
            HxTabUtil.writeCommand((SmartCommand)this.alarmPopupSettingCmd, (HxOp)op);
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            HxTabUtil.writeCommand((SmartCommand)this.changeLayoutCmd, (boolean)true, (HxOp)op);
            out.w((Object)"</td>");
            out.w((Object)"</tr></table>");
            out.w((Object)"</td>");
            ++columnSpan;
        }
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td colspan='").w(columnSpan).w((Object)"' id='").w((Object)op.scope("appletdiv")).w((Object)"'>");
        BWebProfileConfig webProfile = new BWebProfileConfig();
        WbServlet.writeApplet((UserAgent)op.getUserAgent(), (HttpServletRequest)op.getRequest(), (HttpServletResponse)op.getResponse(), (HtmlWriter)out, (String)"100%", (String)"100%", (String)("station:|" + recip.getSlotPath() + "|view:entsecHx:SecurityAlarmConsole"), (String)op.getLanguage(), (String)"entsecHx:LiveAlarmConsolePopupProfile", (String)op.getUser().getUsername(), (BWebService)op.getService(), (BWebProfileConfig)webProfile, (String[])new String[0]);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        SmartCommand.forceUpdate((HxOp)op);
        StringBuffer script = new StringBuffer("var label = document.getElementById(&quot;videoLoadingStatus&quot;);");
        if (options.getActionOnNewAlarm().equals((Object)BVideoViewingOptions.loadNewestAlarm)) {
            script.append("label.innerHTML = &quot;<b>" + lex.getText("secAlarmConsole.autoVideoLoadingOn") + "</b>&quot;;");
            script.append("label.style.color = &quot;green&quot;;");
        } else {
            script.append("label.innerHTML = &quot;<b>" + lex.getText("secAlarmConsole.autoVideoLoadingOff") + "</b>&quot;;");
            script.append("label.style.color = &quot;red&quot;;");
        }
        op.addOnload(script.toString());
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
        BHxAccessProfile.fixAppletHeight(op.scope("appletdiv"), 53, op);
    }

    private class ShowAppletCmd
    extends SmartCommand {
        public ShowAppletCmd(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showApplet";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            BHxAccessProfile.hideApplet(op.scope("appletdiv"), false, op);
        }
    }

    private class AlarmPopupSettingDialog
    extends Dialog {
        public AlarmPopupSettingDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            super.writeContent(op);
            BSecurityAlarmConsoleOptions options = BConsolePopupView.this.getSecurityAlarmConsoleOptions(op);
            BPopupOptions setting = options.getAlarmConsolePopup();
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)setting, (Context)op);
            OrdTarget secOptions = new OrdTarget((OrdTarget)op, (BObject)options);
            OrdTarget popupOptions = new OrdTarget(secOptions, (BObject)setting);
            HxOp newOp = op.make("popupOptions", popupOptions);
            editor.write(newOp);
        }

        public Command[] getCommands() {
            return new Command[]{new ShowAppletSubmit(), new ShowAppletCancel()};
        }

        protected class ShowAppletCancel
        extends Dialog.Cancel {
            public ShowAppletCancel() {
                super((Dialog)AlarmPopupSettingDialog.this);
            }

            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                try {
                    b.append(SmartCommand.getInvokeCode((Command)BConsolePopupView.this.showAppletCmd, (String)HxUtil.getOuterQuote((HxOp)op), (HxOp)op));
                }
                catch (Exception e) {
                    throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
                }
                b.append(";");
                b.append(super.getInvokeCode(op));
                return b.toString();
            }
        }

        protected class ShowAppletSubmit
        extends Dialog.Submit {
            public ShowAppletSubmit() {
                super((Dialog)AlarmPopupSettingDialog.this);
            }

            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                try {
                    b.append(SmartCommand.getInvokeCode((Command)BConsolePopupView.this.showAppletCmd, (String)HxUtil.getOuterQuote((HxOp)op), (HxOp)op));
                }
                catch (Exception e) {
                    throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
                }
                b.append(";");
                b.append(super.getInvokeCode(op));
                return b.toString();
            }
        }
    }

    private class AlarmPopupSettingCmd
    extends SmartCommand {
        private Dialog dlg;

        public AlarmPopupSettingCmd(BHxView view) {
            super(view);
            this.dlg = new AlarmPopupSettingDialog(this.lex.getText("alarmPopupSetting.label"), (Command)this);
        }

        public String getName(HxOp op) {
            return "alarmPopupSetting";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            if (!this.dlg.isSubmit(op)) {
                BHxAccessProfile.hideApplet(op.scope("appletdiv"), true, op);
                this.dlg.open(op);
            } else {
                BSecurityAlarmConsoleOptions options = BConsolePopupView.this.getSecurityAlarmConsoleOptions(op);
                BPopupOptions setting = options.getAlarmConsolePopup();
                OrdTarget secOptions = new OrdTarget((OrdTarget)op, (BObject)options);
                OrdTarget popupOptions = new OrdTarget(secOptions, (BObject)setting);
                HxOp newOp = op.make("popupOptions", popupOptions);
                options.setAlarmConsolePopup(BPopupOptions.make((int)Integer.parseInt(newOp.getFormValue("value"))));
            }
        }
    }

    private class ToggleAlarmLoadingCmd
    extends ToggleCommand {
        public ToggleAlarmLoadingCmd(BHxView view) {
            super(view);
        }

        public boolean isSelected(HxOp op) {
            BSecurityAlarmConsoleOptions options = BConsolePopupView.this.getSecurityAlarmConsoleOptions(op);
            return options.getActionOnNewAlarm().equals((Object)BVideoViewingOptions.loadNewestAlarm);
        }

        public boolean handle(boolean selected, HxOp op) throws Exception {
            BSecurityAlarmConsoleOptions options = BConsolePopupView.this.getSecurityAlarmConsoleOptions(op);
            HtmlWriter out = op.getHtmlWriter();
            if (selected) {
                options.setActionOnNewAlarm(BVideoViewingOptions.manualAlarmSelection);
                out.w((Object)"var loadingStatus = document.getElementById('videoLoadingStatus');");
                out.w((Object)"loadingStatus.innerHTML = '<b>").safe((Object)this.lex.getText("secAlarmConsole.autoVideoLoadingOff")).w((Object)"</b>';");
                out.w((Object)"loadingStatus.style.color = 'red';");
            } else {
                options.setActionOnNewAlarm(BVideoViewingOptions.loadNewestAlarm);
                out.w((Object)"var loadingStatus = document.getElementById('videoLoadingStatus');");
                out.w((Object)"loadingStatus.innerHTML = '<b>").safe((Object)this.lex.getText("secAlarmConsole.autoVideoLoadingOn")).w((Object)"</b>';");
                out.w((Object)"loadingStatus.style.color = 'green';");
            }
            return this.isSelected(op);
        }

        public String getName(HxOp op) {
            return "actionOnNewVideoAlarm";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }
    }

    private class LayoutDialog
    extends Dialog {
        public LayoutDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            BSecurityAlarmConsoleOptions options = BConsolePopupView.this.getSecurityAlarmConsoleOptions(op);
            BLayoutOptions layout = options.getLayout();
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)layout, (Context)op);
            OrdTarget secOptions = new OrdTarget((OrdTarget)op, (BObject)options);
            OrdTarget layoutOptions = new OrdTarget(secOptions, (BObject)layout);
            HxOp newOp = op.make("layoutOptions", layoutOptions);
            editor.write(newOp);
        }
    }

    private class ChangeLayoutCmd
    extends SmartCommand {
        private Dialog dlg;

        public ChangeLayoutCmd(BHxView view) {
            super(view);
            this.dlg = new LayoutDialog("Select Layout", (Command)this);
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                BHxAccessProfile.hideApplet(op.scope("appletdiv"), true, op);
                this.dlg.open(op);
            } else {
                BSecurityAlarmConsoleOptions options = BConsolePopupView.this.getSecurityAlarmConsoleOptions(op);
                BLayoutOptions layout = options.getLayout();
                OrdTarget secOptions = new OrdTarget((OrdTarget)op, (BObject)layout);
                OrdTarget layoutOptions = new OrdTarget(secOptions, (BObject)layout);
                HxOp newOp = op.make("layoutOptions", layoutOptions);
                options.setLayout(BLayoutOptions.make((int)Integer.parseInt(newOp.getFormValue("value"))));
                Thread.sleep(700L);
                this.refresh(op);
            }
        }

        public String getName(HxOp op) {
            return "changeLayoutCommand";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }
    }
}

