/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx;

import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.obix.util.WrapperException;
import com.tridium.rdb.exception.PasswordCipherException;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.baja.naming.SlotPath;
import javax.baja.security.AuthenticationException;
import javax.baja.security.PermissionException;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.LocalizableException;
import javax.baja.util.LexiconModule;

public abstract class HxLocalizableExceptionTranslator {
    private static LexiconModule LEX_MODULE = LexiconModule.make((String)"entsecHx");

    public static Exception localize(Exception e) {
        e.printStackTrace();
        if (e instanceof PermissionException) {
            return new LocalizableException("entsec", "permissionException", (Throwable)e);
        }
        if (e instanceof DuplicateSlotException) {
            return new Exception(SlotPath.unescape((String)e.getMessage()), e);
        }
        if (e instanceof ActionInvokeException && e.getCause() instanceof Exception && (e.getMessage() == null || e.getMessage().length() == 0)) {
            return (Exception)e.getCause();
        }
        if (e instanceof LocalizableException) {
            return e;
        }
        if (e instanceof WrapperException) {
            String temp;
            String obixError = e.toString();
            int index = obixError.indexOf(10);
            if (index > -1) {
                obixError = obixError.substring(0, index);
            }
            if ((index = obixError.lastIndexOf("Exception: ")) > -1 && (temp = obixError.substring(index + "Exception: ".length())).length() > 2) {
                obixError = temp;
            }
            return new Exception(obixError, e);
        }
        if (e instanceof FoxAuthenticationException) {
            return new FoxAuthenticationException("FoxAuthenticationException: Authentication Failed ", null);
        }
        if (e instanceof AuthenticationException) {
            return new AuthenticationException("AuthenticationException: Authentication Failed ");
        }
        if (e instanceof UnknownHostException) {
            return new UnknownHostException(e.getMessage());
        }
        if (e instanceof ConnectException) {
            return new ConnectException("ConnectException: fox/foxs Port connection failed");
        }
        if (e instanceof IOException) {
            return new IOException(e.getMessage());
        }
        if (e instanceof PasswordCipherException) {
            String errorMessage = null;
            String errorCode = ((PasswordCipherException)e).getErrorCode();
            errorMessage = errorCode != null ? LEX_MODULE.getText("passwordCipherException." + errorCode + ".message", null) : e.getMessage();
            return new PasswordCipherException(errorMessage);
        }
        if (e instanceof BajaRuntimeException) {
            return new BajaRuntimeException(e.getMessage());
        }
        BEnterpriseSecurityService.LOG.fine("Localization needed:" + e.getClass() + ":" + e.getMessage());
        return e;
    }
}

