/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.photoID;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.hx.fieldeditors.BHxEnumFE;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DialogWizardCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.BPhotoIDTemplate;
import com.tridiumx.entsec.photoID.BPhotoIDTemplateData;
import com.tridiumx.entsec.photoID.crop.BPaperRatio;
import com.tridiumx.entsec.photoID.orion.BBadgeTemplate;
import com.tridiumx.entsec.photoID.orion.BOrionImageFormat;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import com.tridiumx.entsec.photoID.orion.BPhotoIDTemplateRec;
import com.tridiumx.entsecHx.photoID.BCropViewer;
import com.tridiumx.entsecHx.photoID.BHxPortraitFE;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class CropWizard
extends DialogWizardCommand {
    protected SmartCommand finishCrop;

    public CropWizard(BHxView view) {
        super(view);
        this.finishCrop = new FinishCrop(view);
        view.registerEvent((Event)this.finishCrop);
    }

    public DialogWizardCommand.Step[] makeSteps() {
        return new DialogWizardCommand.Step[]{new RatioStep("ratioStep", (Command)this), new CropWaitingStep("cropWaitingStep", (Command)this)};
    }

    public String getFirstStepName(HxOp op) {
        return "ratioStep";
    }

    public String getName(HxOp op) {
        return "cropWizard";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public BImage getImage(HxOp op) {
        BOrd ord = (BOrd)op.get();
        return BImage.make((BOrd)ord);
    }

    public static BOrionObject getOrionObject(HxOp op) {
        BObject o = op.get();
        HxOp t = op;
        while (!(t.get() instanceof BIOrionObject)) {
            o = t.get();
            t = t.getBaseOrdTarget();
        }
        return (BOrionObject)t.get();
    }

    public static BPhotoIDTemplateData getNewTemplateData(HxOp op) {
        String templateDataSlotPath = (String)op.getRequest().getSession().getAttribute("templateData");
        if (templateDataSlotPath == null || templateDataSlotPath.equals("null")) {
            return null;
        }
        BPhotoIDTemplateData templateData = null;
        try {
            templateData = (BPhotoIDTemplateData)BOrd.make((String)("station:|" + templateDataSlotPath)).get();
            return templateData;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void updateImageWithMaxHeight(BImage image, String formName, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"var img=$$('").safe((Object)formName).w((Object)"').getElementsByTagName('IMG')[0];");
        image.syncDimensions();
        double width = image.getWidth();
        double height = image.getHeight();
        if (image.getHeight() > (double)BHxPortraitFE.PORTRAIT_HEIGHT) {
            double ratio = image.getWidth() / image.getHeight();
            width = (double)BHxPortraitFE.PORTRAIT_HEIGHT * ratio;
            height = BHxPortraitFE.PORTRAIT_HEIGHT;
        }
        out.w((Object)"img.src='ord?").w((Object)image.getOrdList()).w((Object)"';");
        out.w((Object)("img.style.height='" + height + "px';"));
        out.w((Object)("img.style.width='" + width + "px';"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChoices(HxOp op) {
        Array a = new Array();
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        OrionSession session = null;
        try {
            session = service.createSession((Context)op);
            BOrionObject o = CropWizard.getOrionObject(op);
            if (o instanceof BPerson) {
                BPerson person = (BPerson)o;
                BBadge[] badges = (BBadge[])person.getBadges(session).toArray();
                for (int i = 0; i < badges.length; ++i) {
                    a.addAll(this.getChoices(badges[i], session, op));
                }
            } else if (o instanceof BBadge) {
                a.addAll(this.getChoices((BBadge)o, session, op));
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
        BogCursor c = new BogCursor((BComplex)network, 10, new Type[]{BPhotoIDTemplateData.TYPE}, true, (Context)op);
        while (c.next()) {
            BPhotoIDTemplateData data = (BPhotoIDTemplateData)c.get();
            if (!data.isPhotoData() || CropWizard.containsTemplateData(data, a)) continue;
            BPhotoIDTemplate template = (BPhotoIDTemplate)data.getParent();
            CaptureData captureData = new CaptureData();
            captureData.imageRatio = (BPaperRatio)data.get("imageRatio");
            captureData.displayString = "Image Ratio " + captureData.imageRatio.toString((Context)op) + " (Template " + template.getDisplayName((Context)op) + "." + data.getDisplayName((Context)op) + ")";
            captureData.image = BImage.make((BIcon)template.getIcon());
            captureData.templateData = data;
            captureData.saveToBadge = true;
            a.add((Object)captureData);
        }
        CaptureData defaultCaptureData = new CaptureData();
        defaultCaptureData.imageRatio = network.getDefaultImageRatio();
        defaultCaptureData.displayString = "Image Ratio " + network.getDefaultImageRatio().toString((Context)op) + " (Default)";
        defaultCaptureData.image = BImage.make((BIcon)BIcon.std((String)"shapes/diamondBlue.png"));
        a.add((Object)defaultCaptureData);
        CaptureData freehandCaptureData = new CaptureData();
        freehandCaptureData.displayString = "Freehand";
        freehandCaptureData.image = BImage.make((BIcon)BIcon.std((String)"shapes/diamondRed.png"));
        freehandCaptureData.imageRatio = BPaperRatio.FREEHAND;
        a.add((Object)freehandCaptureData);
        return a.trim();
    }

    public Object[] getChoices(BBadge badge, OrionSession session, HxOp op) {
        Array a = new Array();
        BBadgeTemplate badgeTemplate = new BBadgeTemplate();
        badgeTemplate.setBadge(BRef.make((BIOrionObject)badge));
        badgeTemplate = (BBadgeTemplate)session.read((BIOrionObject)badgeTemplate);
        if (badgeTemplate != null) {
            BPhotoIDTemplateRec rec = badgeTemplate.resolveTemplate(session);
            BPhotoIDTemplate template = (BPhotoIDTemplate)MappingSupport.getMappedOrd((BIOrdMappable)rec).get();
            BPhotoIDTemplateData[] templateData = (BPhotoIDTemplateData[])template.getChildren(BPhotoIDTemplateData.class);
            for (int j = 0; j < templateData.length; ++j) {
                if (!templateData[j].isPhotoData()) continue;
                CaptureData captureData = new CaptureData();
                captureData.imageRatio = (BPaperRatio)templateData[j].get("imageRatio");
                captureData.displayString = "Image Ratio " + captureData.imageRatio.toString((Context)op) + " (Badge " + badge.toDisplayString((Context)op) + ", Template " + template.getDisplayName((Context)op) + "." + templateData[j].getDisplayName((Context)op) + ")";
                captureData.image = BImage.make((BIcon)badge.getIcon());
                captureData.templateData = templateData[j];
                captureData.badgeRef = BRef.make((BIOrionObject)badge);
                a.add((Object)captureData);
            }
        }
        return a.trim();
    }

    public static boolean containsTemplateData(BPhotoIDTemplateData data, Array choices) {
        for (int i = 0; i < choices.size(); ++i) {
            CaptureData captureData = (CaptureData)choices.get(i);
            if (captureData.templateData == null || captureData.templateData != data) continue;
            return true;
        }
        return false;
    }

    public static class CaptureChoiceRenderer
    implements DialogWizardCommand.ChoiceRenderer {
        public String getValue(Object o, HxOp op) {
            CaptureData data = (CaptureData)o;
            return this.getImageRatioValue(data) + "|" + this.getTemplateDataValue(data) + "|" + this.getBadgeRef(data);
        }

        public String getImageRatioValue(CaptureData data) {
            if (data.imageRatio == null) {
                return "";
            }
            return data.imageRatio.encodeToString();
        }

        public String getTemplateDataValue(CaptureData data) {
            if (data.templateData == null) {
                return "";
            }
            return "" + data.templateData.getSlotPath();
        }

        public String getBadgeRef(CaptureData data) {
            if (data.badgeRef == null) {
                return "";
            }
            try {
                return "" + data.badgeRef.encodeToString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        public String getDisplayName(Object o, HxOp op) {
            return ((CaptureData)o).displayString;
        }

        public BImage getIcon(Object o, HxOp op) {
            return ((CaptureData)o).image;
        }
    }

    public static class CaptureData {
        public BPaperRatio imageRatio;
        public String displayString;
        public BPhotoIDTemplateData templateData;
        public BImage image;
        public BRef badgeRef;
        public boolean saveToBadge = false;
    }

    public class FinishCrop
    extends SmartCommand {
        public FinishCrop(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "finishCrop";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String fileBody = op.getFormValue("newFileOrd");
            if (fileBody == null) {
                return;
            }
            fileBody = TextUtil.replace((String)fileBody, (String)"/", (String)".");
            String[] split = TextUtil.split((String)fileBody, (char)'.');
            String stringUuid = split[split.length - 2];
            BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(stringUuid);
            BPerson person = (BPerson)CropWizard.getOrionObject(op);
            BOrionDatabase db = person.getOrionDatabase();
            OrionSession session = null;
            BPersonPortrait portrait = null;
            try {
                session = db.createSession((Context)op);
                portrait = (BPersonPortrait)session.read(BPersonPortrait.ORION_TYPE, (BSimple)uuid);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            if (portrait == null) {
                String quote = "'";
                String quote2 = "\\'";
                out.w((Object)"setTimeout(").w((Object)quote);
                out.w((Object)SmartCommand.getInvokeCode((Command)this, (String)quote2, (HxOp)op));
                out.w((Object)quote).w((Object)", 1000);");
            } else {
                BOrd fileOrd = portrait.getImageOrd();
                BImage image = BImage.make((BOrd)fileOrd);
                SmartCommand.tryException((HxOp)op);
                SmartCommand.disable((String)op.scope("submit"), (boolean)false, (HxOp)op);
                CropWizard.updateImageWithMaxHeight(image, op.scope("waitingImage"), op);
                SmartCommand.setFormValue((String)op.scope("capturedImage"), (Object)fileOrd, (HxOp)op);
                SmartCommand.hide((String)op.scope("captureImageDiv"), (HxOp)op);
                SmartCommand.hide((String)op.scope("waitingText"), (HxOp)op);
                SmartCommand.show((String)op.scope("waitingDiv"), (HxOp)op);
                SmartCommand.resizeCurrentDialog((HxOp)op);
                SmartCommand.catchException((HxOp)op);
            }
        }
    }

    public class CropWaitingStep
    extends DialogWizardCommand.Step {
        public CropWaitingStep(String name, Command handler) {
            super((DialogWizardCommand)CropWizard.this, name, handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String handle(HxOp op) throws Exception {
            String saveBadgeTemplate;
            String ord = op.getFormValue("capturedImage");
            if (ord == null) {
                ord = BHxPortraitFE.blank.toString();
            }
            if ((saveBadgeTemplate = op.getFormValue("saveBadgeTemplate")) != null) {
                BPhotoIDTemplateData data = CropWizard.getNewTemplateData(op);
                BBadgeTemplate badgeTemplate = new BBadgeTemplate();
                badgeTemplate.setTemplate(MappingSupport.getMappedRef((BComponent)data.getParent().asComponent()));
                BPerson person = (BPerson)CropWizard.getOrionObject(op);
                BOrionDatabase db = person.getOrionDatabase();
                OrionSession session = null;
                try {
                    session = db.createSession((Context)op);
                    BBadge[] badges = (BBadge[])person.getBadges(session).toArray();
                    int index = Integer.parseInt(op.getFormValue("enum.value"));
                    badgeTemplate.init(BBadgeTemplate.badge, (BValue)BRef.make((BIOrionObject)badges[index]));
                    op.getRequest().getSession().setAttribute("saveBadgeTemplate", (Object)badgeTemplate);
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
            }
            BHxPortraitFE.setMainImage(ord, op);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeContent(HxOp op) throws Exception {
            BPhotoIDTemplateData templateData;
            BImage image = null;
            String imageForm = op.getFormValue("image");
            image = imageForm == null ? CropWizard.this.getImage(op) : BImage.make((String)imageForm);
            HtmlWriter out = op.getHtmlWriter();
            String fileOrd = image.getOrdList().toString();
            BIFile file = (BIFile)BOrd.make((String)fileOrd).get();
            BHxSmartTableView.writeFormValue((String)"fileOrd", (String)fileOrd, (HxOp)op);
            op.getRequest().getSession().setAttribute("fileOrd", (Object)fileOrd);
            BUuid uuid = BUuid.make();
            BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
            BOrionImageFormat imageFormat = network.getDefaultImageFormat();
            String templateDataSlotPath = (String)op.getRequest().getSession().getAttribute("templateData");
            if (templateDataSlotPath != null && templateDataSlotPath.length() > 0) {
                BPhotoIDTemplateData templateData2 = (BPhotoIDTemplateData)BOrd.make((String)("station:|" + templateDataSlotPath)).get();
                imageFormat = (BOrionImageFormat)templateData2.get("imageFormat");
            }
            String newFileOrd = "file:^temp/orionImage/" + uuid.encodeToString() + "." + imageFormat.getTag();
            op.getRequest().getSession().setAttribute("newFileOrd", (Object)newFileOrd);
            BHxSmartTableView.writeFormValue((String)"newFileOrd", (String)newFileOrd, (HxOp)op);
            out.w((Object)"<div ");
            HxTabUtil.scope((String)"waitingText", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            out.safe((Object)CropWizard.this.lex.getText("waitingPhotoCapture"));
            out.w((Object)"</div>");
            out.w((Object)"<div ");
            HxTabUtil.scope((String)"waitingImage", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            HxUtil.makeImage((BImage)BHxPortraitFE.blank, (HxOp)op);
            out.w((Object)"</div>");
            op.addOnload(SmartCommand.disableInvokeCode((String)op.scope("submit"), (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op));
            op.addOnload(SmartCommand.getInvokeCode((Command)CropWizard.this.finishCrop, (String)HxUtil.getInnerQuote((HxOp)op), (HxOp)op));
            HxOp fileOp = op.make("file", new OrdTarget((OrdTarget)op, (BObject)file));
            BCropViewer view = BCropViewer.INSTANCE;
            out.w((Object)"<div ");
            HxTabUtil.scope((String)"captureImageDiv", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            view.write(fileOp);
            out.w((Object)"</div>");
            out.w((Object)"<div ");
            out.attr("style", "display:none;");
            HxTabUtil.scope((String)"waitingDiv", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            String badgeRef = (String)op.getRequest().getSession().getAttribute("badgeRef");
            if ((badgeRef == null || badgeRef.length() == 0) && (templateData = CropWizard.getNewTemplateData(op)) != null) {
                BPerson person = (BPerson)CropWizard.getOrionObject(op);
                BOrionDatabase db = person.getOrionDatabase();
                OrionSession session = null;
                try {
                    session = db.createSession((Context)op);
                    BBadge[] badges = (BBadge[])person.getBadges(session).toArray();
                    if (badges.length > 0) {
                        out.w((Object)"<input type='checkbox'");
                        HxTabUtil.scope((String)"saveBadgeTemplate", (HtmlWriter)out, (HxOp)op);
                        out.w((Object)" checked/>");
                        out.safe((Object)" Save Template '").safe((Object)templateData.getParent().getDisplayName((Context)op)).safe((Object)"' to Badge: ");
                        if (badges.length == 1) {
                            out.safe((Object)badges[0].toDisplayString((Context)op));
                            BHxSmartTableView.writeFormValue((String)"enum.value", (String)"0", (HxOp)op);
                        } else {
                            String[] tags = new String[badges.length];
                            for (int i = 0; i < badges.length; ++i) {
                                tags[i] = SlotPath.escape((String)badges[i].toDisplayString((Context)op));
                            }
                            BEnumRange range = BEnumRange.make((String[])tags);
                            BDynamicEnum dynamicEnum = BDynamicEnum.make((int)0, (BEnumRange)range);
                            OrdTarget target = new OrdTarget(op.getBaseOrdTarget(), (BObject)dynamicEnum);
                            HxOp fieldOp = op.make("enum", target);
                            fieldOp.mergeFacets(BHxEnumFE.PREFER_FROZEN_EDITOR);
                            BHxEnumFE.INSTANCE.write(fieldOp);
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
            }
            out.w((Object)"</div>");
        }
    }

    public class RatioStep
    extends DialogWizardCommand.Step {
        public RatioStep(String name, Command handler) {
            super((DialogWizardCommand)CropWizard.this, name, handler);
        }

        public String handle(HxOp op) throws Exception {
            String captureData = op.getFormValue("captureData");
            String[] split = TextUtil.split((String)captureData, (char)'|');
            String imageRatio = split[0];
            String templateData = split[1];
            String badgeRef = split[2];
            op.getRequest().getSession().setAttribute("imageRatio", (Object)imageRatio);
            op.getRequest().getSession().setAttribute("templateData", (Object)templateData);
            op.getRequest().getSession().setAttribute("badgeRef", (Object)badgeRef);
            return "cropWaitingStep";
        }

        protected void writeContent(HxOp op) throws Exception {
            op.getRequest().getSession().removeAttribute("captureData");
            op.getRequest().getSession().removeAttribute("saveBadgeTemplate");
            HtmlWriter out = op.getHtmlWriter();
            Array choices = new Array();
            choices.addAll(CropWizard.this.getChoices(op));
            DialogWizardCommand.writeChoices((Object[])choices.trim(), null, (boolean)false, (String)"captureData", (DialogWizardCommand.ChoiceRenderer)new CaptureChoiceRenderer(), (HxOp)op);
        }
    }
}

