/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.photoID;

import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.filter.BNullFilter;
import com.tridium.bql.filter.BStringFilter;
import com.tridium.json.JSONObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.ui.BDynamicTableOptions;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.SqlColumns;
import com.tridium.query.BQueryEngine;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.filter.BSecStringFilter;
import com.tridiumx.entsec.photoID.video.BPhotoIDCamera;
import com.tridiumx.entsec.photoID.video.BPhotoIDViewerComponent;
import com.tridiumx.entsec.photoID.video.BVideoCamerasColumnProvider;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.ui.query.BQueryTableOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.collection.BITable;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.BPredicate;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.space.BSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"entsec:PhotoIDViewerComponent"}, app="entsec", requiredPermissions="rR")})
public class BPhotoIDUxRpc
extends BObject {
    public static final Type TYPE = Sys.loadType(BPhotoIDUxRpc.class);

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<String> getReaders(String videoPlaybackMillstreamOrd, String encodedFilterSet, Context cx) throws Exception {
        BOrd ord = BOrd.make((String)videoPlaybackMillstreamOrd);
        BPhotoIDViewerComponent videoPlaybackMillstream = (BPhotoIDViewerComponent)ord.get((BObject)Sys.getStation(), cx);
        BDynamicTable dynamicTable = BPhotoIDUxRpc.getDynamicTable(videoPlaybackMillstream);
        BDynamicTableOptions options = new BDynamicTableOptions();
        options = BPhotoIDUxRpc.setFilterSetFromEncodedValue(encodedFilterSet, dynamicTable, options, cx);
        BOrionService orionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BOrionDatabase orionDatabase = orionService.getOrionDatabases()[0];
        try (OrionSession session = orionDatabase.createSession(cx);){
            if (session != null) {
                BQuery query = dynamicTable.getQuery(0, true, new BPage(0, BDynamicTable.MAX_RESULT_SIZE), options.getFilterSet(dynamicTable), cx);
                BIOrionObject[] arr = dynamicTable.resolve(session, query).toArray();
                List<String> list = Arrays.stream(arr).map(eachReader -> {
                    String readerName = eachReader.get("readerName").toString();
                    String assignment = eachReader.get("assignment").toString();
                    String stationName = eachReader.get("stationName").toString();
                    return SlotPath.escape((String)readerName) + '|' + SlotPath.escape((String)assignment) + '|' + SlotPath.escape((String)stationName) + '|' + SlotPath.escape((String)String.valueOf(eachReader.get("uuid")));
                }).filter(input -> input != null).collect(Collectors.toList());
                return list;
            }
        }
        return null;
    }

    private static BDynamicTableOptions setFilterSetFromEncodedValue(String encodedFilterSet, BDynamicTable dynamicTable, BDynamicTableOptions options, Context cx) throws Exception {
        if (!encodedFilterSet.equals("")) {
            BValue set = BsonDecoderPlugin.unmarshal((JSONObject)new JSONObject(encodedFilterSet));
            BFilterSet queryFilterSet = BPhotoIDUxRpc.rebuildFilterSet(dynamicTable, (BFilterSet)set, cx);
            options.setFilterSet(dynamicTable, queryFilterSet);
        }
        return options;
    }

    private static BDynamicTable getDynamicTable(BPhotoIDViewerComponent videoPlaybackMillstream) {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        service.lease();
        BOrd appOrd = BOrd.make((String)("station:|" + service.getSlotPathOrd().toString()));
        BDynamicTable dynamicTable = new BDynamicTable();
        dynamicTable.setResolveBase((BObject)videoPlaybackMillstream);
        dynamicTable.setAppOrd(appOrd);
        dynamicTable.setRowType(BAccReaderRec.ORION_TYPE.getOrionTypeId());
        return dynamicTable;
    }

    public static synchronized BFilterSet rebuildFilterSet(BDynamicTable dt, BFilterSet filterSet, Context cx) {
        if (filterSet == null) {
            filterSet = new BFilterSet();
        }
        BDynamicTableColumn[] columns = dt.getWorkingColumns(cx);
        BOrionDatabase db = dt.getOrionDatabase();
        for (int i = 0; i < columns.length; ++i) {
            Property prop;
            BValue value;
            AgentList agents;
            String fieldName;
            BDynamicTableColumn col = columns[i];
            if (col.getHiddenKey() || filterSet.get(SlotPath.escape((String)(fieldName = BDynamicTableOptions.getFilterName((BDynamicTableColumn)col)))) != null || (agents = (value = (prop = col.makeDynamicProperty(db)).getDefaultValue()).getAgents().filter(AgentFilter.and((AgentFilter)AgentFilter.is((Type)BIQueryFilter.TYPE), (AgentFilter)new BDynamicTableOptions.ProfileFilter(cx)))).size() == 0) continue;
            BIQueryFilter filter = null;
            boolean active = false;
            boolean activeReadonly = false;
            col.setDefaultFilter((BValue)new BSecStringFilter());
            if (col.getDefaultFilter().getType().equals(BNullFilter.TYPE)) {
                filter = (BIQueryFilter)agents.getDefault().getInstance();
            } else {
                filter = (BIQueryFilter)col.getDefaultFilter().newCopy();
                BFilterEntry currentEntry = (BFilterEntry)filterSet.getNavChild(col.getColumnName()).as(BFilterEntry.class);
                if (currentEntry.getActive()) {
                    active = true;
                    BPhotoIDUxRpc.setFilter((BSecStringFilter)filter, currentEntry);
                } else {
                    active = false;
                }
            }
            if (Flags.isUserDefined2((BComplex)col, (Slot)BDynamicTableColumn.defaultFilter)) {
                activeReadonly = true;
            }
            filter.init((BObject)value);
            BProjectionColumn projectionColumn = SqlColumns.make((BTypeSpec)col.getFromType().getTypeSpec(), (String)col.getFromProperty());
            BFilterEntry entry = new BFilterEntry(active, col.getAlias().format((Object)dt, cx), filter, (BExpression)projectionColumn.getColumnExpression().newCopy());
            if (activeReadonly) {
                entry.setFlags((Slot)BFilterEntry.active, 1);
            }
            filterSet.add(SlotPath.escape((String)fieldName), (BValue)entry, 0, prop.getFacets(), null);
        }
        BPhotoIDUxRpc.removeOldEntries(filterSet, columns);
        return filterSet;
    }

    private static void removeOldEntries(BFilterSet filterSet, BDynamicTableColumn[] columns) {
        BFilterEntry[] entries;
        for (BFilterEntry entry : entries = (BFilterEntry[])filterSet.getChildren(BFilterEntry.class)) {
            String name = entry.getName();
            name = SlotPath.unescape((String)name);
            for (BDynamicTableColumn column : columns) {
                if (!column.getColumnName().equals(TextUtil.split((String)name, (char)'.')[0])) continue;
                filterSet.remove(entry.getPropertyInParent());
            }
        }
    }

    private static void setFilter(BSecStringFilter filter, BFilterEntry currentEntry) {
        BStringFilter filterComponent = (BStringFilter)currentEntry.getFilter();
        filter.setMatchCase(filterComponent.getMatchCase());
        filter.setInclude(filterComponent.getInclude());
        filter.setExact(filterComponent.getExact());
        filter.setPattern(filterComponent.getPattern());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<String> getCameraList(String videoPlaybackMillstreamOrd, String encodedFilterSet, Context cx) throws Exception {
        BOrd ord = BOrd.make((String)videoPlaybackMillstreamOrd);
        BPhotoIDViewerComponent videoPlaybackMillstream = (BPhotoIDViewerComponent)ord.get((BObject)Sys.getStation(), cx);
        BQuery query = BPhotoIDUxRpc.getQueryForCamera();
        BQuery working = QueryUtil.getWorkingCopy((BQuery)query, (Context)cx);
        BQueryTableOptions options = BQueryTableOptions.make();
        BFilterSet filterSet = BPhotoIDUxRpc.setCameraFilterSetFromEncodedValue(encodedFilterSet, working, options, cx);
        BPhotoIDUxRpc.setQueryParameters(working, filterSet);
        BQueryEngine engine = BQueryEngine.make((BSpace)videoPlaybackMillstream.getSpace());
        BOrd base = BOrd.make((String)"service:driver:DriverContainer");
        if (videoPlaybackMillstream.get("base") instanceof BOrd) {
            base = (BOrd)videoPlaybackMillstream.get("base");
        }
        BOrd ordStream = BOrd.make((BOrd)videoPlaybackMillstream.getSpace().getAbsoluteOrd(), (BOrd)base);
        BITable collection = engine.compile(working, ordStream).execute();
        Iterator iterator = collection.cursor().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            BIVideoCamera camera = (BIVideoCamera)iterator.next();
            if (camera instanceof BPhotoIDCamera) continue;
            String displayName = BPhotoIDUxRpc.getCameraDisplayName(camera);
            BComponent comp = (BComponent)camera;
            list.add(SlotPath.escape((String)displayName) + "|" + SlotPath.escape((String)comp.getSlotPath().toString()));
        }
        return list;
    }

    private static void setQueryParameters(BQuery working, BFilterSet filterSet) {
        BExpression exp;
        BPredicate queryPredicate = working.getPredicate();
        BExpression queryExp = null;
        if (queryPredicate != null) {
            queryExp = queryPredicate.getPredicateExpr();
        }
        ExpressionBuilder builder = new ExpressionBuilder(queryExp);
        if (filterSet != null && filterSet.getQueryPredicate() != null && filterSet.getQueryPredicate().getPredicateExpr() != null) {
            builder = builder.and((BExpression)filterSet.getQueryPredicate().getPredicateExpr().newCopy(true));
        }
        if ((exp = builder.getExpression()) != null) {
            working.where(new BPredicate((BExpression)exp.newCopy(true)));
        }
    }

    public static String getCameraDisplayName(BIVideoCamera camera) {
        String dvrDescription;
        String displayName = camera.getCameraDescription();
        BIVideoDvr videoCameraDvr = camera.getDvr();
        if (videoCameraDvr != null && (dvrDescription = videoCameraDvr.getDvrDescription()) != null) {
            if (dvrDescription.length() > 43) {
                dvrDescription = dvrDescription.substring(0, 40) + "...";
            }
            displayName = dvrDescription + " - " + displayName;
        }
        return displayName;
    }

    private static BQuery getQueryForCamera() {
        BQuery query = new BQuery();
        BVideoCamerasColumnProvider provider = new BVideoCamerasColumnProvider();
        query.add(null, (BValue)provider);
        query = QueryUtil.makeQuery((BQuery)query, (BTypeSpec)BIVideoCamera.TYPE.getTypeSpec());
        return query;
    }

    public static synchronized BFilterSet rebuildCameraFilterSet(BQuery query, BFilterSet filterSet, Context cx) {
        if (filterSet == null) {
            filterSet = new BFilterSet();
        }
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            AgentList agents;
            BProjectionColumn col = columns[i];
            String alias = col.getAlias();
            String fieldName = col.getName();
            Object filter = null;
            boolean active = false;
            BTypeSpec typeSpec = (BTypeSpec)col.get("typeSpec");
            BObject value = typeSpec.getInstance();
            filter = col.get("defaultFilter") == null ? ((agents = value.getAgents().filter(AgentFilter.and((AgentFilter)AgentFilter.is((Type)BIQueryFilter.TYPE), (AgentFilter)new BQueryTableOptions.ProfileFilter(cx)))).size() != 0 ? (BIQueryFilter)agents.getDefault().getInstance() : new BStringFilter()) : (BIQueryFilter)col.get("defaultFilter").newCopy();
            if (filterSet.getNavChild(fieldName) == null) continue;
            BFilterEntry currentEntry = (BFilterEntry)filterSet.getNavChild(fieldName).as(BFilterEntry.class);
            if (currentEntry.getActive()) {
                active = true;
                BPhotoIDUxRpc.setFilter((BSecStringFilter)filter, currentEntry);
            } else {
                active = false;
            }
            filter.init(value);
            BFilterEntry entry = new BFilterEntry(active, alias, filter, (BExpression)col.getColumnExpression().newCopy());
            BPhotoIDUxRpc.setFilterSetParameters(query, filterSet, col, fieldName, entry);
        }
        BFilterEntry[] entries = (BFilterEntry[])filterSet.getChildren(BFilterEntry.class);
        BPhotoIDUxRpc.removeOldEntries(filterSet, columns, entries);
        for (int i = columns.length - 1; i >= 0; --i) {
            Property p = filterSet.getProperty(columns[i].getName());
            if (p == null) continue;
            filterSet.reorderToTop(p);
        }
        return filterSet;
    }

    private static void removeOldEntries(BFilterSet filterSet, BProjectionColumn[] columns, BFilterEntry[] entries) {
        for (BFilterEntry entry : entries) {
            String alias = entry.getName();
            boolean found = false;
            for (int j = 0; j < columns.length; ++j) {
                if (!columns[j].getName().equals(alias)) continue;
                found = true;
            }
            if (found) continue;
            filterSet.remove(entry.getPropertyInParent());
        }
    }

    private static void setFilterSetParameters(BQuery query, BFilterSet filterSet, BProjectionColumn col, String fieldName, BFilterEntry entry) {
        if (Flags.isHidden((BComplex)query.getProjection(), (Slot)col.getPropertyInParent())) {
            if (filterSet.get(fieldName) == null) {
                filterSet.add(fieldName, (BValue)entry, 4);
            } else {
                filterSet.set(fieldName, (BValue)entry);
                Property p = filterSet.getProperty(fieldName);
                filterSet.setFlags((Slot)p, filterSet.getFlags((Slot)p) | 4);
            }
        } else if (filterSet.get(fieldName) == null) {
            filterSet.add(fieldName, (BValue)entry);
        } else {
            filterSet.set(fieldName, (BValue)entry);
            Property p = filterSet.getProperty(fieldName);
            filterSet.setFlags((Slot)p, filterSet.getFlags((Slot)p) & 0xFFFFFFFB);
        }
    }

    private static BFilterSet setCameraFilterSetFromEncodedValue(String encodedFilterSet, BQuery working, BQueryTableOptions options, Context cx) throws Exception {
        BFilterSet queryFilterSet = null;
        if (!encodedFilterSet.equals("")) {
            BValue set = BsonDecoderPlugin.unmarshal((JSONObject)new JSONObject(encodedFilterSet));
            queryFilterSet = BPhotoIDUxRpc.rebuildCameraFilterSet(working, (BFilterSet)set, cx);
            options.setFilterSet(working, queryFilterSet);
        }
        return queryFilterSet;
    }
}

