/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.installable.CursorUtil;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.threat.BThreatLevel;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BObjectImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import java.util.HashSet;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class SysJoinTypeThreatLevel
extends SysJoinType {
    private static final String NAME = BThreatLevel.threatLevelName.getName();
    private static final String LEVEL = BThreatLevel.level.getName();

    public SysJoinTypeThreatLevel() {
        super(THREATLEVEL_TYPE);
    }

    @Override
    public Cursor getSubordinateRecordsCursor(SubordinateConnection jaceConn) {
        BFoxSession session = jaceConn.getProxy();
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)session.getService(BEnterpriseSecurityService.TYPE);
        service.lease();
        service.getThreatLevelSetup().lease();
        BEnumRange range = service.getThreatLevelSetup().getThreatLevelRange();
        return this.getCursor(range);
    }

    protected Cursor getCursor(BEnumRange range) {
        int[] ordinals = range.getOrdinals();
        Object[] levels = new BThreatLevel[ordinals.length];
        for (int i = 0; i < ordinals.length; ++i) {
            String displayTag = range.getDisplayTag(ordinals[i], null);
            BThreatLevel threatLevel = new BThreatLevel();
            threatLevel.setThreatLevelName(displayTag);
            threatLevel.setLevel(ordinals[i]);
            levels[i] = threatLevel;
        }
        return CursorUtil.cursor((Object[])levels, null);
    }

    @Override
    protected void match(OrionSession supSession, SubordinateConnection jaceConn, SysJoinManifest manifest) {
        HashSet supMatches = new HashSet();
        if (this.actions.length == 0) {
            return;
        }
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BEnumRange enumRange = service.getThreatLevelSetup().getThreatLevelRange();
        for (int i = 0; i < this.actions.length; ++i) {
            BThreatLevel supervisorThreatLevel;
            JoinAction action = this.actions[i];
            BThreatLevel jaceRec = (BThreatLevel)this.actions[i].getJaceObject();
            int jaceLevel = jaceRec.getLevel();
            String name = jaceRec.getThreatLevelName();
            if (enumRange.isOrdinal(jaceLevel) && enumRange.isTag(SlotPath.escape((String)name))) {
                if (enumRange.tagToOrdinal(SlotPath.escape((String)name)) != jaceLevel) {
                    supervisorThreatLevel = new BThreatLevel();
                    supervisorThreatLevel.setLevel(jaceLevel);
                    supervisorThreatLevel.setThreatLevelName(SlotPath.unescape((String)enumRange.getTag(jaceLevel)));
                    action.setStatus(BObjectImportStatus.error);
                    action.setMatch(supervisorThreatLevel);
                    action.setErrorDescription(SysJoinTypeThreatLevel.getLexiconText("join.errThreatLevelNameAndLevelMismatch"));
                }
                this.actions[i].setStatus(BObjectImportStatus.matchedObject);
                this.actions[i].setMatch(jaceRec);
                continue;
            }
            if (enumRange.isOrdinal(jaceLevel)) {
                supervisorThreatLevel = new BThreatLevel();
                supervisorThreatLevel.setLevel(jaceLevel);
                supervisorThreatLevel.setThreatLevelName(SlotPath.unescape((String)enumRange.getTag(jaceLevel)));
                action.setStatus(BObjectImportStatus.error);
                action.setMatch(supervisorThreatLevel);
                action.setErrorDescription(SysJoinTypeThreatLevel.getLexiconText("join.errThreatLevelNameMismatch"));
                continue;
            }
            if (enumRange.isTag(SlotPath.escape((String)name))) {
                supervisorThreatLevel = new BThreatLevel();
                supervisorThreatLevel.setLevel(enumRange.tagToOrdinal(SlotPath.escape((String)name)));
                supervisorThreatLevel.setThreatLevelName(name);
                action.setMatch(supervisorThreatLevel);
                action.setStatus(BObjectImportStatus.error);
                action.setErrorDescription(SysJoinTypeThreatLevel.getLexiconText("join.errThreatLevelLevelMismatch"));
                continue;
            }
            this.actions[i].setStatus(BObjectImportStatus.newObject);
            action.setWarningDescription(SysJoinTypeThreatLevel.getLexiconText("join.newThreatLevel"));
        }
    }

    @Override
    public void join(OrionSession supSession, SubordinateConnection jaceConn, BSysJoinJob job, SysJoinManifest manifest) {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BEnumRange enumRange = service.getThreatLevelSetup().getThreatLevelRange();
        BEnumRange range = service.getThreatLevelSetup().getThreatLevelRange();
        for (int i = 0; i < this.actions.length; ++i) {
            JoinAction action = this.actions[i];
            BThreatLevel jaceObj = (BThreatLevel)action.getJaceObject();
            if (action.getStatus().equals((Object)BObjectImportStatus.newObject)) {
                range = BThreatLevel.addLevel((BEnumRange)range, (int)jaceObj.getLevel(), (String)jaceObj.getThreatLevelName());
                continue;
            }
            if (!action.getStatus().equals((Object)BObjectImportStatus.matchedObject)) continue;
        }
        service.getThreatLevelSetup().setThreatLevelRange(range);
    }

    @Override
    public BSimple getKey(BIOrionObject obj) {
        return BString.make((String)(obj.get(NAME).toString() + "_" + obj.get(LEVEL).toString()));
    }
}

