/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BObjectImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.util.BUuid;

public class SysJoinTypePersonAccJoin
extends SysJoinType {
    private static final String PERSON = "person";
    private static final String ACCESS_RIGHT = "accessRight";

    public SysJoinTypePersonAccJoin() {
        super(PERSONACCJOIN_TYPE);
    }

    @Override
    protected void match(OrionSession supSession, SubordinateConnection jaceConn, SysJoinManifest manifest) {
        SysJoinType joinPerson = manifest.getConfigForType(jaceConn, PERSON_TYPE, manifest);
        SysJoinType joinAccessRight = manifest.getConfigForType(jaceConn, ACCESSRIGHT_TYPE, manifest);
        for (int i = 0; i < this.actions.length; ++i) {
            BIOrionObject jaceRec = this.actions[i].getJaceObject();
            BSimple jaceKey = this.getKey(jaceRec);
            this.setActionByJaceId(jaceKey, this.actions[i]);
            BUuid personId = (BUuid)((BRef)jaceRec.get(PERSON)).getId();
            BUuid accRightId = (BUuid)((BRef)jaceRec.get(ACCESS_RIGHT)).getId();
            JoinAction personAction = joinPerson.getActionByJaceId((BSimple)personId);
            JoinAction accRightAction = joinAccessRight.getActionByJaceId((BSimple)accRightId);
            this.actions[i].setMatch(null);
            if (personAction.getStatus().equals((Object)BObjectImportStatus.deleteObject)) {
                this.actions[i].setStatus(BObjectImportStatus.deleteObject);
                continue;
            }
            if (personAction.getStatus().equals((Object)BObjectImportStatus.newObject) || accRightAction.getStatus().equals((Object)BObjectImportStatus.newObject)) {
                this.actions[i].setStatus(BObjectImportStatus.newObject);
                continue;
            }
            this.actions[i].setStatus(BObjectImportStatus.matchedObject);
        }
    }

    @Override
    public void join(OrionSession supSession, SubordinateConnection jaceConn, BSysJoinJob job, SysJoinManifest manifest) {
        SysJoinType joinPerson = manifest.getConfigForType(jaceConn, PERSON_TYPE, manifest);
        SysJoinType joinAccessRight = manifest.getConfigForType(jaceConn, ACCESSRIGHT_TYPE, manifest);
        BatchStatement supInsert = supSession.batchInsert(PERSONACCJOIN_TYPE);
        supInsert.setChunkSize(CHUNK_SIZE);
        for (int i = 0; i < this.actions.length; ++i) {
            JoinAction action = this.actions[i];
            BIOrionObject jaceObj = action.getJaceObject();
            if (!action.getStatus().equals((Object)BObjectImportStatus.newObject)) continue;
            BOrionObject clonedObj = (BOrionObject)this.copyObject(jaceObj);
            SysJoinType.adjustRef(clonedObj, PERSON, joinPerson);
            SysJoinType.adjustRef(clonedObj, ACCESS_RIGHT, joinAccessRight);
            supInsert.add((BIOrionObject)clonedObj);
            if (supInsert.size() <= EXECUTE_SIZE) continue;
            this.execute(supInsert, supSession, job);
        }
        this.execute(supInsert, supSession, job);
    }

    public void execute(BatchStatement supInsert, OrionSession supSession, BSysJoinJob job) {
        try {
            supInsert.execute();
        }
        catch (Exception e) {
            job.log().message("WARNING: Batch Insert Failed, but retrying as individual Persist...");
            Logger.getLogger("entsec").log(Level.WARNING, "Batch Insert Failed, but retrying as individual Persist...", e);
            for (int i = 0; i < supInsert.size(); ++i) {
                BPersonAccJoin join = (BPersonAccJoin)supInsert.get(i);
                join.setModified(BPersonAccJoin.person, false);
                join.setModified(BPersonAccJoin.accessRight, false);
                supSession.persist((BIOrionObject)join);
            }
            job.log().message("Individual Persist Success. Joining will continue.");
            Logger.getLogger("entsec").log(Level.WARNING, "Individual Persist Success. Joining will continue.");
        }
    }

    @Override
    public BSimple getKey(BIOrionObject obj) {
        return BString.make((String)(obj.get(PERSON).toString() + "_" + obj.get(ACCESS_RIGHT).toString()));
    }
}

