/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BObjectImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeSimple;
import java.util.HashSet;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;

public class SysJoinTypeIntrusionPin
extends SysJoinTypeSimple {
    private static final String ID = "intrusionPinId";
    private static final String NAME = "intrusionPinName";
    private static final String TENANT = "tenant";
    private static final String SCHEDULE = "schedule";

    public SysJoinTypeIntrusionPin() {
        super(INTRUSIONPIN_TYPE, ID, NAME);
    }

    @Override
    protected void match(OrionSession supSession, SubordinateConnection jaceConn, SysJoinManifest manifest) {
        HashSet<BValue> supMatches = new HashSet<BValue>();
        OrionCursor c = supSession.scan(this.getOrionType());
        while (c.next()) {
            BIOrionObject supRec = (BIOrionObject)c.get();
            supMatches.add(supRec.get(this.matchField));
        }
        for (int i = 0; i < this.actions.length; ++i) {
            BIOrionObject supRec = null;
            BIOrionObject jaceRec = this.actions[i].getJaceObject();
            BSimple jaceKey = this.getKey(jaceRec);
            this.setActionByJaceId(jaceKey, this.actions[i]);
            BValue jaceMatch = jaceRec.get(this.matchField);
            if (supMatches.contains(jaceMatch)) {
                supRec = supSession.read(this.getOrionType(), new PropertyValue(this.getOrionType().getProperty(this.matchField), jaceMatch));
                this.actions[i].setStatus(BObjectImportStatus.matchedObject);
                this.actions[i].setMatch(supRec);
                continue;
            }
            supRec = supSession.read(this.getOrionType(), jaceKey);
            if (supRec != null) {
                this.actions[i].setStatus(BObjectImportStatus.matchedObject);
                this.actions[i].setMatch(supRec);
                this.actions[i].setWarningDescription(SysJoinTypeIntrusionPin.getLexiconText("join.matchByUuid"));
                continue;
            }
            this.actions[i].setStatus(BObjectImportStatus.newObject);
            BRef ref = (BRef)jaceRec.get(SCHEDULE);
            if (!ref.isBound() || supSession.read(BScheduleRec.ORION_TYPE, ref.getId()) != null) continue;
            this.actions[i].setWarningDescription("Schedule is missing on supervisor");
        }
    }

    @Override
    public void join(OrionSession supSession, SubordinateConnection jaceConn, BSysJoinJob job, SysJoinManifest manifest) {
        SysJoinType joinTenant = manifest.getConfigForType(jaceConn, TENANT_TYPE, manifest);
        for (int i = 0; i < this.actions.length; ++i) {
            JoinAction action = this.actions[i];
            if (!action.getStatus().equals((Object)BObjectImportStatus.newObject)) continue;
            BIOrionObject jaceObj = action.getJaceObject();
            BOrionObject clonedObj = (BOrionObject)this.copyObject(jaceObj);
            SysJoinType.adjustRef(clonedObj, TENANT, joinTenant);
            BRef ref = (BRef)clonedObj.get(SCHEDULE);
            if (ref.isBound() && supSession.read(BScheduleRec.ORION_TYPE, ref.getId()) == null) {
                job.log().message("WARNING: Intrusion Pin '" + clonedObj.get(NAME) + "' is now missing a Schedule.");
                clonedObj.set(SCHEDULE, (BValue)BRef.NULL);
            }
            supSession.insert((BIOrionObject)clonedObj);
        }
    }
}

