/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BObjectImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import java.util.HashMap;
import java.util.Map;
import javax.baja.nre.util.Array;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class SysJoinTypeBadge
extends SysJoinType {
    private static final String BADGE_ID = "badgeId";
    private static final String OWNER = "owner";
    private static final String TENANT = "tenant";
    private static final String WIEGAND_FORMAT = "wiegandFormat";
    private Map jacePersonBadges = new HashMap();

    public SysJoinTypeBadge() {
        super(BADGE_TYPE);
    }

    @Override
    protected void match(OrionSession supSession, SubordinateConnection jaceConn, SysJoinManifest manifest) {
        for (int i = 0; i < this.actions.length; ++i) {
            BBadge jaceRec = (BBadge)this.actions[i].getJaceObject();
            SysJoinTypeBadge.updatePersonBadges(this.jacePersonBadges, jaceRec);
            BSimple jaceId = this.getKey((BIOrionObject)jaceRec);
            this.setActionByJaceId(jaceId, this.actions[i]);
            BBadge supBadge = (BBadge)supSession.read(this.getOrionType(), new PropertyValue(this.getOrionType().getProperty(BADGE_ID), (BValue)jaceId));
            if (supBadge != null) {
                boolean supervisorBadgeIsBound;
                this.actions[i].setStatus(BObjectImportStatus.matchedObject);
                this.actions[i].setMatch(BRef.make((BTypeSpec)this.getOrionType().getTypeSpec(), (BSimple)jaceId));
                BUuid supBadgeOwner = (BUuid)supBadge.getOwner().getId();
                boolean bl = supervisorBadgeIsBound = supBadgeOwner != null;
                if (jaceRec.getOwner().isBound() == supervisorBadgeIsBound) continue;
                if (!supervisorBadgeIsBound) {
                    this.actions[i].setWarningDescription(SysJoinTypeBadge.getLexiconText("join.warning.subordinateLooseOwner"));
                    continue;
                }
                BPerson supPerson = (BPerson)supSession.read(BPerson.ORION_TYPE, new PropertyValue(BPerson.personId, (BValue)supBadgeOwner));
                this.actions[i].setWarningDescription(SysJoinTypeBadge.getLexiconText("join.warning.subordinateGainOwner", new Object[]{supPerson.toDisplayString(null)}));
                continue;
            }
            this.actions[i].setStatus(BObjectImportStatus.newObject);
        }
    }

    @Override
    public void join(OrionSession supSession, SubordinateConnection jaceConn, BSysJoinJob job, SysJoinManifest manifest) {
        SysJoinType joinTenant = manifest.getConfigForType(jaceConn, TENANT_TYPE, manifest);
        SysJoinType joinPerson = manifest.getConfigForType(jaceConn, PERSON_TYPE, manifest);
        SysJoinType joinWiegand = manifest.getConfigForType(jaceConn, WIEGAND_TYPE, manifest);
        BatchStatement supInsert = supSession.batchInsert(BADGE_TYPE);
        supInsert.setChunkSize(CHUNK_SIZE);
        for (int i = 0; i < this.actions.length; ++i) {
            JoinAction action = this.actions[i];
            if (!action.getStatus().equals((Object)BObjectImportStatus.newObject)) continue;
            BIOrionObject jaceObj = action.getJaceObject();
            BOrionObject clonedObj = (BOrionObject)this.copyObject(jaceObj);
            SysJoinType.adjustRef(clonedObj, TENANT, joinTenant);
            SysJoinType.adjustRef(clonedObj, OWNER, joinPerson);
            SysJoinType.adjustRef(clonedObj, WIEGAND_FORMAT, joinWiegand);
            supInsert.add((BIOrionObject)clonedObj);
            if (supInsert.size() <= EXECUTE_SIZE) continue;
            supInsert.execute();
        }
        supInsert.execute();
    }

    @Override
    public BSimple getKey(BIOrionObject obj) {
        return (BSimple)((BBadge)obj).get(BBadge.badgeId);
    }

    private static void updatePersonBadges(Map badgeIds, BBadge badge) {
        if (badge.getOwner().isBound()) {
            BUuid owner = (BUuid)badge.getOwner().getId();
            Array arr = (Array)badgeIds.get(owner);
            if (arr == null) {
                arr = new Array(String.class);
                badgeIds.put(owner, arr);
            }
            arr.add((Object)badge.getBadgeId());
        }
    }

    String[] getJaceBadges(BUuid personId) {
        Array arr = (Array)this.jacePersonBadges.get(personId);
        return arr == null ? new String[]{} : (String[])arr.trim();
    }
}

