/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.TableBuilder;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccFloorJoin;
import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessRightLdapGroupJoin;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.access.orion.BInfoTemplate;
import com.tridiumx.entsec.access.orion.BKeypadFormat;
import com.tridiumx.entsec.access.orion.BLdapGroup;
import com.tridiumx.entsec.access.orion.BLdapServer;
import com.tridiumx.entsec.access.orion.BNiagaraIntegrationID;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.access.orion.BThreatLevelBadgeJoin;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPin;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPinJoin;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.replicate.BNiagaraReplicationDeviceExt;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.orionTools.replicate.ReplicationManager;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinConstraints;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.job.JobCancelException;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSysJoinJob
extends BSafeSimpleJob {
    public static final Type TYPE = Sys.loadType(BSysJoinJob.class);
    SysJoinManifest manifest;
    HxOp op;
    private boolean forceJoin;
    private int maxProgress = 30;
    private int initProgress = 0;

    public Type getType() {
        return TYPE;
    }

    public BSysJoinJob() {
    }

    public BSysJoinJob(SysJoinManifest manifest, HxOp op, boolean forceJoin) {
        this.manifest = manifest;
        this.op = op;
        this.forceJoin = forceJoin;
    }

    void logMessage(String msg) {
        Logger.getLogger("entsec").info(msg);
        this.log().message(msg);
    }

    void logDebug(String message) {
        Logger.getLogger("entsec").finer(message);
    }

    void logError(String msg, Exception e) {
        Logger.getLogger("entsec").log(Level.SEVERE, msg, e);
        this.log().failed(msg, (Throwable)e);
    }

    private void dropTable(OrionSession jaceSession, TableBuilder tb) {
        this.logMessage("JOIN: dropping table " + tb.getTableName());
        DdlCommand[] ddl = tb.dropTable();
        for (int i = 0; i < ddl.length; ++i) {
            try {
                jaceSession.invokeDdl(ddl[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logError(e.getMessage(), e);
            }
        }
    }

    private void createTable(OrionSession jaceSession, TableBuilder tb) {
        this.logMessage("JOIN: recreating table " + tb.getTableName());
        DdlCommand[] ddl = tb.createTable();
        for (int i = 0; i < ddl.length; ++i) {
            try {
                jaceSession.invokeDdl(ddl[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logError(e.getMessage(), e);
            }
        }
    }

    private void dropTables(OrionSession jaceSession, RdbmsContext rcx) {
        int i;
        this.logMessage("JOIN: begin dropTables");
        TableBuilder[] builders = new TableBuilder[]{new TableBuilder(jaceSession.getOrionDatabase(), BKeypadFormat.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BWiegandFormat.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BTenant.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BNiagaraIntegrationID.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BAccessRight.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BAccReaderJoin.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BAccFloorJoin.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BPerson.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BPersonAccJoin.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BIntrusionPin.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BIntrusionPinJoin.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BBadge.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BPersonInfo.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BInfoTemplate.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BThreatLevelBadgeJoin.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BLdapServer.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BLdapGroup.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BPersonLdapServerJoin.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BAccessRightLdapGroupJoin.ORION_TYPE), new TableBuilder(jaceSession.getOrionDatabase(), BBadgeLdapServerJoin.ORION_TYPE)};
        for (i = builders.length - 1; i >= 0; --i) {
            this.dropTable(jaceSession, builders[i]);
        }
        for (i = 0; i < builders.length; ++i) {
            this.createTable(jaceSession, builders[i]);
        }
        this.logMessage("JOIN: end dropTables");
        this.progress(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullFromJace(BAccessControlService service, SubordinateConnection jaceConn) {
        this.logMessage("JOIN: begin pullFromJace");
        OrionSession supSession = null;
        try {
            supSession = service.createSession(null);
            int length = SysJoinType.ALL_TYPES.length;
            for (int i = 0; i < SysJoinType.ALL_TYPES.length; ++i) {
                SysJoinType joinType = this.manifest.getConfigForType(jaceConn, SysJoinType.ALL_TYPES[i], this.manifest);
                this.logMessage("JOIN: joining " + joinType.getOrionType());
                joinType.join(supSession, jaceConn, this, this.manifest);
                this.progress(this.initProgress + this.maxProgress * i / length);
            }
        }
        finally {
            if (supSession != null) {
                supSession.close();
                supSession = null;
            }
        }
        this.logMessage("JOIN: end pullFromJace");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        BAbsTime begin = BAbsTime.now();
        boolean replicationEnabled = true;
        BReplicationService rs = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
        SubordinateConnection jaceConn = null;
        OrionSession jaceSession = null;
        try {
            if (!rs.obtainRunningLock((BSafeSimpleJob)this)) {
                throw new JobCancelException("Job has been canceled");
            }
            BNiagaraReplicationDeviceExt ext = (BNiagaraReplicationDeviceExt)this.op.get();
            BNiagaraStation ns = (BNiagaraStation)ext.getDevice();
            this.maxProgress = 30;
            this.initProgress = 0;
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            jaceConn = this.manifest.makeSubordinateConnection();
            this.checkCancel(cx);
            if (!this.forceJoin) {
                this.pullFromJace(service, jaceConn);
            }
            this.checkCancel(cx);
            jaceSession = jaceConn.getSession();
            RdbmsContext rcx = jaceSession.getRdbmsContext();
            JoinConstraints consMgr = new JoinConstraints(this, jaceSession, rcx);
            consMgr.dropPhotoIDTables();
            consMgr.dropJoinConstraints();
            consMgr.adjustJoinRecords(this.op, jaceConn, this.manifest);
            this.dropTables(jaceSession, rcx);
            this.logMessage("JOIN: begin initial replication");
            BFacets facets = BFacets.DEFAULT;
            ReplicationManager mgr = new ReplicationManager(rs, (BSafeSimpleJob)this, facets);
            boolean succeeded = mgr.joinStation(ns);
            consMgr.addJoinConstraints();
            try {
                mgr.reinitDbCache(ns);
            }
            catch (Exception e) {
                this.logError("Cannot reinit validation cache", e);
            }
            try {
                BIntrusionService intrusionService = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
                intrusionService.cleanupAfterReplication();
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
            if (succeeded) {
                this.logMessage("JOIN: end initial replication");
                this.progress(100);
                ext.setJoined(true);
                ext.setAutomaticReplicationEnabled(true);
            } else {
                this.logMessage("JOIN FAILED: end initial replication");
                this.progress(100);
            }
        }
        finally {
            try {
                if (jaceSession != null) {
                    jaceSession.close();
                    jaceSession = null;
                }
                if (jaceConn != null) {
                    jaceConn.close();
                }
            }
            catch (Exception e) {
                this.logError("Error During Connection Cleanup", e);
            }
            rs.releaseRunningLock((BJob)this);
            this.manifest = null;
        }
    }
}

