/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.BSystemPlatformService;
import com.tridiumx.entsec.orionTools.replicate.BNiagaraReplicationDeviceExt;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinManager;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.hx.HxOp;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BForceBatchSysJoinJob
extends BSafeSimpleJob {
    public static final Type TYPE = Sys.loadType(BForceBatchSysJoinJob.class);
    String[] selectionList;
    SysJoinManifest manifest;
    HxOp op;
    private int maxProgress = 30;
    private int initProgress = 0;

    public Type getType() {
        return TYPE;
    }

    public BForceBatchSysJoinJob() {
    }

    public BForceBatchSysJoinJob(String[] selectionList, HxOp op) {
        this.op = op;
        this.selectionList = selectionList;
        this.safeToCancel = true;
    }

    public void run(Context cx) throws Exception {
        BReplicationService service = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
        if (service.isRunningReplication()) {
            this.log().failed("Replication is already running.");
            this.cancel();
            throw new JobCancelException("Job has been canceled");
        }
        for (int i = 0; i < this.selectionList.length; ++i) {
            this.setProgress(100 * i / this.selectionList.length);
            BNiagaraStation station = (BNiagaraStation)BOrd.make((String)("station:|" + this.selectionList[i])).get();
            HxOp jobOp = this.op.make("job", (BObject)station.getMixIn(BNiagaraReplicationDeviceExt.TYPE), null);
            this.logMessage("---------Starting Recovery For " + station.getName() + "...");
            if (!this.join(station, true, jobOp, cx)) {
                throw new Exception("---------Recovery cannot be completed for " + station.getName() + ".");
            }
            this.logMessage("---------Completed Recovery For " + station.getName() + ".");
        }
        this.setProgress(100);
    }

    public boolean join(BNiagaraStation station, boolean forced, HxOp jobOp, Context cx) throws Exception {
        this.checkCancel(cx);
        BNiagaraReplicationDeviceExt replication = (BNiagaraReplicationDeviceExt)station.getMixIn(BNiagaraReplicationDeviceExt.TYPE);
        SysJoinManifest.removeFromSession(jobOp);
        SysJoinManifest manifest = SysJoinManifest.getForSession(jobOp);
        BAbsTime supervisorTime = Clock.time();
        BAbsTime subordinateTime = this.getSubordinateTime(jobOp);
        if (subordinateTime.delta(supervisorTime).abs().compareTo((Object)BSysJoinManager.getAllowableTimeDifference(jobOp)) > 0) {
            BSysJoinManager.INSTANCE.synchronizeTime(null, jobOp);
            this.logMessage("Time Sync needed. Changing Time on '" + station.getName() + " ' from " + subordinateTime + " to " + supervisorTime + ".");
        }
        BOrd jobOrd = null;
        if (forced) {
            BSysJoinJob joinJob = new BSysJoinJob(manifest, jobOp, forced);
            jobOrd = joinJob.submit((Context)jobOp);
            while (joinJob.getJobState().isRunning()) {
                Thread.sleep(50L);
            }
            JobLogItem[] items = joinJob.log().getItems();
            for (int i = 0; i < items.length; ++i) {
                this.log().add(items[i]);
            }
            if (joinJob.getJobState() != BJobState.success) {
                return false;
            }
            BSysJoinManager.INSTANCE.processJaceJoinSystem(jobOp);
            SysJoinManifest.removeFromSession(jobOp);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getSubordinateTime(HxOp jobOp) {
        SysJoinManifest manifest = SysJoinManifest.getForSession(jobOp);
        try (SubordinateConnection jaceConn = manifest.makeSubordinateConnection();){
            BAbsTime remoteTime;
            BSystemPlatformService service = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)jaceConn.getProxy());
            service.lease();
            BTimeZone timeZone = service.getTimeZone();
            BAbsTime bAbsTime = remoteTime = BAbsTime.make((BAbsTime)service.getSystemTime(), (BTimeZone)timeZone);
            return bAbsTime;
        }
    }

    void logMessage(String msg) {
        Logger.getLogger("entsec").info(msg);
        this.log().message(msg);
    }

    void logError(String msg, Exception e) {
        Logger.getLogger("entsec").log(Level.SEVERE, msg, e);
        this.log().failed(msg, (Throwable)e);
    }
}

