/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAddAppView;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class DuplicateCommand
extends SmartCommand {
    public DuplicateCommand(BHxView view) {
        super(view);
    }

    public String getName(HxOp op) {
        return "duplicate";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.singleSelection;
    }

    public BOrionObject getDuplicateRecord(HxOp op) {
        return (BOrionObject)((BHxDynamicTableView)this.getView()).getSubject(op);
    }

    public String getTableOrd(HxOp op) {
        return op.getOrd().toString();
    }

    public void handle(HxOp op) throws Exception {
        BOrionObject o = this.getDuplicateRecord(op);
        String duplicateUuid = o.get(o.getOrionType().getKey()[0]).asSimple().encodeToString();
        String extraText = "?duplicateUuid=" + SlotPath.escape((String)duplicateUuid);
        this.redirect(op, op.toUri(BOrd.make((String)(this.getTableOrd(op) + "|view:" + BHxAddAppView.TYPE + extraText))));
    }

    public static BOrionObject getDuplicateTarget(BOrionObject target, HxOp op) {
        BOrionObject orionObject = target;
        String duplicateUuid = op.getViewParameter("duplicateUuid", null);
        if (duplicateUuid != null) {
            duplicateUuid = SlotPath.unescape((String)duplicateUuid);
            try {
                BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(duplicateUuid);
                BOrionObject copy = (BOrionObject)orionObject.newCopy();
                copy.setOrionDatabase(orionObject.getOrionDatabase());
                orionObject = copy;
                copy.set(copy.getOrionType().getKey()[0], (BValue)uuid);
                return copy;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BObject getDuplicatePropertyObject(Property[] copyProps, HxOp op) throws Exception {
        BOrionObject orionObject = (BOrionObject)op.get();
        String duplicateUuid = op.getViewParameter("duplicateUuid", null);
        if (duplicateUuid != null && !HxUtil.isPost((HxOp)op)) {
            duplicateUuid = SlotPath.unescape((String)duplicateUuid);
            BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(duplicateUuid);
            OrionSession session = null;
            try {
                session = orionObject.getOrionDatabase().createSession(null);
                BOrionObject duplicateObject = (BOrionObject)session.read(orionObject.getOrionType(), (BSimple)uuid);
                for (int i = 0; i < copyProps.length; ++i) {
                    orionObject.set(copyProps[i], duplicateObject.get(copyProps[i]));
                }
                BOrionObject bOrionObject = orionObject;
                return bOrionObject;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void duplicateSave(OrionType joinType, BOrionObject orionObject, HxOp op) throws Exception {
        String duplicateUuid = op.getViewParameter("duplicateUuid", null);
        if (duplicateUuid != null) {
            duplicateUuid = SlotPath.unescape((String)duplicateUuid);
            BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(duplicateUuid);
            BOrionDatabase db = orionObject.getOrionDatabase();
            OrionSession session = null;
            try {
                session = db.createSession((Context)op);
                Property p = null;
                Property[] keys = joinType.getKey();
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i].getType() != BRef.TYPE || !((BRef)keys[i].getDefaultValue()).getTargetTypeSpec().equals((Object)orionObject.getType().getTypeSpec())) continue;
                    p = keys[i];
                }
                OrionCursor c = session.select(joinType, new PropertyValue(p, (BValue)BRef.make((BTypeSpec)p.getType().getTypeSpec(), (BSimple)uuid)));
                while (c.next()) {
                    BOrionObject join = (BOrionObject)c.get();
                    join = (BOrionObject)join.newCopy();
                    join.init(p, (BValue)BRef.make((BIOrionObject)orionObject));
                    session.persist((BIOrionObject)join);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }
}

