/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.PermissionsUtil;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsecHx.orionToolsHx.BHxSmartRefTable;
import com.tridiumx.entsecHx.orionToolsHx.SummaryCommand;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BHxSmartRefFE
extends BHxFieldEditor {
    public static final BHxSmartRefFE INSTANCE = new BHxSmartRefFE();
    public static final Type TYPE = Sys.loadType(BHxSmartRefFE.class);
    public static final String UPDATE = "update";
    protected SmartCommand chooser = new Chooser((BHxView)this);
    protected SmartCommand summary;
    protected SmartCommand clear;
    protected SmartCommand hyperlink;
    protected Command fixSubmit;

    public Type getType() {
        return TYPE;
    }

    public BHxSmartRefFE() {
        this.registerEvent((Event)this.chooser);
        this.summary = new Summary((BHxView)this);
        this.registerEvent((Event)this.summary);
        this.clear = new Clear((BHxView)this);
        this.registerEvent((Event)this.clear);
        this.hyperlink = new Hyperlink((BHxView)this);
        this.registerEvent((Event)this.hyperlink);
        this.fixSubmit = new FixSubmit((BHxView)this);
        this.registerEvent((Event)this.fixSubmit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HxOp op) throws Exception {
        BRef ref = (BRef)op.get();
        boolean allowNull = op.getFacets().getb("allowNull", false);
        if (op.getFacets().get(BReplicableObject.ALLOW_UI_NULL) != null) {
            allowNull = op.getFacets().getb(BReplicableObject.ALLOW_UI_NULL, false);
        }
        int width = ((BInteger)op.getFacets().get("fieldWidth", (BObject)BInteger.make((int)36))).getInt();
        HtmlWriter out = op.getHtmlWriter();
        BOrionDatabase db = this.getOrionDatabase(op);
        OrionType refOrionType = (OrionType)ref.getTargetTypeSpec().getResolvedType();
        if (!PermissionsUtil.canAdminReadOrionType((OrionType)refOrionType, (BOrionDatabase)db, (Context)op)) {
            op.setReadonly(true);
        }
        OrionSession session = null;
        try {
            boolean canReadRef = PermissionsUtil.canReadOrionType((OrionType)refOrionType, (BOrionDatabase)db, (Context)op);
            session = db.createSession((Context)op);
            if (BHxSmartRefFE.isUnmountedSingleTenant(session, op)) {
                ref = EntsecTenantUtil.getTenantList((Context)op).getRefs()[0];
            }
            BIOrionObject target = ref.getTarget(session);
            String handle = "";
            if (target != null) {
                handle = target.getHandle().toString();
            }
            BHxSmartTableView.writeFormValue((String)"value", (String)ref.encodeToString(), (HxOp)op);
            BHxSmartTableView.writeFormValue((String)"handle", (String)handle, (HxOp)op);
            out.w((Object)"<span ");
            if (canReadRef) {
                out.attr("title", this.hyperlink.getDisplayName(op));
                out.attr("style", "cursor:pointer;");
                out.w((Object)("onclick='" + this.hyperlink.getInvokeCode(op)));
                out.w((Object)"'");
            }
            out.w((Object)"> ");
            HxUtil.makeImage((BImage)BImage.make((BIcon)refOrionType.getInstance().getIcon()), (HxOp)op);
            out.w((Object)"</span>");
            out.w((Object)" <input ");
            out.attr("type", "text");
            out.attr("size", "" + width);
            out.attr("readonly", "readonly");
            HxTabUtil.scope((String)"preview", (HtmlWriter)out, (HxOp)op);
            if (!canReadRef) {
                out.attr("value", "--not privileged--");
            } else if (target != null) {
                out.attr("value", target.toDisplayString((Context)op));
            } else {
                out.attr("value", HxTabUtil.getNoneText((Context)op));
            }
            out.w((Object)"/>");
            if (op.canWrite()) {
                out.w((Object)"<span ");
                out.attr("title", this.chooser.getDisplayName(op));
                out.attr("style", "cursor:pointer;");
                out.w((Object)("onclick='" + this.chooser.getInvokeCode(op)));
                out.w((Object)"'> ");
                HxUtil.makeImage((BImage)this.chooser.getIcon(op), (HxOp)op);
                out.w((Object)"</span>");
            }
            if (canReadRef) {
                out.w((Object)"<span ");
                HxTabUtil.scope((String)"summary", (HtmlWriter)out, (HxOp)op);
                out.attr("title", this.summary.getDisplayName(op));
                if (target == null) {
                    out.attr("style", "display:none;cursor:pointer");
                } else {
                    out.attr("style", "cursor:pointer;");
                }
                out.w((Object)("onclick='" + this.summary.getInvokeCode(op)));
                out.w((Object)"'> ");
                HxUtil.makeImage((BImage)this.summary.getIcon(op), (HxOp)op);
                out.w((Object)"</span>");
            }
            if (allowNull && op.canWrite()) {
                out.w((Object)"<span ");
                HxTabUtil.scope((String)"clear", (HtmlWriter)out, (HxOp)op);
                if (target == null) {
                    out.attr("style", "display:none;cursor:pointer");
                } else {
                    out.attr("style", "cursor:pointer;");
                }
                out.attr("title", this.clear.getDisplayName(op));
                out.attr("style", "cursor:pointer;");
                out.w((Object)("onclick='" + this.clear.getInvokeCode(op)));
                out.w((Object)"'> ");
                HxUtil.makeImage((BImage)this.clear.getIcon(op), (HxOp)op);
                out.w((Object)"</span>");
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public BObject save(HxOp op) throws Exception {
        BRefList tenantList;
        String refForm = op.getFormValue("value");
        BRef ref = (BRef)BRef.NULL.decodeFromString(refForm);
        boolean allowNull = op.getFacets().getb("allowNull", false);
        if (op.getFacets().get(BReplicableObject.ALLOW_UI_NULL) != null) {
            allowNull = op.getFacets().getb(BReplicableObject.ALLOW_UI_NULL, false);
        }
        if (!allowNull && !ref.isBound()) {
            String module = TYPE.getModule().getModuleName();
            throw new LocalizableException(module, "error.mustBeAssigned", new Object[]{ref.getTargetTypeSpec().getResolvedType().getDisplayName((Context)op)});
        }
        if (ref.getTargetTypeSpec().getResolvedType().is(BTenant.TYPE) && op.getFacets().getb("tenantRequired", true) && (!op.getUser().getPermissions().isSuperUser() || op.getFacets().getb("suTenantRequired", true)) && (tenantList = EntsecTenantUtil.getTenantList((Context)op)) != null && tenantList.isBound() && !ref.isBound()) {
            String module = TYPE.getModule().getModuleName();
            throw new LocalizableException(module, "error.mustBeAssigned", new Object[]{ref.getTargetTypeSpec().getResolvedType().getDisplayName((Context)op)});
        }
        return ref;
    }

    public BOrionTypeId getOrionTypeId(HxOp op) {
        return ((BRef)op.get()).getTargetOrionTypeId();
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        if (this.chooser.process(op)) {
            return true;
        }
        if (this.summary.process(op)) {
            return true;
        }
        return this.clear.process(op);
    }

    public static boolean isUnmountedSingleTenant(OrionSession session, HxOp op) {
        BRef ref = (BRef)op.get();
        if (ref.getTargetTypeSpec().getResolvedType().is(BTenant.TYPE) && EntsecTenantUtil.hasSingleTenant((Context)op)) {
            if (!op.getFacets().getb("suTenantRequired", true) && BHxSmartRefFE.isSelfUser(op)) {
                return false;
            }
            op.setReadonly(true);
            if (ref.isBound()) {
                return false;
            }
            if (!BHxSmartRefFE.isMountedOrionObject(session, op) && !BHxSmartRefFE.isMountedInComponentSpace(op)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMountedOrionObject(OrionSession session, HxOp op) {
        BObject o = op.get();
        HxOp t = op;
        while (!(t.get() instanceof BIOrionObject)) {
            o = t.get();
            if ((t = t.getBaseOrdTarget()) != null) continue;
            return false;
        }
        if (t == null) {
            return false;
        }
        BIOrionObject oo = (BIOrionObject)t.get();
        return session.exists(oo);
    }

    public static boolean isSelfUser(HxOp op) {
        BObject o = op.get();
        HxOp t = op;
        while (!(t.get() instanceof BUser)) {
            o = t.get();
            if ((t = t.getBaseOrdTarget()) != null) continue;
            return false;
        }
        if (t == null) {
            return false;
        }
        BUser deepContextUser = (BUser)t.get();
        return deepContextUser.equals((Object)op.getUser());
    }

    public static boolean isMountedInComponentSpace(HxOp op) {
        BObject o = op.get();
        HxOp t = op;
        while (!(t.get() instanceof BComponent) || ((BComponent)t.get()).isMounted()) {
            o = t.get();
            if ((t = t.getBaseOrdTarget()) != null) continue;
            return false;
        }
        if (t == null) {
            return false;
        }
        return t.get() instanceof BComponent && ((BComponent)t.get()).isMounted();
    }

    public BOrionDatabase getOrionDatabase(HxOp op) {
        BObject o = op.get();
        HxOp t = op;
        while (!(t.get() instanceof BIOrionDatabaseObject)) {
            o = t.get();
            t = t.getBaseOrdTarget();
        }
        return ((BIOrionDatabaseObject)t.get()).getOrionDatabase();
    }

    public static void setModified(HxOp op) throws Exception {
        op.getHtmlWriter().w((Object)"smartTable.fireOnChange($('").w((Object)op.scope("handle")).w((Object)"'));");
        HxTabUtil.fireSaveEventInFacets((HxOp)op);
        if (op.getFacets().getb("setModified", true)) {
            SaveCommand.setModified((HxOp)op);
        }
        if (op.getFacets().getb(UPDATE, false)) {
            SmartCommand.forceUpdate((HxOp)op);
        }
    }

    public Tab getDialogTab(HxOp op) {
        BAppTable table = new BAppTable();
        table.setRowType(this.getOrionTypeId(op));
        table.setResolveBase((BObject)this.getOrionDatabase(op));
        table.setDbOrd(this.getOrionDatabase(op).getAbsoluteOrd());
        HxOp fieldOp = op.make("refChooser", (BObject)table, BHxSmartTableView.makeHeightFacets((int)300));
        op.getRequest().setAttribute(fieldOp.scope("parentOp"), (Object)op);
        return new Tab((BHxView)BHxSmartRefTable.INSTANCE, fieldOp);
    }

    public class Chooser
    extends SmartCommand {
        private ChooserDialog dlg;

        public Chooser(BHxView view) {
            super(view);
            this.dlg = new ChooserDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "refChooser";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            return BHxSmartRefFE.this.getDialogTab(op).process();
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                SmartCommand.disable((String)op.scope("submit"), (HxOp)op);
                return;
            }
            Tab tab = BHxSmartRefFE.this.getDialogTab(op);
            BHxSmartRefTable sView = (BHxSmartRefTable)tab.view;
            BIOrionObject o = (BIOrionObject)sView.getSubject(tab.op);
            if (o == null) {
                throw new IllegalStateException("Need at least one reference");
            }
            BRef ref = BRef.make((BIOrionObject)o);
            HtmlWriter out = op.getHtmlWriter();
            SmartCommand.setFormValue((String)op.scope("preview"), (Object)o.toDisplayString((Context)op), (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("value"), (Object)ref.encodeToString(), (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("handle"), (Object)o.getHandle(), (HxOp)op);
            SmartCommand.show((String)op.scope("summary"), (HxOp)op);
            SmartCommand.tryException((HxOp)op);
            SmartCommand.show((String)op.scope("clear"), (HxOp)op);
            SmartCommand.catchException((HxOp)op);
            BHxSmartRefFE.setModified(op);
        }

        class ChooserDialog
        extends Dialog {
            public ChooserDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                Tab tab = BHxSmartRefFE.this.getDialogTab(op);
                tab.write();
                String quote = HxUtil.getInnerQuote((HxOp)op);
                BHxSmartTableView.writeFormValue((String)"fixCommandEvent", (String)SmartCommand.getInvokeCode((Command)BHxSmartRefFE.this.fixSubmit, (String)quote, (HxOp)op), (HxOp)tab.op);
            }
        }
    }

    public class FixSubmit
    extends Command {
        public FixSubmit(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            SmartCommand.tryException((HxOp)op);
            Tab tab = BHxSmartRefFE.this.getDialogTab(op);
            String[] propNames = SmartCommand.getSelectionList((HxOp)tab.op);
            if (propNames.length == 1) {
                SmartCommand.disable((String)op.scope("submit"), (boolean)false, (HxOp)op);
            } else {
                SmartCommand.disable((String)op.scope("submit"), (boolean)true, (HxOp)op);
            }
            SmartCommand.catchException((HxOp)op);
        }
    }

    public class Hyperlink
    extends SmartCommand {
        public Hyperlink(BHxView view) {
            super(view, smartTableHxLex);
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public String getName(HxOp op) {
            return "hyperlink";
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HxOp op) throws Exception {
            String value = op.getFormValue("value");
            BRef ref = (BRef)BRef.NULL.decodeFromString(value);
            BIOrionObject o = null;
            OrionSession session = null;
            try {
                session = BHxSmartRefFE.this.getOrionDatabase(op).createSession((Context)op);
                o = ref.getTarget(session);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            if (o == null) {
                return;
            }
            BOrd ord = BOrd.make((String)("station:|" + o.getHandle()));
            this.redirect(op, op.toUri(ord));
        }
    }

    public class Summary
    extends SummaryCommand {
        public Summary(BHxView view) {
            super(view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BObject getResolvedSubject(HxOp op) throws Exception {
            String value = op.getFormValue("value");
            BRef ref = (BRef)BRef.NULL.decodeFromString(value);
            BIOrionObject o = null;
            OrionSession session = null;
            try {
                session = BHxSmartRefFE.this.getOrionDatabase(op).createSession((Context)op);
                o = ref.getTarget(session);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            return (BOrionObject)o;
        }
    }

    public class Clear
    extends SmartCommand {
        private ConfirmDialog dlg;

        public Clear(BHxView view) {
            super(view);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this, Lexicon.make(((Object)((Object)this)).getClass()).getText("clearRefQuestion"));
        }

        public String getName(HxOp op) {
            return "clear";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            boolean confirm = op.getFacets().getb("confirmClear", false);
            if (confirm && !this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BRef ref = (BRef)op.get();
            BRef nullRef = BRef.make((BTypeSpec)ref.getTargetTypeSpec());
            SmartCommand.setFormValue((String)op.scope("preview"), (Object)HxTabUtil.getNoneText((Context)op), (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("value"), (Object)nullRef.encodeToString(), (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("handle"), (Object)"", (HxOp)op);
            SmartCommand.hide((String)op.scope("summary"), (HxOp)op);
            SmartCommand.hide((String)op.scope("clear"), (HxOp)op);
            BHxSmartRefFE.setModified(op);
        }
    }
}

