/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.PermissionsUtil;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.BIBackgroundAssociation;
import com.tridiumx.entsec.orionTools.BIHierarchyObject;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BISummaryImage;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BSqlMergeFilter;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsecHx.orionToolsHx.BHxMissingTenantView;
import com.tridiumx.entsecHx.orionToolsHx.BHxOrionSummaryTable;
import com.tridiumx.entsecHx.orionToolsHx.BHxSmartRefListFE;
import com.tridiumx.entsecHx.orionToolsHx.BHxSmartRefListTable;
import com.tridiumx.entsecHx.orionToolsHx.DynamicTableCommand;
import com.tridiumx.entsecHx.orionToolsHx.HxRemoteUtil;
import com.tridiumx.entsecHx.orionToolsHx.SummaryCommand;
import com.tridiumx.entsecHx.photoID.BHxPortraitFE;
import java.io.Serializable;
import java.util.Comparator;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.Columns;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BHxOrionSummary
extends BHxView {
    public static final Lexicon summaryLex = Lexicon.make(BHxOrionSummary.class);
    public static final BHxOrionSummary INSTANCE = new BHxOrionSummary();
    public static final Type TYPE = Sys.loadType(BHxOrionSummary.class);
    private static BImage neutralImage = BImage.make((String)"module://entsecHx/rc/neutral.png");
    private static BImage expandImage = BImage.make((String)"module://entsecHx/rc/expand.png");
    private static BImage collapseImage = BImage.make((String)"module://entsecHx/rc/collapse.png");
    private CountCommand countCommand;
    private RefListCommand refListCommand;
    private HyperlinkCommand hyperlinkCommand = new HyperlinkCommand(this);
    private TableCommand tableCommand;
    public SelfSummaryCommand selfSummaryCommand;
    public UpSummaryCommand upSummaryCommand;
    private SmartCommand topLevelHierarchy;

    public Type getType() {
        return TYPE;
    }

    public BHxOrionSummary() {
        this.registerEvent((Event)this.hyperlinkCommand);
        this.tableCommand = new TableCommand(this);
        this.registerEvent((Event)this.tableCommand);
        this.refListCommand = new RefListCommand(this);
        this.registerEvent((Event)this.refListCommand);
        this.countCommand = new CountCommand(this);
        this.registerEvent((Event)this.countCommand);
        this.selfSummaryCommand = new SelfSummaryCommand(this);
        this.registerEvent((Event)this.selfSummaryCommand);
        this.upSummaryCommand = new UpSummaryCommand(this);
        this.registerEvent((Event)this.upSummaryCommand);
        this.topLevelHierarchy = new TopLevelHierarchy(this);
        this.registerEvent((Event)this.topLevelHierarchy);
    }

    public void write(HxOp op) throws Exception {
        op.addStyleSheet("module://smartTableHx/rc/smartTable.css");
        if (op.get() instanceof BOrionObject) {
            this.write((BOrionObject)op.get(), op);
        } else if (op.get() instanceof BRefList) {
            this.write((BRefList)op.get(), op);
        } else if (op.get() instanceof BDynamicTable) {
            this.write((BDynamicTable)op.get(), op);
        }
    }

    public boolean process(HxOp op) throws Exception {
        if (op.get() instanceof BDynamicTable) {
            BDynamicTable dt = (BDynamicTable)op.get();
            return this.getDynamicTableTab(dt, op).process();
        }
        if (super.process(op)) {
            return true;
        }
        if (this.refListCommand.process(op)) {
            return true;
        }
        return this.topLevelHierarchy.process(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(BOrionObject o, HxOp op) throws Exception {
        this.setLastSubject((BObject)o, op);
        OrionSession session = null;
        try {
            session = o.getOrionDatabase().createSession((Context)op);
            OrionType orionType = o.getOrionType();
            boolean limited = EntsecTenantUtil.isMissingTenant((BComponent)o, (boolean)true, (Context)op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<div ");
            out.attr("id", op.scope("summary"));
            out.attr("name", op.scope("summary"));
            out.attr("class", "smartTable-setup-panel");
            out.attr("style", "border: 0px;");
            out.w((Object)">");
            if (o instanceof BISummaryImage && !limited) {
                out.w((Object)"<table>");
                out.w((Object)"<tr><td valign='top'>");
            }
            this.writeHeader(o, op);
            if (limited) {
                BHxMissingTenantView.INSTANCE.write(op);
                return;
            }
            this.writeSummaryProperties(o, session, op);
            if (o instanceof BISummaryImage) {
                out.w((Object)"</td><td>");
                try {
                    BImage image = ((BISummaryImage)o).getSummaryImage(session);
                    if (image != null && image.getOrdList().size() > 0) {
                        image.sync();
                        if (image.getHeight() > (double)BHxPortraitFE.PORTRAIT_HEIGHT) {
                            HxUtil.makeImage((BImage)image, (String)(" style='height: " + BHxPortraitFE.PORTRAIT_HEIGHT + "px;'"), (HxOp)op);
                        } else {
                            HxUtil.makeImage((BImage)image, (HxOp)op);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                out.w((Object)"</td></tr>");
                out.w((Object)"</table>");
            }
            this.writeReferences(o, session, op);
            out.w((Object)"</div>");
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(BRefList o, HxOp op) throws Exception {
        this.setLastSubject((BObject)o, op);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div ");
        out.attr("id", op.scope("summary"));
        out.attr("name", op.scope("summary"));
        out.attr("class", "smartTable-setup-panel");
        out.attr("style", "border: 0px;");
        out.w((Object)">");
        BOrionDatabase db = BHxSmartRefListFE.getOrionDatabase(op);
        OrionSession session = null;
        Array a = new Array(BIOrionObject.class);
        try {
            session = db.createSession((Context)op);
            Object[] targets = o.getTargets(session);
            if (targets != null) {
                a.addAll(targets);
                a = a.sort((Comparator)new ToDisplayStringComparator((Context)op));
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        out.w((Object)"<table>");
        out.w((Object)"<tr><td>");
        out.w((Object)" ");
        if (a.size() > 0) {
            out.safe((Object)o.toString());
        } else {
            out.safe((Object)summaryLex.getText("none"));
        }
        out.w((Object)"</td></tr>");
        for (int i = 0; i < a.size(); ++i) {
            BOrionObject target = (BOrionObject)a.get(i);
            out.w((Object)"<tr><td>");
            if (target != null) {
                this.writeSummaryHyperlink(target, BImage.make((BIcon)target.getIcon()), op);
            } else {
                this.writeHyperlink(null, o.toString(i, (Context)op), BImage.make((BIcon)o.getTargetOrionType(null).getInstance().getIcon()), op);
            }
            out.w((Object)"</td></tr>");
        }
        out.w((Object)"</table>");
        out.w((Object)"</div>");
    }

    public void write(BDynamicTable dt, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div ");
        out.attr("id", op.scope("summary"));
        out.attr("name", op.scope("summary"));
        out.attr("class", "smartTable-setup-panel");
        out.attr("style", "border: 0px;");
        out.w((Object)">");
        this.getDynamicTableTab(dt, op).write();
        out.w((Object)"</div>");
    }

    public Tab getDynamicTableTab(BDynamicTable dt, HxOp op) {
        if (op.get() instanceof BDynamicTable) {
            op.setAttribute(op.scope("parentOp"), (Object)op);
            op.setAttribute(op.scope("parentView"), (Object)this);
            return new Tab((BHxView)BHxOrionSummaryTable.INSTANCE, "summary", op);
        }
        HxOp fieldOp = op.make("summary", new OrdTarget((OrdTarget)op, (BObject)dt));
        op.setAttribute(fieldOp.scope("parentOp"), (Object)op);
        op.setAttribute(fieldOp.scope("parentView"), (Object)this);
        return new Tab((BHxView)BHxOrionSummaryTable.INSTANCE, "summary", fieldOp);
    }

    public void setLastSubject(BObject o, HxOp op) {
        op.getRequest().getSession().setAttribute(op.scope("lastSubject"), (Object)o);
    }

    public BObject getLastSubject(HxOp op) {
        return (BObject)op.getRequest().getSession().getAttribute(op.scope("lastSubject"));
    }

    public void writeHeader(BOrionObject o, HxOp op) throws Exception {
        BOrd ord = (BOrd)o.getHandle();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table ");
        out.attr(" id", op.scope("title"));
        out.w((Object)"><tr><td ");
        out.attr(" class", "smartTable-header");
        if (HxUtil.isPost((HxOp)op)) {
            String extra = "view:?defaultTab=" + SlotPath.escape((String)o.getType().getDisplayName((Context)op));
            ord = BOrd.make((BOrd)ord, (String)extra);
            out.attr(" style", "cursor: pointer;");
            out.w((Object)"onclick = ");
            out.w((Object)"'window.location=&quot;").w((Object)HxUtil.encodeURLForHref((String)op.toUri(ord))).w((Object)"&quot;;");
            out.w((Object)"'");
        }
        out.w((Object)">");
        HxUtil.makeImage((BImage)BImage.make((BIcon)o.getIcon()), (HxOp)op);
        out.safe((Object)o.toDisplayString((Context)op));
        out.w((Object)"</td></tr></table>");
    }

    public void writeSummaryProperties(BOrionObject o, OrionSession session, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table><tr><td ");
        out.w((Object)">");
        if (o instanceof BIOrdMappable && !(o instanceof BIHierarchyObject)) {
            BIOrdMappable mapped = (BIOrdMappable)o;
            HxUtil.makeImage((BImage)BImage.make((BIcon)BIcon.std((String)"hyperlink.png")), (HxOp)op);
            out.safe((Object)(Lexicon.make(((Object)((Object)this)).getClass()).get("orion.mappedOrd") + ":  "));
            out.w((Object)"</td><td>");
            BOrd hyperlink = mapped.getMappedOrd();
            if (mapped.getStationName().equals(Sys.getStation().getStationName())) {
                this.writeHyperlink(op.toUri(hyperlink), mapped.getMappedDisplayPath(), null, op);
            } else {
                String url = HxRemoteUtil.getRemoteUrl(hyperlink, mapped.getStationName(), op);
                if (url == null) {
                    this.writeHyperlink(url, Lexicon.make(((Object)((Object)this)).getClass()).get("stationUnavailable"), null, op);
                } else {
                    this.writeHyperlink(url, SlotPath.unescape((String)url), null, op);
                }
            }
            out.w((Object)"</td></tr><tr><td>");
        }
        HxUtil.makeImage((BImage)BImage.make((BIcon)BIcon.std((String)"shapes/squareBlue.png")), (HxOp)op);
        out.safe((Object)(Lexicon.make(((Object)((Object)this)).getClass()).get("orion.type") + ":  "));
        out.w((Object)"</td><td ");
        out.w((Object)">");
        BImage image = BImage.make((BIcon)BIcon.std((String)"shapes/squareBlue.png"));
        BTypeSpec typeSpec = o.getOrionType().getTypeSpec();
        this.writeTableType(null, o.getOrionType().getDisplayName((Context)op), BImage.make((BIcon)o.getIcon()), op);
        out.w((Object)"</td></tr>");
        Property[] props = o.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BRef ref;
            OrionType refOrionType;
            if (!Flags.isSummary((BComplex)o, (Slot)props[i]) || props[i].getType().is(BRef.TYPE) && !PermissionsUtil.canReadOrionType((OrionType)(refOrionType = (OrionType)(ref = (BRef)props[i].getDefaultValue()).getTargetTypeSpec().getResolvedType()), (BOrionDatabase)o.getOrionDatabase(), (Context)op)) continue;
            out.w((Object)"<tr><td>");
            if (props[i].getType().is(BRef.TYPE)) {
                ref = (BRef)props[i].getDefaultValue();
                HxUtil.makeImage((BImage)BImage.make((BIcon)ref.getTargetTypeSpec().getInstance().getIcon()), (HxOp)op);
            } else {
                HxUtil.makeImage((BImage)BImage.make((BIcon)props[i].getType().getTypeSpec().getTypeInfo().getIcon((Context)op)), (HxOp)op);
            }
            String text = props[i].getDefaultDisplayName((Context)op) + ":  ";
            out.safe((Object)text);
            out.w((Object)"</td><td>");
            if (props[i].getType().is(BRef.TYPE)) {
                BRef ref2 = (BRef)o.get(props[i]);
                if (ref2.isBound()) {
                    this.writeSummaryHyperlink((BOrionObject)ref2.getTarget(session), null, op);
                } else {
                    out.w((Object)"&nbsp;");
                }
            } else {
                out.safe((Object)o.get(props[i]).toString());
            }
            out.w((Object)"</td></tr>");
        }
        if (o instanceof BIOrdMappable) {
            BHxOrionSummary.writeMappableSummaries((BIOrdMappable)o, op);
        }
        out.w((Object)"</td></tr></table>");
    }

    public static void writeMappableSummaries(BIOrdMappable mappable, HxOp op) throws Exception {
        BOrd ord = mappable.getMappedOrd();
        if (ord == BOrd.NULL) {
            return;
        }
        BComponent mapped = null;
        if (mappable.getStationName().equals(Sys.getStation().getStationName())) {
            try {
                mapped = (BComponent)ord.get();
            }
            catch (UnresolvedException e) {
                return;
            }
        } else {
            mapped = HxRemoteUtil.getRemoteComponent(ord, mappable.getStationName(), op);
            if (mapped == null) {
                return;
            }
            mapped.lease();
        }
        HtmlWriter out = op.getHtmlWriter();
        Property[] props = mapped.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!Flags.isSummary((BComplex)mapped, (Slot)props[i]) || ((BIOrionObject)mappable).getOrionType().getProperty(props[i].getName()) != null) continue;
            out.w((Object)"<tr><td>");
            HxUtil.makeImage((BImage)BImage.make((BIcon)props[i].getType().getTypeSpec().getTypeInfo().getIcon((Context)op)), (HxOp)op);
            String text = mapped.getDisplayName((Slot)props[i], (Context)op) + ":  ";
            out.safe((Object)text);
            out.w((Object)"</td><td>");
            out.safe((Object)mapped.get(props[i]).toString((Context)mapped.getSlotFacets((Slot)props[i])));
            out.w((Object)"</td></tr>");
        }
    }

    public void writeTableType(BOrionObject o, String text, BImage image, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        HxUtil.makeImage((BImage)image, (HxOp)op);
        out.w((Object)" ");
        if (o == null || !HxUtil.isPost((HxOp)op)) {
            out.safe((Object)text);
            return;
        }
        out.w((Object)"<span ");
        out.attr(" class", "smartTableButton");
        out.attr(" style", "color: #af0000;");
        String extra = "view:?defaultTab=" + SlotPath.escape((String)text);
        out.w((Object)"onclick = 'window.location=&quot;");
        out.w((Object)HxUtil.encodeURLForHref((String)op.toUri(BOrd.make((BOrd)((BOrd)o.getHandle()), (String)extra))));
        out.w((Object)"&quot;;'>");
        out.w((Object)" ");
        out.safe((Object)text);
        out.w((Object)"</span>");
    }

    public void writeSummaryHyperlink(BOrionObject o, BImage image, HxOp op) throws Exception {
        this.writeSummaryHyperlink(o, image, null, op);
    }

    public void writeSummaryHyperlink(BOrionObject o, BImage image, String spanStyle, HxOp op) throws Exception {
        this.writeSummaryHyperlink(o.toDisplayString((Context)op), o, image, spanStyle, op);
    }

    public void writeSummaryHyperlink(String displayString, BOrionObject o, BImage image, String spanStyle, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span ");
        out.attr(" class", "smartTableButton");
        if (spanStyle != null) {
            out.attr(" style", spanStyle);
        }
        if (!HxUtil.isPost((HxOp)op)) {
            out.w((Object)"onclick = \"");
            this.hyperlinkCommand.redirect(op, (BOrd)o.getHandle());
            out.w((Object)"\"");
        } else {
            out.w((Object)"onclick = '");
            out.w((Object)("hx.setFormValue(&quot;" + op.scope("handle") + "&quot;,&quot;" + o.getHandle() + "&quot;);" + this.hyperlinkCommand.getInvokeCode(op)));
            out.w((Object)"'");
        }
        out.w((Object)">");
        if (image != null) {
            HxUtil.makeImage((BImage)image, (HxOp)op);
        }
        out.w((Object)" ");
        out.safe((Object)displayString);
        out.w((Object)"</span>");
    }

    public void writeSummaryReadonly(String displayString, BOrionObject o, BImage image, String spanStyle, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span ");
        if (spanStyle != null) {
            out.attr(" style", spanStyle);
        }
        out.w((Object)">");
        if (image != null) {
            HxUtil.makeImage((BImage)image, (HxOp)op);
        }
        out.w((Object)" ");
        out.safe((Object)displayString);
        out.w((Object)"</span>");
    }

    public void writeTopLevelHierarachy(BOrionObject o, String text, BImage image, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        HxUtil.makeImage((BImage)image, (HxOp)op);
        out.w((Object)" ");
        out.w((Object)"<span ");
        out.attr(" class", "smartTableButton");
        out.attr(" style", "color: #af0000;");
        String onClick = SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("handle"), (Object)o.getHandle(), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("isPost"), (Object)("" + HxUtil.isPost((HxOp)op)), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + this.topLevelHierarchy.getInvokeCode(op);
        out.w((Object)"onclick = ' ");
        out.w((Object)onClick);
        out.w((Object)"'>");
        out.w((Object)" ");
        out.safe((Object)text);
        out.w((Object)"</span>");
    }

    public void writeHyperlink(BOrd o, BImage image, HxOp op) throws Exception {
        if (o == BOrd.NULL) {
            this.writeHyperlink(null, "", image, op);
        } else {
            this.writeHyperlink(op.toUri(o), o.toString((Context)op), image, op);
        }
    }

    public void writeHyperlink(String s, String display, BImage image, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span ");
        if (s != null) {
            out.attr(" class", "smartTableButton");
            out.attr(" onclick", "hx.hyperlink('" + HxUtil.escapeJsStringLiteral((String)s) + "');");
        }
        out.w((Object)">");
        if (image != null) {
            HxUtil.makeImage((BImage)image, (HxOp)op);
        }
        out.safe((Object)display);
        out.w((Object)"</span>");
    }

    public void writeHierarchy(BOrionObject o, OrionSession session, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<td valign='top'>");
        out.w((Object)"<table>");
        out.w((Object)"<tr><td ");
        out.w((Object)">");
        Lexicon lex = Lexicon.make(BHxOrionSummary.class);
        this.writeTopLevelHierarachy(o, lex.getText("hierarchy"), neutralImage, op);
        out.w((Object)"</td></tr>");
        int spaces = 1;
        BIOrionObject[] parents = ((BIHierarchyObject)o).getParentObjects(session);
        for (int i = 0; i < parents.length; ++i) {
            BOrionObject parent = (BOrionObject)parents[i];
            out.w((Object)"<tr><td>");
            for (int j = 0; j < spaces; ++j) {
                out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            String displayString = parent.toDisplayString((Context)BIHierarchyObject.HIERARCHY_DISPLAY_FACETS);
            if (!EntsecTenantUtil.isMissingTenant((BComponent)parent, (Context)op)) {
                this.writeSummaryHyperlink(displayString, parent, neutralImage, null, op);
            } else {
                this.writeSummaryReadonly(displayString, parent, neutralImage, null, op);
            }
            out.w((Object)"</td></tr>");
            ++spaces;
        }
        out.w((Object)"<tr><td>");
        for (int j = 0; j < spaces; ++j) {
            out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        String displayString = o.toDisplayString((Context)BIHierarchyObject.HIERARCHY_DISPLAY_FACETS);
        this.writeSummaryHyperlink(displayString, o, collapseImage, "color: #af0000;", op);
        out.w((Object)"</td></tr>");
        ++spaces;
        BIOrionObject[] children = ((BIHierarchyObject)o).getChildObjects(session);
        for (int i = 0; i < children.length; ++i) {
            BOrionObject child = (BOrionObject)children[i];
            if (EntsecTenantUtil.isMissingTenant((BComponent)child, (Context)op)) continue;
            out.w((Object)"<tr><td>");
            for (int j = 0; j < spaces; ++j) {
                out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            displayString = child.toDisplayString((Context)BIHierarchyObject.HIERARCHY_DISPLAY_FACETS);
            this.writeSummaryHyperlink(displayString, child, expandImage, null, op);
            out.w((Object)"</td></tr>");
        }
        out.w((Object)"</table>");
        out.w((Object)"</td>");
    }

    public void writeReferences(BOrionObject o, OrionSession session, HxOp op) throws Exception {
        OrionType oOrionType;
        HtmlWriter out = op.getHtmlWriter();
        BOrionDatabase db = o.getOrionDatabase();
        BTypeDependency[] refTypes = db.getDependentTypes(oOrionType = o.getOrionType());
        if (refTypes.length == 0) {
            return;
        }
        int columns = refTypes.length;
        out.w((Object)"<table ");
        out.w((Object)">");
        out.w((Object)"<tr>");
        if (o instanceof BIHierarchyObject) {
            this.writeHierarchy(o, session, op);
        }
        block0: for (int i = 0; i < columns; ++i) {
            String displayName = "";
            BOrionTypeId fromId = refTypes[i].getFromTypeId();
            OrionType orionType = db.getType(fromId);
            if (orionType.is(BIBackgroundAssociation.TYPE) || !PermissionsUtil.canReadOrionType((OrionType)orionType, (BOrionDatabase)db, (Context)op)) continue;
            if (orionType.isAssociation()) {
                Property fromProp = orionType.getProperty(refTypes[i].getFromProperty());
                Property[] props = orionType.getProperties();
                for (int j = 0; j < props.length; ++j) {
                    BIOrionObject[] matches;
                    BProjectionColumn projectionColumn;
                    BProjection projection;
                    BSqlQuery q;
                    String labelText;
                    if (props[j].equals(fromProp)) continue;
                    Property otherKey = props[j];
                    if (otherKey.getType().is(BRef.TYPE)) {
                        OrionType refOrionType = db.getType(((BRef)otherKey.getDefaultValue()).getTargetOrionTypeId());
                        if (refOrionType.is(BIBackgroundAssociation.TYPE) || !PermissionsUtil.canReadOrionType((OrionType)refOrionType, (BOrionDatabase)db, (Context)op)) continue;
                        Lexicon lex = Lexicon.make((Class)refOrionType.getTypeClass());
                        labelText = BHxOrionSummary.getRelationshipDisplayName((Type)oOrionType, (Type)orionType, (Type)refOrionType, op);
                        if (labelText == null) {
                            labelText = HxTabUtil.getPluralDisplayName((Type)refOrionType, (Context)op);
                        }
                        q = BSqlQuery.make((OrionType)orionType);
                        projection = new BProjection();
                        projectionColumn = SqlColumns.make((OrionType)orionType, (Property)otherKey);
                        projection.add(projectionColumn);
                        q.select(projection);
                        q.where(Predicates.eq((BExpression)new BSqlField(orionType, orionType.getProperty(refTypes[i].getFromProperty())), (BSimple)BRef.make((BIOrionObject)o)));
                        q.page(new BPage(0, 6));
                        q = EntsecTenantUtil.filter((BSqlQuery)q, (BOrionDatabase)session.getOrionDatabase(), (Context)op);
                        matches = session.select((BQuery)q).toArray();
                        if (matches.length <= 0) continue;
                        out.w((Object)"<td valign='top'>");
                        out.w((Object)"<table>");
                        out.w((Object)"<tr><td ");
                        out.w((Object)">");
                        this.writeTableType(o, labelText, BImage.make((BIcon)refOrionType.getInstance().getIcon()), op);
                        out.w((Object)"</td></tr>");
                        if (matches.length < 6) {
                            int k;
                            Property prop = matches[0].getOrionType().getProperties()[0];
                            BRef defaultRef = (BRef)otherKey.getDefaultValue();
                            Array results = new Array(BIOrionObject.class);
                            for (k = 0; k < matches.length; ++k) {
                                BRef ref = (BRef)matches[k].get(prop);
                                results.add((Object)ref.getTarget(session));
                            }
                            results = results.sort((Comparator)new ToDisplayStringComparator((Context)op));
                            for (k = 0; k < results.size(); ++k) {
                                BOrionObject h = (BOrionObject)results.get(k);
                                out.w((Object)"<tr><td>");
                                this.writeSummaryHyperlink(h, BImage.make((BIcon)h.getIcon()), op);
                                out.w((Object)"</td></tr>");
                            }
                        } else {
                            String onclick = SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("labelText"), (Object)SlotPath.escape((String)labelText), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("handle"), (Object)o.getHandle(), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + this.countCommand.getInvokeCode(op);
                            String onSecondClick = SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("labelText"), (Object)SlotPath.escape((String)labelText), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("handle"), (Object)o.getHandle(), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("isPost"), (Object)("" + HxUtil.isPost((HxOp)op)), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + this.refListCommand.getInvokeCode(op);
                            out.w((Object)"<tr><td");
                            out.attr(" class", "smartTableButton");
                            if (!HxUtil.isPost((HxOp)op)) {
                                out.w((Object)("onclick = '" + onclick + "'"));
                            } else {
                                out.w((Object)("onclick = '" + onSecondClick + "'"));
                            }
                            out.w((Object)("id = '" + op.scope("refCount" + SlotPath.escape((String)labelText)) + "'"));
                            out.w((Object)">");
                            out.safe((Object)BHxSmartTableView.getManyText((HxOp)op));
                            out.w((Object)"</td></tr>");
                        }
                        out.w((Object)"</table>");
                        out.w((Object)"</td>");
                        continue block0;
                    }
                    String targetTypeString = otherKey.getFacets().gets("targetType", null);
                    if (targetTypeString == null) continue;
                    Type targetType = BTypeSpec.make((String)targetTypeString).getResolvedType();
                    labelText = BHxOrionSummary.getRelationshipDisplayName((Type)oOrionType, (Type)orionType, targetType, op);
                    if (labelText == null) {
                        labelText = HxTabUtil.getPluralDisplayName((Type)targetType, (Context)op);
                    }
                    q = BSqlQuery.make((OrionType)orionType);
                    projection = new BProjection();
                    projectionColumn = SqlColumns.make((OrionType)orionType, (Property)otherKey);
                    projection.add(projectionColumn);
                    q.select(projection);
                    q.where(Predicates.eq((BExpression)new BSqlField(orionType, orionType.getProperty(refTypes[i].getFromProperty())), (BSimple)BRef.make((BIOrionObject)o)));
                    if (targetType.is(BNiagaraStation.TYPE)) {
                        ExpressionBuilder b = new ExpressionBuilder(q.getPredicate().getPredicateExpr());
                        b.and(Predicates.ne((BExpression)new BSqlField(orionType, otherKey), (BSimple)BString.make((String)Sys.getStation().getStationName())));
                        q.where(b.getExpression());
                    }
                    q.page(new BPage(0, 6));
                    q = EntsecTenantUtil.filter((BSqlQuery)q, (BOrionDatabase)session.getOrionDatabase(), (Context)op);
                    matches = session.select((BQuery)q).toArray();
                    if (matches.length <= 0) continue;
                    out.w((Object)"<td valign='top'>");
                    out.w((Object)"<table>");
                    out.w((Object)"<tr><td ");
                    out.w((Object)">");
                    BIcon icon = otherKey.getType().getTypeInfo().getIcon((Context)op);
                    if (targetType != null) {
                        icon = targetType.getInstance().getIcon();
                    }
                    this.writeTableType(o, labelText, BImage.make((BIcon)icon), op);
                    out.w((Object)"</td></tr>");
                    if (matches.length < 6) {
                        for (int m = 0; m < matches.length; ++m) {
                            out.w((Object)"<tr><td>");
                            out.w((Object)"<span ");
                            out.attr(" class", "smartTableButton");
                            out.attr(" style", "font-weight: normal; cursor: default;");
                            out.w((Object)">");
                            HxUtil.makeImage((BImage)BImage.make((BIcon)icon), (HxOp)op);
                            out.w((Object)" ");
                            out.safe((Object)matches[m].get(otherKey).toString((Context)op));
                            out.w((Object)"</span>");
                            out.w((Object)"</td></tr>");
                        }
                    } else {
                        out.w((Object)"<tr><td>");
                        out.safe((Object)BHxSmartTableView.getManyText((HxOp)op));
                        out.w((Object)"</td></tr>");
                    }
                    out.w((Object)"</table>");
                    out.w((Object)"</td>");
                    continue block0;
                }
                continue;
            }
            Property refProp = orionType.getProperty(refTypes[i].getFromProperty());
            BSqlQuery q = BSqlQuery.make((OrionType)orionType);
            q.where(Predicates.eq((BExpression)new BSqlField(orionType, refProp), (BSimple)BRef.make((BIOrionObject)o)));
            q.page(new BPage(0, 6));
            q = EntsecTenantUtil.filter((BSqlQuery)q, (BOrionDatabase)session.getOrionDatabase(), (Context)op);
            Object[] matches = session.select((BQuery)q).toArray();
            if (matches.length <= 0) continue;
            out.w((Object)"<td valign='top'>");
            out.w((Object)"<table>");
            out.w((Object)"<tr><td ");
            out.w((Object)">");
            Lexicon lex = Lexicon.make((Class)orionType.getTypeClass());
            String labelText = HxTabUtil.getPluralDisplayName((Type)orionType, (Context)op);
            this.writeTableType(o, labelText, BImage.make((BIcon)orionType.getInstance().getIcon()), op);
            out.w((Object)"</td></tr>");
            if (matches.length < 6) {
                Array results = new Array(BIOrionObject.class);
                results.addAll(matches);
                results = results.sort((Comparator)new ToDisplayStringComparator((Context)op));
                for (int k = 0; k < results.size(); ++k) {
                    BOrionObject h = (BOrionObject)results.get(k);
                    out.w((Object)"<tr><td>");
                    this.writeSummaryHyperlink(h, BImage.make((BIcon)h.getIcon()), op);
                    out.w((Object)"</td></tr>");
                }
            } else {
                String onclick = SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("labelText"), (Object)SlotPath.escape((String)labelText), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("handle"), (Object)o.getHandle(), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + this.countCommand.getInvokeCode(op);
                String onSecondClick = SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("labelText"), (Object)SlotPath.escape((String)labelText), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("handle"), (Object)o.getHandle(), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("isPost"), (Object)("" + HxUtil.isPost((HxOp)op)), (String)HxUtil.getOuterQuote((HxOp)op), (boolean)true, (HxOp)op) + this.refListCommand.getInvokeCode(op);
                out.w((Object)"<tr><td");
                out.attr(" class", "smartTableButton");
                if (!HxUtil.isPost((HxOp)op)) {
                    out.w((Object)("onclick = '" + onclick + "'"));
                } else {
                    out.w((Object)("onclick = '" + onSecondClick + "'"));
                }
                out.w((Object)("id = '" + op.scope("refCount" + SlotPath.escape((String)labelText)) + "'"));
                out.w((Object)">");
                out.safe((Object)BHxSmartTableView.getManyText((HxOp)op));
                out.w((Object)"</td></tr>");
            }
            out.w((Object)"</table>");
            out.w((Object)"</td>");
        }
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
    }

    public static String getRelationshipDisplayName(Type fromType, Type joinType, Type toType, HxOp op) {
        Lexicon lex = Lexicon.make((Class)joinType.getTypeClass());
        String labelText = lex.get(fromType.getTypeName() + ".to." + joinType.getTypeName() + ".to." + toType.getTypeName());
        return labelText;
    }

    public BDynamicTable getDynamicTable(BOrionObject o, OrionSession session, String labelTextMatch, HxOp op) throws Exception {
        OrionType oOrionType;
        BOrionDatabase db = o.getOrionDatabase();
        BTypeDependency[] refTypes = db.getDependentTypes(oOrionType = o.getOrionType());
        if (refTypes.length == 0) {
            // empty if block
        }
        int columns = refTypes.length;
        for (int i = 0; i < columns; ++i) {
            String displayName = "";
            BOrionTypeId fromId = refTypes[i].getFromTypeId();
            OrionType orionType = db.getType(fromId);
            if (orionType.is(BIBackgroundAssociation.TYPE) || !PermissionsUtil.canReadOrionType((OrionType)orionType, (BOrionDatabase)db, (Context)op)) continue;
            if (orionType.isAssociation()) {
                Property fromProp = orionType.getProperty(refTypes[i].getFromProperty());
                Property[] props = orionType.getProperties();
                for (int j = 0; j < props.length; ++j) {
                    OrionType refOrionType;
                    if (props[j].equals(fromProp) || !props[j].getType().is(BRef.TYPE) || (refOrionType = db.getType(((BRef)props[j].getDefaultValue()).getTargetOrionTypeId())).is(BIBackgroundAssociation.TYPE) || !PermissionsUtil.canReadOrionType((OrionType)refOrionType, (BOrionDatabase)db, (Context)op)) continue;
                    Lexicon lex = Lexicon.make((Class)refOrionType.getTypeClass());
                    String labelText = BHxOrionSummary.getRelationshipDisplayName((Type)oOrionType, (Type)orionType, (Type)refOrionType, op);
                    if (labelText == null) {
                        labelText = HxTabUtil.getPluralDisplayName((Type)refOrionType, (Context)op);
                    }
                    if (!labelTextMatch.equals(labelText)) continue;
                    BSqlQuery q = BSqlQuery.make((OrionType)refOrionType);
                    BSqlJoin join = new BSqlJoin(refOrionType, refOrionType.getKey()[0], orionType, props[j]);
                    BExpression e = join.getOnExpr().newExprCopy();
                    join.setOnExpr(Predicates.and((BExpression)e, (BExpression)Predicates.eq((BExpression)new BSqlField(orionType, orionType.getProperty(refTypes[i].getFromProperty())), (BSimple)BRef.make((BIOrionObject)o))));
                    q.join(join);
                    BOrdering ordering = new BOrdering();
                    Property[] refProps = refOrionType.getProperties();
                    for (int k = 0; k < refProps.length; ++k) {
                        if (!BOrionObject.isDisplayId((Property)refProps[k])) continue;
                        ordering.add(Columns.orderBy((BExpression)new BSqlField(refOrionType, refProps[k])));
                    }
                    q.orderBy(ordering);
                    q = EntsecTenantUtil.filter((BSqlQuery)q, (BOrionDatabase)session.getOrionDatabase(), (Context)op);
                    return (BDynamicTable)this.getListTab((BSqlQuery)q, (OrionType)refOrionType, (BOrionDatabase)db, (HxOp)op).op.get();
                }
                continue;
            }
            Lexicon lex = Lexicon.make((Class)orionType.getTypeClass());
            String labelText = HxTabUtil.getPluralDisplayName((Type)orionType, (Context)op);
            if (!labelTextMatch.equals(labelText)) continue;
            Property refProp = orionType.getProperty(refTypes[i].getFromProperty());
            BSqlQuery q = BSqlQuery.make((OrionType)orionType);
            q.where(Predicates.eq((BExpression)new BSqlField(orionType, refProp), (BSimple)BRef.make((BIOrionObject)o)));
            q = EntsecTenantUtil.filter((BSqlQuery)q, (BOrionDatabase)session.getOrionDatabase(), (Context)op);
            return (BDynamicTable)this.getListTab((BSqlQuery)q, (OrionType)orionType, (BOrionDatabase)db, (HxOp)op).op.get();
        }
        return null;
    }

    public Tab getListTab(BSqlQuery sqlQuery, OrionType rowType, BOrionDatabase db, HxOp op) {
        BAppTable table = new BAppTable();
        table.setRowType(rowType.getOrionTypeId());
        table.setResolveBase((BObject)db);
        table.setDbOrd(db.getAbsoluteOrd());
        table.add(null, (BValue)new BSqlMergeFilter(sqlQuery));
        HxOp fieldOp = op.make("refChooser", (BObject)table, BHxSmartTableView.makeHeightFacets((int)300));
        return new Tab((BHxView)BHxSmartRefListTable.INSTANCE, fieldOp);
    }

    public static int getCount(BOrionObject o, OrionSession session, String labelTextMatch, HxOp op) throws Exception {
        OrionType oOrionType;
        BOrionDatabase db = o.getOrionDatabase();
        BTypeDependency[] refTypes = db.getDependentTypes(oOrionType = o.getOrionType());
        if (refTypes.length == 0) {
            return 0;
        }
        int columns = refTypes.length;
        for (int i = 0; i < columns; ++i) {
            String displayName = "";
            BOrionTypeId fromId = refTypes[i].getFromTypeId();
            OrionType orionType = db.getType(fromId);
            if (orionType.is(BIBackgroundAssociation.TYPE) || !PermissionsUtil.canReadOrionType((OrionType)orionType, (BOrionDatabase)db, (Context)op)) continue;
            if (orionType.isAssociation()) {
                Property fromProp = orionType.getProperty(refTypes[i].getFromProperty());
                Property[] props = orionType.getProperties();
                for (int j = 0; j < props.length; ++j) {
                    OrionType refOrionType;
                    if (props[j].equals(fromProp) || !props[j].getType().is(BRef.TYPE) || (refOrionType = db.getType(((BRef)props[j].getDefaultValue()).getTargetOrionTypeId())).is(BIBackgroundAssociation.TYPE) || !PermissionsUtil.canReadOrionType((OrionType)refOrionType, (BOrionDatabase)db, (Context)op)) continue;
                    Lexicon lex = Lexicon.make((Class)refOrionType.getTypeClass());
                    String labelText = BHxOrionSummary.getRelationshipDisplayName((Type)oOrionType, (Type)orionType, (Type)refOrionType, op);
                    if (labelText == null) {
                        labelText = HxTabUtil.getPluralDisplayName((Type)refOrionType, (Context)op);
                    }
                    if (!labelTextMatch.equals(labelText)) continue;
                    return EntsecTenantUtil.getCount((OrionType)orionType, (Property)orionType.getProperty(refTypes[i].getFromProperty()), (BSimple)BRef.make((BIOrionObject)o), (OrionSession)session);
                }
                continue;
            }
            Lexicon lex = Lexicon.make((Class)orionType.getTypeClass());
            String labelText = HxTabUtil.getPluralDisplayName((Type)orionType, (Context)op);
            if (!labelTextMatch.equals(labelText)) continue;
            Property refProp = orionType.getProperty(refTypes[i].getFromProperty());
            return EntsecTenantUtil.getCount((OrionType)orionType, (Property)refProp, (BSimple)BRef.make((BIOrionObject)o), (OrionSession)session);
        }
        throw new RuntimeException("Unknown Count");
    }

    public static class ToDisplayStringComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Context cx;

        public ToDisplayStringComparator(Context cx) {
            this.cx = cx;
        }

        public int compare(Object o1, Object o2) {
            BIOrionObject oo1 = (BIOrionObject)o1;
            BIOrionObject oo2 = (BIOrionObject)o2;
            return oo1.toDisplayString(this.cx).compareTo(oo2.toDisplayString(this.cx));
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    public class CountCommand
    extends SummaryCommand {
        public CountCommand(BHxView view) {
            super(view);
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public void handle(HxOp op) throws Exception {
            String labelText = op.getFormValue("labelText");
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)("var refCount = $('" + op.scope("refCount") + labelText + "');"));
            out.w((Object)"refCount.innerHTML = \"");
            out.w(this.getCount(op));
            out.w((Object)"\";");
            out.w((Object)"refCount.setAttribute('onclick', refCount.getAttribute('onSecondclick'));");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCount(HxOp op) throws Exception {
            BOrionObject o = (BOrionObject)BOrd.make((String)op.getFormValue("handle")).get();
            BOrionDatabase db = BHxSmartRefListFE.getOrionDatabase(op);
            OrionSession session = null;
            try {
                session = db.createSession((Context)op);
                int n = BHxOrionSummary.getCount(o, session, SlotPath.unescape((String)op.getFormValue("labelText")), op);
                return n;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }

    public class TopLevelHierarchy
    extends SummaryCommand {
        public TopLevelHierarchy(BHxView view) {
            super(view);
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public void handle(HxOp op) throws Exception {
            if (op.getFormValue("isPost").equals("false")) {
                super.handle(op);
            } else {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)("$('" + op.scope("summary") + "').innerHTML = \""));
                this.writeSummary(op);
                out.w((Object)"\";");
                String[] code = op.getOnload();
                for (int i = 0; i < code.length; ++i) {
                    out.w((Object)code[i]);
                }
                SmartCommand.resizeCurrentDialog((HxOp)op);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BObject getResolvedSubject(HxOp op) throws Exception {
            BOrionObject o = (BOrionObject)BOrd.make((String)op.getFormValue("handle")).get();
            BOrionDatabase db = BHxSmartRefListFE.getOrionDatabase(op);
            OrionSession session = null;
            try {
                BRefList refList;
                session = db.createSession((Context)op);
                BIOrionObject[] os = ((BIHierarchyObject)o).getTopLevelHierarchyObjects(session);
                BRefList bRefList = refList = BRefList.make((OrionType)o.getOrionType(), (BIOrionObject[])os);
                return bRefList;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }

    public class RefListCommand
    extends SummaryCommand {
        public RefListCommand(BHxView view) {
            super(view);
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public void handle(HxOp op) throws Exception {
            if (op.getFormValue("isPost").equals("false")) {
                super.handle(op);
            } else {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)("$('" + op.scope("summary") + "').innerHTML = \""));
                this.writeSummary(op);
                out.w((Object)"\";");
                String[] code = op.getOnload();
                for (int i = 0; i < code.length; ++i) {
                    out.w((Object)code[i]);
                }
                SmartCommand.resizeCurrentDialog((HxOp)op);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BObject getResolvedSubject(HxOp op) throws Exception {
            BOrionObject o = (BOrionObject)BOrd.make((String)op.getFormValue("handle")).get();
            BOrionDatabase db = BHxSmartRefListFE.getOrionDatabase(op);
            OrionSession session = null;
            try {
                BDynamicTable oo;
                session = db.createSession((Context)op);
                String text = op.getFormValue("labelText");
                if (text == null) {
                    BObject bObject = null;
                    return bObject;
                }
                text = SlotPath.unescape((String)text);
                BDynamicTable bDynamicTable = oo = BHxOrionSummary.this.getDynamicTable(o, session, text, op);
                return bDynamicTable;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }

    public class UpSummaryCommand
    extends SummaryCommand {
        public UpSummaryCommand(BHxView view) {
            super(view, Lexicon.make((String)"entsecHx"));
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public String getName(HxOp op) {
            return "upSummary";
        }

        public boolean isTableCommand(HxOp op) {
            return true;
        }

        public String getInvokeCode(HxOp op) {
            String method = op.getRequest().getMethod().toLowerCase();
            String quote = method.equals("get") ? "\"" : "&quot;";
            HxOp parentOp = (HxOp)op.getAttribute(op.scope("parentOp"));
            StringBuffer buf = new StringBuffer();
            buf.append("hx.fireEvent(");
            buf.append(quote).append(parentOp.getPath()).append(quote);
            buf.append(",");
            buf.append(quote).append(this.getId()).append(quote);
            buf.append(");");
            return buf.toString();
        }

        @Override
        public BObject getResolvedSubject(HxOp op) throws Exception {
            return BHxOrionSummary.this.getLastSubject(op);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)("$('" + op.scope("summary") + "').innerHTML = \""));
            this.writeSummary(op);
            out.w((Object)"\";");
            String[] code = op.getOnload();
            for (int i = 0; i < code.length; ++i) {
                out.w((Object)code[i]);
            }
            SmartCommand.resizeCurrentDialog((HxOp)op);
        }

        @Override
        public void writeSummary(HxOp op) throws Exception {
            BObject o = this.getResolvedSubject(op);
            BHxOrionSummary fe = INSTANCE;
            if (o instanceof BOrionObject) {
                fe.write((BOrionObject)o, op);
            } else if (o instanceof BRefList) {
                fe.write((BRefList)o, op);
            } else if (o instanceof BDynamicTable) {
                fe.write((BDynamicTable)o, op);
            }
        }
    }

    public class SelfSummaryCommand
    extends SummaryCommand {
        public SelfSummaryCommand(BHxView view) {
            super(view);
        }

        public String getInvokeCode(HxOp op) {
            String method = op.getRequest().getMethod().toLowerCase();
            String quote = method.equals("get") ? "\"" : "&quot;";
            HxOp parentOp = (HxOp)op.getAttribute(op.scope("parentOp"));
            StringBuffer buf = new StringBuffer();
            buf.append("hx.fireEvent(");
            buf.append(quote).append(parentOp.getPath()).append(quote);
            buf.append(",");
            buf.append(quote).append(this.getId()).append(quote);
            buf.append(");");
            return buf.toString();
        }

        @Override
        public BObject getResolvedSubject(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op.make("summary", (OrdTarget)op));
            if (selectionList.length < 1) {
                throw new IllegalStateException("Please select a row.");
            }
            String rowId = selectionList[0];
            return (BOrionObject)BOrd.make((String)rowId).get();
        }

        @Override
        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)("$('" + op.scope("summary") + "').innerHTML = \""));
            this.writeSummary(op);
            out.w((Object)"\";");
            String[] code = op.getOnload();
            for (int i = 0; i < code.length; ++i) {
                out.w((Object)code[i]);
            }
            SmartCommand.resizeCurrentDialog((HxOp)op);
        }

        @Override
        public void writeSummary(HxOp op) throws Exception {
            BObject o = this.getResolvedSubject(op);
            BHxOrionSummary fe = INSTANCE;
            if (o instanceof BOrionObject) {
                fe.write((BOrionObject)o, op);
            } else if (o instanceof BRefList) {
                fe.write((BRefList)o, op);
            } else if (o instanceof BDynamicTable) {
                fe.write((BDynamicTable)o, op);
            }
        }
    }

    public class HyperlinkCommand
    extends Command {
        public HyperlinkCommand(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)("$('" + op.scope("summary") + "').innerHTML = \""));
            String handle = op.getFormValue("handle");
            BOrionObject o = (BOrionObject)BOrd.make((String)handle).get();
            BHxOrionSummary fe = INSTANCE;
            fe.write(o, op);
            out.w((Object)"\";");
            SmartCommand.resizeCurrentDialog((HxOp)op);
        }
    }

    public class TableCommand
    extends DynamicTableCommand {
        public TableCommand(BHxView view) {
            super(view);
        }

        @Override
        public BTypeSpec getTypeSpec(HxOp op) {
            String formValue = op.getFormValue("handle");
            BTypeSpec typeSpec = BTypeSpec.make((String)formValue);
            return typeSpec;
        }
    }
}

