/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionHx;

import com.tridium.hx.fieldeditors.BHxBooleanFE;
import com.tridium.hx.fieldeditors.BHxEnumFE;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.dt.BDynamicTableReportType;
import com.tridium.orion.priv.ui.BDynamicTableOptions;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.filter.PrefilteringUtil;
import com.tridiumx.entsecHx.orionHx.BHxDTFrom;
import com.tridiumx.entsecHx.orionHx.BHxDTLinkedProperty;
import com.tridiumx.entsecHx.orionHx.BHxDTProperty;
import com.tridiumx.entsecHx.orionHx.BHxDynamicColumnTable;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.util.LexiconModule;

public class BHxDynamicTableConfig
extends BHxView {
    public static final LexiconModule lex = LexiconModule.make((String)"entsecHx");
    public static final BHxDynamicTableConfig INSTANCE = new BHxDynamicTableConfig();
    public static final Type TYPE = Sys.loadType(BHxDynamicTableConfig.class);
    private static final String SAVE_TO_OPTIONS_ID = "save_to_options";
    SmartCommand addColumn;
    SmartCommand defaultColumns;
    Command rowTypeChanged;
    Command reportTypeChanged;
    Command fromChanged;
    Command propertyChanged;
    Command linkedPropertyChanged;
    Command prefilteringChanged = new PrefilteringChanged(this);

    public Type getType() {
        return TYPE;
    }

    public BHxDynamicTableConfig() {
        this.registerEvent((Event)this.prefilteringChanged);
        this.rowTypeChanged = new RowTypeChanged(this);
        this.registerEvent((Event)this.rowTypeChanged);
        this.fromChanged = new FromChanged(this);
        this.registerEvent((Event)this.fromChanged);
        this.propertyChanged = new PropertyChanged(this);
        this.registerEvent((Event)this.propertyChanged);
        this.linkedPropertyChanged = new LinkedPropertyChanged(this);
        this.registerEvent((Event)this.linkedPropertyChanged);
        this.addColumn = new AddColumn(this);
        this.registerEvent((Event)this.addColumn);
        this.defaultColumns = new DefaultColumns(this);
        this.registerEvent((Event)this.defaultColumns);
        this.reportTypeChanged = new ReportTypeChanged(this);
        this.registerEvent((Event)this.reportTypeChanged);
    }

    public void write(HxOp op) throws Exception {
        BDynamicTable dtable = (BDynamicTable)op.get();
        boolean prefiltering = PrefilteringUtil.getPrefiltering((BDynamicTable)dtable);
        BDynamicTable working = (BDynamicTable)dtable.newCopy();
        working.setResolveBase((BObject)dtable);
        working.removeAll();
        PrefilteringUtil.setPrefiltering((BDynamicTable)working, (boolean)prefiltering);
        BDynamicTableColumn[] columns = dtable.getWorkingColumns((Context)op);
        for (int i = 0; i < columns.length; ++i) {
            working.add(columns[i].getColumnName(), columns[i].newCopy());
        }
        op.getRequest().getSession().setAttribute("working", (Object)working);
        BHxDynamicTableConfig.initSaveToColumns(op);
        HtmlWriter out = op.getHtmlWriter();
        BHxDynamicColumnTable.INSTANCE.write(op.make("setColumns", (OrdTarget)op));
        HxTabUtil.getSpacerDiv((HxOp)op);
        this.writeRowType(op);
        HxTabUtil.writeCommands((SmartCommand[])new SmartCommand[]{this.addColumn, this.defaultColumns}, (boolean)true, (HxOp)op);
        out.w((Object)"<table ");
        out.attr("width", "100%");
        out.w((Object)">");
        out.w((Object)"<tr><td ");
        out.attr("valign", "top");
        out.attr("class", "unselect");
        out.w((Object)">");
        HxOp fromOp = op.make("from", (OrdTarget)op);
        BHxDTFrom.INSTANCE.write(fromOp);
        HxTabUtil.addEvent((String)HxTabUtil.CLICK, (String)HxTabUtil.FIRE_ROW_EVENT, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)fromOp.scope("records"), (String)op.getPath(), (String)this.fromChanged.getId(), (HxOp)op);
        out.w((Object)"</td><td ");
        out.attr("valign", "top");
        out.attr("class", "unselect");
        out.w((Object)">");
        HxOp propOp = op.make("property", (OrdTarget)op);
        BHxDTProperty.INSTANCE.write(propOp);
        HxTabUtil.addEvent((String)HxTabUtil.CLICK, (String)HxTabUtil.FIRE_ROW_EVENT, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)propOp.scope("records"), (String)op.getPath(), (String)this.propertyChanged.getId(), (HxOp)op);
        out.w((Object)"</td><td ");
        out.attr("valign", "top");
        out.attr("class", "unselect");
        out.w((Object)">");
        HxOp linkedOp = op.make("linkedProperty", (OrdTarget)op);
        BHxDTLinkedProperty.INSTANCE.write(linkedOp);
        HxTabUtil.addEvent((String)HxTabUtil.CLICK, (String)HxTabUtil.FIRE_ROW_EVENT, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)linkedOp.scope("records"), (String)op.getPath(), (String)this.linkedPropertyChanged.getId(), (HxOp)op);
        out.w((Object)"</td></tr>");
        out.w((Object)"</table>");
        HxTabUtil.addEvent((String)HxTabUtil.DOUBLE_CLICK, (String)HxTabUtil.FIRE_ROW_EVENT, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)linkedOp.scope("records"), (String)op.getPath(), (String)this.addColumn.getId(), (HxOp)op);
        HxTabUtil.addEvent((String)HxTabUtil.DOUBLE_CLICK, (String)HxTabUtil.FIRE_ROW_EVENT, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)propOp.scope("records"), (String)op.getPath(), (String)this.addColumn.getId(), (HxOp)op);
    }

    public void writeRowType(HxOp op) throws Exception {
        BDynamicTable dtable = (BDynamicTable)op.get();
        HxOp fieldOp = op.make("rowType", (BObject)BHxDynamicTableConfig.getRange(op), null);
        if (Flags.isReadonly((BComplex)dtable, (Slot)BDynamicTable.rowType)) {
            fieldOp.setReadonly(true);
        }
        HtmlWriter out = op.getHtmlWriter();
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("rowType", (Context)op), (HtmlWriter)out, (HxOp)op);
        fieldOp.mergeFacets(BHxEnumFE.PREFER_FROZEN_EDITOR);
        BHxEnumFE.INSTANCE.write(fieldOp);
        HxTabUtil.addEvent((String)"change", (String)HxTabUtil.FIRE_EVENT, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)fieldOp.scope("value"), (String)op.getPath(), (String)this.rowTypeChanged.getId(), (HxOp)op);
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        Tab reportTypeTab = this.getReportTypeTab(op);
        HxTabUtil.startRow((String)reportTypeTab.title, (HtmlWriter)out, (HxOp)op);
        reportTypeTab.write();
        HxTabUtil.addEvent((String)"change", (String)HxTabUtil.FIRE_EVENT, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)reportTypeTab.op.scope("value"), (String)op.getPath(), (String)this.reportTypeChanged.getId(), (HxOp)op);
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        Tab preTab = this.getPrefilteringTab(op);
        HxTabUtil.startRow((String)preTab.title, (HtmlWriter)out, (HxOp)op);
        preTab.write();
        HxTabUtil.addEvent((String)"change", (String)HxTabUtil.FIRE_EVENT, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)preTab.op.scope("value"), (String)op.getPath(), (String)this.prefilteringChanged.getId(), (HxOp)op);
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
    }

    public Tab getReportTypeTab(HxOp op) {
        BDynamicTable working = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
        BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
        BDynamicTableReportType reportType = options.getReportType(working, (Context)op);
        HxOp reportTypeOp = op.make("reportType", (BObject)reportType, null);
        if (Flags.isReadonly((BComplex)working, (Slot)BDynamicTable.reportType)) {
            reportTypeOp.setReadonly(true);
        }
        reportTypeOp.mergeFacets(BHxEnumFE.PREFER_FROZEN_EDITOR);
        return new Tab((BHxView)BHxEnumFE.INSTANCE, lex.getText("reportType", (Context)op), reportTypeOp, op);
    }

    public Tab getPrefilteringTab(HxOp op) {
        BDynamicTable working = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
        BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
        BBoolean prefilter = BBoolean.make((boolean)options.getPrefiltering(working));
        HxOp prefilterOp = op.make("preFilter", (BObject)prefilter, null);
        return new Tab((BHxView)BHxBooleanFE.INSTANCE, lex.getText("preFilter", (Context)op), prefilterOp, op);
    }

    public static BDynamicEnum getRange(HxOp op) throws Exception {
        BDynamicTable dtable = (BDynamicTable)op.get();
        BOrionDatabase db = dtable.getOrionDatabase();
        BOrionSpace space = (BOrionSpace)BOrd.make((String)"orion:").get((BObject)dtable);
        BOrionType[] orionTypes = db.getTypes();
        OrionType[] types = new OrionType[orionTypes.length];
        for (int i = 0; i < orionTypes.length; ++i) {
            types[i] = orionTypes[i].getOrionType();
        }
        BOrionTypeId rowTypeId = dtable.getRowType();
        String[] tags = new String[types.length];
        int selectedIndex = -1;
        for (int i = 0; i < types.length; ++i) {
            tags[i] = SlotPath.escape((String)types[i].toString());
            if (rowTypeId.isNull() || !types[i].getOrionTypeId().equals((Object)rowTypeId)) continue;
            selectedIndex = i;
        }
        BEnumRange range = BEnumRange.make((String[])tags);
        return BDynamicEnum.make((int)selectedIndex, (BEnumRange)range);
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        if (BHxDynamicColumnTable.INSTANCE.process(op.make("setColumns", (OrdTarget)op))) {
            return true;
        }
        if (BHxDTFrom.INSTANCE.process(op.make("from", (OrdTarget)op))) {
            return true;
        }
        if (BHxDTProperty.INSTANCE.process(op.make("property", (OrdTarget)op))) {
            return true;
        }
        return BHxDTLinkedProperty.INSTANCE.process(op.make("linkedProperty", (OrdTarget)op));
    }

    public static void initSaveToColumns(HxOp op) throws Exception {
        op.getRequest().getSession().removeAttribute(SAVE_TO_OPTIONS_ID);
        boolean saveToOptions = BHxDynamicTableConfig.getSaveToOptions(op);
        BHxDynamicTableConfig.setSaveToOptions(saveToOptions, op);
    }

    public static void setSaveToOptions(boolean saveToOptions, HxOp op) throws Exception {
        op.getRequest().getSession().setAttribute(SAVE_TO_OPTIONS_ID, (Object)BBoolean.make((boolean)saveToOptions));
    }

    public static boolean getSaveToOptions(HxOp op) {
        if (HxUtil.isPost((HxOp)op) && op.getRequest().getSession().getAttribute(SAVE_TO_OPTIONS_ID) != null) {
            BBoolean b = (BBoolean)op.getRequest().getSession().getAttribute(SAVE_TO_OPTIONS_ID);
            return b.getBoolean();
        }
        BDynamicTable dt = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
        BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
        return options.getColumns(dt, (Context)op) != null;
    }

    public class AddColumn
    extends SmartCommand {
        public AddColumn(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "addColumn";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BOrionObject instance;
            SaveCommand.setModified((HxOp)op);
            BDynamicTable dt = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
            BOrionDatabase db = ((BDynamicTable)op.get()).getOrionDatabase();
            BOrionSpace space = (BOrionSpace)BOrd.make((String)"orion:").get();
            BTypeDependency from = (BTypeDependency)dt.get("working_from");
            Property fromTypeProp = BHxDTProperty.getProperty(op.make("property", (OrdTarget)op));
            Property linkedProp = BHxDTLinkedProperty.getLinkedProperty(op.make("linkedProperty", (OrdTarget)op));
            if (from == null || fromTypeProp == null) {
                return;
            }
            String columnName = linkedProp == null ? fromTypeProp.getName() : linkedProp.getName();
            BDynamicTableColumn col = null;
            if (linkedProp == null) {
                BOrionTypeId fromType = from.getFromTypeId();
                OrionType fromOrionType = (OrionType)fromType.getTypeSpec().getResolvedType();
                instance = (BOrionObject)fromOrionType.getInstance();
                instance.setOrionDatabase(db);
                String displayName = instance.getDisplayName((Slot)fromTypeProp, (Context)op);
                if (displayName == null) {
                    displayName = fromTypeProp.getDefaultDisplayName((Context)op);
                }
                col = new BDynamicTableColumn(columnName, displayName, fromType, fromTypeProp.getName(), from.getFromProperty().length() == 0 ? BTypeDependency.NULL : from);
            } else {
                BOrionTypeId refTypeId = ((BRef)fromTypeProp.getDefaultValue()).getTargetOrionTypeId();
                OrionType refType = db.getType(refTypeId);
                instance = (BOrionObject)refType.getInstance();
                String displayName = instance.getDisplayName((Slot)linkedProp, (Context)op);
                if (displayName == null) {
                    displayName = linkedProp.getDefaultDisplayName((Context)op);
                }
                BTypeDependency d = BTypeDependency.make((BOrionTypeId)refTypeId, (String)refType.getKey()[0].getName(), (BOrionTypeId)from.getFromTypeId(), (String)fromTypeProp.getName());
                col = new BDynamicTableColumn(columnName, displayName, refTypeId, linkedProp.getName(), d, from.getFromProperty().length() == 0 ? BTypeDependency.NULL : from);
            }
            if (dt.get(col.getColumnName()) == null) {
                dt.add(col.getColumnName(), (BValue)col);
            } else if (((BDynamicTableColumn)dt.get(col.getColumnName())).getHiddenKey()) {
                dt.set(dt.getProperty(col.getColumnName()), (BValue)col);
            } else {
                return;
            }
            HxOp setOp = op.make("setColumns", (OrdTarget)op);
            HtmlWriter out = op.getHtmlWriter();
            String cls = "smartTable-row1";
            out.w((Object)"var table = $('").w((Object)setOp.scope("records")).w((Object)"');");
            out.w((Object)"var row=table.insertRow(table.rows.length);");
            out.w((Object)"row.id='").safe((Object)col.getColumnName()).w((Object)"';");
            out.w((Object)"var cell=row.insertCell(row.cells.length);");
            out.w((Object)"cell.className='").w((Object)cls).w((Object)"';");
            out.w((Object)"cell.textContent=\"");
            out.w((Object)HxUtil.escapeJsStringLiteral((String)col.getColumnName()));
            out.w((Object)"\";");
            out.w((Object)"cell=row.insertCell(row.cells.length);");
            out.w((Object)"cell.className='").w((Object)cls).w((Object)"';");
            out.w((Object)"cell.textContent=\"");
            out.w((Object)HxUtil.escapeJsStringLiteral((String)col.getAlias().format((Object)op.get(), (Context)op)));
            out.w((Object)"\";");
            out.w((Object)"cell=row.insertCell(row.cells.length);");
            out.w((Object)"cell.className='").w((Object)cls).w((Object)"';");
            out.w((Object)"cell.innerHTML=\"");
            out.w((Object)col.getFromType());
            out.w((Object)"\";");
            BHxDynamicTableConfig.setSaveToOptions(true, op);
        }
    }

    public class LinkedPropertyChanged
    extends Command {
        public LinkedPropertyChanged(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            BDynamicTable dtable = (BDynamicTable)op.get();
            BOrionDatabase db = dtable.getOrionDatabase();
            BDynamicTable working = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
            HxOp propertyOp = op.make("property", (OrdTarget)op);
            Property fromProp = BHxDTProperty.getProperty(op.make("property", (OrdTarget)op));
            if (fromProp != null && fromProp.getType() == BRef.TYPE) {
                BRef def = (BRef)fromProp.getDefaultValue();
                BOrionSpace space = (BOrionSpace)BOrd.make((String)"orion:").get((BObject)dtable);
                OrionType targetType = db.getType(def.getTargetOrionTypeId());
                if (working.get("working_prop") != null) {
                    working.set("working_prop", (BValue)targetType.getOrionTypeId());
                } else {
                    working.add("working_prop", (BValue)targetType.getOrionTypeId());
                }
            } else if (working.get("working_prop") != null) {
                working.remove("working_prop");
            }
        }
    }

    public class PropertyChanged
    extends Command {
        public PropertyChanged(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            BDynamicTable dtable = (BDynamicTable)op.get();
            BOrionDatabase db = dtable.getOrionDatabase();
            BDynamicTable working = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
            HxOp propertyOp = op.make("property", (OrdTarget)op);
            Property fromProp = BHxDTProperty.getProperty(op.make("property", (OrdTarget)op));
            if (fromProp != null && fromProp.getType() == BRef.TYPE) {
                BRef def = (BRef)fromProp.getDefaultValue();
                BOrionSpace space = (BOrionSpace)BOrd.make((String)"orion:").get((BObject)dtable);
                OrionType targetType = db.getType(def.getTargetOrionTypeId());
                if (working.get("working_prop") != null) {
                    working.set("working_prop", (BValue)targetType.getOrionTypeId());
                } else {
                    working.add("working_prop", (BValue)targetType.getOrionTypeId());
                }
            } else if (working.get("working_prop") != null) {
                working.remove("working_prop");
            }
            BHxDTLinkedProperty.INSTANCE.reloadTable(op.make("linkedProperty", (OrdTarget)op));
        }
    }

    public class FromChanged
    extends Command {
        public FromChanged(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            BDynamicTable dtable = (BDynamicTable)op.get();
            BDynamicTable working = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
            HxOp fromOp = op.make("from", (OrdTarget)op);
            String[] propNames = SmartCommand.getSelectionList((HxOp)fromOp);
            if (propNames.length == 0) {
                working.remove("working_from");
                if (working.get("working_prop") != null) {
                    working.remove("working_prop");
                }
                BHxDTFrom.INSTANCE.reloadTable(op.make("from", (OrdTarget)op));
                BHxDTProperty.INSTANCE.reloadTable(op.make("property", (OrdTarget)op));
                BHxDTLinkedProperty.INSTANCE.reloadTable(op.make("linkedProperty", (OrdTarget)op));
                return;
            }
            String propName = propNames[0];
            BOrionSpace space = (BOrionSpace)BOrd.make((String)"orion:").get((BObject)dtable);
            BTypeDependency dependency = (BTypeDependency)BTypeDependency.DEFAULT.decodeFromString(propName);
            if (working.get("working_from") != null) {
                working.set("working_from", (BValue)dependency);
            } else {
                working.add("working_from", (BValue)dependency);
            }
            if (working.get("working_prop") != null) {
                working.remove("working_prop");
            }
            BHxDTProperty.INSTANCE.reloadTable(op.make("property", (OrdTarget)op));
            BHxDTLinkedProperty.INSTANCE.reloadTable(op.make("linkedProperty", (OrdTarget)op));
        }
    }

    public class ReportTypeChanged
    extends Command {
        public ReportTypeChanged(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            Tab tab = BHxDynamicTableConfig.this.getReportTypeTab(op);
            BDynamicTableReportType reportType = (BDynamicTableReportType)tab.save();
            BDynamicTable dt = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
            dt.setReportType(reportType);
        }
    }

    public class PrefilteringChanged
    extends Command {
        public PrefilteringChanged(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            Tab tab = BHxDynamicTableConfig.this.getPrefilteringTab(op);
            BBoolean prefiltering = (BBoolean)tab.save();
            BDynamicTable dt = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
            PrefilteringUtil.setPrefiltering((BDynamicTable)dt, (boolean)prefiltering.getBoolean());
        }
    }

    public class RowTypeChanged
    extends Command {
        public RowTypeChanged(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            BDynamicTable dt = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
            HxOp fieldOp = op.make("rowType", (BObject)BHxDynamicTableConfig.getRange(op), null);
            fieldOp.mergeFacets(BHxEnumFE.PREFER_FROZEN_EDITOR);
            BEnum saved = (BEnum)BHxEnumFE.INSTANCE.save(fieldOp);
            BOrionTypeId typeId = BOrionTypeId.make((String)SlotPath.unescape((String)saved.getTag()));
            dt.set(BDynamicTable.rowType, (BValue)typeId, (Context)op);
            BHxDTFrom.INSTANCE.reloadTable(op.make("from", (OrdTarget)op));
            BHxDTProperty.INSTANCE.reloadTable(op.make("property", (OrdTarget)op));
            BHxDTLinkedProperty.INSTANCE.reloadTable(op.make("linkedProperty", (OrdTarget)op));
        }
    }

    public class DefaultColumns
    extends SmartCommand {
        public DefaultColumns(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "defaultColumns";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            BDynamicTable working = (BDynamicTable)op.getRequest().getSession().getAttribute("working");
            if (op.getUser().getPermissions().isSuperUser()) {
                BDynamicTableColumn[] columns = working.getDefaultColumns();
                working.removeAll();
                PrefilteringUtil.removePrefiltering((BDynamicTable)working);
                working.setReportType((BDynamicTableReportType)working.getProperty(BDynamicTable.reportType.getName()).getDefaultValue());
                for (int i = 0; i < columns.length; ++i) {
                    working.add(columns[i].getColumnName(), (BValue)columns[i]);
                }
                op.getRequest().getSession().setAttribute("working", (Object)working);
                BHxDynamicTableConfig.setSaveToOptions(false, op);
                BHxDynamicColumnTable.INSTANCE.save.saveTable(op);
                out.w((Object)"save.saved();");
            } else {
                BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
                options.removePrefiltering(working);
                options.removeColumns(working);
                options.removeReportType(working);
                new HxOptionsManager(op).save((BOptions)options);
                BDynamicTable dtable = (BDynamicTable)op.get();
                working = (BDynamicTable)dtable.newCopy();
                working.setResolveBase((BObject)dtable);
                if (dtable.getColumns().length == 0) {
                    BDynamicTableColumn[] columns = dtable.getWorkingColumns((Context)op);
                    for (int i = 0; i < columns.length; ++i) {
                        working.add(columns[i].getColumnName(), columns[i].newCopy());
                    }
                }
                op.getRequest().getSession().setAttribute("working", (Object)working);
                out.w((Object)"save.saved();");
            }
            this.refresh(op);
        }
    }
}

