/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.nrio.util;

import com.tridium.nrio.components.BUIPointEntry;
import com.tridium.nrio.enums.BNrioIoTypeEnum;
import com.tridium.nrio.ui.BNrio16PointManager;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.hx.HxOp;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.workbench.mgr.MgrLearn;

public class NrioUtil {
    private BPointDeviceExt pointsDeviceExt;
    private MgrLearn mgrLearn;
    private BNrio16PointManager pointManager;

    private NrioUtil(HxOp op) {
        this.loadPointManager(op);
    }

    private void loadPointManager(HxOp op) {
        this.pointsDeviceExt = (BPointDeviceExt)op.getComponent();
        AgentList agents = this.pointsDeviceExt.getAgents((Context)op);
        this.pointManager = this.getPointManager(agents);
        this.pointManager.loadValue((BObject)this.pointsDeviceExt, (Context)op);
    }

    private BNrio16PointManager getPointManager(AgentList agents) {
        BNrio16PointManager pointManager = null;
        for (int i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().is(BNrio16PointManager.TYPE)) continue;
            pointManager = (BNrio16PointManager)agents.get(i).getInstance();
            break;
        }
        return pointManager;
    }

    public static NrioUtil make(HxOp op) {
        return new NrioUtil(op);
    }

    public BPointManager getPointManager() {
        return this.pointManager;
    }

    public BPointDeviceExt getPointDeviceExtension() {
        return this.pointsDeviceExt;
    }

    public BControlPoint[] getDbPoints() {
        return this.pointsDeviceExt.getPoints();
    }

    public boolean isDatabaseEmpty() {
        return this.pointsDeviceExt.getPoints().length == 0;
    }

    public BUIPointEntry[] getLearnEntries() {
        this.mgrLearn = this.pointManager.getLearn();
        Array learnEntries = new Array(BUIPointEntry.class);
        learnEntries.addAll(this.mgrLearn.getRoots());
        return (BUIPointEntry[])learnEntries.trim();
    }

    public BUIPointEntry[] getAvailableLearnEntries() {
        BUIPointEntry[] entries = this.getLearnEntries();
        BControlPoint[] dbPoints = this.pointsDeviceExt.getPoints();
        Array availableEntries = new Array(BUIPointEntry.class);
        for (int i = 0; i < entries.length; ++i) {
            boolean inUse = false;
            for (int j = 0; j < dbPoints.length; ++j) {
                if (!entries[i].matches((BComponent)dbPoints[j])) continue;
                inUse = true;
                break;
            }
            if (inUse) continue;
            availableEntries.add((Object)entries[i]);
        }
        return (BUIPointEntry[])availableEntries.trim();
    }

    public BUIPointEntry[] getAvailableLearnEntries(BNrioIoTypeEnum ioType) {
        Array entries = new Array(BUIPointEntry.class);
        BUIPointEntry[] availableEntries = this.getAvailableLearnEntries();
        for (int i = 0; i < availableEntries.length; ++i) {
            if (!availableEntries[i].getIoType().equals((Object)ioType)) continue;
            entries.add((Object)availableEntries[i]);
        }
        return (BUIPointEntry[])entries.trim();
    }
}

