/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.nrio.device.handlers.content;

import com.tridium.nrio.components.BUIPointEntry;
import com.tridium.nrio.enums.BNrioIoTypeEnum;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridiumx.entsecHx.factory.handlers.ContentHandler;
import com.tridiumx.entsecHx.nrio.util.INrioLexicon;
import com.tridiumx.entsecHx.nrio.util.INrioPointCategories;
import com.tridiumx.entsecHx.nrio.util.NrioUtil;
import javax.baja.gx.BImage;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;

public class SelectIoPointContentHandler
extends ContentHandler
implements INrioPointCategories,
INrioLexicon {
    private static String space = "&nbsp;";
    private boolean checked = false;
    private boolean USE_CHECKBOXES = false;
    private BImage booleanIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
    private BImage floatIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
    private BImage mixIcon = BImage.make((String)"module://icons/x16/statusMixed.png");

    @Override
    public void writeContent(HxOp op) throws Exception {
        String ioCategory = op.getFormValue("ioCategory");
        BHxSmartTableView.writeFormValue((String)"ioCategory", (String)ioCategory, (HxOp)op);
        BUIPointEntry[] availableEntries = null;
        NrioUtil util = NrioUtil.make(op);
        HtmlWriter out = op.getHtmlWriter();
        availableEntries = !ioCategory.equals("relayOutput") && !ioCategory.equals("voltageOutput") ? util.getAvailableLearnEntries(BNrioIoTypeEnum.universalInput) : (ioCategory.equals("relayOutput") ? util.getAvailableLearnEntries(BNrioIoTypeEnum.relayOutput) : util.getAvailableLearnEntries(BNrioIoTypeEnum.analogOutput));
        if (availableEntries.length > 0) {
            out.w((Object)"<b>").w((Object)selectIoPointStepComment).w((Object)"</b><br /><br />");
            this.checked = false;
            for (int i = 0; i < availableEntries.length; ++i) {
                BUIPointEntry entry = availableEntries[i];
                this.writeEntry(entry, op, this.USE_CHECKBOXES);
            }
        } else {
            out.w((Object)"<b>No points are currently available for assignment</b>");
            StringBuffer script = new StringBuffer();
            script.append("var elems = document.getElementsByTagName(\"input\");");
            script.append("for(var i = 0; i < elems.length; i++){");
            script.append("if(elems[i].type == \"submit\"){");
            script.append("elems[i].onclick = function(){}");
            script.append("}");
            script.append("}");
            op.addOnload(script.toString());
        }
    }

    private void writeEntry(BUIPointEntry entry, HxOp op, boolean multiSelect) throws Exception {
        BNrioIoTypeEnum type = entry.getIoType();
        String value = entry.getName() + ":" + type.getTag() + ":" + entry.getInstance();
        int instance = entry.getInstance();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input ");
        out.attr("type", multiSelect ? "checkbox" : "radio");
        out.attr("name", op.scope("learnPoint"));
        out.attr("value", value);
        if (!this.checked && !multiSelect) {
            out.attr("checked", "checked");
            this.checked = true;
        }
        out.w((Object)" />");
        switch (type.getOrdinal()) {
            case 4: {
                HxUtil.makeImage((BImage)this.mixIcon, (HxOp)op);
                out.w((Object)(space + "Universal Input " + instance + "<br />"));
                break;
            }
            case 5: {
                HxUtil.makeImage((BImage)this.floatIcon, (HxOp)op);
                out.w((Object)(space + "Analog Output " + instance + "<br />"));
                break;
            }
            case 2: {
                HxUtil.makeImage((BImage)this.booleanIcon, (HxOp)op);
                out.w((Object)(space + "Relay Output " + instance + "<br />"));
                break;
            }
            default: {
                out.w((Object)(space + "Unknown Type " + instance + "<br />"));
            }
        }
    }
}

