/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.nrio.device.handlers.command;

import com.tridium.hx.ErrorDialog;
import com.tridium.nrio.points.BNrio16Points;
import com.tridiumx.entsecHx.factory.handlers.CommandHandler;
import com.tridiumx.entsecHx.nrio.util.NrioCCPMap;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

public class PasteIoPointsCommandHandler
extends CommandHandler {
    public PasteIoPointsCommandHandler(BHxView view) {
        super(view);
    }

    @Override
    public void handle(HxOp op) {
        String[] keys = op.getFormKeys();
        Array copyOrds = new Array(BOrd.class);
        Array cutOrds = new Array(BOrd.class);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].startsWith("copyPointHandleOrd")) {
                copyOrds.add((Object)BOrd.make((String)op.getFormValue(keys[i])));
                continue;
            }
            if (!keys[i].startsWith("cutPointHandleOrd")) continue;
            cutOrds.add((Object)BOrd.make((String)op.getFormValue(keys[i])));
        }
        if (copyOrds.size() > 0) {
            this.pasteCopiedPoints((BOrd[])copyOrds.trim(), op);
        }
        if (cutOrds.size() > 0) {
            this.pasteCutPoints((BOrd[])cutOrds.trim(), op);
        }
    }

    private void pasteCopiedPoints(BOrd[] ords, HxOp op) {
        if (!op.get().getType().is(BNrio16Points.TYPE)) {
            try {
                new ErrorDialog("Invalid Destination", (Throwable)new Exception("The paste destination is invalid.")).open(op);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BComponent pointExtension = op.getComponent();
        BatchResolve batch = null;
        try {
            batch = new BatchResolve(ords).resolve((BObject)pointExtension);
        }
        catch (UnresolvedException ex) {
            try {
                new ErrorDialog("Paste Operation Aborted", (Throwable)new Exception("One or more source points could not be found")).open(op);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        BComponent[] points = batch.getTargetComponents();
        for (int i = 0; i < points.length; ++i) {
            try {
                BComponent point = points[i];
                if (point.getParent() == pointExtension) continue;
                BComponent pointCopy = point.newCopy(true).asComponent();
                pointExtension.add(null, (BValue)pointCopy);
                pointExtension.rename(pointCopy.getPropertyInParent(), SlotPath.escape((String)point.getDisplayName((Context)op)));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.refresh(op);
    }

    private void pasteCutPoints(BOrd[] ords, HxOp op) {
        if (!op.get().getType().is(BNrio16Points.TYPE)) {
            try {
                new ErrorDialog("Invalid Destination", (Throwable)new Exception("The paste destination is invalid.")).open(op);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BComponent pointExtension = op.getComponent();
        BatchResolve batch = null;
        try {
            batch = new BatchResolve(ords).resolve((BObject)pointExtension);
        }
        catch (UnresolvedException ex) {
            try {
                new ErrorDialog("Paste Operation Aborted", (Throwable)new Exception("One or more source points could not be found")).open(op);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        BComponent[] points = batch.getTargetComponents();
        for (int i = 0; i < points.length; ++i) {
            try {
                BComponent point = points[i];
                if (point.getParent() == pointExtension) continue;
                BComponent pointCopy = point.newCopy(true).asComponent();
                pointExtension.add(null, (BValue)pointCopy);
                pointExtension.rename(pointCopy.getPropertyInParent(), SlotPath.escape((String)point.getDisplayName((Context)op)));
                point.getParent().asComponent().remove((BComplex)point);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        NrioCCPMap.getMap().clearMap();
        this.refresh(op);
    }
}

