/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.ui;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Comparator;
import javax.baja.nre.util.TextUtil;

public abstract class IPAddressUtil {
    public static final Comparator ASCENDING = new Comparator(){

        public int compare(Object v1, Object v2) {
            return IPAddressUtil.compare(v1, v2);
        }
    };
    public static final Comparator DESCENDING = new Comparator(){

        public int compare(Object v1, Object v2) {
            return -1 * IPAddressUtil.compare(v1, v2);
        }
    };
    private static final String HEX = "0123456789abcdefABCDEF";
    private static final String ALPHA_NUM = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static boolean isNumericAddr(String hostname) {
        return IPAddressUtil.isIpv4Address(hostname) || IPAddressUtil.isIpv6Address(hostname) || IPAddressUtil.isIpv4MappedAddress(hostname);
    }

    public static boolean isHostname(String address) {
        if (address.length() == 0) {
            return false;
        }
        if (address.length() > 255) {
            return false;
        }
        String[] labels = TextUtil.split((String)address, (char)'.');
        for (int i = 0; i < labels.length; ++i) {
            String currentLabel = labels[i];
            if (currentLabel.length() < 1 || currentLabel.length() > 63) {
                return false;
            }
            if (ALPHA_NUM.indexOf(currentLabel.charAt(0)) == -1 || ALPHA_NUM.indexOf(currentLabel.charAt(currentLabel.length() - 1)) == -1) {
                return false;
            }
            for (int idx = 1; idx < currentLabel.length() - 1; ++idx) {
                char currentChar = currentLabel.charAt(idx);
                if (ALPHA_NUM.indexOf(currentChar) != -1 || currentChar == '-') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIpv6Address(String address) {
        if (address.trim().length() == 0) {
            return false;
        }
        if (address.indexOf(":") != -1) {
            int colons = 0;
            int width = 0;
            if (address.indexOf("::") != address.lastIndexOf("::")) {
                return false;
            }
            for (int idx = 0; idx < address.length(); idx = (int)((short)(idx + 1))) {
                char c = address.charAt(idx);
                if (c == ':') {
                    if (colons >= 7) {
                        return false;
                    }
                    width = 0;
                    colons = (short)(colons + 1);
                    continue;
                }
                if (HEX.indexOf(c) != -1) {
                    if (width >= 4) {
                        return false;
                    }
                    width = (short)(width + 1);
                    continue;
                }
                if (c == '%') {
                    if (idx + 1 == address.length()) {
                        return false;
                    }
                    String deviceId = address.substring(idx + 1);
                    try {
                        Integer.valueOf(deviceId);
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            if (!System.getProperty("java.vm.vendor", "null").equalsIgnoreCase("IBM Corporation") ? NetworkInterface.getByName(deviceId) == null : deviceId.indexOf(32) == -1) {
                                return false;
                            }
                        }
                        catch (SocketException e) {
                            return false;
                        }
                    }
                    idx = (short)address.length();
                    continue;
                }
                return false;
            }
            return colons >= 2 && (address.indexOf("::") != -1 || colons >= 7) && (width != 0 || address.lastIndexOf(":") != address.length() - 1 || address.indexOf("::") == address.length() - 2);
        }
        return false;
    }

    public static boolean isIpv4MappedAddress(String address) {
        if (address.trim().length() == 0) {
            return false;
        }
        if ((address.startsWith("::ffff:") || address.startsWith("::FFFF:")) && address.length() >= 8) {
            return IPAddressUtil.isIpv4Address(address.substring(7));
        }
        return false;
    }

    public static boolean isIpv4Address(String address) {
        if (address.trim().length() == 0) {
            return false;
        }
        if (address.indexOf(".") != -1) {
            int dots = 0;
            int digit = 0;
            int quartetValue = 0;
            for (int i = 0; i < address.length(); ++i) {
                char c = address.charAt(i);
                if (c == '.') {
                    if (digit == 0 || dots >= 3) {
                        return false;
                    }
                    digit = 0;
                    quartetValue = 0;
                    ++dots;
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (digit >= 3) {
                        return false;
                    }
                    ++digit;
                    if ((quartetValue = quartetValue * 10 + Integer.valueOf(new String("" + c))) <= 255) continue;
                    return false;
                }
                return false;
            }
            return dots == 3 && digit != 0;
        }
        return false;
    }

    public static boolean isIpv4SubnetMask(String address) {
        if (address == null) {
            return false;
        }
        if (!IPAddressUtil.isIpv4Address(address)) {
            return false;
        }
        byte[] mask = IPAddressUtil.numericStringToByteArray(address);
        boolean notCompleteHit = false;
        block4: for (int i = 0; i < 4; ++i) {
            int unsignedValue = mask[i] & 0xFF;
            if (notCompleteHit && unsignedValue != 0) {
                return false;
            }
            switch (unsignedValue) {
                case 255: {
                    continue block4;
                }
                case 0: 
                case 128: 
                case 192: 
                case 224: 
                case 240: 
                case 248: 
                case 252: 
                case 254: {
                    notCompleteHit = true;
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static byte[] numericStringToByteArray(String numericString) {
        byte[] address = null;
        if (IPAddressUtil.isIpv6Address(numericString)) {
            address = new byte[16];
            String expandedAddress = IPAddressUtil.expandIPv6NumericString(numericString, true);
            if (expandedAddress.indexOf(37) != -1) {
                expandedAddress = expandedAddress.substring(0, expandedAddress.indexOf(37));
            }
            String[] octet = TextUtil.split((String)expandedAddress, (char)':');
            try {
                for (int i = 0; i < 16; ++i) {
                    String twoByteString = TextUtil.padZeros((String)octet[i / 2], (int)4);
                    address[i++] = (byte)Integer.valueOf(twoByteString.substring(0, 2), 16).intValue();
                    address[i] = (byte)Integer.valueOf(twoByteString.substring(2, 4), 16).intValue();
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        } else if (IPAddressUtil.isIpv4Address(numericString)) {
            address = new byte[4];
            String[] quartet = TextUtil.split((String)numericString, (char)'.');
            try {
                for (int i = 0; i < 4; ++i) {
                    address[i] = (byte)Integer.valueOf(quartet[i]).intValue();
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        } else {
            return null;
        }
        return address;
    }

    public static String expandIPv6NumericString(String ipv6Address, boolean expandCompletely) {
        if (!IPAddressUtil.isIpv6Address(ipv6Address)) {
            return ipv6Address;
        }
        int expanisionIndex = 0;
        expanisionIndex = ipv6Address.indexOf("::");
        if (expanisionIndex == -1) {
            return ipv6Address;
        }
        if (expanisionIndex != ipv6Address.lastIndexOf("::")) {
            return ipv6Address;
        }
        String deviceId = null;
        if (ipv6Address.indexOf(37) != -1) {
            deviceId = ipv6Address.substring(ipv6Address.indexOf(37));
            ipv6Address = ipv6Address.substring(0, ipv6Address.indexOf(37));
        }
        int colonCount = 0;
        for (int i = 0; i < ipv6Address.length(); ++i) {
            if (ipv6Address.charAt(i) != ':') continue;
            ++colonCount;
        }
        StringBuffer expansion = new StringBuffer(":");
        for (int i = 0; i < 8 - colonCount; ++i) {
            expansion.append("0:");
        }
        if (expanisionIndex == 0) {
            expansion.insert(0, "0");
        }
        if (expanisionIndex == ipv6Address.length() - 2) {
            expansion.append("0");
        }
        String result = TextUtil.replace((String)ipv6Address, (String)"::", (String)expansion.toString());
        if (expandCompletely) {
            String[] octets = TextUtil.split((String)result, (char)':');
            StringBuffer fullExpansion = new StringBuffer();
            for (int i = 0; i < 8; ++i) {
                fullExpansion.append(TextUtil.padZeros((String)octets[i], (int)4));
                if (i == 7) continue;
                fullExpansion.append(":");
            }
            if (deviceId != null) {
                fullExpansion.append(deviceId);
            }
            return fullExpansion.toString();
        }
        if (deviceId != null) {
            result = result + deviceId;
        }
        return result;
    }

    public static String getIPv4NetworkPrefix(String ipAddress, String subnetMask) {
        if (ipAddress == null) {
            throw new NullPointerException("IP Address parameter can not be null");
        }
        if (subnetMask == null) {
            throw new NullPointerException("Subnet Mask parameter can not be null");
        }
        if (!IPAddressUtil.isIpv4Address(ipAddress)) {
            throw new IllegalStateException("IP Address is not valid");
        }
        if (!IPAddressUtil.isIpv4SubnetMask(subnetMask)) {
            throw new IllegalStateException("Subnet Mask is not valid");
        }
        byte[] ipAddressBytes = IPAddressUtil.numericStringToByteArray(ipAddress);
        byte[] subnetMaskBytes = IPAddressUtil.numericStringToByteArray(subnetMask);
        StringBuffer networkAsString = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            int quartet = ipAddressBytes[i] & subnetMaskBytes[i] & 0xFF;
            networkAsString.append(quartet);
            if (i == 3) continue;
            networkAsString.append('.');
        }
        return networkAsString.toString();
    }

    public static int compare(Object thisObj, Object thatObj) {
        if (thisObj == null && thatObj == null) {
            return 0;
        }
        if (thisObj != null && thatObj == null) {
            return 1;
        }
        if (thisObj == null && thatObj != null) {
            return -1;
        }
        if (thisObj == thatObj) {
            return 0;
        }
        String thisAddress = thisObj.toString();
        String thatAddress = thatObj.toString();
        boolean thisIsNumeric = IPAddressUtil.isNumericAddr(thisAddress);
        boolean thatIsNumeric = IPAddressUtil.isNumericAddr(thatAddress);
        if (thisIsNumeric && !thatIsNumeric) {
            return 1;
        }
        if (!thisIsNumeric && thatIsNumeric) {
            return -1;
        }
        if (thisIsNumeric && thatIsNumeric) {
            if (thisAddress.equalsIgnoreCase(thatAddress)) {
                return 0;
            }
            boolean thisIsIPv4 = IPAddressUtil.isIpv4Address(thisAddress);
            boolean thatIsIPv4 = IPAddressUtil.isIpv4Address(thatAddress);
            if (thisIsIPv4 && !thatIsIPv4) {
                return -1;
            }
            if (!thisIsIPv4 && thatIsIPv4) {
                return 1;
            }
            if (thisIsIPv4 && thatIsIPv4) {
                String[] theseOctets = TextUtil.split((String)thisAddress, (char)'.');
                String[] thoseOctets = TextUtil.split((String)thatAddress, (char)'.');
                for (int i = 0; i < 4; ++i) {
                    int thatOctet;
                    int thisOctet = Integer.valueOf(theseOctets[i]);
                    if (thisOctet < (thatOctet = Integer.valueOf(thoseOctets[i]).intValue())) {
                        return -1;
                    }
                    if (thisOctet <= thatOctet) continue;
                    return 1;
                }
                return 0;
            }
            if (!thisIsIPv4 && !thatIsIPv4) {
                String[] theseOctets = TextUtil.split((String)IPAddressUtil.expandIPv6NumericString(thisAddress, true), (char)':');
                String[] thoseOctets = TextUtil.split((String)IPAddressUtil.expandIPv6NumericString(thatAddress, true), (char)':');
                for (int i = 0; i < 8; ++i) {
                    int thatOctet;
                    int thisOctet = Integer.valueOf(theseOctets[i], 16);
                    if (thisOctet < (thatOctet = Integer.valueOf(thoseOctets[i], 16).intValue())) {
                        return -1;
                    }
                    if (thisOctet <= thatOctet) continue;
                    return 1;
                }
                return 0;
            }
            return thisAddress.compareTo(thatAddress);
        }
        return thisAddress.compareTo(thatAddress);
    }
}

