/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.join;

import com.tridiumx.accessDriver.enums.activity.BLDAPActivityEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.history.BLDAPAuditRecord;
import com.tridiumx.entsec.ldap.util.ExportPersonsDataUtility;
import com.tridiumx.entsec.ldap.util.LdapValidationUtil;
import com.tridiumx.entsec.securityUtil.HistoryManager;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.users.BLdapUserOperationResponse;
import com.tridiumx.ldapDriver.users.BLdapUserOperationStatus;
import java.util.ArrayList;
import javax.baja.history.BHistoryRecord;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BLdapRollbackJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BLdapRollbackJob.class);
    static Lexicon lex = Lexicon.make(BLdapRollbackJob.class);
    HxOp op;
    BLdapServer selectedLdapServer;

    public Type getType() {
        return TYPE;
    }

    public BLdapRollbackJob() {
    }

    public BLdapRollbackJob(HxOp op, BLdapServer selectedLdapServer) {
        this.op = op;
        this.selectedLdapServer = selectedLdapServer;
    }

    public void run(Context cx) throws Exception {
        try {
            this.progress(10);
            ArrayList ldapUsers = new ArrayList();
            int jobId = ExportPersonsDataUtility.getLdapServerJobId((BLdapServer)this.selectedLdapServer);
            ArrayList distinguishNamesList = ExportPersonsDataUtility.getDistinguishNamesListForDeletion((int)jobId);
            ldapUsers = ExportPersonsDataUtility.getLdapUsersForDeletion((ArrayList)distinguishNamesList);
            BLdapUserOperationResponse[] result = ExportPersonsDataUtility.deleteUsersFromLdapServer((ArrayList)ldapUsers, (BLdapServer)this.selectedLdapServer);
            this.progress(40);
            Array deletedUsersofLdap = LdapValidationUtil.validatePersonsDeleteFromLdapServer((BJob)this, (BLdapUserOperationResponse[])result);
            ExportPersonsDataUtility.deleteLdapPersonsDetails((Array)deletedUsersofLdap);
            this.jobDeleteSuccessLdapUsersMessage(distinguishNamesList.size(), deletedUsersofLdap.size());
            this.makeAuditLogEntries(this.selectedLdapServer, result, jobId, cx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jobDeleteSuccessLdapUsersMessage(int totalLdapUsersToBeDeleted, int ldapDeletedUsers) throws Exception {
        if (totalLdapUsersToBeDeleted == ldapDeletedUsers) {
            this.log().success("All Persons Deleted successfully");
        } else {
            if (totalLdapUsersToBeDeleted > ldapDeletedUsers && ldapDeletedUsers > 0) {
                this.log().failed("Partially Success as only some Persons are deleted ...");
                throw new Exception("Partially deleted Persons ...");
            }
            if (totalLdapUsersToBeDeleted > ldapDeletedUsers && ldapDeletedUsers == 0) {
                throw new Exception("Failed to delete persons ...");
            }
        }
    }

    public void makeAuditLogEntries(BLdapServer server, BLdapUserOperationResponse[] ldapUserOperationResponses, int jobId, Context ctx) {
        BAccessControlService accessControlService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        HistoryManager historyManager = accessControlService.getHistoryManager();
        for (int i = 0; i < ldapUserOperationResponses.length; ++i) {
            BLDAPAuditRecord ldapAuditRecord = new BLDAPAuditRecord();
            ldapAuditRecord.setTimestamp(BAbsTime.now());
            ldapAuditRecord.setLdapServerOrd(server.getSlotPathOrd());
            ldapAuditRecord.setActivity(BLDAPActivityEnum.exportRollback);
            ldapAuditRecord.setActivityId(jobId);
            ldapAuditRecord.setOwner(ctx.getUser().getUsername());
            if (ldapUserOperationResponses[i].getStatus().equals((Object)BLdapUserOperationStatus.success)) {
                ldapAuditRecord.setStatus(BLDAPAuditRecord.successText());
                ldapAuditRecord.setDetails("Successfully rolled back person: " + ldapUserOperationResponses[i].getDistinguishedName());
            } else {
                ldapAuditRecord.setStatus(BLDAPAuditRecord.failureText());
                switch (ldapUserOperationResponses[i].getStatus().getOrdinal()) {
                    case 1: {
                        ldapAuditRecord.setDetails("Failed to roll back person: " + ldapUserOperationResponses[i].getDistinguishedName() + ". No connection");
                        break;
                    }
                    case 2: {
                        ldapAuditRecord.setDetails("Failed to roll back person: " + ldapUserOperationResponses[i].getDistinguishedName() + ". Invalid distinguished name");
                        break;
                    }
                    case 3: {
                        ldapAuditRecord.setDetails("Failed to roll back person: " + ldapUserOperationResponses[i].getDistinguishedName() + ". Entry already exists");
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        ldapAuditRecord.setDetails("Failed to roll back person: " + ldapUserOperationResponses[i].getDistinguishedName() + ". Invalid attributes specified");
                        break;
                    }
                    default: {
                        ldapAuditRecord.setDetails("Failed to roll back person: " + ldapUserOperationResponses[i].getDistinguishedName() + ". Unknown error");
                    }
                }
            }
            historyManager.append((BHistoryRecord)ldapAuditRecord);
        }
    }
}

