/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.discover;

import com.tridium.hx.fieldeditors.BHxDefaultFE;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.fieldeditors.BHxSmartDefaultFE;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.ldapHx.LdapUtil;
import com.tridiumx.entsecHx.ldapHx.discover.BHxLdapDeviceView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.ldapDriver.BLdapNetwork;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

public class BHxLdapUsersView
extends BHxAbstractManagerView {
    static final Lexicon secUtilLex = Lexicon.make(BHxLdapUsersView.class);
    public static final BHxLdapUsersView INSTANCE = new BHxLdapUsersView();
    public static final Type TYPE = Sys.loadType(BHxLdapUsersView.class);
    SmartCommand pingDevices;
    AddDevice addDevice = new AddDevice((BHxView)this);
    EditDevice editDevice;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxLdapUsersView() {
        this.registerEvent((Event)this.addDevice);
        this.editDevice = new EditDevice((BHxView)this);
        this.registerEvent((Event)this.editDevice);
        this.pingDevices = new PingDevices((BHxView)this);
        this.registerEvent((Event)this.pingDevices);
    }

    @Override
    public String getPageTitle(HxOp op) {
        return lex.getText("LdapUsers");
    }

    @Override
    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        return BTypeSpec.make((String)"ldapDriver", (String)"LdapUsers");
    }

    public Type getQueryType(HxOp op) {
        if (op.get() instanceof BLdapNetwork) {
            return ((BDeviceNetwork)op.get()).getDeviceType();
        }
        return null;
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BComponent component = (BComponent)op.get();
        BQuery query = QueryUtil.makeQuery((BTypeSpec)this.getDeviceTypeSpec(op));
        query.select(new BProjection());
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "displayName", lex.getText("displayName")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "serverUrl", lex.getText("serverUrl")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "status", lex.getText("status")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "enabled", lex.getText("enabled")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "faultCause", lex.getText("faultCause")));
        QueryUtil.addHiddenColumns((BQuery)query);
        query.add("base", (BValue)component.getAbsoluteOrd());
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        return query;
    }

    @Override
    public BQuery getDiscoverQuery(HxOp op) {
        return null;
    }

    @Override
    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return null;
    }

    @Override
    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        return null;
    }

    @Override
    public Tab getLearnTab(HxOp op) {
        return new Tab((BHxView)BHxDefaultFE.INSTANCE, op.make("null", (BObject)BString.DEFAULT, null));
    }

    @Override
    public BJob submitDiscoveryJob(HxOp op) {
        return null;
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.addDevice, this.editDevice, this.delete, this.pingDevices, this.hyperlinkCommand, this.filterCommand, this.refresh, this.exportCommand};
    }

    public BComponent getContainer(HxOp op) {
        return (BComponent)op.get();
    }

    static BObject readProperty(String name, HxOp op, Property prop) {
        return BHxLdapUsersView.readProperty(name, op, (BObject)prop.getDefaultValue());
    }

    static BObject readProperty(String name, HxOp op, BObject defaultVal) {
        try {
            BHxSmartDefaultFE editor = BHxSmartDefaultFE.INSTANCE;
            try {
                editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op.make((OrdTarget)op));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return editor.save(op.make(name, new OrdTarget((OrdTarget)op, defaultVal)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static void writeProperty(String name, HxOp op, BComplex obj, Property prop, Lexicon lex) throws Exception {
        if (lex == null) {
            lex = Lexicon.make(obj.getClass());
        }
        BHxLdapUsersView.writeProperty(name, op, (BObject)obj.get(prop), lex.get(prop.getName(), TextUtil.toFriendly((String)prop.getName())), obj.getSlotFacets((Slot)prop), false);
    }

    static void writeProperty(String name, HxOp op, BObject defaultVal, String displayName, BFacets facets, boolean readonly) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BHxSmartDefaultFE editor = BHxSmartDefaultFE.INSTANCE;
        try {
            editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op.make((OrdTarget)op).mergeFacets(facets));
        }
        catch (Exception exception) {
            // empty catch block
        }
        OrdTarget target = new OrdTarget((OrdTarget)op, defaultVal);
        HxOp fieldOp = op.make(name, defaultVal, facets);
        fieldOp.setReadonly(readonly);
        out.w((Object)"<tr ");
        out.w((Object)"><td class='smartTable-setup-label'>");
        out.safe((Object)displayName);
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        editor.write(fieldOp);
        out.w((Object)"</td></tr>");
    }

    public class PingDevices
    extends SmartCommand {
        public PingDevices(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "pingDevices";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            Object[] devices = BHxQueryTableView.getSubjects(op);
            for (int i = 0; i < devices.length; ++i) {
                if (!(devices[i] instanceof BDevice)) continue;
                BDevice device = (BDevice)devices[i];
                device.ping();
            }
            BHxLdapUsersView.this.reloadTables(op);
        }
    }

    class EditDevice
    extends SmartCommand {
        EditDeviceDialog addDeviceDlg;

        public EditDevice(BHxView view) {
            super(view, secUtilLex);
            this.addDeviceDlg = new EditDeviceDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public BComponent getSelectedComponent(HxOp op) {
            String[] sel = EditDevice.getSelectionList((HxOp)op);
            String slotPath = sel[0];
            BOrd ord = BOrd.make((String)("station:|" + slotPath));
            return (BComponent)ord.get(op.get());
        }

        public void handle(HxOp op) throws Exception {
            if (!this.addDeviceDlg.isSubmit(op)) {
                this.addDeviceDlg.open(op);
                return;
            }
            BComponent newC = this.getSelectedComponent(op);
            MgrColumn[] cols = LdapUtil.getMgrColumns(newC);
            String name = BHxLdapUsersView.readProperty("name", op, (BObject)BString.DEFAULT).toString();
            for (int i = 0; i < cols.length; ++i) {
                BObject o = (BObject)cols[i].get((Object)newC);
                if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                String propName = SlotPath.escape((String)cols[i].getDisplayName());
                String newPropStr = op.getFormValue(propName + ".value");
                BValue originalPropValue = (BValue)o;
                BObject obj = BHxLdapUsersView.readProperty(propName, op, (BObject)originalPropValue);
                cols[i].save(new MgrEditRow(newC, null, null), (BValue)obj, (Context)op);
            }
            if (!name.equals(newC.getName())) {
                BHxLdapUsersView.this.getContainer(op).rename(newC.getPropertyInParent(), SlotPath.escape((String)name));
            }
            newC.lease();
            Thread.sleep(1000L);
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }

        class EditDeviceDialog
        extends Dialog {
            public EditDeviceDialog(String title, Command handler) {
                super(title, handler);
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand(), this.makeCancelCommand()};
            }

            protected void writeContent(HxOp op) throws Exception {
                HtmlWriter out = op.getHtmlWriter();
                Lexicon lex = Lexicon.make(BHxLdapDeviceView.class);
                BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"addDevice", (HxOp)op);
                out.w((Object)"<table>");
                BComponent newC = EditDevice.this.getSelectedComponent(op);
                MgrColumn[] cols = LdapUtil.getMgrColumns(newC);
                BHxLdapUsersView.writeProperty("name", op, (BObject)BString.make((String)SlotPath.unescape((String)newC.getName())), "Name", BFacets.NULL, false);
                for (int i = 0; i < cols.length; ++i) {
                    BObject o = (BObject)cols[i].get((Object)newC);
                    if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                    op.setReadonly(cols[i].isReadonly());
                    BHxLdapUsersView.writeProperty(SlotPath.escape((String)cols[i].getDisplayName()), op, o, cols[i].getDisplayName(), BFacets.make((String)"alwaysExpanded", (BIDataValue)BBoolean.TRUE), false);
                }
                out.w((Object)"</table>");
            }
        }
    }

    class AddDevice
    extends SmartCommand {
        AddDeviceDialog addDeviceDlg;

        public AddDevice(BHxView view) {
            super(view, secUtilLex);
            this.addDeviceDlg = new AddDeviceDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "new";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public String getDefaultDisplayName(HxOp op) {
            return this.getNewComponent(op).getType().getDisplayName((Context)op);
        }

        public BComponent getNewComponent(HxOp op) {
            Type newType = BHxLdapUsersView.this.getQueryType(op);
            return (BComponent)newType.getInstance();
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            SmartCommand[] cmds = (SmartCommand[])this.addDeviceDlg.getCommands();
            for (int i = 0; i < cmds.length; ++i) {
                if (!cmds[i].process(op)) continue;
                return true;
            }
            return false;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.addDeviceDlg.isSubmit(op)) {
                this.addDeviceDlg.open(op);
                return;
            }
            BComponent newC = this.getNewComponent(op);
            MgrColumn[] cols = LdapUtil.getMgrColumns(newC);
            String name = BHxLdapUsersView.readProperty("name", op, (BObject)BString.DEFAULT).toString();
            for (int i = 0; i < cols.length; ++i) {
                String propName111 = SlotPath.escape((String)cols[i].getDisplayName());
                BObject o = (BObject)cols[i].get((Object)newC);
                if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                String propName = SlotPath.escape((String)cols[i].getDisplayName());
                String newPropStr = op.getFormValue(propName + ".value");
                BValue originalPropValue = (BValue)o;
                BObject obj = BHxLdapUsersView.readProperty(propName, op, (BObject)originalPropValue);
                cols[i].save(new MgrEditRow(newC, null, null), (BValue)obj, null);
            }
            BHxLdapUsersView.this.getContainer(op).add(name, (BValue)newC);
            newC.lease();
            Thread.sleep(1000L);
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }

        class AddDeviceDialog
        extends Dialog {
            public AddDeviceDialog(String title, Command handler) {
                super(title, handler);
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand(), this.makeCancelCommand()};
            }

            protected void writeContent(HxOp op) throws Exception {
                HtmlWriter out = op.getHtmlWriter();
                Lexicon lex = Lexicon.make(BHxLdapDeviceView.class);
                BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"addDevice", (HxOp)op);
                out.w((Object)"<table>");
                BComponent newC = AddDevice.this.getNewComponent(op);
                MgrColumn[] cols = LdapUtil.getMgrColumns(newC);
                BHxLdapUsersView.writeProperty("name", op, (BObject)BString.make((String)AddDevice.this.getDefaultDisplayName(op)), lex.getText("displayName"), BFacets.NULL, false);
                for (int i = 0; i < cols.length; ++i) {
                    BObject o = (BObject)cols[i].get((Object)newC);
                    if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                    op.setReadonly(cols[i].isReadonly());
                    BHxLdapUsersView.writeProperty(SlotPath.escape((String)cols[i].getDisplayName()), op, o, cols[i].getDisplayName(), BFacets.make((String)"alwaysExpanded", (BIDataValue)BBoolean.TRUE), false);
                }
                out.w((Object)"</table>");
            }
        }
    }
}

