/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx;

import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsecHx.ldapHx.BHxObjectClassListFE;
import java.io.Serializable;
import java.util.Comparator;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BHxObjectClassListTable
extends BHxSmartTableView {
    public static final Lexicon lex = Lexicon.make(BHxObjectClassListTable.class);
    public static final BHxObjectClassListTable INSTANCE = new BHxObjectClassListTable();
    public static final Type TYPE = Sys.loadType(BHxObjectClassListTable.class);
    SmartCommand editCommand = new EditCommand((BHxView)this);
    SmartCommand deleteCommand;
    SmartCommand addCommand;

    public Type getType() {
        return TYPE;
    }

    public BHxObjectClassListTable() {
        this.registerEvent((Event)this.editCommand);
        this.deleteCommand = new DeleteCommand((BHxView)this);
        this.registerEvent((Event)this.deleteCommand);
        this.addCommand = new AddCommand((BHxView)this);
        this.registerEvent((Event)this.addCommand);
    }

    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        super.write(op);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        if (op.canWrite()) {
            return new SmartCommand[]{this.addCommand, this.editCommand, this.deleteCommand};
        }
        return new SmartCommand[0];
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("objectClassName"));
        out.w((Object)"</th>");
    }

    public BComponent getComponent(HxOp op) throws Exception {
        return BHxObjectClassListFE.getObjectClassListComponent(op);
    }

    public TableContents writeContents(HxOp op) throws Exception {
        TableContents contents = new TableContents(op.scope("records"));
        BComponent temp = this.getComponent(op);
        Property[] props = temp.getPropertiesArray();
        String[] objectClassNames = new String[props.length];
        String[] ids = new String[props.length];
        for (int i = props.length - 1; i >= 0; --i) {
            ids[i] = SlotPath.unescape((String)props[i].getName());
            objectClassNames[i] = SlotPath.escape((String)temp.get(props[i]).toString());
            TableContents.Tr tr = new TableContents.Tr();
            tr.id = ids[i];
            tr.td.add(new TableContents.Td(SlotPath.unescape((String)objectClassNames[i])));
            contents.tr.add(tr);
        }
        return contents;
    }

    public static class PropCompare
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        public int compare(Object o1, Object o2) {
            Property p1 = (Property)o1;
            Property p2 = (Property)o2;
            String name1 = SlotPath.unescape((String)p1.getName());
            String name2 = SlotPath.unescape((String)p2.getName());
            return name1.compareTo(name2);
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    public class AddCommand
    extends SmartCommand {
        private AddDialog dlg;

        public AddCommand(BHxView view) {
            super(view);
            this.dlg = new AddDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "add";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String newObjectClassName = op.getFormValue("name");
            BComponent c = BHxObjectClassListTable.this.getComponent(op);
            try {
                c.add(newObjectClassName, (BValue)BString.make((String)newObjectClassName));
            }
            catch (DuplicateSlotException e) {
                throw new Exception("Object Class Name already exists");
            }
            Array a = new Array((Object[])c.getPropertiesArray());
            a = a.sort((Comparator)new PropCompare());
            Property[] props = (Property[])a.trim();
            if (a.size() > 0) {
                c.reorder(props);
            }
            BHxObjectClassListFE.setObjectClassListComponent(c, op);
            SaveCommand.setModified((HxOp)op);
            BHxObjectClassListTable.this.reloadTable(op);
        }

        class AddDialog
        extends Dialog {
            public AddDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<table>");
                out.w((Object)"<tr ");
                HxTabUtil.scope((String)"tr", (HtmlWriter)out, (HxOp)op);
                out.w((Object)">");
                out.w((Object)"<td class='smartTable-setup-label'>");
                out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;");
                out.w((Object)"</td>");
                out.w((Object)"<td class='smartTable-setup-label'>");
                out.safe((Object)AddCommand.this.lex.getText("objectClassName"));
                out.w((Object)"</td></tr>");
                out.w((Object)"<td class='smartTable-setup-label'>");
                out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;");
                out.w((Object)"</td>");
                out.w((Object)"<td>");
                out.w((Object)"<input ");
                out.attr("type", "text");
                HxTabUtil.scope((String)"name", (HtmlWriter)out, (HxOp)op);
                out.attr("value", "");
                out.w((Object)"/>");
                out.w((Object)"</td></tr>");
                out.w((Object)"</table>");
            }
        }
    }

    public class DeleteCommand
    extends SmartCommand {
        public DeleteCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            BComponent c = BHxObjectClassListTable.this.getComponent(op);
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            for (int i = 0; i < selectionList.length; ++i) {
                c.remove(SlotPath.escape((String)selectionList[i]));
            }
            BHxObjectClassListFE.setObjectClassListComponent(c, op);
            SaveCommand.setModified((HxOp)op);
            BHxObjectClassListTable.this.reloadTable(op);
        }
    }

    public class EditCommand
    extends SmartCommand {
        private EditDialog dlg;

        public EditCommand(BHxView view) {
            super(view);
            this.dlg = new EditDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String newObjectClassName = op.getFormValue("name");
            BComponent c = BHxObjectClassListTable.this.getComponent(op);
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            String objectClassName = selectionList[0];
            if (newObjectClassName != objectClassName) {
                c.remove(SlotPath.escape((String)objectClassName));
                try {
                    c.add(newObjectClassName, (BValue)BString.make((String)newObjectClassName));
                }
                catch (DuplicateSlotException e) {
                    throw new Exception("Object Class Name already exists");
                }
            } else {
                c.set(SlotPath.escape((String)newObjectClassName), (BValue)BString.make((String)newObjectClassName));
            }
            Array a = new Array((Object[])c.getPropertiesArray());
            a = a.sort((Comparator)new PropCompare());
            Property[] props = (Property[])a.trim();
            if (a.size() > 0) {
                c.reorder(props);
            }
            BHxObjectClassListFE.setObjectClassListComponent(c, op);
            SaveCommand.setModified((HxOp)op);
            BHxObjectClassListTable.this.reloadTable(op);
        }

        class EditDialog
        extends Dialog {
            public EditDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
                BComponent c = BHxObjectClassListTable.this.getComponent(op);
                String name = c.get(SlotPath.escape((String)selectionList[0])).toString();
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<table>");
                out.w((Object)"<tr ");
                HxTabUtil.scope((String)"tr", (HtmlWriter)out, (HxOp)op);
                out.w((Object)">");
                out.w((Object)"<td class='smartTable-setup-label'>");
                out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;");
                out.w((Object)"</td>");
                out.w((Object)"<td class='smartTable-setup-label'>");
                out.safe((Object)EditCommand.this.lex.getText("objectClassName"));
                out.w((Object)"</td></tr>");
                out.w((Object)"<tr ");
                HxTabUtil.scope((String)"tr", (HtmlWriter)out, (HxOp)op);
                out.w((Object)">");
                out.w((Object)"</td>");
                out.w((Object)"<td class='smartTable-setup-label'>");
                out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;");
                out.w((Object)"</td>");
                out.w((Object)"<td>");
                out.w((Object)"<input ");
                out.attr("type", "text");
                HxTabUtil.scope((String)"name", (HtmlWriter)out, (HxOp)op);
                out.attr("value", name);
                out.w((Object)"/>");
                out.w((Object)"</td></tr>");
                out.w((Object)"</table>");
            }
        }
    }
}

