/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.help;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsecHx.help.BHelpDoc;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.baja.file.BIFile;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxHelpDocView
extends BHxView {
    public static final BHxHelpDocView INSTANCE = new BHxHelpDocView();
    public static final Type TYPE = Sys.loadType(BHxHelpDocView.class);

    public Type getType() {
        return TYPE;
    }

    public String getPageTitle(HxOp op) {
        String title = (String)op.getRequest().getSession().getAttribute("helpTitle");
        if (title != null) {
            op.getRequest().getSession().removeAttribute("helpTitle");
            return title;
        }
        return BEnterpriseSecurityService.lex.getText("help");
    }

    public void write(HxOp op) throws Exception {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        String module = service.getBrandingManager().getHelpModule().toString();
        op.addStyleSheet(module + "/document.css");
        op.addStyleSheet(module + "/vsaHelp.css");
        op.addStyleSheet(module + "/dmc.css");
        op.addStyleSheet(module + "/styler.css");
        String fileName = ((BHelpDoc)op.get()).getFileName();
        try {
            this.writeHelpFile(module, fileName, op.getHtmlWriter(), op);
        }
        catch (UnresolvedException e) {
            BEnterpriseSecurityService.LOG.warning("Can't resolve help file " + fileName);
            this.writeHelpFile(module, "TOC.html", op.getHtmlWriter(), op);
        }
    }

    private void writeHelpFile(String module, String fileName, HtmlWriter out, HxOp op) throws Exception {
        String ordstr = module + "/" + fileName;
        BIFile file = (BIFile)BOrd.make((String)ordstr).get();
        BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream()));
        out.w((Object)"<span class='help'>").nl();
        boolean inBody = false;
        String line = in.readLine();
        while (line != null) {
            if (inBody) {
                if (line.trim().equals("</body>")) break;
                line = TextUtil.replace((String)line, (String)" src=\"images/", (String)(" src=\"" + module + "/images/"));
                line = TextUtil.replace((String)line, (String)" src=\"graphics/", (String)(" src=\"" + module + "/graphics/"));
                line = TextUtil.replace((String)line, (String)" href=\"", (String)" href=\"accessHelp:/");
                out.w((Object)line).nl();
            } else if (line.trim().startsWith("<body")) {
                inBody = true;
            }
            if (line.trim().startsWith("<title>")) {
                int start = line.trim().indexOf("<title>") + 7;
                int end = line.trim().indexOf("</title>");
                String title = line.trim().substring(start, end);
                op.getRequest().getSession().setAttribute("helpTitle", (Object)title);
            }
            line = in.readLine();
        }
        out.w((Object)"</span>").nl();
        in.close();
    }
}

