/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.factory.network;

import com.tridium.hx.fieldeditors.BHxDefaultFE;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsecHx.factory.SmartCommandArray;
import com.tridiumx.entsecHx.factory.network.BHxDeviceDiscoveryView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BHxDeviceManagerView
extends BHxAbstractManagerView {
    public static final BHxDeviceManagerView INSTANCE = new BHxDeviceManagerView();
    public static final Type TYPE = Sys.loadType(BHxDeviceManagerView.class);
    private SmartCommand[] networkCommands;
    private SmartCommand[] learnCommands;
    private boolean supportsDiscovery;
    private Type deviceType;
    private Type deviceLearnType;
    private Type restrictedDeviceType;
    private String uniqueProperty;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        if (this.deviceType != null) {
            return this.deviceType.getTypeSpec();
        }
        if (op != null) {
            BDeviceNetwork network = (BDeviceNetwork)op.get();
            return network.getDeviceType().getTypeSpec();
        }
        return BDevice.TYPE.getTypeSpec();
    }

    @Override
    public String getPageTitle(HxOp op) {
        BDeviceNetwork network = (BDeviceNetwork)op.get();
        return SlotPath.unescape((String)network.getDisplayName((Context)op));
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        if (this.networkCommands != null) {
            SmartCommandArray commands = SmartCommandArray.make(super.getButtonCommands(op));
            commands.appendBack(this.networkCommands);
            for (int i = 0; i < this.networkCommands.length; ++i) {
                this.registerEvent((Event)this.networkCommands[i]);
            }
            return commands.getCommands();
        }
        return super.getButtonCommands(op);
    }

    @Override
    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        if (this.supportsDiscovery) {
            BHxDeviceDiscoveryView discoveryView = BHxDeviceDiscoveryView.INSTANCE;
            discoveryView.setDeviceType(this.deviceType != null ? this.deviceType : this.getDeviceTypeSpec(op).getResolvedType());
            discoveryView.setDeviceLearnType(this.deviceLearnType);
            discoveryView.setDeviceNetworkType(op.get().getType());
            discoveryView.setUniqueProperty(this.uniqueProperty);
            discoveryView.setLearnCommands(this.learnCommands);
            return discoveryView;
        }
        return null;
    }

    @Override
    public boolean needsRediscovering(HxOp op) {
        return this.supportsDiscovery;
    }

    @Override
    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        return this.deviceLearnType.getTypeSpec();
    }

    @Override
    public Tab getLearnTab(HxOp op) {
        if (!this.supportsDiscovery) {
            return new Tab((BHxView)BHxDefaultFE.INSTANCE, op.make("null", (BObject)BString.DEFAULT, null));
        }
        return super.getLearnTab(op);
    }

    @Override
    public BJob submitDiscoveryJob(HxOp op) {
        BDeviceNetwork network = (BDeviceNetwork)op.get();
        Action[] actions = network.getActionsArray();
        Action discoveryAction = null;
        for (int i = 0; i < actions.length; ++i) {
            Action action = actions[i];
            String actionName = action.getName().toLowerCase();
            if (actionName.indexOf("discover") < 0) continue;
            discoveryAction = action;
            break;
        }
        if (discoveryAction != null) {
            BOrd ord = (BOrd)network.invoke(discoveryAction, null);
            return (BJob)ord.get((BObject)network);
        }
        return null;
    }

    public void setSupportsDiscovery(boolean supportsDiscovery) {
        this.supportsDiscovery = supportsDiscovery;
    }

    public void setDeviceType(Type deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceLearnType(Type deviceLearnType) {
        this.deviceLearnType = deviceLearnType;
    }

    public void setRestrictedDeviceType(Type restrictedDevicedType) {
        this.restrictedDeviceType = restrictedDevicedType;
    }

    public void setNetworkCommands(SmartCommand[] networkCommands) {
        this.networkCommands = networkCommands;
    }

    public void setLearnCommands(SmartCommand[] learnCommands) {
        this.learnCommands = learnCommands;
    }

    public void setUniqueProperty(String uniqueProperty) {
        this.uniqueProperty = uniqueProperty;
    }
}

