/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.factory.handlers;

import com.tridium.smartTableHx.DialogWizardCommand;
import com.tridiumx.entsecHx.factory.device.BHxGenericManagerView;
import com.tridiumx.entsecHx.factory.handlers.CommandHandler;
import com.tridiumx.entsecHx.factory.handlers.ContentHandler;
import javax.baja.gx.BImage;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;

public class StepHandler {
    private DialogWizardCommand dlgWizardCommand;
    private String stepName = "Step Name";
    private String stepTitle = "Step Title";
    private String stepDisplayName = "Step Display Name";
    private BIcon stepIcon = BIcon.std((String)"gears.png");
    private String stepComment = "Step Comment";
    private boolean stepMultiSelect = false;
    private ContentHandler contentHandler;
    private CommandHandler commandHandler;
    private Array nextStepHandlerArray;

    private StepHandler(DialogWizardCommand dlgWizardCommand) {
        this.dlgWizardCommand = dlgWizardCommand;
        this.nextStepHandlerArray = new Array(StepHandler.class);
    }

    public StepHandler(BHxGenericManagerView view) {
        this(view.getManageCommand());
    }

    public StepHandler stepName(String stepName) {
        this.stepName = stepName;
        return this;
    }

    public StepHandler stepTitle(String stepTitle) {
        this.stepTitle = stepTitle;
        return this;
    }

    public StepHandler stepDisplayName(String stepDisplayName) {
        this.stepDisplayName = stepDisplayName;
        return this;
    }

    public StepHandler stepIcon(BIcon stepIcon) {
        this.stepIcon = stepIcon;
        return this;
    }

    public StepHandler stepComment(String stepComment) {
        this.stepComment = stepComment;
        return this;
    }

    public StepHandler multiSelection(boolean multiSelect) {
        this.stepMultiSelect = multiSelect;
        return this;
    }

    public StepHandler registerCommandHandler(CommandHandler commandHandler) {
        this.commandHandler = commandHandler;
        return this;
    }

    public StepHandler registerContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        return this;
    }

    public StepHandler addNextStep(StepHandler nextStepHandler) {
        this.nextStepHandlerArray.add((Object)nextStepHandler);
        return this;
    }

    private DialogWizardCommand.Step[] getNextSteps() {
        Array nextSteps = new Array(DialogWizardCommand.Step.class);
        StepHandler[] nextStepHandlers = (StepHandler[])this.nextStepHandlerArray.trim();
        for (int i = 0; i < nextStepHandlers.length; ++i) {
            nextSteps.add(i, (Object)nextStepHandlers[i].makeStep());
        }
        return (DialogWizardCommand.Step[])nextSteps.trim();
    }

    public DialogWizardCommand.Step makeStep() {
        return new ConcreteStep(this.dlgWizardCommand, this.stepName, (Command)(this.commandHandler != null ? this.commandHandler.makeCommand() : this.dlgWizardCommand));
    }

    private class ConcreteStep
    extends DialogWizardCommand.Step {
        public ConcreteStep(DialogWizardCommand dialogWizardCommand, String name, Command handler) {
            DialogWizardCommand dialogWizardCommand2 = dialogWizardCommand;
            dialogWizardCommand2.getClass();
            super(dialogWizardCommand2, name, handler);
        }

        protected String getTitle(HxOp op) {
            return StepHandler.this.stepTitle;
        }

        public String getDisplayName(HxOp op) {
            return StepHandler.this.stepDisplayName;
        }

        public BImage getIcon(HxOp op) {
            return BImage.make((BIcon)StepHandler.this.stepIcon);
        }

        public String handle(HxOp op) throws Exception {
            String nextStepName = op.getFormValue("nextStep");
            DialogWizardCommand.Step[] nextSteps = StepHandler.this.getNextSteps();
            if (nextSteps.length > 0) {
                for (int i = 0; i < nextSteps.length; ++i) {
                    if (!nextSteps[i].getName(op).equals(nextStepName)) continue;
                    return nextSteps[i].getName(op);
                }
                return StepHandler.this.getNextSteps()[0].getName(op);
            }
            return super.handle(op);
        }

        protected void writeContent(HxOp op) throws Exception {
            Object[] nextSteps = StepHandler.this.getNextSteps();
            if (StepHandler.this.contentHandler != null) {
                StepHandler.this.contentHandler.writeContent(op);
                return;
            }
            if (nextSteps.length > 0) {
                DialogWizardCommand.writeChoices((Object[])nextSteps, (String)StepHandler.this.stepComment, (boolean)StepHandler.this.stepMultiSelect, (String)"nextStep", (HxOp)op);
            }
        }
    }
}

