/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.backup;

import com.tridium.hx.ErrorDialog;
import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.backup.BSystemRestoreJob;
import com.tridiumx.entsecHx.backup.BHxBackupFileTableView;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxFileImportFE;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BHxRestoreFromFile
extends BHxAbstractJobView {
    public static final BHxRestoreFromFile INSTANCE = new BHxRestoreFromFile();
    public static final Type TYPE = Sys.loadType(BHxRestoreFromFile.class);
    static final Lexicon lex = Lexicon.make(BHxRestoreFromFile.class);
    private SmartCommand restoreCommand = new RestoreCommand((BHxView)this);
    private Command cancelRestoreCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxRestoreFromFile() {
        this.registerEvent((Event)this.restoreCommand);
        this.cancelRestoreCommand = new CancelRestoreCommand((BHxView)this);
        this.registerEvent((Event)this.cancelRestoreCommand);
    }

    @Override
    public void write(HxOp op) throws Exception {
        super.write(op);
    }

    @Override
    public boolean needsFileSubmit(HxOp op) {
        return true;
    }

    @Override
    public void checkProgress(HxOp op) throws Exception {
        op.setDynamic();
        if (op.getRequest().getSession().getAttribute("info") != null) {
            if (op.getRequest().getSession().getAttribute("backupJob") == null) {
                op.addOnload(this.restoreCommand.getInvokeCode(op));
            } else {
                log.fine("import info found");
                op.addOnload(this.progressCommand.getInvokeCode(op));
            }
        }
    }

    public String getPageTitle(HxOp op) throws Exception {
        if (BEnterpriseSecurityService.isWorkstation()) {
            return HxTabUtil.getLexicon(BHxRestoreFromFile.class, (Context)op).getText("RestoreBackupHxView.supervisor.title");
        }
        return HxTabUtil.getLexicon(BHxRestoreFromFile.class, (Context)op).getText("RestoreBackupHxView.title");
    }

    @Override
    public String getJobTitle() {
        return HxTabUtil.getLexicon(BHxRestoreFromFile.class, null).getText("RestoreBackupHxView.job.title");
    }

    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        Object backupJob = op.getRequest().getSession().getAttribute("backupJob");
        if (backupJob == null) {
            return null;
        }
        op.getRequest().getSession().setAttribute("backupJob", null);
        BComponent c = this.getSavedComponent(op);
        BJob job = (BJob)backupJob;
        BOrd jobOrd = job.submit((Context)op);
        return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
    }

    @Override
    public Tab getTab(HxOp op) {
        BComponent c = new BComponent();
        String s = SlotPath.escape((String)"File");
        BFacets facets = BHxFileImportFE.makeExtFacet(new String[]{"dist", "zip"});
        if (!BEnterpriseSecurityService.isWorkstation()) {
            facets = BHxFileImportFE.makeExtFacet(new String[]{"dist"});
        }
        facets = BFacets.make((BFacets)facets, (String)"fieldEditor", (BIDataValue)BString.make((String)"entsecHx:HxFileImportFE"));
        c.add(s, (BValue)BOrd.DEFAULT, 0, facets, null);
        return new BHxTabbedView.PropertyTab((BHxTabbedView)this, (BHxView)BHxFieldSheet.INSTANCE, lex.getText("RestoreBackupHxView.tab"), op.make("tab", (BObject)c, null), op);
    }

    @Override
    public FilePath getFilePath(BComponent c, Property p, HxOp op) {
        String filePath = op.getFormValue("tab.File.fileName");
        if (filePath != null && filePath.indexOf(".") > -1) {
            int index = filePath.lastIndexOf(".");
            String suffix = filePath.substring(index);
            return new FilePath("^temp/" + p.getName() + suffix);
        }
        return new FilePath("^temp/" + p.getName());
    }

    public static BIFile getSelectedFile(HxOp op) {
        BComponent c = (BComponent)op.getRequest().getSession().getAttribute("info");
        if (c == null) {
            throw new IllegalStateException("Info Is Null");
        }
        String s = SlotPath.escape((String)"File");
        BOrd bord = (BOrd)c.get(s);
        BIFile file = (BIFile)bord.get();
        return file;
    }

    public class RestoreCommand
    extends SmartCommand {
        protected RestoreCommandDialog dlg;

        public RestoreCommand(BHxView view) {
            super(view);
            this.dlg = new RestoreCommandDialog((Command)this, this.getDisplayName(null));
        }

        public String getName(HxOp op) {
            return "restore";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            try {
                if (!this.dlg.isSubmit(op)) {
                    this.dlg.open(op);
                    return;
                }
                Array stationNames = new Array(String.class);
                BIFile file = BHxRestoreFromFile.getSelectedFile(op);
                BDistribution[] distributions = BHxBackupFileTableView.getDistributions(file, op);
                boolean local = file instanceof BDistributionFile;
                if (!local) {
                    String localStationName;
                    boolean useful = false;
                    for (int i = 0; i < distributions.length; ++i) {
                        String[] split = TextUtil.split((String)distributions[i].getDescription(), (char)'\"');
                        String stationName = split[1];
                        if (op.getFormValue("stationName-" + stationName) == null) continue;
                        useful = true;
                        stationNames.add((Object)stationName);
                    }
                    if (!useful) {
                        new ErrorDialog(this.getDisplayName(op), (Command)this, (Throwable)new Exception("Please Select at least one station to restore."), null).open(op);
                        return;
                    }
                    if (stationNames.size() > 1) {
                        new ErrorDialog(this.getDisplayName(op), (Command)this, (Throwable)new Exception(this.lex.getText("restoreMultipleStation")), null).open(op);
                        return;
                    }
                    if (stationNames.size() == 1 && !(localStationName = Sys.getStation().getStationName()).equals(stationNames.get(0))) {
                        new ErrorDialog(this.getDisplayName(op), (Command)this, (Throwable)new Exception(this.lex.getText("restoreRemoteStationError")), null).open(op);
                        return;
                    }
                }
                BSystemRestoreJob job = new BSystemRestoreJob(file, (String[])stationNames.trim(), false);
                op.getRequest().getSession().setAttribute("backupJob", (Object)job);
                this.refresh(op);
            }
            catch (Exception e) {
                op.getRequest().getSession().removeAttribute("info");
                op.getRequest().getSession().removeAttribute("backupJob");
                throw e;
            }
        }

        protected class RestoreCommandDialog
        extends DynamicDialog {
            RestoreCommandDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BIFile file = BHxRestoreFromFile.getSelectedFile(op);
                BHxBackupFileTableView.writeDistributions(BHxBackupFileTableView.getDistributions(file, op), file instanceof BDistributionFile, op);
            }

            public Command[] getCommands() {
                return new Command[]{new Dialog.Submit((Dialog)this), new RestoreCancel()};
            }

            protected class RestoreCancel
            extends Dialog.Cancel {
                public RestoreCancel() {
                    super((Dialog)RestoreCommandDialog.this);
                }

                public String getInvokeCode(HxOp op) {
                    StringBuffer b = new StringBuffer();
                    b.append("hx.closeDialog(null,null,null);");
                    b.append(BHxRestoreFromFile.this.cancelRestoreCommand.getInvokeCode(op));
                    return b.toString();
                }
            }
        }
    }

    public static class CancelRestoreCommand
    extends Command {
        public CancelRestoreCommand(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) {
            op.getRequest().getSession().setAttribute("info", null);
        }
    }
}

