/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.orionTools.ui.BAppView;
import com.tridiumx.entsecHx.access.orion.BHxBadgeView;
import java.math.BigInteger;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxRangeBadgeView
extends BHxBadgeView {
    public static final BHxRangeBadgeView INSTANCE = new BHxRangeBadgeView();
    public static final Type TYPE = Sys.loadType(BHxRangeBadgeView.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public String getSaveConfirmMessage(HxOp op) throws Exception {
        try {
            long amount = BHxRangeBadgeView.checkRange(op);
            return "You are about to create " + amount + " badges, Continue?";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public BObject getPropertyObject(HxOp op) throws Exception {
        BBadge badge = (BBadge)super.getPropertyObject(op);
        if (badge.getProperty("credentialStart") == null) {
            badge.add("credentialStart", (BValue)BString.make((String)badge.getCredential()));
        }
        if (badge.getProperty("credentialFinish") == null) {
            badge.add("credentialFinish", (BValue)BString.make((String)badge.getCredential()));
        }
        return badge;
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        BHxRangeBadgeView.checkRange(op);
        String idStart = op.getFormValue("prop.credentialStart.value");
        String idFinish = op.getFormValue("prop.credentialFinish.value");
        BBadge badge = (BBadge)op.get();
        badge.setCredential(idStart);
        BObject save = super.save(op);
        BBadge template = (BBadge)save;
        BOrionDatabase db = BHxRangeBadgeView.getOrionDatabase(op);
        OrionSession session = null;
        try {
            session = db.createSession((Context)op);
            BHxRangeBadgeView.duplicate(template, idStart, idFinish, session, op);
            if (session != null) {
                session.close();
            }
        }
        catch (Exception e) {
            if (session != null) {
                session.close();
                session = null;
            }
            throw e;
        }
        return save;
    }

    public static long checkRange(HxOp op) {
        String idStart = op.getFormValue("prop.credentialStart.value");
        String idFinish = op.getFormValue("prop.credentialFinish.value");
        if (idStart.equals("") || idFinish.equals("")) {
            throw new IllegalStateException(BAccessControlService.lex.getText("mustSupplyIdValidRange"));
        }
        BigInteger start = new BigInteger(idStart);
        BigInteger finish = new BigInteger(idFinish);
        if (start.compareTo(finish) != -1) {
            throw new IllegalStateException(BAccessControlService.lex.getText("mustSupplyValidRange"));
        }
        return finish.subtract(start).longValue() + 1L;
    }

    public static void duplicate(BBadge template, String idStart, String idFinish, OrionSession session, HxOp op) throws Exception {
        BRef badgeTemplateRef = null;
        if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
            badgeTemplateRef = (BRef)template.get("template");
        }
        BigInteger start = new BigInteger(idStart);
        start = start.add(BigInteger.ONE);
        BigInteger finish = new BigInteger(idFinish);
        while (start.compareTo(finish) != 1) {
            String startString = start.toString();
            BBadge badge = new BBadge();
            badge.setIssueDate(template.getIssueDate());
            badge.setExpirationDate(template.getExpirationDate());
            badge.setFacilityCode(template.getFacilityCode());
            badge.setCredential(startString);
            badge.setWiegandFormat(template.getWiegandFormat());
            badge.setOwner(template.getOwner());
            badge.setBadgeId(badge.calculateId(session));
            badge.setTenant(template.getTenant());
            badge.setStatus(template.getStatus());
            badge.setBDescription(template.getBDescription());
            if (session.exists((BIOrionObject)badge)) {
                if (idStart.equals(startString)) {
                    throw new IllegalStateException(BAccessControlService.lex.getText("badgeRangeCreateFailFor", new Object[]{idStart, idFinish}));
                }
                String end = start.subtract(BigInteger.ONE).toString();
                throw new IllegalStateException(BAccessControlService.lex.getText("badgeAlreadyExistsRangeWorkedFor", new Object[]{startString, idStart, end, idFinish}));
            }
            session.insert((BIOrionObject)badge);
            if (badgeTemplateRef != null) {
                BHxRangeBadgeView.saveBadgeTemplate(badge, badgeTemplateRef, session);
            }
            start = start.add(BigInteger.ONE);
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"alert('");
        out.safe((Object)BAccessControlService.lex.getText("rangeCreateComplete"));
        out.w((Object)"');");
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BHxTabbedView.PropertyTab propTab = super.getPropertyTab(op);
        BBadge badge = (BBadge)op.get();
        Property[] props = new Property[]{BBadge.credential};
        BAppView.setHidden((BOrionObject)badge, (Property[])props, (boolean)true);
        return propTab;
    }
}

