/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.orion;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.ui.BAppView;
import com.tridiumx.entsecHx.access.orion.BHxBadgeView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppView;
import com.tridiumx.entsecHx.orionToolsHx.HxRemoteUtil;
import javax.baja.data.BIDataValue;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxEnrollBadgeView
extends BHxBadgeView {
    public static final BHxEnrollBadgeView INSTANCE = new BHxEnrollBadgeView();
    public static final Type TYPE = Sys.loadType(BHxEnrollBadgeView.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void write(HxOp op) throws Exception {
        BBadge badge = (BBadge)op.get();
        super.write(op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.enrollmentReader.value"), (HxOp)op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.enrollmentReader.oldValue"), (HxOp)op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.scannedBadge.value"), (HxOp)op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.acceptableFormats.value"), (HxOp)op);
        SmartCommand.hide((String)op.scope("prop.badgeId"), (HxOp)op);
        SmartCommand.forceUpdate((BRelTime)BRelTime.make((long)1500L), (HxOp)op);
    }

    @Override
    public BObject getPropertyObject(HxOp op) throws Exception {
        String owner;
        BBadge badge = (BBadge)super.getPropertyObject(op);
        badge.setCredential("");
        badge.setFacilityCode("");
        if (badge.getProperty("acceptableFormats") == null) {
            badge.add("acceptableFormats", (BValue)BString.make((String)""), 0, BFacets.make((String)"fieldEditor", (String)"entsecHx:HxBadgePickerFE"), null);
        }
        if (badge.getProperty("scannedBadge") == null) {
            badge.add("scannedBadge", (BValue)BString.make((String)""), 1, BFacets.make((String)"fieldEditor", (String)"entsec:SecStringFE"), null);
        }
        if (badge.getProperty("enrollmentReader") == null) {
            badge.add("enrollmentReader", (BValue)BRef.make((BOrionTypeId)BAccReaderRec.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (BIDataValue)BBoolean.TRUE), null);
        }
        if ((owner = op.getViewParameter("owner", null)) != null) {
            owner = SlotPath.unescape((String)owner);
            badge.setOwner((BRef)BRef.DEFAULT.decodeFromString(owner));
        }
        if (HxUtil.isPost((HxOp)op)) {
            String encoded = op.getFormValue("owner.value");
            badge.setOwner((BRef)BRef.DEFAULT.decodeFromString(encoded));
        }
        return badge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(HxOp op) throws Exception {
        super.update(op);
        String quote = HxUtil.getInnerQuote((HxOp)op);
        HtmlWriter out = op.getHtmlWriter();
        String value = op.getFormValue("prop.enrollmentReader.value");
        String oldValue = op.getFormValue("prop.enrollmentReader.oldValue");
        SmartCommand.setFormValue((String)op.scope("prop.enrollmentReader.oldValue"), (Object)value, (HxOp)op);
        boolean eraseLastBadge = !value.equals(oldValue);
        BOrionDatabase db = BHxAppView.getOrionDatabase(op);
        OrionSession session = null;
        try {
            session = db.createSession((Context)op);
            BRef ref = (BRef)BRef.DEFAULT.decodeFromString(value);
            BAccReaderRec rec = (BAccReaderRec)ref.getTarget(session);
            BAccessReader reader = null;
            if (rec == null) {
                return;
            }
            if (rec.getStationName().equals(Sys.getStation().getStationName())) {
                reader = (BAccessReader)rec.getMappedOrd().get();
            } else {
                BFoxSession foxSession = HxRemoteUtil.getEngagedFoxSession(rec.getStationName(), op);
                if (foxSession == null) {
                    out.w((Object)("select.clearSelect(" + quote + op.scope("prop.acceptableFormats.value") + quote + ");"));
                    SmartCommand.exception((String)op.scope("prop.enrollmentReader"), (String)"Session Unavailable", (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.scannedBadge.value"), (Object)"", (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.credential.value"), (Object)"", (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.facilityCode.value"), (Object)"", (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.badgeId.value"), (Object)"", (HxOp)op);
                    return;
                }
                reader = (BAccessReader)RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)rec.getMappedOrd().toString());
                reader.lease();
            }
            if (eraseLastBadge) {
                reader.setLastBadgeRead("");
            }
            String scanned = reader.getLastBadgeRead();
            String oldScanned = op.getFormValue("prop.scannedBadge.value");
            String selectedCard = op.getFormValue("prop.acceptableFormats.value");
            if (!scanned.equals(oldScanned)) {
                out.w((Object)("select.clearSelect(" + quote + op.scope("prop.acceptableFormats.value") + quote + ");"));
                SmartCommand.setFormValue((String)op.scope("prop.scannedBadge.value"), (Object)scanned, (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("prop.credential.value"), (Object)"", (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("prop.facilityCode.value"), (Object)"", (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("prop.badgeId.value"), (Object)scanned, (HxOp)op);
                BBadge badge = new BBadge();
                badge.setBadgeId(scanned);
                badge = (BBadge)session.read((BIOrionObject)badge);
                if (badge != null) {
                    SmartCommand.exception((String)op.scope("prop.scannedBadge"), (String)("Badge Already Exists:  " + badge.toDisplayString((Context)op)), (HxOp)op);
                    return;
                }
                SmartCommand.clearException((String)op.scope("prop.scannedBadge"), (HxOp)op);
                SmartCommand.clearException((String)op.scope("prop.credential"), (HxOp)op);
                if (scanned.length() > 0) {
                    BBadge[] badges = BWiegandFormat.getUnknownBadgeInfo((String)scanned, (OrionSession)session);
                    if (badges.length == 1) {
                        if (!badges[0].getWiegandFormat().isBound()) {
                            return;
                        }
                        SmartCommand.setFormValue((String)op.scope("prop.credential.value"), (Object)badges[0].getCredential(), (HxOp)op);
                        SmartCommand.setFormValue((String)op.scope("prop.facilityCode.value"), (Object)badges[0].getFacilityCode(), (HxOp)op);
                        SmartCommand.setFormValue((String)op.scope("prop.wiegandFormat.value"), (Object)badges[0].getWiegandFormat().encodeToString(), (HxOp)op);
                        SmartCommand.setFormValue((String)op.scope("prop.wiegandFormat.handle"), (Object)badges[0].resolveWiegandFormat(session).getHandle().toString(), (HxOp)op);
                        SmartCommand.setFormValue((String)op.scope("prop.wiegandFormat.preview"), (Object)badges[0].resolveWiegandFormat(session).toDisplayString((Context)op), (HxOp)op);
                    }
                    for (int i = 0; i < badges.length; ++i) {
                        out.w((Object)("select.addToSelect(" + quote + op.scope("prop.acceptableFormats.value") + quote + "," + quote + badges[i].getWiegandFormat().encodeToString() + quote + "," + quote + this.getFormatDescription(badges[i], session) + quote + ");"));
                    }
                }
            } else if (selectedCard != null && selectedCard.length() > 0) {
                BRef wiegandRef = (BRef)BRef.DEFAULT.decodeFromString(selectedCard);
                BWiegandFormat format = (BWiegandFormat)wiegandRef.getTarget(session);
                String cred = format.getCredentialNumber(scanned);
                String fac = format.getFacilityCode(scanned);
                SmartCommand.setFormValue((String)op.scope("prop.credential.value"), (Object)cred, (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("prop.facilityCode.value"), (Object)fac, (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("prop.wiegandFormat.value"), (Object)wiegandRef.encodeToString(), (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("prop.wiegandFormat.handle"), (Object)format.getHandle().toString(), (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("prop.wiegandFormat.preview"), (Object)format.toDisplayString((Context)op), (HxOp)op);
            }
            SmartCommand.clearException((String)op.scope("prop.enrollmentReader"), (HxOp)op);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
            SmartCommand.forceUpdate((BRelTime)BRelTime.make((long)1500L), (HxOp)op);
        }
    }

    public String getFormatDescription(BBadge badge, OrionSession session) {
        BWiegandFormat format = badge.resolveWiegandFormat(session);
        return badge.toString() + " " + format.getWiegandFormatName();
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BHxTabbedView.PropertyTab propTab = super.getPropertyTab(op);
        BBadge badge = (BBadge)op.get();
        Property[] props = new Property[]{BBadge.credential, BBadge.facilityCode, BBadge.wiegandFormat};
        BAppView.setReadonly((BOrionObject)badge, (Property[])props);
        props = new Property[]{BBadge.badgeId};
        BAppView.setHidden((BOrionObject)badge, (Property[])props, (boolean)false);
        return propTab;
    }
}

