/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionType;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.PermissionsUtil;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccFloorRec;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsecHx.access.orion.BHxAccessRightJoinFE;
import com.tridiumx.entsecHx.access.orion.BHxFloorJoinFE;
import com.tridiumx.entsecHx.access.orion.BHxReaderJoinFE;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppView;
import com.tridiumx.entsecHx.orionToolsHx.DuplicateCommand;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseManager;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxAccessRightView
extends BHxAppView {
    public static final BHxAccessRightView INSTANCE = new BHxAccessRightView();
    public static final Type TYPE = Sys.loadType(BHxAccessRightView.class);
    SmartCommand duplicateCommand = new AccessRightDuplicateCommand((BHxView)this);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxAccessRightView() {
        this.registerEvent((Event)this.duplicateCommand);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        a.add((Object)this.duplicateCommand);
        return (SmartCommand[])a.trim();
    }

    public BObject getPropertyObject(HxOp op) throws Exception {
        Property[] copyProps = new Property[]{BAccessRight.schedule, BAccessRight.niagaraIntegrationID, BAccessRight.tenant, BAccessRight.threatLevelGroup, BAccessRight.defaultAssignedThreatLevel};
        return DuplicateCommand.getDuplicatePropertyObject(copyProps, op);
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BHxTabbedView.PropertyTab tab = super.getPropertyTab(op);
        if (PermissionsUtil.canAdminReadOrionType((OrionType)BThreatLevelGroupRec.ORION_TYPE, (BOrionDatabase)BHxAccessRightView.getOrionDatabase(op), (Context)op) && BEnterpriseSecurityService.isThreatAvailable()) {
            tab.op = tab.op.mergeFacets(BHxFieldSheet.getFieldsProvidedFacets((String[])new String[]{BAccessRight.accessRightName.getName(), BAccessRight.schedule.getName(), BAccessRight.niagaraIntegrationID.getName(), BAccessRight.tenant.getName(), BAccessRight.threatLevelGroup.getName(), BAccessRight.threatLevelOperation.getName(), BAccessRight.defaultAssignedThreatLevel.getName(), BAccessRight.acDescription.getName()}));
            if (!HxUtil.isPost((HxOp)op)) {
                HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.SHOW_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)tab.op.scope(BAccessRight.threatLevelGroup.getName() + ".handle"), (String)tab.op.scope(BAccessRight.threatLevelOperation.getName()), (String)"", (HxOp)op);
                HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.SHOW_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)tab.op.scope(BAccessRight.threatLevelGroup.getName() + ".handle"), (String)tab.op.scope(BAccessRight.defaultAssignedThreatLevel.getName()), (String)"", (HxOp)op);
            }
        } else {
            tab.op = tab.op.mergeFacets(BHxFieldSheet.getFieldsProvidedFacets((String[])new String[]{BAccessRight.accessRightName.getName(), BAccessRight.schedule.getName(), BAccessRight.niagaraIntegrationID.getName(), BAccessRight.tenant.getName(), BAccessRight.acDescription.getName()}));
        }
        return tab;
    }

    @Override
    public Tab[] getFieldEditors(HxOp op) {
        BIOrionObject o = (BIOrionObject)op.get();
        BOrionDatabase db = o.getOrionDatabase();
        Array tabs = new Array(Tab.class);
        BHxAccessRightJoinFE personFE = BHxAccessRightJoinFE.INSTANCE;
        OrdTarget target = new OrdTarget((OrdTarget)op, (BObject)BPerson.ORION_TYPE.getOrionTypeId());
        HxOp personOp = op.make("person", target);
        personOp.mergeFacets(BHxSmartTableView.finishLater);
        SmartCommand.matchReadonly((HxOp)personOp, (HxOp)op);
        Tab personTab = new Tab((BHxView)personFE, HxTabUtil.getPluralDisplayName((Type)BPerson.ORION_TYPE, (Context)op), personOp);
        if (PermissionsUtil.canReadOrionType((OrionType)BPerson.ORION_TYPE, (BOrionDatabase)db, (Context)op)) {
            tabs.add((Object)personTab);
        }
        BHxReaderJoinFE readerFE = BHxReaderJoinFE.INSTANCE;
        target = new OrdTarget((OrdTarget)op, (BObject)BAccReaderRec.ORION_TYPE.getOrionTypeId());
        HxOp readerOp = op.make("readers", target);
        SmartCommand.matchReadonly((HxOp)readerOp, (HxOp)op);
        Tab readerTab = new Tab((BHxView)readerFE, HxTabUtil.getPluralDisplayName((Type)BAccReaderRec.ORION_TYPE, (Context)op), readerOp);
        if (PermissionsUtil.canReadOrionType((OrionType)BAccReaderRec.ORION_TYPE, (BOrionDatabase)db, (Context)op)) {
            tabs.add((Object)readerTab);
        }
        if (this.licenseChecksValid()) {
            BHxFloorJoinFE floorFE = BHxFloorJoinFE.INSTANCE;
            target = new OrdTarget((OrdTarget)op, (BObject)BAccFloorRec.ORION_TYPE.getOrionTypeId());
            HxOp floorOp = op.make("floors", target);
            SmartCommand.matchReadonly((HxOp)floorOp, (HxOp)op);
            Tab floorTab = new Tab((BHxView)floorFE, HxTabUtil.getPluralDisplayName((Type)BAccFloorRec.ORION_TYPE, (Context)op), floorOp);
            if (PermissionsUtil.canReadOrionType((OrionType)BAccFloorRec.ORION_TYPE, (BOrionDatabase)db, (Context)op)) {
                tabs.add((Object)floorTab);
            }
        }
        return (Tab[])tabs.trim();
    }

    private boolean licenseChecksValid() {
        try {
            LicenseManager manager = Sys.getLicenseManager();
            manager.checkFeature("tridium", "accessControl");
            String elevatorLimitAttribute = manager.getFeature("tridium", "accessControl").get("elevator.limit");
            return elevatorLimitAttribute != null;
        }
        catch (FeatureNotLicensedException ex) {
            return false;
        }
    }

    public static class AccessRightDuplicateCommand
    extends DuplicateCommand {
        public AccessRightDuplicateCommand(BHxView view) {
            super(view);
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public BOrionObject getDuplicateRecord(HxOp op) {
            return (BOrionObject)op.get();
        }

        @Override
        public String getTableOrd(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            return "station:|" + service.getAccessRights().getSlotPath();
        }
    }
}

