/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.managers;

import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.ToggleCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.BTimedOverride;
import com.tridiumx.accessDriver.enums.BOverrideEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

public class ManualOverride
extends ToggleCommand {
    private ManualOverrideDialog dialog = new ManualOverrideDialog(this.getDisplayName(null), (Command)this);
    private boolean easyPassOption = false;

    public ManualOverride(BHxView view) {
        this(view, false);
    }

    public ManualOverride(BHxView view, boolean easyPassOption) {
        super(view);
        this.easyPassOption = easyPassOption;
    }

    public String getName(HxOp op) {
        return "manualOverride";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public boolean isSelected(HxOp op) {
        BAccessDoor door = (BAccessDoor)op.get();
        return door.getStrike() != null && (door.getStrike().getOut().getStatus().isOverridden() || door.getStrike().getIn14().getStatus().isOverridden());
    }

    public boolean handle(boolean selected, HxOp op) throws Exception {
        if (!this.dialog.isSubmit(op)) {
            this.dialog.open(op);
            return selected;
        }
        BAccessDoor door = (BAccessDoor)op.get();
        String cancel = op.getFormValue("isCancel");
        if (cancel.equals("true")) {
            if (door.getStrike() != null && door.getStrike().getIn14().getStatus().isOverridden()) {
                door.getStrike().invoke(BAccessStrike.clearScheduleLockOut, null, (Context)op);
            } else {
                BTimedOverride timedOverride = new BTimedOverride();
                timedOverride.setOverrideType(BOverrideEnum.pickTime);
                timedOverride.setDoorOpenTime(BTimedOverride.cancelTime);
                door.invoke(BAccessDoor.manualOverride, (BValue)timedOverride, (Context)op);
            }
            SmartCommand.forceUpdate((BRelTime)BRelTime.make((long)100L), (HxOp)op);
            return false;
        }
        BTimedOverride timedOverride = (BTimedOverride)this.getTab(op).save();
        door.invoke(BAccessDoor.manualOverride, (BValue)timedOverride, (Context)op);
        if (this.easyPassOption) {
            if (op.getFormValue("easyPass") != null) {
                op.addCookie("easyPass." + door.getHandle(), timedOverride.getDoorOpenTime().encodeToString() + "," + timedOverride.getOverrideType().encodeToString());
            } else {
                op.removeCookie("easyPass." + door.getHandle());
            }
        }
        SmartCommand.forceUpdate((BRelTime)BRelTime.make((long)100L), (HxOp)op);
        return true;
    }

    private Tab getTab(HxOp op) {
        BTimedOverride timedOverride = new BTimedOverride();
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, op.make("override", (BObject)timedOverride, null));
    }

    class ManualOverrideDialog
    extends Dialog {
        public ManualOverrideDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            BAccessDoor door = (BAccessDoor)op.get();
            HtmlWriter out = op.getHtmlWriter();
            if (door.getStrike().getOut().getStatus().isOverridden() || door.getStrike().getIn14().getStatus().isOverridden()) {
                out.w((Object)"<table>");
                out.w((Object)"<tr>");
                out.w((Object)"<td><span class='setup-label'>");
                out.safe((Object)BAccessControlService.lex.getText("cancelManualOverride"));
                out.w((Object)"</span></td></tr></table>");
                BHxSmartTableView.writeUnscopedFormValue((String)"isCancel", (String)"true", (HxOp)op);
                return;
            }
            BHxSmartTableView.writeUnscopedFormValue((String)"isCancel", (String)"false", (HxOp)op);
            Tab tab = ManualOverride.this.getTab(op);
            tab.write();
            HxTabUtil.addEvent((String)"change", (String)HxTabUtil.HIDE_LESS_THAN_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)tab.op.scope(BTimedOverride.overrideType.getName() + ".value"), (String)tab.op.scope(BTimedOverride.doorOpenTime.getName()), (String)String.valueOf(3), (HxOp)op);
        }
    }
}

