/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.managers;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.accessDriver.BAccessElevator;
import com.tridiumx.accessDriver.BAccessFloor;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.entsecHx.access.fieldeditors.BHxFloorFE;
import com.tridiumx.entsecHx.filter.BHxSmartOrdFE;
import com.tridiumx.entsecHx.filter.BHxSmartOrdListFE;
import com.tridiumx.entsecHx.securityUtilHx.UpLevelCommand;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxSmartScheduleLinkFE;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDeviceGrouping;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import com.tridiumx.entsecHx.securityUtilHx.manager.ManageDevicesCommand;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxElevatorView
extends BHxManageDevicesView {
    public static final BHxElevatorView INSTANCE = new BHxElevatorView();
    public static final Type TYPE = Sys.loadType(BHxElevatorView.class);
    SmartCommand elevatorsCommand = new UpLevelElevatorCommand((BHxView)this);
    SmartCommand elevatorManageDevicesCommand;
    SmartCommand scheduleFloorsCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxElevatorView() {
        this.registerEvent((Event)this.elevatorsCommand);
        this.elevatorManageDevicesCommand = new ElevatorManageDevicesCommand((BHxView)this);
        this.registerEvent((Event)this.elevatorManageDevicesCommand);
        this.scheduleFloorsCommand = new ScheduleFloorsCommand((BHxView)this);
        this.registerEvent((Event)this.scheduleFloorsCommand);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        for (int i = 0; i < a.size(); ++i) {
            if (!(a.get(i) instanceof ManageDevicesCommand)) continue;
            a.set(i, (Object)this.elevatorManageDevicesCommand);
        }
        a.add((Object)this.elevatorsCommand);
        a.add((Object)this.scheduleFloorsCommand);
        return (SmartCommand[])a.trim();
    }

    public void write(HxOp op) throws Exception {
        op.setDynamic();
        super.write(op);
    }

    public boolean process(HxOp op) throws Exception {
        op.setDynamic();
        return super.process(op);
    }

    public class ScheduleFloorsCommand
    extends SmartCommand {
        private ScheduleFloorsCommandDialog dlg;

        public ScheduleFloorsCommand(BHxView view) {
            super(view);
            this.dlg = new ScheduleFloorsCommandDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "scheduleFloorsCommand";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BComponent c = this.getTab(op).save().asComponent();
            String scheduleName = SlotPath.escape((String)this.lex.getText("schedule.label"));
            String floorName = SlotPath.escape((String)HxTabUtil.getPluralDisplayName((Type)BAccessFloor.TYPE, (Context)op));
            BOrd scheduleOrd = (BOrd)c.get(scheduleName);
            BValue target = null;
            if (scheduleOrd != BOrd.NULL) {
                target = (BValue)BOrd.make((String)("station:|" + scheduleOrd)).get();
            }
            Array floorOrds = new Array((Object[])((BOrdList)c.get(floorName)).toArray());
            Tab[] tabs = BHxElevatorView.this.getTabs(op);
            Tab floorGroupTab = tabs[tabs.length - 1];
            if (!(floorGroupTab.view instanceof BHxManageDeviceGrouping)) {
                new ErrorDialog("Schedule Floors Error", (Command)this, (Throwable)new Exception("No Floors to Schedule")).open(op);
                return;
            }
            BHxManageDeviceGrouping grouping = (BHxManageDeviceGrouping)floorGroupTab.view;
            Tab[] floorTabs = grouping.getTabs(floorGroupTab.op);
            for (int i = 0; i < floorTabs.length; ++i) {
                BAccessFloor floor = (BAccessFloor)floorTabs[i].op.get();
                if (!floorOrds.contains((Object)floor.getSlotPathOrd())) continue;
                BHxFieldSheet fieldSheet = (BHxFieldSheet)floorTabs[i].view;
                Tab floorTab = fieldSheet.getTabs(floorTabs[i].op)[0];
                BHxFloorFE floorFE = (BHxFloorFE)floorTab.view;
                Tab scheduleLinkTab = floorFE.getScheduleLinkTab(floorTab.op);
                BHxSmartScheduleLinkFE scheduleLinkFE = (BHxSmartScheduleLinkFE)scheduleLinkTab.view;
                scheduleLinkFE.update(target, scheduleLinkTab.op);
            }
        }

        public boolean process(HxOp op) throws Exception {
            return this.getTab(op).process();
        }

        public Tab getTab(HxOp op) {
            BComponent c = new BComponent();
            BFacets facets = BFacets.make((String)"targetType", (String)BBooleanSchedule.TYPE.toString());
            facets = BFacets.make((BFacets)facets, (String)"fieldEditor", (BIDataValue)BString.make((String)BHxSmartOrdFE.TYPE.toString()));
            String name = SlotPath.escape((String)this.lex.getText("schedule.label"));
            c.add(name, (BValue)BOrd.DEFAULT, 0, facets, null);
            facets = BFacets.make((String)"targetType", (String)BAccessFloor.TYPE.toString());
            facets = BFacets.make((BFacets)facets, (String)"fieldEditor", (BIDataValue)BString.make((String)BHxSmartOrdListFE.TYPE.toString()));
            facets = BFacets.make((BFacets)facets, (String)"base", (BIDataValue)BString.make((String)op.get().asComponent().getSlotPathOrd().toString()));
            name = SlotPath.escape((String)HxTabUtil.getPluralDisplayName((Type)BAccessFloor.TYPE, (Context)op));
            c.add(name, (BValue)BOrdList.DEFAULT, 0, facets, null);
            return new Tab((BHxView)BHxFieldSheet.INSTANCE, op.make("tab", (BObject)c, null), op);
        }

        class ScheduleFloorsCommandDialog
        extends Dialog {
            public ScheduleFloorsCommandDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                ScheduleFloorsCommand.this.getTab(op).write();
            }
        }
    }

    public class ElevatorManageDevicesCommand
    extends ManageDevicesCommand {
        public ElevatorManageDevicesCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getPasteWarningFromCut(BComplex complex, HxOp op) {
            BAccessReader reader;
            if (complex instanceof BAccessReader && (reader = (BAccessReader)complex).isIntrusionReader()) {
                return this.lex.getText("confirmIntrusionToValidation", new Object[]{complex.asComponent().toDisplayPathString((Context)op)});
            }
            return null;
        }
    }

    public class UpLevelElevatorCommand
    extends UpLevelCommand {
        public UpLevelElevatorCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getDisplayName(HxOp op) {
            return HxTabUtil.getPluralDisplayName((Type)BAccessElevator.TYPE, (Context)op);
        }

        @Override
        public BOrd getOrd(HxOp op) {
            BOrd parentOrd = super.getOrd(op);
            return BOrd.make((String)(parentOrd + "|view:?" + "defaultTab" + "=" + SlotPath.escape((String)this.getDisplayName(op))));
        }
    }
}

