/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.managers;

import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.accessDriver.BAccessAda;
import com.tridiumx.accessDriver.BAccessBacnetOutput;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BAccessRex;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.BOverrideInput;
import com.tridiumx.accessDriver.BTimedOverride;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsecHx.access.managers.ManualOverride;
import com.tridiumx.entsecHx.securityUtilHx.UpLevelCommand;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import com.tridiumx.entsecHx.securityUtilHx.manager.ManageDevicesCommand;
import java.util.ListIterator;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.license.LicenseManager;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BHxDoorView
extends BHxManageDevicesView {
    public static final BHxDoorView INSTANCE = new BHxDoorView();
    public static final Type TYPE = Sys.loadType(BHxDoorView.class);
    SmartCommand manualOverride = new ManualOverride((BHxView)this);
    SmartCommand doorsCommand;
    SmartCommand doorManageDevices;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxDoorView() {
        this.registerEvent((Event)this.manualOverride);
        this.doorsCommand = new UpLevelDoorCommand((BHxView)this);
        this.registerEvent((Event)this.doorsCommand);
        this.doorManageDevices = new DoorManageDevicesCommand((BHxView)this);
        this.registerEvent((Event)this.doorManageDevices);
    }

    public void write(HxOp op) throws Exception {
        String scope;
        op.setDynamic();
        super.write(op);
        BAccessDoor door = (BAccessDoor)this.getContainer((OrdTarget)op);
        BOverrideInput[] inputs = (BOverrideInput[])door.getChildren(BOverrideInput.class);
        for (int i = 0; i < inputs.length; ++i) {
            scope = op.scope(inputs[i].getName() + ".timedOverride.");
            HxTabUtil.addEvent((String)"change", (String)HxTabUtil.HIDE_LESS_THAN_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)(scope + BTimedOverride.overrideType.getName() + ".value"), (String)(scope + BTimedOverride.doorOpenTime.getName()), (String)String.valueOf(3), (HxOp)op);
        }
        if (door.getStrike() != null) {
            BAccessStrike strike = door.getStrike();
            scope = op.scope(strike.getName() + ".");
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)(scope + BAccessStrike.scheduleOperation.getName() + ".value"), (String)(scope + BAccessStrike.followStrike.getName()), (String)String.valueOf(3), (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.SHOW_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)(scope + BAccessStrike.threatLevelGroup.getName() + ".value"), (String)(scope + BAccessStrike.scheduleLockdownThreatLevel.getName()), (String)"", (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.SHOW_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)(scope + BAccessStrike.threatLevelGroup.getName() + ".value"), (String)(scope + BAccessStrike.unlockThreatLevel.getName()), (String)"", (HxOp)op);
        }
        BAccessRex[] rexes = (BAccessRex[])door.getChildren(BAccessRex.class);
        for (int i = 0; i < rexes.length; ++i) {
            if (rexes[i].getType() != BAccessRex.TYPE) continue;
            String scope2 = op.scope(rexes[i].getName() + ".");
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)(scope2 + BAccessRex.unlockOnExitRequest.getName() + ".value"), (String)(scope2 + BAccessRex.exitRequestTimeout.getName()), (String)"true", (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)(scope2 + BAccessRex.unlockOnExitRequest.getName() + ".value"), (String)(scope2 + BAccessRex.exitRequestTimeoutRelock.getName()), (String)"true", (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)(scope2 + BAccessRex.unlockOnExitRequest.getName() + ".value"), (String)(scope2 + BAccessRex.exitRequestTimeoutAlarmExt.getName() + "." + BAlarmSourceExt.alarmClass.getName()), (String)"true", (HxOp)op);
        }
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        Object[] tabs = super.getTabs(op);
        Array tabsToRemove = new Array(Tab.class);
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i].op.get() instanceof BAccessStrike) {
                if (BEnterpriseSecurityService.isThreatAvailable((Context)op)) continue;
                ((Tab)tabs[i]).op.mergeFacets(BHxFieldSheet.getTypesExcludedFacets((String[])new String[]{BInteger.TYPE.toString()}));
                continue;
            }
            if (!(((Tab)tabs[i]).op.get() instanceof BAccessAda) || this.adaLicensed()) continue;
            tabsToRemove.add(tabs[i]);
        }
        ListIterator iterator = tabsToRemove.iterator();
        Array tabArray = new Array(tabs);
        while (iterator.hasNext()) {
            tabArray.remove(iterator.next());
        }
        return (Tab[])tabArray.trim();
    }

    private boolean adaLicensed() {
        try {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            if (service.getUnlicensedVisibility()) {
                return true;
            }
            LicenseManager manager = Sys.getLicenseManager();
            manager.checkFeature("tridium", "accessControl");
            String adaFeature = manager.getFeature("tridium", "accessControl").get("ada");
            if (adaFeature == null) {
                return false;
            }
            return adaFeature.equals("true");
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String[] getDevices(HxOp op) {
        Array a = new Array((Object[])super.getDevices(op));
        BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        if (network.getBacnetDoorControl()) {
            a.add((Object)BAccessBacnetOutput.TYPE.toString());
        }
        return (String[])a.trim();
    }

    public boolean process(HxOp op) throws Exception {
        op.setDynamic();
        return super.process(op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        BAccessDoor door = (BAccessDoor)op.get();
        a.add((Object)this.doorsCommand);
        if (door.getStrike() != null) {
            a.add((Object)this.manualOverride);
        }
        for (int i = 0; i < a.size(); ++i) {
            if (!(a.get(i) instanceof ManageDevicesCommand)) continue;
            a.set(i, (Object)this.doorManageDevices);
        }
        return (SmartCommand[])a.trim();
    }

    public class DoorManageDevicesCommand
    extends ManageDevicesCommand {
        public DoorManageDevicesCommand(BHxView view) {
            super(view);
        }

        @Override
        public String[] getDevices(BTypeSpec parentTypeSpec, HxOp op) {
            return BHxDoorView.this.getDevices(op);
        }

        @Override
        public String getPasteWarningFromCut(BComplex complex, HxOp op) {
            BAccessReader reader;
            if (complex instanceof BAccessReader && (reader = (BAccessReader)complex).isIntrusionReader()) {
                return this.lex.getText("confirmIntrusionToValidation", new Object[]{complex.asComponent().toDisplayPathString((Context)op)});
            }
            return null;
        }
    }

    public class UpLevelDoorCommand
    extends UpLevelCommand {
        public UpLevelDoorCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getDisplayName(HxOp op) {
            return HxTabUtil.getPluralDisplayName((Type)BAccessDoor.TYPE, (Context)op);
        }

        @Override
        public BOrd getOrd(HxOp op) {
            BOrd parentOrd = super.getOrd(op);
            return BOrd.make((String)(parentOrd + "|view:?" + "defaultTab" + "=" + SlotPath.escape((String)this.getDisplayName(op))));
        }
    }
}

