/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.maintenance;

import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.platPower.BNpmDualBatteryPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.rdb.hsqldb.BHsqlDatabase;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.JobLogDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.sys.station.BStationSaveJob;
import com.tridium.sys.station.Station;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.securityUtil.BDefragAndStationSaveJob;
import com.tridiumx.entsec.securityUtil.BGetCorruptedPinNumbersJob;
import com.tridiumx.entsec.securityUtil.BUpdateCorruptedPinNumbersJob;
import com.tridiumx.entsec.securityUtil.BUpdateReaderCountJob;
import com.tridiumx.entsecHx.BHxAccessProfile;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

public class BHxMaintenanceView
extends BHxAbstractJobView {
    public static final BHxMaintenanceView INSTANCE = new BHxMaintenanceView();
    public static final Type TYPE = Sys.loadType(BHxMaintenanceView.class);
    public RestartStation restartStation;
    public SaveStation saveStation = new SaveStation((BHxView)this);
    private DefragAndSaveStation defragAndSaveStation;
    public UpdateReaderCount updateReaderCount;
    public GetCorruptPinNumbers updatePinNumbers;
    public UpdatePinNumbers updPinNumbers;
    static final Lexicon lex = Lexicon.make(BHxMaintenanceView.class);
    public static final BString UNLICENSED = BString.make((String)lex.getText("unlicensed"));
    public static final BString LICENSED = BString.make((String)lex.getText("licensed"));
    public static final BString UNLIMITED = BString.make((String)lex.getText("unlimited"));

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxMaintenanceView() {
        this.registerEvent((Event)this.saveStation);
        this.defragAndSaveStation = new DefragAndSaveStation((BHxView)this);
        this.registerEvent((Event)this.defragAndSaveStation);
        this.restartStation = new RestartStation((BHxView)this);
        this.registerEvent((Event)this.restartStation);
        this.updateReaderCount = new UpdateReaderCount((BHxView)this);
        this.registerEvent((Event)this.updateReaderCount);
        this.updatePinNumbers = new GetCorruptPinNumbers((BHxView)this);
        this.registerEvent((Event)this.updatePinNumbers);
        this.updPinNumbers = new UpdatePinNumbers((BHxView)this);
        this.registerEvent((Event)this.updPinNumbers);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array(SmartCommand.class);
        try {
            a.add((Object)this.save);
            a.add((Object)this.saveStation);
            if (this.defragAndSaveStation.isAvailable(op)) {
                a.add((Object)this.defragAndSaveStation);
            }
            if (this.restartStation.isAvailable(op)) {
                a.add((Object)this.restartStation);
            }
            if (BEnterpriseSecurityService.isWorkstation()) {
                a.add((Object)this.updateReaderCount);
            }
            a.add((Object)this.updatePinNumbers);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        return (SmartCommand[])a.trim();
    }

    @Override
    public void jobSuccess(BJob job, Command progressCommand, HxOp op) throws Exception {
        if (job instanceof BUpdateReaderCountJob) {
            BHxMaintenanceView.openSuccessDialog(job, progressCommand, op.mergeFacets(JobLogDialog.forceDetailsFacets));
        } else if (job instanceof BGetCorruptedPinNumbersJob) {
            GetInvalidPinsDialog confirmUpdateDialog = new GetInvalidPinsDialog(progressCommand, job, "Get Corrupt Pin Numbers");
            confirmUpdateDialog.open(op.mergeFacets(GetInvalidPinsDialog.forceDetailsFacets));
        } else if (job instanceof BUpdateCorruptedPinNumbersJob) {
            BHxMaintenanceView.openSuccessDialog(job, progressCommand, op.mergeFacets(JobLogDialog.forceDetailsFacets));
        } else {
            super.jobSuccess(job, progressCommand, op);
        }
    }

    @Override
    public void write(HxOp op) throws Exception {
        super.write(op);
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        if (op.getRequest().getSession().getAttribute("job") != null) {
            return super.save(op);
        }
        BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BComponent saveComponent = (BComponent)this.getTab(op).save();
        String propName = SlotPath.escape((String)BEnterpriseSecurityService.showGuidedTour.getDefaultDisplayName((Context)op));
        entsecService.set(BEnterpriseSecurityService.showGuidedTour, saveComponent.get(propName), (Context)op);
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        propName = SlotPath.escape((String)BAlarmService.coalesceAlarms.getDefaultDisplayName((Context)op));
        alarmService.set(BAlarmService.coalesceAlarms, saveComponent.get(propName), (Context)op);
        if (!Flags.isHidden((BComplex)entsecService, (Slot)BEnterpriseSecurityService.queryOutdatedStations)) {
            propName = SlotPath.escape((String)BEnterpriseSecurityService.queryOutdatedStations.getDefaultDisplayName((Context)op));
            entsecService.set(BEnterpriseSecurityService.queryOutdatedStations, saveComponent.get(propName), (Context)op);
        }
        return op.get();
    }

    public String getPageTitle(HxOp op) throws Exception {
        return HxTabUtil.getLexicon(BHxMaintenanceView.class, (Context)op).getText("jaceMaintenance.title");
    }

    @Override
    public String getJobTitle() {
        return HxTabUtil.getLexicon(BHxMaintenanceView.class).getText("jaceMaintenance.working");
    }

    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        BComponent c = this.getSavedComponent(op);
        String jobString = (String)op.getRequest().getSession().getAttribute("job");
        if (jobString == null) {
            return null;
        }
        op.getRequest().getSession().removeAttribute("job");
        if (jobString.equals("stationSave")) {
            BStationSaveJob job = new BStationSaveJob();
            BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
            BOrd jobOrd = jobService.submit((BJob)job, (Context)op);
            return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
        }
        if (jobString.equals("defragAndSaveStation")) {
            BDefragAndStationSaveJob job = new BDefragAndStationSaveJob();
            BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
            BOrd jobOrd = jobService.submit((BJob)job, (Context)op);
            return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
        }
        if (jobString.equals("updateReaderCount")) {
            BUpdateReaderCountJob job = new BUpdateReaderCountJob();
            BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
            BOrd jobOrd = jobService.submit((BJob)job, (Context)op);
            op.getRequest().getSession().removeAttribute("updateReaderCount");
            return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
        }
        if (jobString.equals("getCorruptPinNumbers")) {
            BGetCorruptedPinNumbersJob getCorruptedPinNumbersJob = new BGetCorruptedPinNumbersJob();
            BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
            BOrd jobOrd = jobService.submit((BJob)getCorruptedPinNumbersJob, (Context)op);
            op.getRequest().getSession().removeAttribute("getCorruptPinNumbers");
            return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
        }
        if (jobString.equals("updCorruptPinNumbers")) {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            BUpdateCorruptedPinNumbersJob updateCorruptedPinNumbersJob = new BUpdateCorruptedPinNumbersJob(service.getInvalidPinMap());
            BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
            BOrd jobOrd = jobService.submit((BJob)updateCorruptedPinNumbersJob, (Context)op);
            op.getRequest().getSession().removeAttribute("updCorruptPinNumbers");
            return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
        }
        throw new IllegalStateException("unknown job");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tab getTab(HxOp op) {
        BComponent c = new BComponent();
        OrionSession session = null;
        String propName = null;
        BString value = null;
        try {
            Feature f2;
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            BEnterpriseSecurityService entService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            try {
                if (!HxUtil.isPost((HxOp)op)) {
                    session = service.createSession(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String version = service.getSoftwareVersion();
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.softwareVersion"));
            value = BString.make((String)version);
            c.add(propName, (BValue)value, 1);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.accessControlVersion"));
            value = BString.make((String)Sys.loadModule((String)"entsec").getVendorVersion(RuntimeProfile.wb).toString());
            c.add(propName, (BValue)value, 1);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.accessDriverVersion"));
            value = BString.make((String)Sys.loadModule((String)"accessDriver").getVendorVersion(RuntimeProfile.rt).toString());
            c.add(propName, (BValue)value, 1);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.lastStationRestart"));
            value = BString.make((String)HxTabUtil.getDisplayDuration((BAbsTime)BAccessControlService.getLastStationRestart()));
            c.add(propName, (BValue)value, 1);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.lastStationSave"));
            value = BString.make((String)BHxMaintenanceView.getLastSaveDurationString());
            c.add(propName, (BValue)value, 1);
            boolean intrusionAllowed = false;
            try {
                f2 = Sys.getLicenseManager().checkFeature("Tridium", "intrusion");
                intrusionAllowed = true;
            }
            catch (Exception f2) {
                // empty catch block
            }
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.intrusionDetection"));
            value = this.getLicenseAvailableText(intrusionAllowed);
            c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.threatLevelGroupLimit"));
            f2 = Sys.getLicenseManager().checkFeature("Tridium", "entSecurity");
            String limitString = f2.get("threatGroup.limit");
            value = this.getLicenseCountText(limitString);
            c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.threatLevelCount"));
            Integer threatLevelCount = (Integer)entService.fw(503, (Object)"threatGroup.limit", null, null, null);
            value = BInteger.make((int)threatLevelCount);
            c.add(propName, (BValue)value, 1);
            if (BEnterpriseSecurityService.isWorkstation()) {
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.readerLimit"));
                f2 = Sys.getLicenseManager().checkFeature("Tridium", "entSecurity");
                String maxReadersString = f2.get("reader.limit");
                value = this.getLicenseCountText(maxReadersString);
                c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
                if (!HxUtil.isPost((HxOp)op)) {
                    propName = SlotPath.escape((String)lex.getText("jaceMaintenance.readerCount"));
                    value = BInteger.DEFAULT;
                    try {
                        int readerCount = CountingUtil.getCount((OrionType)BAccReaderRec.ORION_TYPE, (OrionSession)session);
                        value = BInteger.make((int)readerCount);
                    }
                    catch (Exception readerCount) {
                        // empty catch block
                    }
                    c.add(propName, (BValue)value, 1);
                }
                BPhotoIDNetwork photoIDNetwork = null;
                boolean photoIdAllowed = false;
                String maxAsureId = null;
                int asureIdCount = 0;
                try {
                    f2 = Sys.getLicenseManager().checkFeature("Tridium", "secPhotoId");
                    photoIdAllowed = true;
                    maxAsureId = f2.get("asureId.limit");
                    photoIDNetwork = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
                    Integer asureIdCountI = (Integer)photoIDNetwork.fw(503, (Object)"asureId.limit", null, null, null);
                    asureIdCount = asureIdCountI;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.photoID"));
                value = this.getLicenseAvailableText(photoIdAllowed);
                c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
                if (photoIdAllowed) {
                    propName = SlotPath.escape((String)lex.getText("jaceMaintenance.asureIdLimit"));
                    value = this.getLicenseCountText(maxAsureId);
                    c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
                    propName = SlotPath.escape((String)lex.getText("jaceMaintenance.asureIdCount"));
                    value = BInteger.make((int)asureIdCount);
                    c.add(propName, (BValue)value, 1);
                }
            } else {
                BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.readerLimit"));
                value = this.getLicenseCountText(network.getLicenseFeature().get("reader.limit", null));
                c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.readerCount"));
                Integer readerCount = (Integer)network.fw(503, (Object)"reader.limit", null, null, null);
                value = BInteger.make((int)readerCount);
                c.add(propName, (BValue)value, 1);
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.elevatorLimit"));
                value = this.getLicenseCountText(network.getLicenseFeature().get("elevator.limit"));
                c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.elevatorCount"));
                Integer elevatorCount = (Integer)network.fw(503, (Object)"elevator.limit", null, null, null);
                value = BInteger.make((int)elevatorCount);
                c.add(propName, (BValue)value, 1);
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.ada"));
                boolean ada = network.getLicenseFeature().get("ada", "false").equals("true");
                value = this.getLicenseAvailableText(ada);
                c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
            }
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.accessZoneLimit"));
            value = this.getLicenseCountText(service.getAccessZoneLimit());
            c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.accessZoneCount"));
            Integer accessZoneCount = (Integer)service.fw(503, (Object)"accessZone.limit", null, null, null);
            value = BInteger.make((int)accessZoneCount);
            c.add(propName, (BValue)value, 1);
            if (!HxUtil.isPost((HxOp)op)) {
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.credentialLimit"));
                value = this.getLicenseCountText(service.getCredentialLimit());
                c.add(propName, (BValue)value, 1, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10)), null);
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.badgeCount"));
                value = BInteger.DEFAULT;
                try {
                    int count = CountingUtil.getCount((OrionType)BBadge.ORION_TYPE, (OrionSession)session);
                    value = BInteger.make((int)count);
                }
                catch (Exception count) {
                    // empty catch block
                }
                c.add(propName, (BValue)value, 1);
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.personCount"));
                value = BInteger.DEFAULT;
                try {
                    int count = CountingUtil.getCount((OrionType)BPerson.ORION_TYPE, (OrionSession)session);
                    value = BInteger.make((int)count);
                }
                catch (Exception count) {
                    // empty catch block
                }
                c.add(propName, (BValue)value, 1);
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.accessRightCount"));
                value = BInteger.DEFAULT;
                try {
                    int count = CountingUtil.getCount((OrionType)BAccessRight.ORION_TYPE, (OrionSession)session);
                    value = BInteger.make((int)count);
                }
                catch (Exception count) {
                    // empty catch block
                }
                c.add(propName, (BValue)value, 1);
                propName = SlotPath.escape((String)lex.getText("jaceMaintenance.accessRightAssignmentCount"));
                value = BInteger.DEFAULT;
                try {
                    int count = CountingUtil.getCount((OrionType)BPersonAccJoin.ORION_TYPE, (OrionSession)session);
                    value = BInteger.make((int)count);
                }
                catch (Exception count) {
                    // empty catch block
                }
                c.add(propName, (BValue)value, 1);
            }
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.fipsStatus"));
            boolean fipsLicensed = false;
            try {
                Sys.getLicenseManager().checkFeature("Tridium", "fips140-2");
                fipsLicensed = true;
            }
            catch (FeatureNotLicensedException elevatorCount) {
                // empty catch block
            }
            boolean fipsEnabled = SecurityInitializer.getInstance().isFips();
            if (fipsLicensed && fipsEnabled) {
                value = BString.make((String)this.getLexicon().getText("jaceMaintenance.fipsEnabled"));
            } else if (fipsLicensed && !fipsEnabled) {
                value = BString.make((String)this.getLexicon().getText("jaceMaintenance.fipsLicensedNotInstalled"));
            } else if (!fipsLicensed && fipsEnabled) {
                value = BString.make((String)this.getLexicon().getText("jaceMaintenance.fipsInstalledNotLicensed"));
            }
            c.add(propName, (BValue)value, 1);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        try {
            BNpmDualBatteryPlatformService power = (BNpmDualBatteryPlatformService)Sys.getService((Type)BNpmDualBatteryPlatformService.TYPE);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.primaryPowerPresent"));
            value = BString.make((String)BBoolean.toString((boolean)power.getPrimaryPowerPresent(), (Context)op));
            c.add(propName, (BValue)value, 1);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.slaBatteryGood"));
            value = BString.make((String)BBoolean.toString((boolean)power.getSlaBatteryGood(), (Context)op));
            c.add(propName, (BValue)value, 1);
            propName = SlotPath.escape((String)lex.getText("jaceMaintenance.nimhBatteryGood"));
            value = BString.make((String)BBoolean.toString((boolean)power.getNimhBatteryGood(), (Context)op));
            c.add(propName, (BValue)value, 1);
        }
        catch (ServiceNotFoundException power) {
            // empty catch block
        }
        BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        propName = SlotPath.escape((String)BEnterpriseSecurityService.showGuidedTour.getDefaultDisplayName((Context)op));
        c.add(propName, entsecService.get(BEnterpriseSecurityService.showGuidedTour));
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        propName = SlotPath.escape((String)BAlarmService.coalesceAlarms.getDefaultDisplayName((Context)op));
        c.add(propName, alarmService.get(BAlarmService.coalesceAlarms), (Context)op);
        if (!Flags.isHidden((BComplex)entsecService, (Slot)BEnterpriseSecurityService.queryOutdatedStations)) {
            propName = SlotPath.escape((String)BEnterpriseSecurityService.queryOutdatedStations.getDefaultDisplayName((Context)op));
            c.add(propName, entsecService.get(BEnterpriseSecurityService.queryOutdatedStations), 0, entsecService.getSlotFacets((Slot)BEnterpriseSecurityService.queryOutdatedStations), null);
        }
        return new BHxTabbedView.PropertyTab((BHxTabbedView)this, (BHxView)BHxFieldSheet.INSTANCE, lex.getText("jaceMaintenance.info"), op.make("tab", (BObject)c, null), op);
    }

    public static String getLastSaveDurationString() {
        long t = Station.lastSuccessfulSaveTicks;
        return HxTabUtil.getDisplayDuration((BRelTime)BRelTime.make((long)(Clock.ticks() - t)));
    }

    public BString getLicenseCountText(String license) {
        if (license == null) {
            return UNLICENSED;
        }
        if (license.equals("none")) {
            return UNLIMITED;
        }
        return BString.make((String)license);
    }

    public BString getLicenseAvailableText(boolean available) {
        if (available) {
            return LICENSED;
        }
        return UNLICENSED;
    }

    public static class RestartStation
    extends SmartCommand {
        private ConfirmDialog dialog;

        public RestartStation(BHxView view) {
            super(view);
            Lexicon lex = HxTabUtil.getLexicon(BHxMaintenanceView.class);
            this.dialog = new ConfirmDialog(lex.getText("jaceMaintenance.restartStation"), (Command)this, lex.getText("jaceMaintenance.restartQuestion"));
        }

        public String getName(HxOp op) {
            return "restartStation";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                try {
                    BNpmDualBatteryPlatformService power = (BNpmDualBatteryPlatformService)Sys.getService((Type)BNpmDualBatteryPlatformService.TYPE);
                    this.dialog.open(op);
                }
                catch (ServiceNotFoundException e) {
                    this.dialog.open(this.lex.getText("serverMaintenance.restartQuestion"), op);
                }
                return;
            }
            BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            service.restartStation();
            HtmlWriter out = op.getHtmlWriter();
            if (op.getProfile().getType().is(BHxAccessProfile.TYPE)) {
                BHxAccessProfile.disconnect(op);
            }
        }

        public boolean isAvailable(HxOp op) {
            try {
                BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                return LocalSessionUtil.localDaemonIsAvailable();
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public class UpdatePinNumbers
    extends BHxTabbedView.Save {
        public UpdatePinNumbers(BHxView view) {
            super((BHxTabbedView)BHxMaintenanceView.this, view);
            this.lexModule = LexiconModule.make((String)"entsecHx");
        }

        public boolean startsEnabled(HxOp op) {
            return op.canWrite();
        }

        public boolean registerOnInputs() {
            return false;
        }

        public String getName(HxOp op) {
            return "updCorruptPinNumbers";
        }

        public String getHtmlElementName(HxOp op) {
            return "updCorruptPinNumbers";
        }

        public void onHandle(HxOp op) throws Exception {
            op.getRequest().getSession().setAttribute("job", (Object)"updCorruptPinNumbers");
            super.onHandle(op);
        }

        public String getInvokeCode(HxOp hxOp) {
            return super.getInvokeCode(hxOp);
        }
    }

    public class GetCorruptPinNumbers
    extends BHxTabbedView.Save {
        public GetCorruptPinNumbers(BHxView view) {
            super((BHxTabbedView)BHxMaintenanceView.this, view);
            this.lexModule = LexiconModule.make((String)"entsecHx");
        }

        public boolean startsEnabled(HxOp op) {
            return op.canWrite();
        }

        public boolean registerOnInputs() {
            return false;
        }

        public String getName(HxOp op) {
            return "getCorruptPinNumbers";
        }

        public String getHtmlElementName(HxOp op) {
            return "getCorruptPinNumbers";
        }

        public void onHandle(HxOp op) throws Exception {
            op.getRequest().getSession().setAttribute("job", (Object)"getCorruptPinNumbers");
            super.onHandle(op);
        }

        public String getInvokeCode(HxOp hxOp) {
            return super.getInvokeCode(hxOp);
        }
    }

    public class UpdateReaderCount
    extends BHxTabbedView.Save {
        public UpdateReaderCount(BHxView view) {
            super((BHxTabbedView)BHxMaintenanceView.this, view);
            this.lexModule = LexiconModule.make((String)"entsecHx");
        }

        public boolean startsEnabled(HxOp op) {
            return op.canWrite();
        }

        public boolean registerOnInputs() {
            return false;
        }

        public String getName(HxOp op) {
            return "updateReaderCount";
        }

        public String getHtmlElementName(HxOp op) {
            return "updateReaderCount";
        }

        public void onHandle(HxOp op) throws Exception {
            ConfirmDialog dlg = new ConfirmDialog("Confirm update", (Command)this, this.lex.getText("jaceMaintenance.deletes.unused.readers.of.subordinate.stations"));
            if (!dlg.isSubmit(op)) {
                dlg.open(op);
                return;
            }
            op.getRequest().getSession().setAttribute("job", (Object)"updateReaderCount");
            super.onHandle(op);
        }
    }

    public class DefragAndSaveStation
    extends BHxTabbedView.Save {
        private ConfirmDialog dialog;
        private BHsqlDatabase hsqlDatabase;

        public DefragAndSaveStation(BHxView view) {
            BRdbms rdbms;
            super((BHxTabbedView)BHxMaintenanceView.this, view);
            this.lexModule = LexiconModule.make((String)"entsecHx");
            Context op = Sys.getService((Type)BEnterpriseSecurityService.TYPE).getSession().getSessionContext();
            this.dialog = new ConfirmDialog(this.lexModule.getHtmlSafeText("jaceMaintenance.defragAndSaveStation", op), (Command)this, this.lexModule.getHtmlSafeText("jaceMaintenance.defragAndSaveStationQuestion", op));
            BOrionDatabase[] orionDatabases = BOrionService.getService().getOrionDatabases();
            if (orionDatabases != null && orionDatabases.length > 0 && (rdbms = orionDatabases[0].getRdbms()).getType().is(BHsqlDatabase.TYPE)) {
                this.hsqlDatabase = (BHsqlDatabase)orionDatabases[0].getRdbms();
            }
        }

        public boolean startsEnabled(HxOp op) {
            return op.canWrite();
        }

        public boolean registerOnInputs() {
            return false;
        }

        public String getName(HxOp op) {
            return "defragAndSaveStation";
        }

        public String getHtmlElementName(HxOp op) {
            return this.lexModule.getHtmlSafeText("jaceMaintenance.defragAndSaveStation", (Context)op);
        }

        public void onHandle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(this.lexModule.getHtmlSafeText("jaceMaintenance.defragAndSaveStationQuestion", (Context)op), op);
                return;
            }
            op.getRequest().getSession().setAttribute("job", (Object)"defragAndSaveStation");
            super.onHandle(op);
        }

        public boolean isAvailable(HxOp op) {
            return this.hsqlDatabase != null && !this.hsqlDatabase.getDefragOnSave();
        }
    }

    public class SaveStation
    extends BHxTabbedView.Save {
        public SaveStation(BHxView view) {
            super((BHxTabbedView)BHxMaintenanceView.this, view);
            this.lexModule = LexiconModule.make((String)"entsecHx");
        }

        public String getName(HxOp op) {
            return "saveStation";
        }

        public boolean startsEnabled(HxOp op) {
            return op.canWrite();
        }

        public boolean registerOnInputs() {
            return false;
        }

        public String getHtmlElementName(HxOp op) {
            return "stationSave";
        }

        public void onHandle(HxOp op) throws Exception {
            op.getRequest().getSession().setAttribute("job", (Object)"stationSave");
            super.onHandle(op);
        }
    }

    public class GetInvalidPinsDialog
    extends JobLogDialog {
        private BEnterpriseSecurityService entsecService;

        public GetInvalidPinsDialog(Command command, BJob job, String title) {
            super(command, job, title);
            this.entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        }

        public Command[] getCommands() {
            if (this.entsecService.isInvalidPinsJobCancelled() || this.entsecService.getInvalidPinMap() != null && this.entsecService.getInvalidPinMap().size() == 0) {
                return new Command[]{new TriggerJob()};
            }
            return new Command[]{new TriggerJob(), new Dialog.Cancel((Dialog)this)};
        }

        protected class TriggerJob
        extends Dialog.Submit {
            public TriggerJob() {
                super((Dialog)GetInvalidPinsDialog.this);
            }

            public String getDisplayName(HxOp hxOp) {
                return GetInvalidPinsDialog.this.entsecService.isInvalidPinsJobCancelled() || GetInvalidPinsDialog.this.entsecService.getInvalidPinMap() != null && GetInvalidPinsDialog.this.entsecService.getInvalidPinMap().size() == 0 ? "Close" : "Update";
            }

            public String getInvokeCode(HxOp op) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("hx.closeDialog(null,null,null);");
                if (!GetInvalidPinsDialog.this.entsecService.isInvalidPinsJobCancelled() && GetInvalidPinsDialog.this.entsecService.getInvalidPinMap() != null && GetInvalidPinsDialog.this.entsecService.getInvalidPinMap().size() > 0) {
                    try {
                        buffer.append(SmartCommand.getInvokeCode((Command)BHxMaintenanceView.this.updPinNumbers, (String)"&quot;", (HxOp)op));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    buffer.append("window.location.reload(true);");
                }
                return buffer.toString();
            }
        }
    }
}

