/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.fieldeditors;

import com.tridium.hx.fieldeditors.BHxNumericFE;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxVoltageFE
extends BHxFieldEditor {
    public static final BHxVoltageFE INSTANCE = new BHxVoltageFE();
    public static final Type TYPE = Sys.loadType(BHxVoltageFE.class);

    public Type getType() {
        return TYPE;
    }

    public Tab getNumberTab(HxOp op) {
        BInteger raw = (BInteger)op.get();
        BFloat voltage = BFloat.make((float)BHxVoltageFE.toVoltage(raw.getInt()));
        HxOp tabOp = op.make("voltage", (BObject)voltage, null);
        SmartCommand.matchReadonly((HxOp)tabOp, (HxOp)op);
        return new Tab((BHxView)BHxNumericFE.INSTANCE, tabOp);
    }

    private static float toVoltage(int unit) {
        return (float)unit / 4096.0f * 3.3f;
    }

    private static int fromVoltage(float voltage) {
        return (int)(voltage / 3.3f * 4096.0f);
    }

    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        Tab numericTab = this.getNumberTab(op);
        numericTab.write();
        out.w((Object)"&nbsp;V");
    }

    public BObject save(HxOp op) throws Exception {
        if (!op.canWrite()) {
            return op.get();
        }
        Tab numberTab = this.getNumberTab(op);
        BFloat voltage = (BFloat)numberTab.save();
        BInteger raw = BInteger.make((int)BHxVoltageFE.fromVoltage(voltage.getFloat()));
        return raw;
    }
}

