/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.accessNetwork;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.ToggleCommand;
import com.tridiumx.accessDriver.BAccessInputOutputModule;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BBase2ReaderModule;
import com.tridiumx.accessDriver.BRemote2ReaderModule;
import com.tridiumx.entsecHx.access.accessNetwork.BHxAccessNetworkView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BHxAccessNetworkDiscoverView
extends BHxAbstractDiscoverView {
    static final Lexicon entsecHxLex = Lexicon.make(BHxAccessNetworkDiscoverView.class);
    public static final BHxAccessNetworkDiscoverView INSTANCE = new BHxAccessNetworkDiscoverView();
    public static final Type TYPE = Sys.loadType(BHxAccessNetworkDiscoverView.class);
    SmartCommand wink = new WinkCommand((BHxView)this);
    private static String[] LEARN_FIELDS = new String[]{"address", "deviceType", "uid", "version", "usedBy"};
    private static String[] DEVICE_FIELDS = new String[]{"deviceType", "enabled", "address", "uid", "initialDoors"};

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxAccessNetworkDiscoverView() {
        this.registerEvent((Event)this.wink);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.add, this.match, this.wink, this.filterCommand, this.exportCommand};
    }

    @Override
    public BHxAbstractManagerView getAbstractManagerView(HxOp op) {
        return BHxAccessNetworkView.INSTANCE;
    }

    @Override
    public BComponent getDeviceSubject(HxOp op) {
        BNrioLearnDeviceEntry entry = (BNrioLearnDeviceEntry)this.getLearnEntrySubject(op);
        if (entry == null) {
            throw new IllegalStateException("No Device Selected");
        }
        this.checkDuplicate(entry.getUid());
        BNrioDeviceTypeEnum deviceTypeEnum = entry.getDeviceType();
        BRemote2ReaderModule device = null;
        if (deviceTypeEnum == BNrioDeviceTypeEnum.remoteReader) {
            device = new BRemote2ReaderModule();
        } else if (deviceTypeEnum == BNrioDeviceTypeEnum.baseBoardReader) {
            device = new BBase2ReaderModule();
        } else if (deviceTypeEnum == BNrioDeviceTypeEnum.remoteInputOutput) {
            device = new BAccessInputOutputModule();
        } else {
            if (deviceTypeEnum == BNrioDeviceTypeEnum.io16) {
                throw new IllegalStateException("io16 addition not allowed through Security Appliance");
            }
            throw new IllegalStateException("Unknown device");
        }
        device.setUid(entry.getUid());
        device.setAddress(entry.getAddress());
        return device;
    }

    public void checkDuplicate(BBlob uid) {
        BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        BNrioDevice[] devices = (BNrioDevice[])network.getChildren(BNrioDevice.class);
        for (int i = 0; i < devices.length; ++i) {
            if (!devices[i].getUid().equals((Object)uid)) continue;
            throw new BajaRuntimeException(entsecHxLex.getText("deviceAlreadyInUse"));
        }
    }

    @Override
    public void match(BComplex learnEntry, BComponent databaseDevice, HxOp op) {
        BNrioLearnDeviceEntry entry = (BNrioLearnDeviceEntry)learnEntry;
        BNrioDevice d = (BNrioDevice)databaseDevice;
        this.checkDuplicate(entry.getUid());
        if (!entry.isMatchable((BComponent)d)) {
            if (!entry.getDeviceType().equals((Object)d.getDeviceType())) {
                throw new BajaRuntimeException(entsecHxLex.getText("matchDeviceType"));
            }
            if (d.isDown()) {
                // empty if block
            }
            throw new BajaRuntimeException(entsecHxLex.getText("deviceMustBeDownToMatch"));
        }
        d.setUid(entry.getUid());
        d.setAddress(entry.getAddress());
        entry.setUsedBy(d.getDisplayName((Context)op));
        d.setInstalledVersion(entry.getVersion());
        d.doPing();
        BNrioLearnDeviceEntry[] peers = (BNrioLearnDeviceEntry[])entry.getParent().asComponent().getChildren(BNrioLearnDeviceEntry.class);
        for (int i = 0; i < peers.length; ++i) {
            if (peers[i] == entry || !peers[i].getUsedBy().equals(d.getDisplayName((Context)op))) continue;
            peers[i].setUsedBy("");
            peers[i].setAddress(0);
        }
    }

    @Override
    public void handleAdd(BComponent newDevice, String addName, HxOp op) throws Exception {
        BComponent component = this.getComponent(op);
        Property p = component.add(addName + "?", (BValue)newDevice);
        BNrioDevice device = (BNrioDevice)newDevice;
        device.doPing();
        BNrioLearnDeviceEntry learnDevice = (BNrioLearnDeviceEntry)this.getLearnEntrySubject(op);
        learnDevice.setUsedBy(p.getDefaultDisplayName((Context)op));
        HxOp parentOp = null;
        String parentOpOrdFromValue = op.getFormValue("parentOp");
        String parentOpOrdStr = op.getBaseOrdTarget().getBaseOrdTarget().getOrd().encodeToString();
        if (parentOpOrdStr.equals(parentOpOrdFromValue)) {
            parentOp = (HxOp)op.getBase().getBase();
        }
        this.getAbstractManagerView(op).reloadTables(parentOp);
    }

    @Override
    public String[] getDeviceFields(HxOp op) {
        return DEVICE_FIELDS;
    }

    @Override
    public String[] getLearnFields(HxOp op) {
        return LEARN_FIELDS;
    }

    public class WinkCommand
    extends ToggleCommand {
        public WinkCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "wink";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean isSelected(HxOp op) {
            Object[] subjects = BHxQueryTableView.getSubjects(op);
            for (int i = 0; i < subjects.length; ++i) {
                BNrioLearnDeviceEntry d = (BNrioLearnDeviceEntry)subjects[i];
                if (!d.isWinkActive()) continue;
                return true;
            }
            return false;
        }

        public boolean handle(boolean selected, HxOp op) throws Exception {
            BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
            Object[] subjects = BHxQueryTableView.getSubjects(op);
            for (int i = 0; i < subjects.length; ++i) {
                BNrioLearnDeviceEntry d;
                d.doWinkDevice((BNrioNetwork)network, BBoolean.make((!(d = (BNrioLearnDeviceEntry)subjects[i]).isWinkActive() ? 1 : 0) != 0));
            }
            return this.isSelected(op);
        }
    }
}

