/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.filter.BBadgeStringFilter;
import com.tridiumx.entsec.photoID.orion.BBadgeTemplate;
import com.tridiumx.entsecHx.access.BHxPersonnelView;
import com.tridiumx.entsecHx.access.orion.BHxBatchBadgeView;
import com.tridiumx.entsecHx.access.orion.BHxEnrollBadgeView;
import com.tridiumx.entsecHx.access.orion.BHxRangeBadgeView;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAddAppView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppTableView;
import com.tridiumx.entsecHx.orionToolsHx.BadgeDelete;
import com.tridiumx.entsecHx.orionToolsHx.OrionBatchEditCommand;
import com.tridiumx.entsecHx.photoID.PrintBadgeWizard;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BHxBadgesView
extends BHxAppTableView {
    public static final BHxBadgesView INSTANCE = new BHxBadgesView();
    public static final Type TYPE = Sys.loadType(BHxBadgesView.class);
    static Lexicon lex = Lexicon.make(BHxBadgesView.class);
    protected SmartCommand printBadge;
    protected SmartCommand enroll = new Enroll((BHxView)this);
    protected SmartCommand batch;
    protected SmartCommand range;
    protected SmartCommand batchEdit;
    protected SmartCommand showHistoryCommand;
    protected SmartCommand showExpirationsCommand;
    protected SmartCommand showReadersCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxBadgesView() {
        this.registerEvent((Event)this.enroll);
        this.batch = new Batch((BHxView)this);
        this.registerEvent((Event)this.batch);
        this.range = new Range((BHxView)this);
        this.registerEvent((Event)this.range);
        this.batchEdit = new BadgeBatchEditCommand((BHxView)this);
        this.registerEvent((Event)this.batchEdit);
        this.showHistoryCommand = new ShowBadgeHistoryCommand((BHxView)this);
        this.registerEvent((Event)this.showHistoryCommand);
        this.showExpirationsCommand = new ShowBadgeExpirationsCommand((BHxView)this);
        this.registerEvent((Event)this.showExpirationsCommand);
        this.showReadersCommand = new ShowBadgeReadersCommand((BHxView)this);
        this.registerEvent((Event)this.showReadersCommand);
        this.printBadge = new PrintBadgeWizard.OrionPrintBadgeWizard((BHxView)this);
        this.registerEvent((Event)this.printBadge);
        this.delete = new BadgeDelete((BHxView)this);
        this.registerEvent((Event)this.delete);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        a.add(1, (Object)this.range);
        a.add(1, (Object)this.batch);
        a.add(0, (Object)this.enroll);
        a.add(8, (Object)this.batchEdit);
        a.add(6, (Object)this.showExpirationsCommand);
        a.add(6, (Object)this.showHistoryCommand);
        a.add(6, (Object)this.showReadersCommand);
        if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
            a.add((Object)this.printBadge);
        }
        return (SmartCommand[])a.trim();
    }

    public static class ShowBadgeReadersCommand
    extends BHxPersonnelView.ShowReadersCommand {
        public ShowBadgeReadersCommand(BHxView view) {
            super(view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BIOrionObject[] getSubjects(HxOp op) {
            BIOrionObject[] badges = (BIOrionObject[])((BHxDynamicTableView)this.getView()).getSubjects(op);
            BIOrionObject[] owners = new BIOrionObject[badges.length];
            BDynamicTable dt = this.getReport(op);
            OrionSession session = null;
            try {
                session = dt.getOrionDatabase().createSession((Context)op);
                for (int i = 0; i < badges.length; ++i) {
                    owners[i] = ((BBadge)badges[i]).resolveOwner(session);
                    if (owners[i] != null) continue;
                    throw new IllegalStateException("All Badges must have an owner, " + badges[i].toString((Context)op) + " does not have an owner.");
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            return owners;
        }
    }

    public static class ShowBadgeExpirationsCommand
    extends BHxPersonnelView.ShowExpirationsCommand {
        public ShowBadgeExpirationsCommand(BHxView view) {
            super(view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BIOrionObject[] getSubjects(HxOp op) {
            BIOrionObject[] badges = (BIOrionObject[])((BHxDynamicTableView)this.getView()).getSubjects(op);
            BIOrionObject[] owners = new BIOrionObject[badges.length];
            BDynamicTable dt = this.getReport(op);
            OrionSession session = null;
            try {
                session = dt.getOrionDatabase().createSession((Context)op);
                for (int i = 0; i < badges.length; ++i) {
                    owners[i] = ((BBadge)badges[i]).resolveOwner(session);
                    if (owners[i] != null) continue;
                    throw new IllegalStateException("All Badges must have an owner, " + badges[i].toString((Context)op) + " does not have an owner.");
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            return owners;
        }
    }

    public static class ShowBadgeHistoryCommand
    extends BHxPersonnelView.ShowHistoryCommand {
        public ShowBadgeHistoryCommand(BHxView view) {
            super(view);
        }

        @Override
        public Type getFilterType(HxOp op) {
            return BBadgeStringFilter.TYPE;
        }
    }

    public static class BadgeBatchEditCommand
    extends OrionBatchEditCommand {
        public BadgeBatchEditCommand(BHxView view) {
            super(view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HxOp op) throws Exception {
            BDynamicTable dt = (BDynamicTable)op.get();
            OrionSession session = null;
            Object[] subjects = null;
            if (!this.dlg.isSubmit(op)) {
                try {
                    session = dt.getOrionDatabase().createSession((Context)op);
                    subjects = this.getSubjects(op);
                    if (subjects != null) {
                        for (int i = 0; i < subjects.length; ++i) {
                            BBadge badge = (BBadge)subjects[i];
                            BBadgeLdapServerJoin badgeLdapServerJoin = badge.getBadgeLdapServerJoin(session);
                            if (badgeLdapServerJoin == null) continue;
                            throw new BajaRuntimeException(this.lex.getText("ldap.badge.edit.Exception"));
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
            }
            super.handle(op);
        }

        @Override
        public void saveRow(BComponent saved, BOrionObject subject, BOrionObject template, OrionSession session, HxOp op) throws Exception {
            super.saveRow(saved, subject, template, session, op);
            if (!BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
                return;
            }
            BDynamicTable dt = (BDynamicTable)op.get();
            BOrionDatabase db = dt.getOrionDatabase();
            BBadge badge = (BBadge)saved;
            BRef ref = (BRef)badge.get("template");
            BBadgeTemplate dbBadgeTemplate = (BBadgeTemplate)session.read(BBadgeTemplate.ORION_TYPE, new PropertyValue(BBadgeTemplate.badge, (BValue)BRef.make((BIOrionObject)badge)));
            BBadgeTemplate badgeTemplate = null;
            if (dbBadgeTemplate != null) {
                badgeTemplate = dbBadgeTemplate;
            } else {
                badgeTemplate = new BBadgeTemplate();
                badgeTemplate.setBadge(BRef.make((BIOrionObject)badge));
            }
            badgeTemplate.setTemplate(ref);
            if (ref.isBound() && dbBadgeTemplate == null) {
                session.insert((BIOrionObject)badgeTemplate);
            } else if (!ref.isBound() && dbBadgeTemplate != null) {
                session.delete((BIOrionObject)badgeTemplate);
            } else if (ref.isBound() && dbBadgeTemplate != null) {
                session.update((BIOrionObject)badgeTemplate);
            }
        }

        @Override
        public String[] getProperties(BComponent o, HxOp op) {
            Array a = new Array(String.class);
            a.addAll((Object[])new String[]{"bDescription", "status", "issueDate", "expirationDate", "tenant"});
            if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
                a.add((Object)"template");
            }
            return (String[])a.trim();
        }
    }

    public static class Range
    extends SmartCommand {
        public Range(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "range";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            String enrollTypeSpec = BHxRangeBadgeView.TYPE.getTypeSpec().toString();
            this.redirect(op, op.toUri(BOrd.make((String)(op.getOrd().toString() + "|view:" + BHxAddAppView.TYPE + "?tab=" + enrollTypeSpec))));
        }
    }

    public static class Batch
    extends SmartCommand {
        public Batch(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "batch";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            String enrollTypeSpec = BHxBatchBadgeView.TYPE.getTypeSpec().toString();
            this.redirect(op, op.toUri(BOrd.make((String)(op.getOrd().toString() + "|view:" + BHxAddAppView.TYPE + "?tab=" + enrollTypeSpec))));
        }
    }

    public static class Enroll
    extends SmartCommand {
        public Enroll(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "enroll";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            String enrollTypeSpec = BHxEnrollBadgeView.TYPE.getTypeSpec().toString();
            this.redirect(op, op.toUri(BOrd.make((String)(op.getOrd().toString() + "|view:" + BHxAddAppView.TYPE + "?tab=" + enrollTypeSpec))));
        }
    }
}

