/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.filter.BAccessRightStringFilter;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppTableView;
import com.tridiumx.entsecHx.orionToolsHx.DuplicateCommand;
import com.tridiumx.entsecHx.orionToolsHx.FilteredRedirectCommand;
import com.tridiumx.entsecHx.orionToolsHx.OrionBatchEditCommand;
import com.tridiumx.entsecHx.orionToolsHx.match.BHxMatchSheet;
import com.tridiumx.entsecHx.orionToolsHx.match.MatchCommand;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BHxAccessRightsView
extends BHxAppTableView {
    public static final BHxAccessRightsView INSTANCE = new BHxAccessRightsView();
    public static final Type TYPE = Sys.loadType(BHxAccessRightsView.class);
    SmartCommand matchCommand = new AccessRightMatchCommand((BHxView)this);
    SmartCommand batchCommand;
    SmartCommand showExpirationsCommand;
    SmartCommand showReadersCommand;
    SmartCommand duplicateCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxAccessRightsView() {
        this.registerEvent((Event)this.matchCommand);
        this.batchCommand = new AccessRightBatchEditCommand((BHxView)this);
        this.registerEvent((Event)this.batchCommand);
        this.showExpirationsCommand = new ShowExpirationsCommand((BHxView)this);
        this.registerEvent((Event)this.showExpirationsCommand);
        this.showReadersCommand = new ShowReadersCommand((BHxView)this);
        this.registerEvent((Event)this.showReadersCommand);
        this.duplicateCommand = new DuplicateCommand((BHxView)this);
        this.registerEvent((Event)this.duplicateCommand);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        a.add((Object)this.matchCommand);
        a.add((Object)this.batchCommand);
        a.add((Object)this.duplicateCommand);
        a.add((Object)this.showExpirationsCommand);
        a.add((Object)this.showReadersCommand);
        return (SmartCommand[])a.trim();
    }

    public class AccessRightBatchEditCommand
    extends OrionBatchEditCommand {
        public AccessRightBatchEditCommand(BHxView view) {
            super(view);
        }

        @Override
        public BOrionObject getBatchTemplate(HxOp op) {
            BAccessRight accessRight = (BAccessRight)super.getBatchTemplate(op);
            accessRight.add("addPeople", (BValue)BRefList.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
            accessRight.add("removePeople", (BValue)BRefList.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
            accessRight.add("addReaders", (BValue)BRefList.make((BOrionTypeId)BAccReaderRec.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
            accessRight.add("removeReaders", (BValue)BRefList.make((BOrionTypeId)BAccReaderRec.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
            return accessRight;
        }

        @Override
        public void saveRow(BComponent saved, BOrionObject subject, BOrionObject template, OrionSession session, HxOp op) throws Exception {
            BPersonAccJoin join;
            BRef ref;
            int i;
            super.saveRow(saved, subject, template, session, op);
            BRef accessRightRef = BRef.make((BIOrionObject)((BIOrionObject)saved));
            BRefList refList = (BRefList)template.get("addPeople");
            BSimple[] values = refList.getIds();
            if (values != null) {
                for (i = 0; i < values.length; ++i) {
                    ref = BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)values[i]);
                    join = new BPersonAccJoin();
                    join.setPerson(ref);
                    join.setAccessRight(accessRightRef);
                    if (session.exists((BIOrionObject)join)) continue;
                    session.insert((BIOrionObject)join);
                }
            }
            if ((values = (refList = (BRefList)template.get("removePeople")).getIds()) != null) {
                for (i = 0; i < values.length; ++i) {
                    ref = BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)values[i]);
                    join = new BPersonAccJoin();
                    join.setPerson(ref);
                    join.setAccessRight(accessRightRef);
                    if (!session.exists((BIOrionObject)join)) continue;
                    session.delete((BIOrionObject)join);
                }
            }
            if ((values = (refList = (BRefList)template.get("addReaders")).getIds()) != null) {
                for (i = 0; i < values.length; ++i) {
                    ref = BRef.make((BTypeSpec)BAccReaderRec.ORION_TYPE.getTypeSpec(), (BSimple)values[i]);
                    join = new BAccReaderJoin();
                    join.setAccessRight(accessRightRef);
                    join.setReader(ref);
                    if (session.exists((BIOrionObject)join)) continue;
                    session.insert((BIOrionObject)join);
                }
            }
            if ((values = (refList = (BRefList)template.get("removeReaders")).getIds()) != null) {
                for (i = 0; i < values.length; ++i) {
                    ref = BRef.make((BTypeSpec)BAccReaderRec.ORION_TYPE.getTypeSpec(), (BSimple)values[i]);
                    join = new BAccReaderJoin();
                    join.setAccessRight(accessRightRef);
                    join.setReader(ref);
                    if (!session.exists((BIOrionObject)join)) continue;
                    session.delete((BIOrionObject)join);
                }
            }
        }

        @Override
        public String[] getProperties(BComponent o, HxOp op) {
            Array a = new Array(String.class);
            a.addAll((Object[])new String[]{"schedule", "niagaraIntegrationID", "tenant", "threatLevelGroup", "threatLevelOperation", "defaultAssignedThreatLevel"});
            if (!BEnterpriseSecurityService.isThreatAvailable((Context)op)) {
                a.remove((Object)"threatLevelGroup");
                a.remove((Object)"threatLevelOperation");
                a.remove((Object)"defaultAssignedThreatLevel");
            }
            Property[] props = ((BOrionObject)o).getDynamicPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                a.add((Object)props[i].getName());
            }
            return (String[])a.trim();
        }
    }

    public static class ShowReadersCommand
    extends FilteredRedirectCommand.RefStringFilter {
        public ShowReadersCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showReaders";
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            return service.getAccessRightReaderReport();
        }

        @Override
        public Type getFilterType(HxOp op) {
            return BAccessRightStringFilter.TYPE;
        }
    }

    public static class ShowExpirationsCommand
    extends FilteredRedirectCommand.RefStringFilter {
        public ShowExpirationsCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showExpirations";
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            return service.getPersonAccessRightReport();
        }

        @Override
        public Type getFilterType(HxOp op) {
            return BAccessRightStringFilter.TYPE;
        }
    }

    public static class AccessRightMatchCommand
    extends MatchCommand {
        public AccessRightMatchCommand(BHxView view) {
            super(view);
        }

        @Override
        public Tab getTab(HxOp op) {
            BIOrionObject[] subjects = this.getResolvedSubjects(op);
            HxOp matchOp = op.make("match", (BObject)subjects[0], null);
            HxOp op2 = op.make("op2", (BObject)subjects[1], null);
            matchOp.getRequest().setAttribute(matchOp.scope("op2"), (Object)op2);
            if (!BEnterpriseSecurityService.isThreatAvailable((Context)op)) {
                BFacets facets = BHxFieldSheet.getFieldsProvidedFacets((String[])new String[]{"accessRightName", "schedule", "niagaraIntegrationID", "tenant", "acDescription"});
                matchOp = matchOp.mergeFacets(facets);
            }
            return new Tab((BHxView)BHxMatchSheet.INSTANCE, matchOp);
        }
    }
}

