/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx;

import com.tridium.alarm.BConsoleRecipient;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class SessionAlarmStatus {
    private Array consoleList = new Array(ConsoleRecord.class, 3);
    public static final BIcon okIcon = BIcon.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
    public static final BIcon alarmIcon = BIcon.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
    public static final BIcon amberIcon = BIcon.make((String)"module://alarm/com/tridium/alarm/icons/alarm.png");
    public static final BIcon clearIcon = BIcon.make((String)"module://alarm/com/tridium/alarm/icons/alarmWhite.png");

    public void addConsole(BConsoleRecipient console, Context cx) {
        this.consoleList.add((Object)new ConsoleRecord(console, this.loadConsole(console, cx)));
    }

    public int getConsoleCount() {
        return this.consoleList.size();
    }

    public void validateConsoles() {
        for (int i = this.consoleList.size() - 1; i >= 0; --i) {
            ConsoleRecord record = (ConsoleRecord)this.consoleList.get(i);
            if (record.console.isMounted()) continue;
            this.consoleList.remove((Object)record);
        }
    }

    public BOrd getConsoleOrd(int consoleIndex) {
        return ((ConsoleRecord)this.consoleList.get(consoleIndex)).getConsoleOrd();
    }

    public BIcon getStatusIcon(int consoleIndex) {
        return ((ConsoleRecord)this.consoleList.get(consoleIndex)).getStatusIcon();
    }

    private BAlarmClass[] loadConsole(BConsoleRecipient console, Context cx) {
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        String[] classNames = console.getSubscribedAlarmClasses();
        Array temp = new Array(BAlarmClass.class, classNames.length);
        for (int i = 0; i < classNames.length; ++i) {
            BAlarmClass ac = alarmService.lookupAlarmClass(classNames[i]);
            if (ac == null) continue;
            temp.add((Object)ac);
        }
        return (BAlarmClass[])temp.trim();
    }

    private class ConsoleRecord {
        public final BConsoleRecipient console;
        public final BAlarmClass[] classes;

        public ConsoleRecord(BConsoleRecipient console, BAlarmClass[] classes) {
            this.console = console;
            this.classes = classes;
        }

        public BOrd getConsoleOrd() {
            return BOrd.make((String)("station:|" + this.console.getSlotPathOrd()));
        }

        public BIcon getStatusIcon() {
            int openCount = 0;
            int alarmCount = 0;
            int unackedCount = 0;
            for (int i = 0; i < this.classes.length; ++i) {
                openCount += this.classes[i].getOpenAlarmCount();
                alarmCount += this.classes[i].getInAlarmCount();
                unackedCount += this.classes[i].getUnackedAlarmCount();
            }
            if (openCount == 0 && alarmCount == 0 && unackedCount == 0) {
                return clearIcon;
            }
            if (alarmCount != 0 && unackedCount != 0) {
                return alarmIcon;
            }
            if (alarmCount != 0 && unackedCount == 0) {
                return amberIcon;
            }
            if (alarmCount == 0 && unackedCount != 0) {
                return okIcon;
            }
            return clearIcon;
        }
    }
}

