/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.nav.BEntsecNav;
import com.tridiumx.entsecHx.orionToolsHx.ReportCommand;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public abstract class EntsecReportCommand
extends ReportCommand {
    private static Lexicon APP_LEX = Lexicon.make(EntsecReportCommand.class);
    private static String NAME = SlotPath.escape((String)APP_LEX.getText("name"));
    private static String NAV = SlotPath.escape((String)APP_LEX.getText("navigationPath"));
    private static String ICON = SlotPath.escape((String)APP_LEX.getText("icon"));
    private static String INDEX = SlotPath.escape((String)APP_LEX.getText("index"));

    public EntsecReportCommand(BHxView view) {
        super(view);
    }

    @Override
    public Tab getReportTab(String reportName, HxOp op) {
        BComponent c = new BComponent();
        BString name = BString.DEFAULT;
        BString nav = BString.DEFAULT;
        BIcon icon = BIcon.DEFAULT;
        BInteger index = BInteger.DEFAULT;
        if (reportName != null) {
            name = BString.make((String)SlotPath.unescape((String)reportName));
            BComponent container = this.getContainer(op);
            BComponent report = (BComponent)container.get(reportName);
            BEntsecNav[] entsecNav = (BEntsecNav[])report.getChildren(BEntsecNav.class);
            if (entsecNav.length > 0) {
                nav = BString.make((String)entsecNav[0].getParentPath());
                icon = entsecNav[0].getIconOverride();
                index = BInteger.make((int)entsecNav[0].getIndex());
            }
        }
        c.add(NAME, (BValue)name);
        c.add(NAV, (BValue)nav, 0, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"entsec:EntsecGroupChooserFE"), (String)"allowNull", (BIDataValue)BBoolean.TRUE), null);
        c.add(ICON, (BValue)icon);
        c.add(INDEX, (BValue)index);
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, op.make("fields", (BObject)c, null));
    }

    @Override
    public String handleAdd(HxOp op) throws Exception {
        BComponent container = this.getContainer(op);
        BComponent save = (BComponent)this.getReportTab(null, op).save();
        String addName = save.get(NAME).toString();
        if (SlotPath.unescape((String)addName).equals(container.getDisplayName((Context)op))) {
            throw new IllegalStateException("Report Name cannot be the same as Main Report:" + container.getDisplayName((Context)op));
        }
        String nav = save.get(NAV).toString();
        BIcon icon = (BIcon)save.get(ICON);
        BInteger index = (BInteger)save.get(INDEX);
        BComponent newReport = this.getNewReport(op);
        if (nav.length() > 0) {
            BEntsecNav entsecNav = new BEntsecNav(nav, BFormat.make((String)addName), "", index.getInt());
            newReport.add(null, (BValue)entsecNav);
            container.add(addName + "?", (BValue)newReport, Integer.MIN_VALUE, (Context)op);
            this.rebuildNav(entsecNav, op);
        } else {
            container.add(addName + "?", (BValue)newReport, Integer.MIN_VALUE, (Context)op);
        }
        this.redirect(op, BOrd.make((String)("station:|" + newReport.getSlotPath())));
        return null;
    }

    @Override
    public String handleEdit(HxOp op) throws Exception {
        String reportForm = op.getFormValue("report");
        BComponent container = this.getContainer(op);
        BComponent editReport = container.get(reportForm).asComponent();
        BComponent save = (BComponent)this.getReportTab(reportForm, op).save();
        String newEditName = save.get(NAME).toString();
        if (SlotPath.unescape((String)newEditName).equals(container.getDisplayName((Context)op))) {
            throw new IllegalStateException("Report Name cannot be the same as Main Report:" + container.getDisplayName((Context)op));
        }
        String nav = save.get(NAV).toString();
        BIcon icon = (BIcon)save.get(ICON);
        BInteger index = (BInteger)save.get(INDEX);
        boolean wantsNav = nav.length() > 0;
        boolean alreadyHasNav = false;
        BEntsecNav entsecNav = null;
        BEntsecNav[] navList = (BEntsecNav[])editReport.getChildren(BEntsecNav.class);
        if (navList.length > 0) {
            entsecNav = navList[0];
            alreadyHasNav = true;
        }
        if (wantsNav && !alreadyHasNav) {
            entsecNav = new BEntsecNav(nav, BFormat.make((String)newEditName), "", index.getInt());
            editReport.add(null, (BValue)entsecNav);
        } else if (!wantsNav && alreadyHasNav) {
            editReport.remove(entsecNav.getName());
        } else if (wantsNav && alreadyHasNav) {
            entsecNav.setParentPath(nav);
            entsecNav.setNavDisplayFormat(BFormat.make((String)newEditName));
            entsecNav.setIconOverride(icon);
            entsecNav.setIndex(index.getInt());
        }
        if (!reportForm.equals(newEditName)) {
            container.rename(editReport.getPropertyInParent(), SlotPath.escape((String)newEditName), (Context)op);
        }
        this.rebuildNav(entsecNav, op);
        if (editReport == op.get()) {
            this.redirect(op, BOrd.make((String)("station:|" + editReport.getSlotPath())));
        }
        return null;
    }

    @Override
    public String handleDelete(HxOp op) throws Exception {
        BComponent container = this.getContainer(op);
        Property[] props = container.getDynamicPropertiesArray();
        boolean useful = false;
        boolean redirectToMain = false;
        for (int i = 0; i < props.length; ++i) {
            if (op.getFormValue("report-" + props[i].getName()) == null) continue;
            BComplex deletedReport = (BComplex)container.get(props[i]);
            container.remove(deletedReport.getName(), (Context)op);
            useful = true;
            if (deletedReport != this.getSubject(op)) continue;
            redirectToMain = true;
        }
        if (!useful) {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"alert('No ");
            out.safe((Object)this.lex.getText("reports"));
            out.w((Object)" selected, please select a ");
            out.safe((Object)this.lex.getText("report"));
            out.w((Object)".');");
            return "deleteReport";
        }
        this.rebuildNav(null, op);
        if (redirectToMain) {
            this.redirect(op, BOrd.make((String)("station:|" + container.getSlotPath())));
        }
        return null;
    }

    public void rebuildNav(BEntsecNav nav, HxOp op) throws Exception {
        try {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            service.doRebuildDefaultNav();
            this.refresh(op);
        }
        catch (Exception e) {
            if (nav == null) {
                return;
            }
            try {
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                nav.setParentPath(BEntsecNav.parentPath.getDefaultValue().toString());
                service.doRebuildDefaultNav();
            }
            catch (Exception ee) {
                ee.printStackTrace();
                nav.getParent().asComponent().remove(nav.getPropertyInParent());
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                service.doRebuildDefaultNav();
                new ErrorDialog("Error", (Command)this, (Throwable)e, "Navigation not able to be rebuilt. Removing nav hint and rebuilding.").open(op);
            }
        }
    }
}

