/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.ui;

import javax.baja.agent.BIAgent;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BJobStep;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

public abstract class BJobStepFactory
extends BSingleton
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BJobStepFactory.class);
    public static final BOrd BATCH_SERVICE_ORD = BOrd.make((String)"service:batchJob:BatchJobService");

    public Type getType() {
        return TYPE;
    }

    public abstract Type[] getStageTypes();

    public String getDescription(Context cx) {
        String description = this.getType().getTypeInfo().getLexicon(cx).get(this.getType().getTypeName() + ".description");
        if (description == null) {
            description = TextUtil.toFriendly((String)this.getType().getTypeName());
        }
        return description;
    }

    public BIcon getIcon() {
        return this.getType().getTypeInfo().getIcon(null);
    }

    public boolean isValidFor(BBatchJob currentBatchJob, BObject jobTarget, Type stageType, BObject factoryArg) throws Exception {
        boolean matchedStageType = false;
        for (Type t : this.getStageTypes()) {
            if (!stageType.is(t)) continue;
            matchedStageType = true;
            break;
        }
        if (!matchedStageType) {
            return false;
        }
        try {
            return BATCH_SERVICE_ORD.resolve(jobTarget) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BJobStep makeStep(BWidget owner, BBatchJob currentBatchJob, BObject jobTarget, Context cx) throws Exception {
        return this.makeStep(owner, currentBatchJob, jobTarget, (BObject)this, cx);
    }

    public abstract BJobStep makeStep(BWidget var1, BBatchJob var2, BObject var3, BObject var4, Context var5) throws Exception;

    protected String lexKey(String keySuffix) {
        return this.getType().getTypeName() + "." + keySuffix;
    }
}

