/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.retention.ui;

import com.tridium.platform.ui.util.BBox;
import com.tridium.retention.ui.BTimeSinceLastModifiedFE;
import javax.baja.agent.AgentFilter;
import javax.baja.gx.BImage;
import javax.baja.registry.TypeInfo;
import javax.baja.retention.BIDomainRetentionPolicy;
import javax.baja.retention.BIRetainable;
import javax.baja.retention.BISimpleRetentionPolicy;
import javax.baja.retention.BRetentionPolicy;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BRetentionPolicyFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BRetentionPolicyFE.class);
    private BEdgePane editorPane;
    private BWbFieldEditor fieldEditor;
    private Type retainableType = null;
    private Type domainType = null;
    private BMenu menu = null;
    private BButton button;
    protected static final AgentFilter FIELD_EDITOR_FILTER = AgentFilter.is((Type)BWbFieldEditor.TYPE);

    public Type getType() {
        return TYPE;
    }

    public BRetentionPolicyFE(Type retainableType) {
        this();
        this.setRetainableType(retainableType);
    }

    public BRetentionPolicyFE() {
        BFlowPane flow = new BFlowPane(BHalign.left);
        this.fieldEditor = new BTimeSinceLastModifiedFE();
        this.editorPane = new BEdgePane(null, null, null, null, (BWidget)this.fieldEditor);
        flow.add(null, (BValue)this.editorPane);
        this.button = new BButton(BImage.make((BIcon)BIcon.std((String)"open.png")));
        this.button.setButtonStyle(BButtonStyle.toolBar);
        this.button.setMenuController((BAbstractButton.MenuController)new MenuController());
        flow.add(null, (BValue)new BBox(3.0, 0.0));
        flow.add(null, (BValue)this.button);
        this.setContent((BWidget)flow);
    }

    public void setRetainableType(Type value) {
        this.retainableType = value;
    }

    public Type getRetainableType(Context cx) {
        if (this.retainableType == null) {
            if (cx == null) {
                return BIRetainable.TYPE;
            }
            String typeName = cx.getFacets().gets("retainableType", "batchJob:IRetainable");
            return Sys.getType((String)typeName);
        }
        return this.retainableType;
    }

    public void setDomainType(Type value) {
        this.domainType = value;
    }

    public Type getDomainType(Context cx) {
        if (this.domainType == null) {
            if (cx == null) {
                return null;
            }
            String typeName = cx.getFacets().gets("domainType", null);
            return typeName == null ? null : Sys.getType((String)typeName);
        }
        return this.domainType;
    }

    protected void doSetReadonly(boolean readonly) {
        this.button.setEnabled(!readonly);
        this.fieldEditor.setReadonly(readonly);
    }

    protected TypeInfo getFEType(TypeInfo valueType) {
        return Sys.getRegistry().getAgents(valueType).filter(FIELD_EDITOR_FILTER).getDefault().getAgentType();
    }

    protected void doLoadValue(BObject value, Context cx) {
        TypeInfo feType = this.getFEType(value.getType().getTypeInfo());
        if (!this.fieldEditor.getType().getTypeInfo().equals(feType)) {
            this.fieldEditor = BWbFieldEditor.makeFor((BObject)value);
            this.linkTo((BComponent)this.fieldEditor, (Slot)pluginModified, (Slot)setModified);
            this.editorPane.setCenter((BWidget)this.fieldEditor);
        }
        this.fieldEditor.loadValue(value, cx);
        if (this.menu != null) {
            return;
        }
        this.menu = new BMenu();
        Type retainableType = this.getRetainableType(cx);
        Type domainType = this.getDomainType(cx);
        if (retainableType == null) {
            return;
        }
        block0: for (TypeInfo subtype : Sys.getRegistry().getTypes(BRetentionPolicy.TYPE.getTypeInfo())) {
            Type[] applicableTypes;
            if (subtype.isAbstract() || subtype.isInterface() || subtype.equals(TYPE.getTypeInfo())) continue;
            BValue policy = (BValue)subtype.getInstance();
            boolean added = false;
            if (domainType != null && policy instanceof BIDomainRetentionPolicy) {
                for (Type applicableType : applicableTypes = ((BIDomainRetentionPolicy)policy).getApplicableDomainTypes()) {
                    if (!domainType.is(applicableType)) continue;
                    this.menu.add(null, (Command)new ChangePolicyTypeCommand(subtype));
                    added = true;
                    break;
                }
            }
            if (added || !(policy instanceof BISimpleRetentionPolicy)) continue;
            for (Type applicableType : applicableTypes = ((BISimpleRetentionPolicy)policy).getApplicableRetainableTypes()) {
                if (!retainableType.is(applicableType)) continue;
                this.menu.add(null, (Command)new ChangePolicyTypeCommand(subtype));
                continue block0;
            }
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return this.fieldEditor.saveValue(cx);
    }

    class MenuController
    implements BAbstractButton.MenuController {
        MenuController() {
        }

        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton b) {
            return BRetentionPolicyFE.this.menu;
        }
    }

    private class ChangePolicyTypeCommand
    extends Command {
        private TypeInfo info;

        public ChangePolicyTypeCommand(TypeInfo pInfo) {
            super((BWidget)BRetentionPolicyFE.this, pInfo.getDisplayName(BRetentionPolicyFE.this.getCurrentContext()), BImage.make((BIcon)pInfo.getIcon(BRetentionPolicyFE.this.getCurrentContext())), null, null);
            this.info = pInfo;
        }

        public CommandArtifact doInvoke() {
            if (BRetentionPolicyFE.this.getCurrentValue().getType().getTypeInfo().equals(this.info)) {
                return null;
            }
            BRetentionPolicyFE.this.loadValue(this.info.getInstance(), BRetentionPolicyFE.this.getCurrentContext());
            BRetentionPolicyFE.this.setModified();
            return null;
        }
    }
}

