/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui.driver;

import com.tridium.batchJob.ui.JobTable;
import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.util.LabelUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BForEachDeviceStage;
import javax.baja.batchJob.driver.BNetworkJobStage;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BDeviceNetworkJobView
extends BWbComponentView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType(BDeviceNetworkJobView.class);
    private BLabel userLabel;
    private BLabel startedLabel;
    private BLabel endedLabel;
    private BLabel stateLabel;
    private BLabel progressLabel;
    public static String TOTAL_STEPS = "totalSteps";
    public static String PROGRESS_COUNT = "progressCount";
    public static String STEP_START_TIME = "stepStartTime";
    public static String STEP_STATE = "stepState";
    private BTable table;
    protected Model model;
    private BDeviceNetworkJob job = null;
    private CancelJobCommand cancelJobCommand;
    private CancelDeviceCommand cancelDeviceCommand;
    private DisposeCommand disposeCommand;
    private static final Lexicon lex = Lexicon.make((String)"batchJob");
    public static final int COL_DEVICE = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_START = 2;
    public static final int COL_END = 3;
    public static final int COL_BUTTONS = 4;
    protected ProgressInfo progressInfo = new ProgressInfo();
    private final Object eventLock = new Object();
    private static final Level logLevel = Level.FINER;
    private static final Logger logger = Logger.getLogger("batchJob");

    public Type getType() {
        return TYPE;
    }

    public BDeviceNetworkJobView() {
        this.autoRegisterForComponentEvents = false;
        BGridPane upperPane = new BGridPane();
        upperPane.setHalign(BHalign.left);
        this.userLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceNetworkJobView.user"), (BWidget)this.userLabel);
        this.startedLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceNetworkJobView.started"), (BWidget)this.startedLabel);
        this.endedLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceNetworkJobView.ended"), (BWidget)this.endedLabel);
        this.stateLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceNetworkJobView.state"), (BWidget)this.stateLabel);
        this.progressLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceNetworkJobView.progress"), (BWidget)this.progressLabel);
        CommandBindings bindings = new CommandBindings();
        OpenCommand openCommand = new OpenCommand();
        bindings.addCommand((Command)openCommand, BCommandEnablePolicy.singleSelection);
        this.cancelDeviceCommand = new CancelDeviceCommand();
        bindings.addCommand((Command)this.cancelDeviceCommand, BCommandEnablePolicy.singleSelection);
        bindings.setSupport((CommandBindings.Support)this);
        int COLUMN_OFFSET = this.getColumnOffset();
        this.model = new Model();
        this.table = JobTable.makeListTable(this.model, bindings, 4 + COLUMN_OFFSET, openCommand, null);
        BButtonPane buttons = new BButtonPane();
        buttons.add((Command)new ViewLogCommand());
        if (this.getJobListOrd() != null) {
            buttons.add((Command)new JobListCommand());
        }
        this.cancelJobCommand = new CancelJobCommand();
        buttons.add((Command)this.cancelJobCommand);
        buttons.add((Command)this.cancelDeviceCommand);
        this.disposeCommand = new DisposeCommand();
        buttons.add((Command)this.disposeCommand);
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)upperPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)buttons, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.table), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadValue(BObject value, Context context) throws Exception {
        Object object = this.eventLock;
        synchronized (object) {
            this.job = (BDeviceNetworkJob)value;
            this.model.load(this.job);
            this.job.lease(Integer.MAX_VALUE);
            this.userLabel.setText(this.job.getSubmitUser());
            this.startedLabel.setText(this.job.getStartTime().toString());
            this.endedLabel.setText(this.job.getEndTime().toString());
            this.stateLabel.setText(this.job.getJobState().toString());
            this.cancelJobCommand.checkEnabled();
            this.disposeCommand.checkEnabled();
            this.initJobViewProgress(context);
            this.registerForComponentEvents((BComponent)this.job, Integer.MAX_VALUE);
        }
    }

    protected BOrd getJobListOrd() {
        return null;
    }

    public BDeviceNetworkJob getDeviceNetworkJob() {
        BObject currentValue = this.getCurrentValue();
        return (BDeviceNetworkJob)currentValue;
    }

    public BObject getOrdBase() {
        return this.getDeviceNetworkJob().getOrdBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleComponentEvent(BComponentEvent evt) {
        block10: {
            Object object = this.eventLock;
            synchronized (object) {
                block14: {
                    String deviceName;
                    BJobStepDetails newDetails;
                    block15: {
                        block13: {
                            BJobState state;
                            Property p;
                            block8: {
                                String text;
                                Property p2;
                                block12: {
                                    block11: {
                                        block9: {
                                            if (!(evt.getSourceComponent() instanceof BDeviceNetworkJob) || !evt.getSlot().isProperty()) break block8;
                                            p2 = (Property)evt.getSlot();
                                            text = evt.getValue().toString();
                                            if (p2 != BDeviceNetworkJob.submitUser) break block9;
                                            this.userLabel.setText(text);
                                            break block10;
                                        }
                                        if (p2 != BDeviceNetworkJob.startTime) break block11;
                                        this.startedLabel.setText(text);
                                        break block10;
                                    }
                                    if (p2 != BDeviceNetworkJob.endTime) break block12;
                                    this.endedLabel.setText(text);
                                    break block10;
                                }
                                if (p2 != BDeviceNetworkJob.jobState) break block10;
                                this.stateLabel.setText(text);
                                this.cancelJobCommand.checkEnabled();
                                this.disposeCommand.checkEnabled();
                                BJobState state2 = (BJobState)evt.getValue();
                                if (!state2.isComplete()) break block10;
                                BDeviceNetworkJob deviceNetworkJob = (BDeviceNetworkJob)evt.getSourceComponent();
                                logger.log(logLevel, String.format("BDeviceNetworkJob Start Time = %d, State = %s", deviceNetworkJob.getStartTime().getMillis(), state2.getTag()));
                                break block10;
                            }
                            if (!(evt.getSourceComponent() instanceof BJobStepDetails)) break block13;
                            this.model.updateDetails((BJobStepDetails)evt.getSourceComponent());
                            if (evt.getSlot().isProperty() && (p = (Property)evt.getSlot()) == BJobStepDetails.state && (state = (BJobState)evt.getValue()).isComplete()) {
                                BJobStepDetails eventDetails = (BJobStepDetails)evt.getSourceComponent();
                                String eventDevice = eventDetails.getStageName();
                                if (evt.getSourceComponent() instanceof BDeviceStepDetails) {
                                    BDeviceStepDetails deviceDetails = (BDeviceStepDetails)evt.getSourceComponent();
                                    eventDevice = deviceDetails.getDeviceDisplayName();
                                }
                                this.updateDeviceSteps(eventDevice, eventDetails, this.progressInfo.allJobSteps, eventDetails.getStartTime().getMillis());
                                logger.log(logLevel, String.format(" Job Complete - progressCount = %d, total steps = %d", this.progressInfo.progressCount, this.progressInfo.totalSteps));
                                this.progressLabel.setText(String.format("%d of %d - %d %%", this.progressInfo.progressCount, this.progressInfo.totalSteps, (int)Math.ceil(100.0 * (double)this.progressInfo.progressCount / (double)this.progressInfo.totalSteps)));
                            }
                            break block10;
                        }
                        if (evt.getId() != 1 || !(evt.getValue() instanceof BJobStepDetails)) break block14;
                        this.model.updateDetails((BJobStepDetails)evt.getValue());
                        this.registerForComponentEvents((BComponent)evt.getValue(), Integer.MAX_VALUE);
                        newDetails = (BJobStepDetails)evt.getValue();
                        deviceName = newDetails.getStageName();
                        if (evt.getValue() instanceof BDeviceStepDetails) {
                            BDeviceStepDetails newDeviceDetails = (BDeviceStepDetails)evt.getValue();
                            deviceName = newDeviceDetails.getDeviceDisplayName();
                        }
                        if (this.progressInfo.checkCombinedSteps || !(evt.getValue() instanceof BDeviceStepDetails)) break block15;
                        this.initJobViewProgress(this.getCurrentContext());
                        this.progressInfo.checkCombinedSteps = true;
                        break block10;
                    }
                    int currentProgress = this.progressInfo.progressCount;
                    this.updateDeviceSteps(deviceName, newDetails, this.progressInfo.allJobSteps, BAbsTime.DEFAULT.getMillis());
                    if (currentProgress == this.progressInfo.progressCount) break block10;
                    logger.log(logLevel, String.format(" Job Details state = %s - progressCount = %d, total steps = %d", newDetails.getState().getTag(), this.progressInfo.progressCount, this.progressInfo.totalSteps));
                    this.progressLabel.setText(String.format("%d of %d - %d %%", this.progressInfo.progressCount, this.progressInfo.totalSteps, (int)Math.ceil(100.0 * (double)this.progressInfo.progressCount / (double)this.progressInfo.totalSteps)));
                    break block10;
                }
                if (evt.getId() == 1 && evt.getValue() instanceof BJobStep) {
                    BJobStep step = (BJobStep)evt.getValue();
                    this.registerForComponentEvents((BComponent)step, Integer.MAX_VALUE);
                    for (BJobStepDetails detail : (BJobStepDetails[])step.getChildren(BJobStepDetails.class)) {
                        this.model.updateDetails(detail);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initJobViewProgress(Context context) {
        int totalSteps = 0;
        JSONObject allJobSteps = new JSONObject();
        for (BJobStage jobStage : this.job.getAllStages()) {
            int n;
            int n2;
            HashMap<String, JSONArray> stageJobSteps = new HashMap<String, JSONArray>();
            if (jobStage instanceof BNetworkJobStage) {
                BNetworkJobStage networkJobStage = (BNetworkJobStage)jobStage;
                JSONArray stageSteps = new JSONArray();
                BJobStep[] propertyArray = jobStage.getAllSteps();
                n2 = propertyArray.length;
                for (n = 0; n < n2; ++n) {
                    BJobStep jobStep = propertyArray[n];
                    JSONObject step = new JSONObject();
                    step.put(STEP_START_TIME, BAbsTime.NULL.getMillis());
                    step.put(STEP_STATE, (Object)BJobState.unknown.getTag());
                    stageSteps.put((Object)step);
                }
                stageJobSteps.put(jobStage.getStageName(), stageSteps);
                totalSteps += networkJobStage.getAllSteps().length;
            } else if (jobStage instanceof BForEachDeviceStage) {
                BForEachDeviceStage forEachDeviceJobStage = (BForEachDeviceStage)jobStage;
                if (!this.job.getJobState().isRunning()) {
                    BDevice[] devices = forEachDeviceJobStage.getDeviceStates();
                    Property[] propertyArray = devices.getDynamicPropertiesArray();
                    n2 = propertyArray.length;
                    for (n = 0; n < n2; ++n) {
                        Property device = propertyArray[n];
                        totalSteps += this.addStageSteps(device.getName(), forEachDeviceJobStage, stageJobSteps);
                    }
                } else {
                    for (BDevice device : this.job.getDevices()) {
                        totalSteps += this.addStageSteps(device.getName(), forEachDeviceJobStage, stageJobSteps);
                    }
                }
            }
            allJobSteps.put(jobStage.getStageName(), stageJobSteps);
        }
        ProgressInfo progressInfo = this.progressInfo;
        synchronized (progressInfo) {
            this.progressInfo.progressCount = 0;
            this.progressInfo.totalSteps = totalSteps;
            this.progressInfo.checkCombinedSteps = false;
            BJobStepDetails[] allDetails = this.job.getJobStepDetails();
            if (allDetails != null && allDetails.length > 0) {
                this.progressInfo.checkCombinedSteps = true;
                for (BJobStage jobStage : this.job.getAllStages()) {
                    List stageDetails = Arrays.asList(allDetails).stream().filter(entry -> entry.getStageName().contentEquals(jobStage.getStageName())).collect(Collectors.toList());
                    for (BJobStepDetails details : stageDetails) {
                        String deviceName = jobStage.getStageName();
                        if (details instanceof BDeviceStepDetails) {
                            deviceName = ((BDeviceStepDetails)details).getDeviceId().toString(context);
                        }
                        this.updateDeviceSteps(deviceName, details, allJobSteps, BAbsTime.DEFAULT.getMillis());
                    }
                }
            }
            this.progressInfo.allJobSteps = allJobSteps;
            logger.log(logLevel, String.format(" initJobViewProgress - progressCount = %d, total steps = %d", this.progressInfo.progressCount, this.progressInfo.totalSteps));
            this.progressLabel.setText(String.format("%d of %d - %d %%", this.progressInfo.progressCount, this.progressInfo.totalSteps, (int)Math.ceil(100.0 * (double)this.progressInfo.progressCount / (double)this.progressInfo.totalSteps)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceSteps(String deviceName, BJobStepDetails details, JSONObject allJobSteps, long matchStartTime) {
        ProgressInfo progressInfo = this.progressInfo;
        synchronized (progressInfo) {
            JSONObject devices = allJobSteps.getJSONObject(details.getStageName());
            JSONArray deviceSteps = devices.getJSONArray(deviceName);
            logger.log(logLevel, String.format(" updateDeviceSteps device steps - device = %s, step count = %d", deviceName, deviceSteps.length()));
            for (int i = 0; i < deviceSteps.length(); ++i) {
                JSONObject step = deviceSteps.getJSONObject(i);
                if (step.getLong(STEP_START_TIME) != matchStartTime) continue;
                JSONObject newStep = new JSONObject();
                newStep.put(STEP_START_TIME, details.getStartTime().getMillis());
                newStep.put(STEP_STATE, (Object)details.getState().getTag());
                deviceSteps.put(i, (Object)newStep);
                if (details.getState().isComplete()) {
                    logger.log(logLevel, String.format(" updateDeviceSteps increment - details stage = %s, device = %s, step i = %d, start time = %d", details.getStageName(), deviceName, i, details.getStartTime().getMillis()));
                    ++this.progressInfo.progressCount;
                }
                if (details.getState() != BJobState.canceled && details.getState() != BJobState.failed) break;
                this.progressInfo.totalSteps -= deviceSteps.length() - (i + 1);
                if (i >= deviceSteps.length() - 1) break;
                JSONArray trimmedDeviceSteps = new JSONArray();
                for (int j = 0; j <= i; ++j) {
                    trimmedDeviceSteps.put((Object)deviceSteps.getJSONObject(j));
                }
                devices.put(deviceName, (Object)trimmedDeviceSteps);
                logger.log(logLevel, String.format(" updateDeviceSteps removed steps - device = %s, step count = %d", deviceName, trimmedDeviceSteps.length()));
                break;
            }
        }
    }

    private int addStageSteps(String deviceName, BForEachDeviceStage forEachDeviceJobStage, Map<String, JSONArray> stageJobSteps) {
        int totalSteps = 0;
        JSONArray stageSteps = new JSONArray();
        for (BJobStep jobStep : forEachDeviceJobStage.getAllSteps()) {
            if (jobStep.get("ExcludeFromProgress") != null) continue;
            JSONObject step = new JSONObject();
            step.put(STEP_START_TIME, BAbsTime.NULL.getMillis());
            step.put(STEP_STATE, (Object)BJobState.unknown.getTag());
            stageSteps.put((Object)step);
            ++totalSteps;
        }
        stageJobSteps.put(deviceName, stageSteps);
        return totalSteps;
    }

    protected void setModel(Model model) {
        this.model = model;
        this.table.setModel((TableModel)model);
        model.updateTable(true);
    }

    protected int getColumnOffset() {
        return 0;
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        if (command == this.cancelDeviceCommand && bindingBasedState) {
            BJobStepDetails details = this.model.details(this.model.getTable().getSelection().getRow());
            if (details instanceof BDeviceStepDetails) {
                BDeviceStepDetails deviceStepDetails = (BDeviceStepDetails)details;
                BJobState deviceState = deviceStepDetails.getForEachDeviceStage(this.job).getDeviceState(deviceStepDetails.getDeviceId());
                if (deviceState.isComplete() || deviceState == BJobState.canceling) {
                    command.setEnabled(false);
                    return;
                }
            } else {
                command.setEnabled(false);
                return;
            }
        }
        command.setEnabled(bindingBasedState);
    }

    private class DisposeCommand
    extends Command {
        public DisposeCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.disposeCommand");
            this.setEnabled(false);
        }

        public void checkEnabled() {
            this.setEnabled(!(BDeviceNetworkJobView.this.getCurrentValue() instanceof BDeviceNetworkJob) || BDeviceNetworkJobView.this.getDeviceNetworkJob().getJobState().isComplete());
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BDeviceNetworkJobView.this.model.getTable(), (String)lex.getText("DeviceNetworkJobView.disposeCommand.dlgTitle"), (Object)lex.getText("DeviceNetworkJobView.disposeCommand.dlgMessage"))) {
                    BBatchJobService svc = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(BDeviceNetworkJobView.this.getOrdBase());
                    if (BDeviceNetworkJobView.this.getJobListOrd() != null) {
                        BDeviceNetworkJobView.this.getWbShell().hyperlink(BOrd.make((BOrd)svc.getAbsoluteOrd(), (BOrd)BDeviceNetworkJobView.this.getJobListOrd()));
                    }
                    svc.disposeJob(BDeviceNetworkJobView.this.job.getStartTime());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class CancelDeviceCommand
    extends Command {
        public CancelDeviceCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.cancelDeviceCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BDeviceNetworkJobView.this.model.details(BDeviceNetworkJobView.this.model.getSelection().getRow()).cancel();
                BDeviceNetworkJobView.this.model.getSelection().deselectAll();
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class CancelJobCommand
    extends Command {
        public CancelJobCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.cancelJobCommand");
            this.setEnabled(false);
        }

        public void checkEnabled() {
            try {
                this.setEnabled(BDeviceNetworkJobView.this.getDeviceNetworkJob().getJobState() == BJobState.running);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public CommandArtifact doInvoke() {
            try {
                BDeviceNetworkJobView.this.job.cancel();
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class JobListCommand
    extends Command {
        public JobListCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.jobListCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd ord = BOrd.make((BOrd)BOrd.toSession((BObject)BDeviceNetworkJobView.this.getOrdBase()).getAbsoluteOrd(), (BOrd)BDeviceNetworkJobView.this.getJobListOrd());
                BDeviceNetworkJobView.this.getWbShell().hyperlink(ord);
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class ViewLogCommand
    extends Command {
        public ViewLogCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.viewLogCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                JobTable.showLogDialog((BWidget)BDeviceNetworkJobView.this.model.getTable(), (BJob)BDeviceNetworkJobView.this.job);
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class OpenCommand
    extends Command {
        public OpenCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.openCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStepDetails details = BDeviceNetworkJobView.this.model.details(BDeviceNetworkJobView.this.model.getTable().getSelection().getRow());
                if (details.getState().isComplete()) {
                    BIFile logFile = details.findLogFile(BDeviceNetworkJobView.this.getOrdBase());
                    BOrd ord = BOrd.make((BOrd)((BINavNode)BDeviceNetworkJobView.this.getOrdBase()).getNavOrd(), (BOrd)logFile.getOrdInSession());
                    ord = BOrd.make((BOrd)ord, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)details.getStartTime().getTimeZone().getId()))));
                    BDeviceNetworkJobView.this.getWbShell().hyperlink(ord);
                } else {
                    BDeviceNetworkJobView.this.getWbShell().hyperlink(details.getNavOrd());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class Model
    extends TableModel {
        protected List<BJobStepDetails> rows = new ArrayList<BJobStepDetails>();
        protected Set<BAbsTime> startTimes = new HashSet<BAbsTime>();

        protected Model() {
        }

        public synchronized void updateDetails(BJobStepDetails details) {
            if (!this.startTimes.contains(details.getStartTime())) {
                this.rows.add(details);
                this.startTimes.add(details.getStartTime());
            }
            this.updateTable(true);
        }

        public synchronized void load(BDeviceNetworkJob job) throws Exception {
            BJobStepDetails[] recs = job.getJobStepDetails();
            HashSet<BAbsTime> tempStartTimes = new HashSet<BAbsTime>();
            for (BJobStepDetails rec : recs) {
                tempStartTimes.add(rec.getStartTime());
            }
            this.rows.addAll(Arrays.asList(recs));
            this.startTimes.addAll(tempStartTimes);
            this.updateTable(true);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("DeviceNetworkJobView.col.device");
                }
                case 1: {
                    return lex.getText("DeviceNetworkJobView.col.type");
                }
                case 2: {
                    return lex.getText("DeviceNetworkJobView.col.start");
                }
                case 3: {
                    return lex.getText("DeviceNetworkJobView.col.end");
                }
                case 4: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    if (this.details(row) instanceof BDeviceStepDetails) {
                        String result = ((BDeviceStepDetails)this.details(row)).getDeviceDisplayName();
                        return result.length() == 0 ? ((BDeviceStepDetails)this.details(row)).getDeviceId().toString() : result;
                    }
                    return lex.getText("DeviceNetworkJobView.col.device.none");
                }
                case 1: {
                    return this.details(row).getStepDescription();
                }
                case 2: {
                    return this.details(row).getStartTime().toString();
                }
                case 3: {
                    return this.details(row).getEndTime().isNull() ? "" : this.details(row).getEndTime().toString();
                }
                case 4: {
                    return this.details(row).getState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BJobStepDetails details(int row) {
            return this.rows.get(row);
        }

        public BImage getRowIcon(int row) {
            return JobTable.stateToIcon(this.details(row).getState());
        }
    }

    protected class ProgressInfo {
        public JSONObject allJobSteps = new JSONObject();
        public int totalSteps = 0;
        public int progressCount = 0;
        public boolean checkCombinedSteps = false;

        ProgressInfo() {
        }
    }
}

