/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.baja.history.BTrendFlags;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSqlServerDeprecatedDialect
extends BRdbmsDeprecatedDialect {
    public static final Type TYPE = Sys.loadType(BSqlServerDeprecatedDialect.class);
    private static boolean useBigintDataTypeForIdColumn = AccessController.doPrivileged(() -> System.getProperty("niagara.rdb.useBigintDataTypeForIdColumn", "false")).equals("true");

    public Type getType() {
        return TYPE;
    }

    public boolean tableExists(BRdbms db, Connection conn, String tableName) throws SQLException {
        String catalog = null;
        try {
            Statement s = conn.createStatement();
            ResultSet r = s.executeQuery("select db_name() as current_db");
            r.next();
            catalog = r.getString("current_db");
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Logger.getLogger("rdb").severe("Unable to determine Sql Server catalog.");
        }
        ResultSet rs = conn.getMetaData().getTables(catalog, null, tableName, new String[]{"TABLE"});
        boolean hasNext = rs.next();
        rs.close();
        return hasNext;
    }

    public String makeAlterColumnTypeSql(String tableName, String columnName, BSqlType targetType, int columnSize) {
        String sql = "ALTER TABLE " + tableName + " ALTER COLUMN [" + columnName + "] " + this.getDataType(targetType) + "(" + columnSize + ")";
        return sql;
    }

    public String makeDropIndexSql(String indexName, String tableName) {
        return "DROP INDEX " + indexName + " ON " + tableName;
    }

    public String getSqlType(Type type, BFacets facets) {
        int width = this.getVarcharSize(facets);
        if (type.equals(BString.TYPE)) {
            return this.getStringType(width);
        }
        if (type.equals(BInteger.TYPE)) {
            return "INT";
        }
        if (type.equals(BLong.TYPE)) {
            return "BIGINT";
        }
        if (type.equals(BFloat.TYPE)) {
            return "REAL";
        }
        if (type.equals(BDouble.TYPE)) {
            return "FLOAT";
        }
        if (type.equals(BAbsTime.TYPE)) {
            return "DATETIME";
        }
        if (type.equals(BRelTime.TYPE)) {
            return "BIGINT";
        }
        if (type.equals(BBoolean.TYPE)) {
            return "BIT";
        }
        if (type.equals(BStatus.TYPE)) {
            return "INT";
        }
        if (type.equals(BTrendFlags.TYPE)) {
            return "INT";
        }
        return this.getStringType(width);
    }

    private String getStringType(int width) {
        if (this.database != null && this.database.getUseUnicodeEncodingScheme()) {
            return "NVARCHAR(" + width + ")";
        }
        return "VARCHAR(" + width + ")";
    }

    public long getTimestampAccuracy() {
        return 10L;
    }

    public String getPrimaryKeySql() {
        if (useBigintDataTypeForIdColumn) {
            return "BIGINT IDENTITY PRIMARY KEY";
        }
        return "INT IDENTITY PRIMARY KEY";
    }

    public int getMaxTableName() {
        return 128;
    }

    public int getMaxIndexName() {
        return 128;
    }

    public int getMaxColumnName() {
        return 128;
    }

    public int getMaxSequenceName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSequences() {
        return false;
    }

    public boolean allowsUnicode() {
        return true;
    }
}

