/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.sqlserver.BSqlServerConnector;
import com.tridium.rdb.sqlserver.BSqlServerDatabase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.dbcp2.BasicDataSource;

public class BConnectionPool
extends BAbstractConnectionPool {
    public static final Type TYPE = Sys.loadType(BConnectionPool.class);
    private static final String JTDS_DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    private static final String MSSQL_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String JTDS_BASE_URL = "jdbc:jtds:sqlserver:";
    private static final String MSSQL_BASE_URL = "jdbc:sqlserver:";
    private BasicDataSource ds;
    private static final Logger log = Logger.getLogger("rdb");
    private static final Pattern COMPILE = Pattern.compile("\\s+");
    private static final Pattern PATTERN = Pattern.compile("(?i)useBulkCopyForBatchInsert=true");
    private static final String USE_BULK_COPY_FOR_BATCH_INSERT_PARAM = "useBulkCopyForBatchInsert";

    public Type getType() {
        return TYPE;
    }

    public void doUpdateConnectionStats() {
        if (this.ds != null) {
            this.setNumActive(this.ds.getNumActive());
            if (this.getNumActive() > this.getPeakNumActive()) {
                this.setPeakNumActive(this.getNumActive());
            }
            this.setNumIdle(this.ds.getNumIdle());
        }
    }

    protected Connection obtainConnection(String userName, String password) throws SQLException {
        BSqlServerDatabase db = (BSqlServerDatabase)this.getParent();
        String url = this.makeUrl(db);
        if (this.ds == null) {
            Logger.getLogger("rdb").fine("initializing connection pool for " + url);
            this.ds = this.makeDataSource(url, userName, password, db);
        } else if (!(this.ds.getUrl().equals(url) && this.ds.getUsername().equals(userName) && this.ds.getPassword().equals(password))) {
            Logger.getLogger("rdb").fine("re-initializing connection pool for " + url);
            this.ds.close();
            this.ds = this.makeDataSource(url, userName, password, db);
        }
        return this.ds.getConnection();
    }

    private BasicDataSource makeDataSource(String url, String userName, String password, BSqlServerDatabase db) {
        BasicDataSource ds = new BasicDataSource();
        if (db.getConnector().equals((Object)BSqlServerConnector.jtds)) {
            ds.setDriverClassName(JTDS_DRIVER);
            ds.setValidationQuery("select 1");
        } else if (db.getConnector().equals((Object)BSqlServerConnector.mssql)) {
            ds.setDriverClassName(MSSQL_DRIVER);
        }
        ds.setUrl(url);
        ds.setUsername(userName);
        ds.setPassword(password);
        ds.setMaxTotal(this.getMaxActive());
        ds.setMaxIdle(this.getMaxIdle());
        ds.setMaxWaitMillis(this.getMaxWait());
        return ds;
    }

    private String makeUrl(BSqlServerDatabase db) {
        String extra;
        String instanceName;
        BSqlServerConnector connector = db.getConnector();
        if (connector == null) {
            connector = BSqlServerConnector.DEFAULT;
            db.setConnector(connector);
        }
        StringBuilder url = new StringBuilder();
        if (connector.equals((Object)BSqlServerConnector.jtds)) {
            url.append(JTDS_BASE_URL);
        } else if (connector.equals((Object)BSqlServerConnector.mssql)) {
            url.append(MSSQL_BASE_URL);
        }
        url.append("//").append(db.getHostname());
        if (db.getPort() != 0) {
            url.append(':').append(db.getPort());
        }
        if (!(instanceName = db.getInstanceName()).isEmpty()) {
            if (connector.equals((Object)BSqlServerConnector.jtds)) {
                url.append('/').append(instanceName);
            } else if (connector.equals((Object)BSqlServerConnector.mssql)) {
                url.append(";databaseName=").append(instanceName);
            }
        }
        if (!(extra = db.getExtraConnectionProperties()).isEmpty()) {
            url.append(';');
            if (connector.equals((Object)BSqlServerConnector.mssql)) {
                String[] parameters;
                StringJoiner joiner = new StringJoiner(";");
                for (String param : parameters = extra.split(";")) {
                    if ((param = param.trim()).regionMatches(true, 0, USE_BULK_COPY_FOR_BATCH_INSERT_PARAM, 0, USE_BULK_COPY_FOR_BATCH_INSERT_PARAM.length())) {
                        String param1 = COMPILE.matcher(param).replaceAll("");
                        Matcher matcher = PATTERN.matcher(param1);
                        if (matcher.matches()) {
                            String param2 = matcher.replaceAll("useBulkCopyForBatchInsert=false");
                            joiner.add(param2);
                            if (this.ds != null || !log.isLoggable(Level.WARNING)) continue;
                            log.warning("Ignoring the 'useBulkCopyForBatchInsert=true' parameter in the Extra Connection Properties of" + db.toPathString() + ". Currently, this setting cannot be used.");
                            continue;
                        }
                        joiner.add(param1);
                        continue;
                    }
                    joiner.add(param);
                }
                url.append(joiner);
            } else if (connector.equals((Object)BSqlServerConnector.jtds)) {
                url.append(extra);
            }
        }
        if (db.getUseEncryptedConnection()) {
            if (connector.equals((Object)BSqlServerConnector.jtds)) {
                url.append(";ssl=authenticate");
            } else if (connector.equals((Object)BSqlServerConnector.mssql)) {
                url.append(";encrypt=true;trustServerCertificate=");
                if (db.getSqlServerCert().isEmpty()) {
                    url.append("true");
                } else {
                    url.append("false");
                    url.append(";trustStore=" + db.getTrustStorePath());
                    url.append(";trustStorePassword=" + db.getTrustStorePassword().asString(false));
                    url.append(";trustStoreType=" + db.getTrustStoreType());
                    url.append(";hostNameInCertificate=" + BConnectionPool.sanitize(db.getCertificateHostName()));
                }
            }
        }
        return url.toString();
    }

    private static String sanitize(String property) {
        property = property.replaceAll("}", "}}");
        return '{' + property + '}';
    }
}

